/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import groovy.lang.MetaMethod;
import java.util.Collections;
import java.util.Set;
import javax.swing.ImageIcon;
import org.codehaus.groovy.ast.ASTNode;
import org.netbeans.modules.groovy.editor.NbUtilities;
import org.netbeans.modules.groovy.editor.completion.CodeCompleter;
import org.netbeans.modules.groovy.editor.completion.GroovyCompletionItem;
import org.netbeans.modules.groovy.editor.elements.AstMethodElement;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodItem
extends GroovyCompletionItem {
    private static final String GROOVY_METHOD = "org/netbeans/modules/groovy/editor/resources/groovydoc.png";
    MetaMethod method;
    boolean isGDK;
    AstMethodElement methodElement;

    MethodItem(Class clazz, MetaMethod metaMethod, int n, CodeCompleter.CompletionRequest completionRequest, boolean bl) {
        super(null, n, completionRequest);
        this.method = metaMethod;
        this.isGDK = bl;
        this.methodElement = new AstMethodElement(new ASTNode(), clazz, metaMethod, bl);
    }

    public MetaMethod getMethod() {
        return this.method;
    }

    @Override
    public String getName() {
        return this.method.getName() + "()";
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.METHOD;
    }

    @Override
    public String getLhsHtml(HtmlFormatter htmlFormatter) {
        ElementKind elementKind = this.getKind();
        boolean bl = false;
        if (this.method.isStatic()) {
            bl = true;
            htmlFormatter.emphasis(true);
        }
        htmlFormatter.name(elementKind, true);
        if (this.isGDK) {
            htmlFormatter.appendText(this.method.getName());
            String string = this.method.getSignature();
            int n = string.indexOf("(");
            int n2 = string.indexOf(")");
            String string2 = string.substring(n + 1, n2);
            StringBuffer stringBuffer = new StringBuffer();
            for (String string3 : string2.split(",")) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NbUtilities.stripPackage(string3));
            }
            String string4 = stringBuffer.toString();
            htmlFormatter.appendText("(" + string4 + ")");
        } else {
            htmlFormatter.appendText(CodeCompleter.getMethodSignature(this.method, false, this.isGDK));
        }
        htmlFormatter.name(elementKind, false);
        if (bl) {
            htmlFormatter.emphasis(false);
        }
        return htmlFormatter.getText();
    }

    @Override
    public String getRhsHtml(HtmlFormatter htmlFormatter) {
        String string = this.method.getReturnType().toString();
        string = NbUtilities.stripPackage(string);
        htmlFormatter.appendHtml(string);
        return htmlFormatter.getText();
    }

    @Override
    public ImageIcon getIcon() {
        if (!this.isGDK) {
            return null;
        }
        if (groovyIcon == null) {
            groovyIcon = new ImageIcon(Utilities.loadImage((String)GROOVY_METHOD));
        }
        return groovyIcon;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    @Override
    public ElementHandle getElement() {
        return this.methodElement;
    }
}

