/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.netbeans.modules.groovy.editor.completion.CodeCompleter;
import org.netbeans.modules.groovy.editor.elements.GroovyElement;
import org.netbeans.modules.gsf.api.CompletionProposal;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class GroovyCompletionItem
implements CompletionProposal {
    protected CodeCompleter.CompletionRequest request;
    protected GroovyElement element;
    protected int anchorOffset;
    protected boolean symbol;
    protected boolean smart;
    final Logger LOG = Logger.getLogger(GroovyCompletionItem.class.getName());
    static ImageIcon groovyIcon;
    static ImageIcon javaIcon;
    static ImageIcon newConstructorIcon;

    GroovyCompletionItem(GroovyElement groovyElement, int n, CodeCompleter.CompletionRequest completionRequest) {
        this.element = groovyElement;
        this.anchorOffset = n;
        this.request = completionRequest;
        this.LOG.setLevel(Level.OFF);
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    public String getName() {
        return this.element.getName();
    }

    public void setSymbol(boolean bl) {
        this.symbol = bl;
    }

    public String getInsertPrefix() {
        if (this.symbol) {
            return "." + this.getName();
        }
        return this.getName();
    }

    public String getSortText() {
        return this.getName();
    }

    public ElementHandle getElement() {
        this.LOG.log(Level.FINEST, "getElement() request.info : {0}", this.request.info);
        this.LOG.log(Level.FINEST, "getElement() element : {0}", this.element);
        return null;
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public ImageIcon getIcon() {
        return null;
    }

    public String getLhsHtml(HtmlFormatter htmlFormatter) {
        ElementKind elementKind = this.getKind();
        htmlFormatter.name(elementKind, true);
        htmlFormatter.appendText(this.getName());
        htmlFormatter.name(elementKind, false);
        return htmlFormatter.getText();
    }

    public String getRhsHtml(HtmlFormatter htmlFormatter) {
        return null;
    }

    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string + "(" + this.getKind() + "): " + this.getName();
    }

    void setSmart(boolean bl) {
        this.smart = bl;
    }

    public boolean isSmart() {
        return this.smart;
    }

    public List<String> getInsertParams() {
        return null;
    }

    public String[] getParamListDelimiters() {
        return new String[]{"(", ")"};
    }

    public String getCustomInsertTemplate() {
        return null;
    }
}

