/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.AstPath;
import org.netbeans.modules.groovy.editor.AstUtilities;
import org.netbeans.modules.groovy.editor.VariableScopeVisitor;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.InstantRenamer;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyInstantRenamer
implements InstantRenamer {
    private final Logger LOG = Logger.getLogger(GroovyInstantRenamer.class.getName());

    public GroovyInstantRenamer() {
        this.LOG.setLevel(Level.OFF);
    }

    public boolean isRenameAllowed(CompilationInfo compilationInfo, int n, String[] stringArray) {
        this.LOG.log(Level.FINEST, "isRenameAllowed()");
        AstPath astPath = this.getPathUnderCaret(compilationInfo, n);
        if (astPath != null) {
            ASTNode aSTNode = astPath.leaf();
            if (aSTNode instanceof Variable) {
                return true;
            }
            stringArray[0] = NbBundle.getMessage(GroovyInstantRenamer.class, (String)"OnlyRenameLocalVars");
            return false;
        }
        return false;
    }

    public Set<OffsetRange> getRenameRegions(CompilationInfo compilationInfo, int n) {
        this.LOG.log(Level.FINEST, "getRenameRegions()");
        AstPath astPath = this.getPathUnderCaret(compilationInfo, n);
        HashSet<OffsetRange> hashSet = new HashSet<OffsetRange>();
        GroovyInstantRenamer.markOccurences(astPath, hashSet, (BaseDocument)compilationInfo.getDocument());
        return hashSet;
    }

    private AstPath getPathUnderCaret(CompilationInfo compilationInfo, int n) {
        ModuleNode moduleNode = AstUtilities.getRoot(compilationInfo);
        if (moduleNode == null) {
            return null;
        }
        int n2 = AstUtilities.getAstOffset(compilationInfo, n);
        if (n2 == -1) {
            return null;
        }
        BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
        if (baseDocument == null) {
            this.LOG.log(Level.FINEST, "Could not get BaseDocument. It's null");
            return null;
        }
        return new AstPath((ASTNode)moduleNode, n2, baseDocument);
    }

    private static void markOccurences(AstPath astPath, Set<OffsetRange> set, BaseDocument baseDocument) {
        ASTNode aSTNode = astPath.root();
        assert (aSTNode instanceof ModuleNode);
        ModuleNode moduleNode = (ModuleNode)aSTNode;
        VariableScopeVisitor variableScopeVisitor = new VariableScopeVisitor(moduleNode.getContext(), astPath);
        variableScopeVisitor.collect();
        for (ASTNode aSTNode2 : variableScopeVisitor.getOccurrences()) {
            OffsetRange offsetRange = AstUtilities.getRange(aSTNode2, baseDocument);
            set.add(offsetRange);
        }
    }
}

