/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.groovy.editor.AstChildrenSupport;
import org.netbeans.modules.groovy.editor.AstPath;
import org.netbeans.modules.groovy.editor.VariableScopeVisitor;
import org.netbeans.modules.groovy.editor.elements.AstElement;
import org.netbeans.modules.groovy.editor.elements.IndexedElement;
import org.netbeans.modules.groovy.editor.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.parser.GroovyParserResult;
import org.netbeans.modules.groovy.editor.parser.SourceUtils;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AstUtilities {
    public static int getAstOffset(CompilationInfo compilationInfo, int n) {
        TranslatedSource translatedSource;
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/x-groovy", 0);
        if (parserResult != null && (translatedSource = parserResult.getTranslatedSource()) != null) {
            return translatedSource.getAstOffset(n);
        }
        return n;
    }

    public static BaseDocument getBaseDocument(FileObject fileObject, boolean bl) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                throw new IOException("Can't open " + fileObject.getNameExt());
            }
            StyledDocument styledDocument = bl ? editorCookie.openDocument() : editorCookie.getDocument();
            if (styledDocument instanceof BaseDocument) {
                return (BaseDocument)styledDocument;
            }
            try {
                Class<?> clazz = Class.forName("org.netbeans.modules.groovy.editor.test.GroovyTestBase");
                if (clazz != null) {
                    Method method = clazz.getMethod("getDocumentFor", FileObject.class);
                    return (BaseDocument)method.invoke(null, (Object[])new FileObject[]{fileObject});
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return null;
    }

    public static GroovyParserResult getParseResult(CompilationInfo compilationInfo) {
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/x-groovy", 0);
        if (parserResult == null) {
            return null;
        }
        return (GroovyParserResult)parserResult;
    }

    public static ModuleNode getRoot(CompilationInfo compilationInfo) {
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/x-groovy", 0);
        if (parserResult == null) {
            return null;
        }
        return AstUtilities.getRoot(parserResult);
    }

    public static ModuleNode getRoot(ParserResult parserResult) {
        assert (parserResult instanceof GroovyParserResult);
        GroovyParserResult groovyParserResult = (GroovyParserResult)parserResult;
        ParserResult.AstTreeNode astTreeNode = groovyParserResult.getAst();
        if (astTreeNode == null) {
            return null;
        }
        return (ModuleNode)astTreeNode.getAstNode();
    }

    public static OffsetRange getRangeFull(ASTNode aSTNode, BaseDocument baseDocument) {
        int n;
        if (aSTNode.getLineNumber() < 0 || aSTNode.getColumnNumber() < 0 || aSTNode.getLastLineNumber() < 0 || aSTNode.getLastColumnNumber() < 0) {
            return OffsetRange.NONE;
        }
        int n2 = AstUtilities.getOffset(baseDocument, aSTNode.getLineNumber(), aSTNode.getColumnNumber());
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = AstUtilities.getOffset(baseDocument, aSTNode.getLastLineNumber(), aSTNode.getLastColumnNumber())) < 0) {
            n = 0;
        }
        return new OffsetRange(n2, n);
    }

    public static OffsetRange getRange(ASTNode aSTNode, BaseDocument baseDocument) {
        int n = aSTNode.getLineNumber();
        int n2 = aSTNode.getColumnNumber();
        if (n < 1 || n2 < 1) {
            n = 1;
            n2 = 1;
        }
        if (aSTNode instanceof FieldNode) {
            int n3 = AstUtilities.getOffset(baseDocument, n, n2);
            FieldNode fieldNode = (FieldNode)aSTNode;
            return AstUtilities.getNextIdentifierByName(baseDocument, fieldNode.getName(), n3);
        }
        if (aSTNode instanceof ClassNode) {
            if (baseDocument != null) {
                ClassNode classNode;
                int n4;
                int n5;
                int n6 = AstUtilities.getOffset(baseDocument, n, n2) + "class".length();
                if (n6 > (n5 = baseDocument.getLength())) {
                    n6 = n5;
                }
                try {
                    n6 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n6);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                if (n6 < 0) {
                    n6 = 0;
                }
                if ((n4 = n6 + (classNode = (ClassNode)aSTNode).getNameWithoutPackage().length()) > n5) {
                    n4 = n5;
                }
                return new OffsetRange(n6, n4);
            }
        } else {
            if (aSTNode instanceof ConstructorNode) {
                int n7 = AstUtilities.getOffset(baseDocument, n, n2);
                ConstructorNode constructorNode = (ConstructorNode)aSTNode;
                return new OffsetRange(n7, n7 + constructorNode.getDeclaringClass().getNameWithoutPackage().length());
            }
            if (aSTNode instanceof MethodNode) {
                int n8 = AstUtilities.getOffset(baseDocument, n, n2);
                MethodNode methodNode = (MethodNode)aSTNode;
                return AstUtilities.getNextIdentifierByName(baseDocument, methodNode.getName(), n8);
            }
            if (aSTNode instanceof VariableExpression) {
                int n9 = AstUtilities.getOffset(baseDocument, n, n2);
                VariableExpression variableExpression = (VariableExpression)aSTNode;
                return AstUtilities.getNextIdentifierByName(baseDocument, variableExpression.getName(), n9);
            }
            if (aSTNode instanceof Parameter) {
                Parameter parameter;
                String string;
                int n10 = AstUtilities.getOffset(baseDocument, aSTNode.getLastLineNumber(), aSTNode.getLastColumnNumber());
                if (n10 - (string = (parameter = (Parameter)aSTNode).getName()).length() < 0) {
                    return OffsetRange.NONE;
                }
                return new OffsetRange(n10 - string.length(), n10);
            }
            if (aSTNode instanceof MethodCallExpression) {
                MethodCallExpression methodCallExpression = (MethodCallExpression)aSTNode;
                Expression expression = methodCallExpression.getMethod();
                n = expression.getLineNumber();
                n2 = expression.getColumnNumber();
                if (n < 1 || n2 < 1) {
                    n = 1;
                    n2 = 1;
                }
                int n11 = AstUtilities.getOffset(baseDocument, n, n2);
                return new OffsetRange(n11, n11 + methodCallExpression.getMethodAsString().length());
            }
            if (aSTNode instanceof ClassExpression) {
                ClassExpression classExpression = (ClassExpression)aSTNode;
                int n12 = AstUtilities.getOffset(baseDocument, n, n2);
                return new OffsetRange(n12, n12 + classExpression.getText().length());
            }
            if (aSTNode instanceof ConstantExpression) {
                ConstantExpression constantExpression = (ConstantExpression)aSTNode;
                int n13 = AstUtilities.getOffset(baseDocument, n, n2);
                return new OffsetRange(n13, n13 + constantExpression.getText().length());
            }
        }
        return OffsetRange.NONE;
    }

    public static List<ASTNode> children(ASTNode aSTNode) {
        List<ASTNode> list = new ArrayList<ASTNode>();
        if (aSTNode instanceof ModuleNode) {
            ModuleNode moduleNode = (ModuleNode)aSTNode;
            list.addAll(moduleNode.getClasses());
            list.add(moduleNode.getStatementBlock());
        } else if (aSTNode instanceof ClassNode) {
            AnnotatedNode annotatedNode;
            ClassNode classNode = (ClassNode)aSTNode;
            for (Object e : classNode.getMethods()) {
                annotatedNode = (MethodNode)e;
                if (annotatedNode.getLineNumber() < 0) continue;
                list.add(annotatedNode);
            }
            for (Object e : classNode.getFields()) {
                annotatedNode = (FieldNode)e;
                if (annotatedNode.getLineNumber() < 0) continue;
                list.add(annotatedNode);
            }
            for (Object e : classNode.getDeclaredConstructors()) {
                annotatedNode = (ConstructorNode)e;
                if (annotatedNode.getLineNumber() < 0) continue;
                list.add(annotatedNode);
            }
        } else if (aSTNode instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)aSTNode;
            list.add(methodNode.getCode());
            for (Parameter parameter : methodNode.getParameters()) {
                list.add(parameter);
            }
        } else if (!(aSTNode instanceof Parameter)) {
            if (aSTNode instanceof FieldNode) {
                FieldNode fieldNode = (FieldNode)aSTNode;
                Expression expression = fieldNode.getInitialExpression();
                if (expression != null) {
                    list.add(expression);
                }
            } else if (aSTNode != null) {
                AstChildrenSupport astChildrenSupport = new AstChildrenSupport();
                aSTNode.visit(astChildrenSupport);
                list = astChildrenSupport.children();
            }
        }
        return list;
    }

    public static int getOffset(BaseDocument baseDocument, int n, int n2) {
        assert (n > 0) : "Line number must be at least 1 and was: " + n;
        assert (n2 > 0) : "Column number must be at least 1 ans was: " + n2;
        int n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n - 1));
        if ((n3 += n2 - 1) < 0) {
            n3 = 0;
        }
        return n3;
    }

    public static ASTNode getForeignNode(final IndexedElement indexedElement) {
        final ASTNode[] aSTNodeArray = new ASTNode[1];
        FileObject fileObject = indexedElement.getFileObject();
        assert (fileObject != null) : "null FileObject for IndexedElement " + indexedElement;
        try {
            SourceUtils.runUserActionTask(fileObject, new CancellableTask<GroovyParserResult>(){

                public void run(GroovyParserResult groovyParserResult) throws Exception {
                    String string = indexedElement.getSignature();
                    if (string == null) {
                        return;
                    }
                    int n = string.indexOf(35);
                    if (n != -1) {
                        string = string.substring(n + 1);
                    }
                    for (AstElement astElement : groovyParserResult.getStructure().getElements()) {
                        ASTNode aSTNode = AstUtilities.findBySignature(astElement, string);
                        if (aSTNode == null) continue;
                        aSTNodeArray[0] = aSTNode;
                        return;
                    }
                }

                public void cancel() {
                }
            });
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        return aSTNodeArray[0];
    }

    private static ASTNode findBySignature(AstElement astElement, String string) {
        if (string.equals(astElement.getSignature())) {
            return astElement.getNode();
        }
        for (AstElement astElement2 : astElement.getChildren()) {
            ASTNode aSTNode = AstUtilities.findBySignature(astElement2, string);
            if (aSTNode == null) continue;
            return aSTNode;
        }
        return null;
    }

    public static String getDefSignature(MethodNode methodNode) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(methodNode.getName());
        Parameter[] parameterArray = methodNode.getParameters();
        if (parameterArray.length > 0) {
            stringBuilder.append('(');
            Iterator<Parameter> iterator = Arrays.asList(parameterArray).iterator();
            stringBuilder.append(iterator.next().getName());
            while (iterator.hasNext()) {
                stringBuilder.append(',');
                stringBuilder.append(iterator.next().getName());
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    private static OffsetRange getNextIdentifierByName(BaseDocument baseDocument, String string, int n) {
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
        if (tokenSequence.token().id() == GroovyTokenId.IDENTIFIER && TokenUtilities.equals((CharSequence)tokenSequence.token().text(), (Object)string)) {
            int n2 = tokenSequence.offset();
            return new OffsetRange(n2, n2 + string.length());
        }
        while (tokenSequence.moveNext()) {
            if (tokenSequence.token().id() != GroovyTokenId.IDENTIFIER || !TokenUtilities.equals((CharSequence)tokenSequence.token().text(), (Object)string)) continue;
            int n3 = tokenSequence.offset();
            return new OffsetRange(n3, n3 + string.length());
        }
        return OffsetRange.NONE;
    }

    public static String getFqnName(AstPath astPath) {
        ClassNode classNode = AstUtilities.getOwningClass(astPath);
        return classNode == null ? "" : classNode.getName();
    }

    public static ClassNode getOwningClass(AstPath astPath) {
        ListIterator<ASTNode> listIterator = astPath.rootToLeaf();
        while (listIterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)listIterator.next();
            if (!(aSTNode instanceof ClassNode)) continue;
            return (ClassNode)aSTNode;
        }
        return null;
    }

    public static ASTNode getScope(AstPath astPath, Variable variable) {
        for (ASTNode aSTNode : astPath) {
            Statement statement;
            Object object;
            if (aSTNode instanceof ClosureExpression) {
                object = ((ClosureExpression)aSTNode).getVariableScope();
                if (((VariableScope)object).getDeclaredVariable(variable.getName()) != null) {
                    return aSTNode;
                }
                statement = ((ClosureExpression)aSTNode).getCode();
                if (!(statement instanceof BlockStatement) || ((VariableScope)(object = ((BlockStatement)statement).getVariableScope())).getDeclaredVariable(variable.getName()) == null) continue;
                return aSTNode;
            }
            if (aSTNode instanceof MethodNode || aSTNode instanceof ConstructorNode) {
                object = ((MethodNode)aSTNode).getVariableScope();
                if (((VariableScope)object).getDeclaredVariable(variable.getName()) != null) {
                    return aSTNode;
                }
                statement = ((MethodNode)aSTNode).getCode();
                if (!(statement instanceof BlockStatement) || ((VariableScope)(object = ((BlockStatement)statement).getVariableScope())).getDeclaredVariable(variable.getName()) == null) continue;
                return aSTNode;
            }
            if (aSTNode instanceof ForStatement) {
                object = ((ForStatement)aSTNode).getVariableScope();
                if (((VariableScope)object).getDeclaredVariable(variable.getName()) == null) continue;
                return aSTNode;
            }
            if (aSTNode instanceof BlockStatement) {
                object = ((BlockStatement)aSTNode).getVariableScope();
                if (((VariableScope)object).getDeclaredVariable(variable.getName()) == null) continue;
                return aSTNode;
            }
            if (aSTNode instanceof ClosureListExpression) {
                object = ((ClosureListExpression)aSTNode).getVariableScope();
                if (((VariableScope)object).getDeclaredVariable(variable.getName()) == null) continue;
                return aSTNode;
            }
            if (aSTNode instanceof ClassNode) {
                object = (ClassNode)aSTNode;
                if (((ClassNode)object).getField(variable.getName()) == null) continue;
                return aSTNode;
            }
            if (!(aSTNode instanceof ModuleNode)) continue;
            object = (ModuleNode)aSTNode;
            statement = ((ModuleNode)object).getStatementBlock();
            VariableScope variableScope = ((BlockStatement)statement).getVariableScope();
            if (variableScope.getDeclaredVariable(variable.getName()) != null) {
                return statement;
            }
            Variable variable2 = variableScope.getReferencedClassVariable(variable.getName());
            if (variable2 == null) continue;
            return object;
        }
        return null;
    }

    public static ASTNode getVariable(ASTNode aSTNode, String string, AstPath astPath) {
        if (aSTNode instanceof ClosureExpression) {
            ClosureExpression closureExpression = (ClosureExpression)aSTNode;
            for (Parameter aSTNode2 : closureExpression.getParameters()) {
                if (!string.equals(aSTNode2.getName())) continue;
                return aSTNode2;
            }
            Statement object = closureExpression.getCode();
            if (object instanceof BlockStatement) {
                return AstUtilities.getVariableInBlockStatement((BlockStatement)object, string);
            }
        } else if (aSTNode instanceof MethodNode) {
            MethodNode methodNode = (MethodNode)aSTNode;
            for (Parameter variableScopeVisitor : methodNode.getParameters()) {
                if (!string.equals(variableScopeVisitor.getName())) continue;
                return variableScopeVisitor;
            }
            Statement parameter = methodNode.getCode();
            if (parameter instanceof BlockStatement) {
                return AstUtilities.getVariableInBlockStatement((BlockStatement)parameter, string);
            }
        } else if (aSTNode instanceof ConstructorNode) {
            ConstructorNode constructorNode = (ConstructorNode)aSTNode;
            for (Parameter parameter : constructorNode.getParameters()) {
                if (!string.equals(parameter.getName())) continue;
                return parameter;
            }
            Statement statement = constructorNode.getCode();
            if (statement instanceof BlockStatement) {
                return AstUtilities.getVariableInBlockStatement((BlockStatement)statement, string);
            }
        } else if (aSTNode instanceof ForStatement) {
            ASTNode aSTNode2;
            ASTNode aSTNode3;
            ForStatement forStatement = (ForStatement)aSTNode;
            Parameter parameter = forStatement.getVariable();
            if (string.equals(parameter.getName())) {
                return parameter;
            }
            Expression expression = forStatement.getCollectionExpression();
            if (expression instanceof ClosureListExpression && (aSTNode3 = AstUtilities.getVariableInClosureList((ClosureListExpression)expression, string)) != null) {
                return aSTNode3;
            }
            aSTNode3 = forStatement.getLoopBlock();
            if (aSTNode3 instanceof BlockStatement && (aSTNode2 = AstUtilities.getVariableInBlockStatement((BlockStatement)aSTNode3, string)) != null) {
                return aSTNode2;
            }
        } else {
            if (aSTNode instanceof BlockStatement) {
                return AstUtilities.getVariableInBlockStatement((BlockStatement)aSTNode, string);
            }
            if (aSTNode instanceof ClosureListExpression) {
                return AstUtilities.getVariableInClosureList((ClosureListExpression)aSTNode, string);
            }
            if (aSTNode instanceof ClassNode) {
                return ((ClassNode)aSTNode).getField(string);
            }
            if (aSTNode instanceof ModuleNode) {
                VariableScope variableScope;
                ModuleNode moduleNode = (ModuleNode)aSTNode;
                BlockStatement blockStatement = moduleNode.getStatementBlock();
                ASTNode aSTNode4 = AstUtilities.getVariableInBlockStatement(blockStatement, string);
                if (aSTNode4 == null && (variableScope = blockStatement.getVariableScope()).getReferencedClassVariable(string) != null) {
                    VariableScopeVisitor variableScopeVisitor = new VariableScopeVisitor(moduleNode.getContext(), astPath);
                    variableScopeVisitor.collect();
                    Set<ASTNode> set = variableScopeVisitor.getOccurrences();
                    if (!set.isEmpty()) {
                        aSTNode4 = set.iterator().next();
                    }
                }
                return aSTNode4;
            }
        }
        return null;
    }

    private static ASTNode getVariableInBlockStatement(BlockStatement blockStatement, String string) {
        for (Object e : blockStatement.getStatements()) {
            DeclarationExpression declarationExpression;
            ExpressionStatement expressionStatement;
            Expression expression;
            if (!(e instanceof ExpressionStatement) || !((expression = (expressionStatement = (ExpressionStatement)e).getExpression()) instanceof DeclarationExpression) || !string.equals((declarationExpression = (DeclarationExpression)expression).getVariableExpression().getName())) continue;
            return declarationExpression.getVariableExpression();
        }
        return null;
    }

    private static ASTNode getVariableInClosureList(ClosureListExpression closureListExpression, String string) {
        for (Object e : closureListExpression.getExpressions()) {
            DeclarationExpression declarationExpression;
            if (!(e instanceof DeclarationExpression) || !string.equals((declarationExpression = (DeclarationExpression)e).getVariableExpression().getName())) continue;
            return declarationExpression.getVariableExpression();
        }
        return null;
    }
}

