/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.Document;
import org.netbeans.api.java.queries.AccessibilityQuery;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.modules.javadoc.hints.Access;
import org.netbeans.modules.javadoc.hints.Analyzer;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavadocHintProvider
extends AbstractHint {
    public static final String SCOPE_KEY = "scope";
    public static final String SCOPE_DEFAULT = "protected";
    private boolean createJavadocKind;

    private JavadocHintProvider(boolean bl) {
        super(false, true, bl ? AbstractHint.HintSeverity.CURRENT_LINE_WARNING : AbstractHint.HintSeverity.WARNING, new String[0]);
        this.createJavadocKind = bl;
    }

    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD, Tree.Kind.CLASS, Tree.Kind.VARIABLE);
    }

    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        if (Boolean.FALSE.equals(AccessibilityQuery.isPubliclyAccessible((FileObject)compilationInfo.getFileObject().getParent()))) {
            return null;
        }
        if (compilationInfo.getElements().getTypeElement("java.lang.Object") == null) {
            return Collections.emptyList();
        }
        AbstractHint.HintSeverity hintSeverity = this.getSeverity();
        Severity severity = hintSeverity.toEditorSeverity();
        Document document = null;
        try {
            document = compilationInfo.getDocument();
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        if (document == null) {
            return null;
        }
        Access access = Access.resolve(this.getPreferences(null).get(SCOPE_KEY, SCOPE_DEFAULT));
        Analyzer analyzer = new Analyzer(compilationInfo, document, treePath, severity, hintSeverity, this.createJavadocKind, access);
        return analyzer.analyze();
    }

    public void cancel() {
    }

    public String getId() {
        return this.createJavadocKind ? "create-javadoc" : "error-in-javadoc";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(JavadocHintProvider.class, (String)(this.createJavadocKind ? "DN_CREATE_JAVADOC_HINT" : "DN_ERROR_IN_JAVADOC_HINT"));
    }

    public String getDescription() {
        return NbBundle.getMessage(JavadocHintProvider.class, (String)(this.createJavadocKind ? "DESC_CREATE_JAVADOC_HINT" : "DESC_ERROR_IN_JAVADOC_HINT"));
    }

    public JComponent getCustomizer(final Preferences preferences) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setOpaque(false);
        jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(JavadocHintProvider.class, (String)"LBL_SCOPE")));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                preferences.put(JavadocHintProvider.SCOPE_KEY, jRadioButton.getText());
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        JRadioButton jRadioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)jRadioButton, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"CTL_PUBLIC_OPTION"));
        jRadioButton.setToolTipText(NbBundle.getMessage(JavadocHintProvider.class, (String)"HINT_PUBLIC_OPTION"));
        jRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACD_PUBLIC_OPTION"));
        jRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACN_PUBLIC_OPTION"));
        jRadioButton.addActionListener(actionListener);
        buttonGroup.add(jRadioButton);
        jRadioButton.setSelected(jRadioButton.getText().equals(preferences.get(SCOPE_KEY, SCOPE_DEFAULT)));
        jRadioButton.setOpaque(false);
        jPanel2.add((Component)jRadioButton, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
        jRadioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)jRadioButton, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"CTL_PROTECTED_OPTION"));
        jRadioButton.setToolTipText(NbBundle.getMessage(JavadocHintProvider.class, (String)"HINT_PROTECTED_OPTION"));
        jRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACD_PROTECTED_OPTION"));
        jRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACN_PROTECTED_OPTION"));
        jRadioButton.addActionListener(actionListener);
        buttonGroup.add(jRadioButton);
        jRadioButton.setSelected(jRadioButton.getText().equals(preferences.get(SCOPE_KEY, SCOPE_DEFAULT)));
        jRadioButton.setOpaque(false);
        jPanel2.add((Component)jRadioButton, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
        jRadioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)jRadioButton, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"CTL_PACKAGE_OPTION"));
        jRadioButton.setToolTipText(NbBundle.getMessage(JavadocHintProvider.class, (String)"HINT_PACKAGE_OPTION"));
        jRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACD_PACKAGE_OPTION"));
        jRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACN_PACKAGE_OPTION"));
        jRadioButton.addActionListener(actionListener);
        buttonGroup.add(jRadioButton);
        jRadioButton.setSelected(jRadioButton.getText().equals(preferences.get(SCOPE_KEY, SCOPE_DEFAULT)));
        jRadioButton.setOpaque(false);
        jPanel2.add((Component)jRadioButton, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
        jRadioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)jRadioButton, (String)NbBundle.getMessage(JavadocHintProvider.class, (String)"CTL_PRIVATE_OPTION"));
        jRadioButton.setToolTipText(NbBundle.getMessage(JavadocHintProvider.class, (String)"HINT_PRIVATE_OPTION"));
        jRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACD_PRIVATE_OPTION"));
        jRadioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JavadocHintProvider.class, (String)"ACN_PRIVATE_OPTION"));
        jRadioButton.addActionListener(actionListener);
        buttonGroup.add(jRadioButton);
        jRadioButton.setSelected(jRadioButton.getText().equals(preferences.get(SCOPE_KEY, SCOPE_DEFAULT)));
        jRadioButton.setOpaque(false);
        jPanel2.add((Component)jRadioButton, new GridBagConstraints(0, n++, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 8, 0, 8), 0, 0));
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JLabel(), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        return jPanel;
    }

    public static JavadocHintProvider createCreateJavadoc() {
        return new JavadocHintProvider(true);
    }

    public static JavadocHintProvider createErrorInJavadoc() {
        return new JavadocHintProvider(false);
    }
}

