/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceTaskFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LookupBasedSourceTaskFactory
extends SourceTaskFactory {
    private Lookup.Result<FileObject> fileObjectResult;
    private Lookup.Result<DataObject> dataObjectResult;
    private Lookup.Result<Node> nodeResult;
    private List<FileObject> currentFiles = Collections.emptyList();
    private LookupListener listener = new LookupListenerImpl();

    public LookupBasedSourceTaskFactory(Phase phase, Source.Priority priority) {
        super(phase, priority);
    }

    protected final synchronized void setLookup(Lookup lookup) {
        if (this.fileObjectResult != null) {
            this.fileObjectResult.removeLookupListener(this.listener);
        }
        if (this.dataObjectResult != null) {
            this.dataObjectResult.removeLookupListener(this.listener);
        }
        if (this.nodeResult != null) {
            this.nodeResult.removeLookupListener(this.listener);
        }
        this.fileObjectResult = lookup.lookupResult(FileObject.class);
        this.dataObjectResult = lookup.lookupResult(DataObject.class);
        this.nodeResult = lookup.lookupResult(Node.class);
        this.fileObjectResult.addLookupListener(this.listener);
        this.dataObjectResult.addLookupListener(this.listener);
        this.nodeResult.addLookupListener(this.listener);
        this.updateCurrentFiles();
        this.fileObjectsChanged();
    }

    private synchronized void updateCurrentFiles() {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        hashSet.addAll(this.fileObjectResult.allInstances());
        for (DataObject dataObject : this.dataObjectResult.allInstances()) {
            hashSet.add(dataObject.getPrimaryFile());
        }
        for (DataObject dataObject : this.nodeResult.allInstances()) {
            hashSet.addAll(dataObject.getLookup().lookupAll(FileObject.class));
            for (DataObject dataObject2 : dataObject.getLookup().lookupAll(DataObject.class)) {
                hashSet.add(dataObject2.getPrimaryFile());
            }
        }
        this.currentFiles = new ArrayList<FileObject>(hashSet);
        this.lookupContentChanged();
    }

    public synchronized List<FileObject> getFileObjects() {
        return this.currentFiles;
    }

    protected void lookupContentChanged() {
    }

    private class LookupListenerImpl
    implements LookupListener {
        private LookupListenerImpl() {
        }

        public void resultChanged(LookupEvent lookupEvent) {
            LookupBasedSourceTaskFactory.this.updateCurrentFiles();
            LookupBasedSourceTaskFactory.this.fileObjectsChanged();
        }
    }
}

