/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.EmbeddingModel;
import org.netbeans.modules.gsf.api.GsfLanguage;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.netbeans.modules.gsfpath.api.classpath.ClassPath;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathFactory;
import org.netbeans.modules.gsfpath.spi.classpath.ClassPathImplementation;
import org.netbeans.modules.gsfpath.spi.classpath.PathResourceImplementation;
import org.netbeans.modules.gsfret.source.usages.ClassIndexManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageRegistry
implements Iterable<Language> {
    private static LanguageRegistry instance;
    private static final String ICON_BASE = "iconBase";
    private static final String LANGUAGE = "language.instance";
    private static final String PARSER = "parser.instance";
    private static final String COMPLETION = "completion.instance";
    private static final String RENAMER = "renamer.instance";
    private static final String FORMATTER = "formatter.instance";
    private static final String BRACKET_COMPLETION = "bracket.instance";
    private static final String DECLARATION_FINDER = "declarationfinder.instance";
    private static final String INDEXER = "indexer.instance";
    private static final String STRUCTURE = "structure.instance";
    private static final String HINTS = "hints.instance";
    private static final String SEMANTIC = "semantic.instance";
    private static final String OCCURRENCES = "occurrences.instance";
    private static final String FOLDER = "GsfPlugins";
    private List<Language> languages;
    private Map<String, Language> mimeToLanguage;
    private boolean languagesInitialized;
    private Collection<? extends EmbeddingModel> embeddingModels;
    private Map<String, Map<String, Boolean>> relevantMimes = new HashMap<String, Map<String, Boolean>>();
    private ClassPath libraryPath;
    private List<URL> urls;

    public LanguageRegistry() {
        this.initialize();
    }

    public void addLanguages(List<Language> list) {
        if (this.languages != null && this.languages.size() > 0) {
            throw new RuntimeException("This is for testing purposes only!!!");
        }
        this.languages = list;
        this.mimeToLanguage = new HashMap<String, Language>(2 * this.languages.size());
        for (Language language : this.languages) {
            String string = language.getMimeType();
            assert (string.equals(string.toLowerCase())) : string;
            this.mimeToLanguage.put(string, language);
        }
    }

    public static synchronized LanguageRegistry getInstance() {
        if (instance == null) {
            instance = new LanguageRegistry();
        }
        return instance;
    }

    public Language getLanguageByMimeType(@NonNull String string) {
        if (this.mimeToLanguage == null) {
            return null;
        }
        return this.mimeToLanguage.get(string);
    }

    @CheckForNull
    public EmbeddingModel getEmbedding(@NonNull String string, @NonNull String string2) {
        Collection<? extends EmbeddingModel> collection = this.getEmbeddingModels();
        for (EmbeddingModel embeddingModel : collection) {
            if (!embeddingModel.getTargetMimeType().equals(string) || !embeddingModel.getSourceMimeTypes().contains(string2)) continue;
            return embeddingModel;
        }
        return null;
    }

    private Collection<? extends EmbeddingModel> getEmbeddingModels() {
        if (this.embeddingModels == null) {
            this.embeddingModels = Lookup.getDefault().lookupAll(EmbeddingModel.class);
        }
        return this.embeddingModels;
    }

    public boolean isRelevantFor(FileObject fileObject, String string) {
        Boolean bl;
        String string2 = fileObject.getMIMEType();
        if (string.equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.relevantMimes.get(string);
        if (map == null) {
            map = new HashMap<String, Boolean>();
            this.relevantMimes.put(string, map);
        }
        if ((bl = map.get(string2)) == null) {
            bl = Boolean.FALSE;
            Collection<? extends EmbeddingModel> collection = this.getEmbeddingModels();
            for (EmbeddingModel embeddingModel : collection) {
                if (!embeddingModel.getTargetMimeType().equals(string) || !embeddingModel.getSourceMimeTypes().contains(string2)) continue;
                bl = Boolean.TRUE;
                break;
            }
            map.put(string2, bl);
        }
        return bl;
    }

    @NonNull
    public List<Language> getApplicableLanguages(String string) {
        Collection<? extends EmbeddingModel> collection = this.getEmbeddingModels();
        ArrayList<Language> arrayList = new ArrayList<Language>(5);
        Language language = this.getLanguageByMimeType(string);
        if (language != null) {
            arrayList.add(language);
        }
        for (EmbeddingModel embeddingModel : collection) {
            Language language2;
            if (!embeddingModel.getSourceMimeTypes().contains(string) || (language2 = this.getLanguageByMimeType(embeddingModel.getTargetMimeType())) == null || arrayList.contains(language2)) continue;
            arrayList.add(language2);
        }
        return arrayList;
    }

    public List<URL> getLibraryUrls() {
        if (this.urls == null) {
            this.urls = new ArrayList<URL>();
            for (Language language : this) {
                GsfLanguage gsfLanguage = language.getGsfLanguage();
                if (gsfLanguage == null) continue;
                for (FileObject fileObject : gsfLanguage.getCoreLibraries()) {
                    try {
                        URL uRL = FileUtil.toFile((FileObject)fileObject).toURI().toURL();
                        this.urls.add(uRL);
                        ClassIndexManager.get(language).addBootRoot(uRL);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Exceptions.printStackTrace((Throwable)malformedURLException);
                    }
                }
            }
        }
        return this.urls;
    }

    public List<FileObject> getLibraryFos() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        for (Language language : this) {
            GsfLanguage gsfLanguage = language.getGsfLanguage();
            if (gsfLanguage == null) continue;
            for (FileObject fileObject : gsfLanguage.getCoreLibraries()) {
                arrayList.add(fileObject);
            }
        }
        return arrayList;
    }

    public ClassPath getLibraryPaths() {
        if (this.libraryPath == null) {
            List<URL> list = this.getLibraryUrls();
            final URL[] uRLArray = list.toArray(new URL[list.size()]);
            this.libraryPath = ClassPathFactory.createClassPath((ClassPathImplementation)new ClassPathImplementation(){

                public List<? extends PathResourceImplementation> getResources() {
                    return Collections.singletonList(new PathResourceImplementation(){

                        public URL[] getRoots() {
                            return uRLArray;
                        }

                        public ClassPathImplementation getContent() {
                            return null;
                        }

                        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                        }

                        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                        }
                    });
                }

                public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }

                public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }
            });
        }
        return this.libraryPath;
    }

    private void addLanguages(List<Language> list, TokenSequence tokenSequence, int n) {
        tokenSequence.move(n);
        if (tokenSequence.moveNext() || tokenSequence.movePrevious()) {
            String string;
            Language language;
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 != null) {
                this.addLanguages(list, tokenSequence2, n);
            }
            if ((language = this.getLanguageByMimeType(string = tokenSequence.language().mimeType())) != null) {
                list.add(language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Language> getEmbeddedLanguages(BaseDocument baseDocument, int n) {
        Language language;
        Object object;
        ArrayList<Language> arrayList = new ArrayList<Language>();
        baseDocument.readLock();
        try {
            object = TokenHierarchy.get((Document)baseDocument).tokenSequence();
            if (object != null) {
                this.addLanguages((List<Language>)arrayList, (TokenSequence)object, n);
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        object = (String)baseDocument.getProperty((Object)"mimeType");
        if (object != null && (language = this.getLanguageByMimeType((String)object)) != null && (arrayList.size() == 0 || arrayList.get(arrayList.size() - 1) != language)) {
            arrayList.add(language);
        }
        return arrayList;
    }

    public boolean isSupported(@NonNull String string) {
        if (string == null) {
            return false;
        }
        return this.getLanguageByMimeType(string) != null;
    }

    public String getLanguagesDisplayName() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Language language : this) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(language.getDisplayName());
        }
        return stringBuilder.toString();
    }

    @Override
    public Iterator<Language> iterator() {
        if (this.languages == null) {
            return new Iterator<Language>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Language next() {
                    return null;
                }

                @Override
                public void remove() {
                }
            };
        }
        return this.languages.iterator();
    }

    private synchronized void initialize() {
        if (this.languages == null) {
            this.readSfs();
            if (this.languages != null) {
                this.mimeToLanguage = new HashMap<String, Language>(2 * this.languages.size());
                for (Language language : this.languages) {
                    String string = language.getMimeType();
                    assert (string.equals(string.toLowerCase())) : string;
                    this.mimeToLanguage.put(string, language);
                }
            }
            this.initializeLanguages();
        }
    }

    synchronized void initializeLanguages() {
        if (this.languagesInitialized) {
            return;
        }
        this.languagesInitialized = true;
        if (this.languages == null) {
            return;
        }
        for (Language language : this.languages) {
            this.initializeLanguage(language);
        }
    }

    private void readSfs() {
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject = fileSystem.findResource(FOLDER);
        if (fileObject == null) {
            return;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        this.languages = new ArrayList<Language>();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2 = fileObjectArray[i];
            FileObject[] fileObjectArray2 = fileObject2.getChildren();
            for (int j = 0; j < fileObjectArray2.length; ++j) {
                String string;
                FileObject fileObject3;
                FileObject fileObject4 = fileObjectArray2[j];
                String string2 = fileObject2.getName() + "/" + fileObject4.getName();
                Language language = new Language(string2);
                this.languages.add(language);
                Boolean bl = (Boolean)fileObject4.getAttribute("useCustomEditorKit");
                if (bl != null && bl.booleanValue()) {
                    language.setUseCustomEditorKit(true);
                }
                if ((fileObject3 = fileSystem.findResource("Loaders/" + string2)) != null && (string = (String)fileObject3.getAttribute(ICON_BASE)) != null && string.length() > 0) {
                    language.setIconBase(string);
                }
                boolean bl2 = false;
                for (FileObject fileObject5 : fileObject4.getChildren()) {
                    String string3 = fileObject5.getNameExt();
                    if (LANGUAGE.equals(string3)) {
                        bl2 = true;
                        language.setGsfLanguageFile(fileObject5);
                        continue;
                    }
                    if (HINTS.equals(string3)) {
                        language.setHintsProviderFile(fileObject5);
                        continue;
                    }
                    if (STRUCTURE.equals(string3)) {
                        language.setStructureFile(fileObject5);
                        continue;
                    }
                    if (PARSER.equals(string3)) {
                        language.setParserFile(fileObject5);
                        continue;
                    }
                    if (COMPLETION.equals(string3)) {
                        language.setCompletionProviderFile(fileObject5);
                        continue;
                    }
                    if (RENAMER.equals(string3)) {
                        language.setInstantRenamerFile(fileObject5);
                        continue;
                    }
                    if (FORMATTER.equals(string3)) {
                        language.setFormatterFile(fileObject5);
                        continue;
                    }
                    if (DECLARATION_FINDER.equals(string3)) {
                        language.setDeclarationFinderFile(fileObject5);
                        continue;
                    }
                    if (BRACKET_COMPLETION.equals(string3)) {
                        language.setBracketCompletionFile(fileObject5);
                        continue;
                    }
                    if (INDEXER.equals(string3)) {
                        language.setIndexerFile(fileObject5);
                        continue;
                    }
                    if (SEMANTIC.equals(string3)) {
                        language.setSemanticAnalyzer(fileObject5);
                        continue;
                    }
                    if (!OCCURRENCES.equals(string3)) continue;
                    language.setOccurrencesFinderFile(fileObject5);
                }
                if (bl2) continue;
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "No GSF language registered for mime type " + string2);
            }
        }
    }

    private void initializeLanguage(Language language) {
        FileObject fileObject;
        String string;
        FileSystem fileSystem;
        block13: {
            fileSystem = Repository.getDefault().getDefaultFileSystem();
            if (language.hasStructureScanner()) {
                string = "Navigator/Panels/" + language.getMimeType() + "/org-netbeans-modules-gsfret-navigation-ClassMemberPanel.instance";
                fileObject = fileSystem.findResource(string);
                if (fileObject == null) {
                    try {
                        FileObject fileObject2;
                        FileUtil.createData((FileObject)fileSystem.getRoot(), (String)string);
                        if (!language.getMimeType().equals("text/x-json") || (fileObject2 = fileSystem.findResource("Navigator/Panels/text/x-json/org-netbeans-modules-languages-features-LanguagesNavigator.instance")) == null) break block13;
                        try {
                            fileObject2.delete();
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            } else {
                string = "Navigator/Panels/" + language.getMimeType() + "/org-netbeans-modules-gsfret-navigation-ClassMemberPanel.instance";
                fileObject = fileSystem.findResource(string);
                if (fileObject != null) {
                    try {
                        fileObject.delete();
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        }
        if ((fileObject = fileSystem.findResource(string = "Navigator/Panels/" + language.getMimeType() + "/org-netbeans-modules-retouche-navigation-ClassMemberPanel.instance")) != null) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }

    void initializeLanguageForEditor(Language language) {
        String string;
        FileObject fileObject;
        Object object;
        FileObject fileObject2;
        FileObject fileObject3;
        FileObject fileObject4;
        FileObject fileObject5;
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        String string2 = language.getMimeType();
        FileObject fileObject6 = fileSystem.findResource("Editors/" + string2);
        FileObject fileObject7 = fileObject6.getFileObject("Settings.settings");
        if (fileObject7 != null) {
            try {
                fileObject7.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject6.getFileObject("SideBar/org-netbeans-modules-editor-gsfret-GsfCodeFoldingSideBarFactory.instance") == null && language.getParser() != null) {
            try {
                FileUtil.createData((FileObject)fileObject6, (String)"FoldManager/org-netbeans-modules-gsfret-editor-fold-GsfFoldManagerFactory.instance");
                FileUtil.createData((FileObject)fileObject6, (String)"SideBar/org-netbeans-modules-editor-gsfret-GsfCodeFoldingSideBarFactory.instance").setAttribute("position", (Object)1200);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if ((string2.equals("text/x-yaml") || string2.equals("text/x-json")) && (fileObject5 = fileObject6.getFileObject("Popup/generate-fold-popup")) != null) {
            try {
                fileObject5.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            fileObject5 = fileObject6.getFileObject("ToolTips/org-netbeans-modules-languages-features-ToolTipAnnotation.instance");
            if (fileObject5 != null) {
                try {
                    fileObject5.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if ((fileObject5 = fileObject6.getFileObject("Popup/org-netbeans-modules-languages-features-GoToDeclarationAction.instance")) != null) {
                try {
                    fileObject5.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if ((fileObject5 = fileObject6.getFileObject("UpToDateStatusProvider/org-netbeans-modules-languages-features-UpToDateStatusProviderFactoryImpl.instance")) != null) {
                try {
                    fileObject5.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if ((fileObject5 = fileObject6.getFileObject("run_script.instance")) != null) {
                try {
                    fileObject5.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        boolean bl = false;
        FileObject fileObject8 = fileObject6.getFileObject("SideBar/org-netbeans-modules-editor-retouche-GsfCodeFoldingSideBarFactory.instance");
        if (fileObject8 != null) {
            bl = true;
            try {
                fileObject8.delete();
                fileObject8 = fileObject6.getFileObject("FoldManager/org-netbeans-modules-retouche-editor-fold-GsfFoldManagerFactory.instance");
                if (fileObject8 != null) {
                    fileObject8.delete();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if ((fileObject4 = fileObject6.getFileObject("HyperlinkProviders/GsfHyperlinkProvider.instance")) == null) {
            try {
                fileObject4 = FileUtil.createData((FileObject)fileObject6, (String)"HyperlinkProviders/GsfHyperlinkProvider.instance");
                fileObject4.setAttribute("instanceClass", (Object)"org.netbeans.modules.gsfret.editor.hyperlink.GsfHyperlinkProvider");
                fileObject4.setAttribute("instanceOf", (Object)"org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else {
            if (bl && "org.netbeans.modules.retouche.editor.hyperlink.GsfHyperlinkProvider".equals(fileObject4.getAttribute("instanceClass"))) {
                try {
                    fileObject4.setAttribute("instanceClass", (Object)"org.netbeans.modules.gsfret.editor.hyperlink.GsfHyperlinkProvider");
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if ("org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider".equals(fileObject4.getAttribute("instanceOf"))) {
                try {
                    fileObject4.setAttribute("instanceOf", (Object)"org.netbeans.lib.editor.hyperlink.spi.HyperlinkProviderExt");
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        if ((fileObject3 = fileObject6.getFileObject("Popup")) == null) {
            try {
                fileObject3 = fileObject6.createFolder("Popup");
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        if ((fileObject2 = fileObject3.getFileObject("in-place-refactoring")) == null) {
            try {
                fileObject3.createData("in-place-refactoring").setAttribute("position", (Object)680);
                object = fileObject3.getFileObject("goto");
                if (object == null) {
                    object = fileObject3.createFolder("goto");
                    object.setAttribute("position", (Object)500);
                }
                object.setAttribute("SystemFileSystem.localizingBundle", (Object)"org.netbeans.modules.gsf.Bundle");
                object.createData("goto-declaration").setAttribute("position", (Object)500);
                object.createData("goto").setAttribute("position", (Object)600);
                if (fileObject3.getFileObject("SeparatorBeforeCut.instance") == null) {
                    fileObject = fileObject3.createData("SeparatorBeforeCut.instance");
                    fileObject.setAttribute("instanceClass", (Object)"javax.swing.JSeparator");
                    fileObject.setAttribute("position", (Object)1200);
                }
                if (fileObject3.getFileObject("format") == null) {
                    fileObject3.createData("format").setAttribute("position", (Object)750);
                }
                fileObject = fileObject3.createData("SeparatorAfterFormat.instance");
                fileObject.setAttribute("instanceClass", (Object)"javax.swing.JSeparator");
                fileObject.setAttribute("position", (Object)780);
                if (bl && fileObject3.getFileObject("pretty-print") != null) {
                    fileObject3.getFileObject("pretty-print").delete();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        } else {
            if (bl && fileObject3.getFileObject("generate-goto-popup") != null) {
                object = fileObject3.getFileObject("generate-goto-popup");
                try {
                    object.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (bl && fileObject6.getFileObject("Popup/format") == null) {
                try {
                    fileObject3.createData("format");
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (bl && fileObject6.getFileObject("Popup/pretty-print") != null) {
                try {
                    object = fileObject6.getFileObject("Popup/pretty-print");
                    object.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        if (fileObject6.getFileObject("UpToDateStatusProvider/org-netbeans-modules-gsfret-hints-GsfUpToDateStateProviderFactory.instance") == null) {
            try {
                FileUtil.createData((FileObject)fileObject6, (String)"UpToDateStatusProvider/org-netbeans-modules-gsfret-hints-GsfUpToDateStateProviderFactory.instance");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (bl && (object = fileObject6.getFileObject("UpToDateStatusProvider/org-netbeans-modules-retouche-hints-GsfUpToDateStateProviderFactory.instance")) != null) {
            try {
                object.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject6.getFileObject("UpToDateStatusProvider/org-netbeans-modules-gsfret-editor-semantic-OccurrencesMarkProviderCreator.instance") == null) {
            try {
                FileUtil.createData((FileObject)fileObject6, (String)"UpToDateStatusProvider/org-netbeans-modules-gsfret-editor-semantic-OccurrencesMarkProviderCreator.instance");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (bl && (object = fileObject6.getFileObject("UpToDateStatusProvider/org-netbeans-modules-retouche-editor-semantic-OccurrencesMarkProviderCreator.instance")) != null) {
            try {
                object.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject6.getFileObject("org-netbeans-modules-gsfret-editor-semantic-HighlightsLayerFactoryImpl.instance") == null) {
            try {
                object = FileUtil.createData((FileObject)fileObject6, (String)"org-netbeans-modules-gsfret-editor-semantic-HighlightsLayerFactoryImpl.instance");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if ((fileObject = fileObject6.getFileObject((String)(object = "CompletionProviders"))) == null) {
            try {
                fileObject = fileObject6.createFolder((String)object);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject != null) {
            FileObject fileObject9;
            string = "org-netbeans-lib-editor-codetemplates-CodeTemplateCompletionProvider.instance";
            FileObject fileObject10 = fileObject6.getFileObject((String)object + "/" + string);
            if (fileObject10 == null) {
                try {
                    fileObject.createData(string);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            String string3 = "org-netbeans-modules-gsfret-editor-completion-GsfCompletionProvider.instance";
            FileObject fileObject11 = fileObject6.getFileObject((String)object + "/" + string3);
            if (fileObject11 == null) {
                try {
                    fileObject.createData(string3);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (bl && (fileObject9 = fileObject.getFileObject("org-netbeans-modules-retouche-editor-completion-GsfCompletionProvider.instance")) != null) {
                try {
                    fileObject9.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        if (fileObject6.getFileObject("Toolbars/Default/comment") == null && language.getGsfLanguage() != null && language.getGsfLanguage().getLineCommentPrefix() != null) {
            try {
                string = FileUtil.createData((FileObject)fileObject6, (String)"Toolbars/Default/Separator-before-comment.instance");
                string.setAttribute("instanceClass", (Object)"javax.swing.JSeparator");
                string.setAttribute("position", (Object)30000);
                FileUtil.createData((FileObject)fileObject6, (String)"Toolbars/Default/comment").setAttribute("position", (Object)30100);
                FileUtil.createData((FileObject)fileObject6, (String)"Toolbars/Default/uncomment").setAttribute("position", (Object)30200);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject6.getFileObject("CodeTemplateProcessorFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateProcessor$Factory.instance") == null) {
            try {
                string = FileUtil.createData((FileObject)fileObject6, (String)"CodeTemplateProcessorFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateProcessor$Factory.instance");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (bl && (string = fileObject6.getFileObject("CodeTemplateProcessorFactories/org-netbeans-modules-retouche-editor-codetemplates-GsfCodeTemplateProcessor$Factory.instance")) != null) {
            try {
                string.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (fileObject6.getFileObject("CodeTemplateFilterFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateFilter$Factory.instance") == null) {
            try {
                string = FileUtil.createData((FileObject)fileObject6, (String)"CodeTemplateFilterFactories/org-netbeans-modules-gsfret-editor-codetemplates-GsfCodeTemplateFilter$Factory.instance");
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (bl && (string = fileObject6.getFileObject("CodeTemplateFilterFactories/org-netbeans-modules-retouche-editor-codetemplates-GsfCodeTemplateFilter$Factory.instance")) != null) {
            try {
                string.delete();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
    }
}

