/*
 * PUBLIC DOMAIN PCCTS-BASED C++ GRAMMAR (cplusplus.g, stat.g, expr.g)
 *
 * Authors: Sumana Srinivasan, NeXT Inc.;            sumana_srinivasan@next.com
 *          Terence Parr, Parr Research Corporation; parrt@parr-research.com
 *          Russell Quong, Purdue University;        quong@ecn.purdue.edu
 *
 * VERSION 1.2
 *
 * SOFTWARE RIGHTS
 *
 * This file is a part of the ANTLR-based C++ grammar and is free
 * software.  We do not reserve any LEGAL rights to its use or
 * distribution, but you may NOT claim ownership or authorship of this
 * grammar or support code.  An individual or company may otherwise do
 * whatever they wish with the grammar distributed herewith including the
 * incorporation of the grammar or the output generated by ANTLR into
 * commerical software.  You may redistribute in source or binary form
 * without payment of royalties to us as long as this header remains
 * in all source distributions.
 *
 * We encourage users to develop parsers/tools using this grammar.
 * In return, we ask that credit is given to us for developing this
 * grammar.  By "credit", we mean that if you incorporate our grammar or
 * the generated code into one of your programs (commercial product,
 * research project, or otherwise) that you acknowledge this fact in the
 * documentation, research report, etc....  In addition, you should say nice
 * things about us at every opportunity.
 *
 * As long as these guidelines are kept, we expect to continue enhancing
 * this grammar.  Feel free to send us enhancements, fixes, bug reports,
 * suggestions, or general words of encouragement at parrt@parr-research.com.
 * 
 * NeXT Computer Inc.
 * 900 Chesapeake Dr.
 * Redwood City, CA 94555
 * 12/02/1994
 * 
 * Restructured for public consumption by Terence Parr late February, 1995.
 *
 * DISCLAIMER: we make no guarantees that this grammar works, makes sense,
 *             or can be used to do anything useful.
 */
/* 2001-2002
 * Version 1.0
 * This C++ grammar file has been converted from PCCTS to run under 
 *  ANTLR to generate lexer and parser in C++ code by
 *  Jianguo Zuo and David Wigg at
 *  The Centre for Systems and Software Engineering
 *  London South Bank University
 *  London, UK.
 *
 */
/* 2003
 * Version 2.0 was published by David Wigg in September 2003
 */
/* 2004
 * Version 3.0 July 2004
 * This is version 3.0 of the C++ grammar definition for ANTLR to 
 *  generate lexer and parser in C++ code updated by
 *  David Wigg at
 *  The Centre for Systems and Software Engineering
 *  London South Bank University
 *  London, UK.
 *
 * wiggjd@bcs.ac.uk
 * blackse@lsbu.ac.uk
 *
 * See MyReadMe.txt for further information
 *
 * This file is best viewed in courier font with tabs set to 4 spaces
 */

/* 2005
 * Some modifications were made by Gordon Prieur (Gordon.Prieur@sun.com);
 * after that the grammar was ported to Java by Vladimir Kvashin (Vladimir.Kvashin@sun.com)
 *
 * NOCDDL
 */

header {

package org.netbeans.modules.cnd.modelimpl.parser.generated;

import java.io.*;
import java.util.*;

import antlr.*;
import antlr.collections.*;
import antlr.debug.misc.*;
import org.netbeans.modules.cnd.modelimpl.parser.*;
import org.netbeans.modules.cnd.modelimpl.parser.Enum;
import org.netbeans.modules.cnd.modelimpl.debug.*;

}

options {
	language = "Java";
} 

class CPPParser extends Parser;

options {
	k = 2;
	importVocab = APT;
	exportVocab = CPP;
	codeGenMakeSwitchThreshold = 2;
	codeGenBitsetTestThreshold = 3;
	noConstructors = true;
	buildAST = true;
}

//
// We create CsmAST node for each token,
// which isn't dummy - i.e. which has an appropriate text in translation unit.
// Examples are  CSM_USING_DIRECTIVE and CSM_USING_DECLARATION
//
tokens {
        CSM_START<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>; // dummy token - should be BEFORE ALL CSM_...

	CSM_TRANSLATION_UNIT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_CLASS_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_ENUM_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_NAMESPACE_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.NamedFakeAST>;
	CSM_CTOR_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_CTOR_TEMPLATE_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_FUNCTION_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_FUNCTION_DEFINITION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_FUNCTION_RET_FUN_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_FUNCTION_RET_FUN_DEFINITION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_FUNCTION_TEMPLATE_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_FUNCTION_TEMPLATE_DEFINITION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_PARAMETER_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_TYPE_BUILTIN<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_TYPE_COMPOUND<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	CSM_TEMPLATE_EXPLICIT_SPECIALIZATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_TEMPLATE_EXPLICIT_INSTANTIATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_TEMPLATE_FUNCTION_DEFINITION_EXPLICIT_SPECIALIZATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_TEMPLATE_CLASS_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_EXTERN_TEMPLATE<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_TEMPLATE_TEMPLATE_PARAMETER<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	CSM_DTOR_DEFINITION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_DTOR_TEMPLATE_DEFINITION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_DTOR_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_CTOR_DEFINITION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_CTOR_TEMPLATE_DEFINITION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_USER_TYPE_CAST<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_USER_TYPE_CAST_DEFINITION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	CSM_GENERIC_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	
	CSM_TEMPL_FWD_CL_OR_STAT_MEM<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_STRANGE_2<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_FIELD<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	CSM_VISIBILITY_REDEF<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	
	CSM_TEMPLATE_PARMLIST<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_PARMLIST<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_KR_PARMLIST<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	
	CSM_ENUMERATOR_LIST<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	CSM_NAMESPACE_ALIAS<AST=org.netbeans.modules.cnd.modelimpl.parser.NamedFakeAST>;
	CSM_USING_DIRECTIVE<AST=org.netbeans.modules.cnd.modelimpl.parser.NamedFakeAST>;
	CSM_USING_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.NamedFakeAST>;

        CSM_CTOR_INITIALIZER<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
        CSM_CTOR_INITIALIZER_LIST<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	CSM_QUALIFIED_ID<AST=org.netbeans.modules.cnd.modelimpl.parser.NamedFakeAST>;

	////////// STATEMENTS //////////

	// This is just a start marker of the token types, related with statements
	// Do NOT create tokens of this type
	// Place token types, which correspond to statements only AFTER this type
	// (but BEFORE CSM_STATEMENTS_END)
	CSM_STATEMENTS_START<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	CSM_LABELED_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_CASE_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_DEFAULT_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_EXPRESSION_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_DECLARATION_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_COMPOUND_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
        CSM_COMPOUND_STATEMENT_LAZY<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	// selection
	CSM_IF_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_SWITCH_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	// iteration
	CSM_WHILE_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_DO_WHILE_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_FOR_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	// jump
	CSM_GOTO_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_CONTINUE_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_BREAK_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_RETURN_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	// try-catch
    CSM_TRY_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
    CSM_CATCH_CLAUSE<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	CSM_THROW_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_ASM_BLOCK<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	// This is just an end marker of the token types, related with statements
	// Do NOT create tokens of this type
	// Place token types, which correspond to statements only BEFORE this type
	// (but AFTER CSM_STATEMENTS_START)
	CSM_STATEMENTS_END<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	////////// EXPRESSIONS //////////

	// This is just a start marker of the token types, related with expressions
	// Do NOT create tokens of this type
	// Place token types, which correspond to expressions only AFTER this type
	// (but BEFORE CSM_EXPRESSIONS_END)
	CSM_EXPRESSIONS_START<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	// temporary solution
	// to wrap all expressions 
	CSM_EXPRESSION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

        // cast
        CSM_CAST_EXPRESSION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
        CSM_FUN_TYPE_CAST_EXPRESSION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

        // function call
        CSM_FUNCALL_EXPRESSION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	// This is just an end marker of the token types, related with expressions
	// Do NOT create tokens of this type
	// Place token types, which correspond to expressions only BEFORE this type
	// (but AFTER CSM_EXPRESSIONS_START)
	CSM_EXPRESSIONS_END<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	//////////  //////////

	CSM_FOR_INIT_STATEMENT<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	CSM_LINKAGE_SPECIFICATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_PTR_OPERATOR<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	CSM_ARRAY_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_VARIABLE_DECLARATION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	CSM_CONDITION<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;
	CSM_BASE_SPECIFIER<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	CSM_TEST<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>;

	CSM_END<AST=org.netbeans.modules.cnd.modelimpl.parser.FakeAST>; // dummy token - should be AFTER ALL CSM_...
}

{
    // Defines for flags passed to init methods
    public static final int CPP_STATEMENT_TRACE		= 0x1;
    public static final int CPP_STATEMENT_TRACE_VERBOSE = 0x2;
    public static final int CPP_SUPPRESS_ERRORS		= 0x4;

    public static final int CPP_CPLUSPLUS		= 0x8;
    public static final int CPP_ANSI_C			= 0x10;
    public static final int CPP_KandR_C			= 0x20;
    

    /** Switches legacy warnings on */
    protected static final boolean reportOddWarnings = Boolean.getBoolean("cnd.parser.odd.warnings");

    protected void addNewFold(int type, int startLnum, int startOffset, int endLnum, int endOffset) {}

    //	The statements in this block appear only in CPPParser.cpp and not in CPPLexer.cpp

    public static final
    int statementTrace = 0;	// Used to control selected (level) tracing (see support.cpp)
				// 1 Shows which external and member statements selected
				// 2 Shows above plus all declarations/definitions
				// 3 reserved for future use
				// 4 and above available for user

     protected boolean isLazyCompound() {
        return false;
    }

    protected void init(String filename, int flags) {

	setFilename(filename);
	//
	// Creates a dictionary to hold symbols with 4001 buckets, 200 scopes
	// and 800,000 characters // These can be changed to suit the size of
	// program(s) being parsed.
	//symbols = new CPPDictionary(4001, 200, 800000);

	// Set template parameter and external scopes. Set template parameter scope to 0.
	//templateParameterScope = symbols->getCurrentScopeIndex();
	//symbols->saveScope();	// Advance currentScope from 0 to 1
	//externalScope = symbols->getCurrentScopeIndex();	// Set external scope to 1

	// Declare predefined scope "std" in external scope
	//CPPSymbol *a = new CPPSymbol("std", CPPSymbol::otTypedef);
	//symbols->define("std", a);

	// Global flags to allow for nested declarations
	_td = false;		// For typedef
	_fd = false;		// For friend
	_sc = scInvalid;	// For StorageClass
	_tq = tqInvalid;	// For TypeQualifier
	_ts = tsInvalid;	// For TypeSpecifier
	_ds = dsInvalid;	// For DeclSpecifier

	//functionDefinition = 0;
	qualifierPrefix = new StringBuilder();
	enclosingClass = "";
	assign_stmt_RHS_found = 0;
	in_parameter_list = false;
	K_and_R = false;	// used to distinguish old K & R parameter definitions
	in_return = false;
	is_address = false;
	is_pointer = false;

	/*if ((flags & CPP_STATEMENT_TRACE) > 0) {
	    statementTrace = 1;
	}
	if ((flags & CPP_STATEMENT_TRACE_VERBOSE) > 0) {
	    statementTrace = 2;
	}*/
	if ((flags & CPP_SUPPRESS_ERRORS) > 0) {
	    reportErrors = false;
	}
	if ((flags & CPP_CPLUSPLUS) > 0) {
	    lang = CPLUSPLUS;
	} else if ((flags & CPP_ANSI_C) > 0) {
	    lang = ANSI_C;
	} else if (CPP_KandR_C > 0) { // VK: looks strange; well leave for a while
	    lang = KandR_C;
	} else {
	    lang = UNKNOWN_LANG;
	}
    }

    boolean isCPlusPlus() {
	return lang == CPLUSPLUS;
    }

	protected static final int tsInvalid   = 0x0;
	protected static final int tsVOID      = 0x1;
	protected static final int tsCHAR      = 0x2;
	protected static final int tsSHORT     = 0x4;
	protected static final int tsINT       = 0x8;
	protected static final int tsLONG      = 0x10;
	protected static final int tsFLOAT     = 0x20;
	protected static final int tsDOUBLE    = 0x40;
	protected static final int tsSIGNED    = 0x80;
	protected static final int tsUNSIGNED  = 0x100;
	protected static final int tsTYPEID    = 0x200;
	protected static final int tsSTRUCT    = 0x400;
	protected static final int tsENUM      = 0x800;
	protected static final int tsUNION     = 0x1000;
	protected static final int tsCLASS     = 0x2000;
	protected static final int tsWCHAR_T   = 0x4000;
	protected static final int tsBOOL      = 0x8000;

	public static class TypeQualifier extends Enum { public TypeQualifier(String id) { super(id); } }

	protected static final TypeQualifier tqInvalid = new TypeQualifier("tqInvalid");
	protected static final TypeQualifier tqCONST = new TypeQualifier("tqCONST");
	protected static final TypeQualifier tqVOLATILE = new TypeQualifier("tqVOLATILE");
	protected static final TypeQualifier tqCDECL = new TypeQualifier("tqCDECL");

	public static class StorageClass extends Enum { public StorageClass(String id) { super(id); } }

	protected static final StorageClass scInvalid = new StorageClass("scInvalid");
	protected static final StorageClass scAUTO = new StorageClass("scAUTO");
	protected static final StorageClass scREGISTER = new StorageClass("scREGISTER");
	protected static final StorageClass scSTATIC = new StorageClass("scSTATIC");
	protected static final StorageClass scEXTERN = new StorageClass("scEXTERN");
	protected static final StorageClass scMUTABLE = new StorageClass("scMUTABLE");

	public static class DeclSpecifier extends Enum { public DeclSpecifier(String id) { super(id); } }

	protected static final DeclSpecifier dsInvalid = new DeclSpecifier("dsInvalid");
	protected static final DeclSpecifier dsVIRTUAL = new DeclSpecifier("dsVIRTUAL");
	protected static final DeclSpecifier dsINLINE = new DeclSpecifier("dsINLINE");
	protected static final DeclSpecifier dsEXPLICIT = new DeclSpecifier("dsEXPLICIT");
	protected static final DeclSpecifier dsFRIEND = new DeclSpecifier("dsFRIEND");

        protected static final String LITERAL___global_ext = "__global";

	// typedef int QualifiedItem;
	protected static final int qiInvalid     = 0x0;
	protected static final int qiType        = 0x1;	// includes enum, class, typedefs, namespace
	protected static final int qiDtor        = 0x2;
	protected static final int qiCtor        = 0x4;
	protected static final int qiOperator    = 0x8;
	protected static final int qiPtrMember   = 0x10;
	protected static final int qiVar         = 0x20;
	protected static final int qiFun         = 0x40;
	
	// Language Definitions
	// TODO: what's the difference with the above constants (CPP_ANSI_C, etc)
	protected static final  int UNKNOWN_LANG	= 0x0;
	protected static final  int CPLUSPLUS	= 0x2;
	protected static final  int ANSI_C	= 0x4;
	protected static final  int KandR_C	= 0x8;

	private int errorCount = 0;

	public int getErrorCount() {
	    int cnt = errorCount;
	    return cnt;
	}

	public void reportError(RecognitionException e) {
            // Do not report errors that we had reported already
            if (lastRecoveryPosition == inputState.input.index()) {
                return;
            }
            
            if (Diagnostic.needStatistics()) Diagnostic.onParserError(e);

	    if (reportErrors) {
                if (TraceFlags.DEBUG) {
                    e.printStackTrace(System.err);
                } else {
                    super.reportError(e);
                }
	    }
	    errorCount++;
	}

	public void reportError(String s) {
	    if (reportErrors) {
		super.reportError(s);
	    }
	    errorCount++;
	}

        // Set of tokens stopping recovery
        private static final BitSet stopSet = new BitSet();
        static {
            stopSet.add(LCURLY);
            stopSet.add(RCURLY);
            stopSet.add(RPAREN);
            stopSet.add(LPAREN);
        }
        
        private static final int RECOVERY_LIMIT = 20;
        private int recoveryCounter = 0;
        private int lastRecoveryPosition = -1;
        
        public void recover(RecognitionException ex, BitSet tokenSet) {
            if (lastRecoveryPosition == inputState.input.index()) {
                if (recoveryCounter > RECOVERY_LIMIT) {
                    consume();
                    recoveryCounter = 0;
                } else {
                    recoveryCounter++;
                }
            } else {
                recoveryCounter = 0;
                lastRecoveryPosition = inputState.input.index();
            }
            tokenSet.orInPlace(stopSet);
            consumeUntil(tokenSet);
	}
	
	//protected boolean isCtor() { /*TODO: implement*/ throw new NotImplementedException(); }
	//protected boolean isValidIdentifier(String id) { /*TODO: implement*/ throw new NotImplementedException(); }

	protected
	int lang;

	// Symbol table management stuff
	//CPPDictionary *symbols;

	//protected
	//int templateParameterScope;

	//protected
	//int externalScope;

	protected
	boolean _td;			// For typedef

	protected
	boolean _fd;			// For friend

	protected
	StorageClass _sc;	// For storage class

	protected
	TypeQualifier _tq;	// For type qualifier

	protected
	/*TypeSpecifier*/int _ts;	// For type specifier

	protected
	DeclSpecifier _ds;	// For declaration specifier

	/*protected
	int functionDefinition;	// 0 = Function definition not being parsed
				// 1 = Parsing function name
				// 2 = Parsing function parameter list
				// 3 = Parsing function block*/

	protected
	StringBuilder qualifierPrefix = new StringBuilder();

	protected
	String enclosingClass;

	int assign_stmt_RHS_found;

	boolean in_parameter_list;	// DW 13/02/04 used within CPP_parser
	boolean K_and_R;	// used to distinguish old K & R parameter definitions
	boolean in_return;
	boolean is_address;
	boolean is_pointer;

	protected int MaxTemplateTokenScan = 200;

	static class IF_Type extends Enum { public IF_Type(String id) { super(id); } }
	protected static final IF_Type IF_Local = new IF_Type("IF_Local");
	protected static final IF_Type IF_System = new IF_Type("IF_System");
	protected static final IF_Type IF_Macro = new IF_Type("IF_Macro");

	static class IncludeFile {
	    public IF_Type type;
	    public String file;
	}

	// Semantic interface; You could subclass and redefine these functions
	//  so you don't have to mess with the grammar itself.

	// Antlr doesn't allow to make parser abstract;
	// I throw this exception in methods, which otherwise were just abstract 
	public static class NotImplementedException extends Error {
		public NotImplementedException() { super("not imlemented"); }
	}
	
	// Symbol stuff
	protected boolean qualifiedItemIsOneOf(/*QualifiedItem*/int qiFlags) { return qualifiedItemIsOneOf(qiFlags, 0); }
	protected boolean qualifiedItemIsOneOf(/*QualifiedItem*/int qiFlags, int lookahead_offset) { /*TODO: implement*/ throw new NotImplementedException(); }

	protected /*QualifiedItem*/int qualifiedItemIs()	{ return qualifiedItemIs(0); }
	protected /*QualifiedItem*/int qualifiedItemIs(int lookahead_offset) { /*TODO: implement*/ throw new NotImplementedException(); }

	// both skipTemplateQualifiers and skipNestedParens used only in CPPParserEx
	//protected boolean skipTemplateQualifiers(int kInOut) { /*TODO: implement*/ throw new NotImplementedException(); }
	// TODO: original skipNestedParens(int& kInOut) passes kInOut BY REF!
	//protected int skipNestedParens(int kInOut) { /*TODO: implement*/ throw new NotImplementedException(); }

	protected boolean scopedItem() { return scopedItem(1); }
	protected boolean scopedItem(int k) { /*TODO: implement*/ throw new NotImplementedException(); }

	// finalQualifier is used in CPPParserEx only
	//protected int finalQualifier() { return finalQualifier(1); }
	//protected int finalQualifier(final int k) { /*TODO: implement*/ throw new NotImplementedException(); }

	protected boolean isTypeName(String s) { /*TODO: implement*/ throw new NotImplementedException(); }
	// isClassName is used in CPPParserEx only
	//protected boolean isClassName(String  s) { /*TODO: implement*/ throw new NotImplementedException(); }
	//protected void end_of_stmt() {}


	// Scoping stuff
	//protected void enterNewLocalScope() {}
	//protected void exitLocalScope() {}
	//protected void enterExternalScope() {}
	//protected void exitExternalScope() {}

	// Aggregate stuff
	protected void classForwardDeclaration(/*TypeSpecifier*/int ts, DeclSpecifier ds, String tag) {}
	protected void beginClassDefinition(/*TypeSpecifier*/int ts, String tag) {}
	protected void endClassDefinition() {}
	protected void beginEnumDefinition(String s) {}
	protected void endEnumDefinition() {}
	protected void enumElement(String s) {}

	// Declaration and definition stuff
	protected void declarationSpecifier(boolean td, boolean fd, StorageClass sc, TypeQualifier tq,
			     /*TypeSpecifier*/int ts, DeclSpecifier ds) {}
	protected void beginDeclaration() {}
	protected void endDeclaration() {}
	protected void beginConstructorDeclaration(String s) {}
	protected void endConstructorDeclaration() {}
	protected void beginDestructorDeclaration(String s) {}
	protected void endDestructorDeclaration() {}
	protected void beginParameterDeclaration() {}
	protected void beginFieldDeclaration() {}
	//protected void beginFunctionDefinition() {}
	//protected void endFunctionDefinition() {}
	//protected void functionParameterList() {}
	//protected void functionEndParameterList(boolean def) {}
	//protected void beginConstructorDefinition() {}
	//protected void endConstructorDefinition() {}
	//protected void beginDestructorDefinition() {}
	//protected void endDestructorDefinition() {}

	// Declarator stuff
	protected void declaratorID(String s, /*QualifiedItem*/int qi) {}	// stores new symbol with type
	protected void declaratorArray() {}
	//protected void declaratorParameterList(boolean def) {}
	//protected void declaratorEndParameterList(boolean def) {}

	// template stuff
	protected void templateTypeParameter(String s) {}
	//protected void beginTemplateDeclaration() {}
	//protected void endTemplateDeclaration() {}
	protected void beginTemplateDefinition() {}
	protected void endTemplateDefinition() {}
	//protected void beginTemplateParameterList() {}
	//protected void endTemplateParameterList() {}

	// exception stuff
	//protected void exceptionBeginHandler() {}
	//protected void exceptionEndHandler() {}
	protected void panic(String s) {}

	boolean reportErrors = true;

	// myCode functions ready for overriding in MyCode subclass

	//protected int getOffset() { /*TODO: implement*/ throw new NotImplementedException(); }
	//protected int getLine()	{ /*TODO: implement*/ throw new NotImplementedException(); }

	protected void printf(String pattern, int i) { /*TODO: implement*/ throw new NotImplementedException(); }
	protected void printf(String pattern, Object o) { /*TODO: implement*/ throw new NotImplementedException(); }
	protected void printf(String pattern, int i, Object o) { /*TODO: implement*/ throw new NotImplementedException(); }
	protected void printf(String pattern, int i, Object o1, Object o2) { /*TODO: implement*/ throw new NotImplementedException(); }
	protected void printf(String pattern, int i1, int i2, boolean b1, Object o) { /*TODO: implement*/ throw new NotImplementedException(); }
	protected void printf(String pattern, int i1, int i2) { /*TODO: implement*/ throw new NotImplementedException(); }
	protected void printf (String pattern, int i1, Object o1, int i2, Object o2) { /*TODO: implement*/ throw new NotImplementedException(); }
	protected void printf (String pattern, int i1, int i2, int i3, String s) { /*TODO: implement*/ throw new NotImplementedException(); }

	protected void balanceBraces(int left, int right) throws RecognitionException, TokenStreamException { throw new NotImplementedException(); };
}

public translation_unit:
		//{enterExternalScope();}
                /* Do not generate ambiguity warnings: we intentionally want to match everything that
                   can not be matched in external_declaration in the second alternative */
		(options{generateAmbigWarnings = false;}:
                    external_declaration 
                    | 
                    /* Here we match everything that can not be matched by external_declaration rule,
                       report it as an error and not include in AST */
                    .! { reportError(new NoViableAltException(LT(0), getFilename())); }
                )* EOF!
		{/*exitExternalScope();*/ #translation_unit = #(#[CSM_TRANSLATION_UNIT, getFilename()], #translation_unit);}
       ;

//
// it's a caller's responsibility to check isCPlusPlus
//
protected
template_explicit_specialization
	:
	LITERAL_template LESSTHAN GREATERTHAN
	(
	// Template explicit specialisation function definition (VK 30/05/06)
		(declaration_specifiers function_declarator[true] LCURLY)=>
		{if(statementTrace >= 1)
			printf("external_declaration_0a[%d]: template " +
				"explicit-specialisation function definition\n", LT(1).getLine());
		}
		function_definition
		{ #template_explicit_specialization = #(#[CSM_TEMPLATE_FUNCTION_DEFINITION_EXPLICIT_SPECIALIZATION, "CSM_TEMPLATE_FUNCTION_DEFINITION_EXPLICIT_SPECIALIZATION"], #template_explicit_specialization); }
	|
	// Template explicit specialisation ctor definition 
		(ctor_declarator[true] 
		  (COLON        // DEFINITION :ctor_initializer
		   |LCURLY       // DEFINITION (compound Statement) ?
	 	  )
                )=>
		{if(statementTrace >= 1)
			printf("template_explicit_specialization_0b[%d]: template " +
				"explicit-specialisation ctor definition\n", LT(1).getLine());
		}
		ctor_definition
		{ #template_explicit_specialization = #(#[CSM_TEMPLATE_FUNCTION_DEFINITION_EXPLICIT_SPECIALIZATION, "CSM_TEMPLATE_FUNCTION_DEFINITION_EXPLICIT_SPECIALIZATION"], #template_explicit_specialization); }
         //     { #template_explicit_specialization = #(#[CSM_TEMPLATE_CTOR_DEFINITION_EXPLICIT_SPECIALIZATION, "CSM_TEMPLATE_CTOR_DEFINITION_EXPLICIT_SPECIALIZATION"], #template_explicit_specialization); }
	| 
        // Template explicit specialisation ctor declaration 
		(ctor_declarator[false] SEMICOLON)=>
		{if(statementTrace >= 1)
			printf("template_explicit_specialization_0c[%d]: template " +
				"explicit-specialisation ctor declaration\n", LT(1).getLine());
		}
		ctor_declarator[false] SEMICOLON
		{ #template_explicit_specialization = #(#[CSM_TEMPLATE_EXPLICIT_SPECIALIZATION, "CSM_TEMPLATE_EXPLICIT_SPECIALIZATION"], #template_explicit_specialization); }
        // Template explicit specialisation dtor declaration        
        |
		(dtor_declarator[false] SEMICOLON)=>
		{if(statementTrace >= 1)
			printf("template_explicit_specialization_0d[%d]: template " +
				"explicit-specialisation dtor definition\n", LT(1).getLine());
		}
		dtor_declarator[false] SEMICOLON
		{ #template_explicit_specialization = #(#[CSM_TEMPLATE_EXPLICIT_SPECIALIZATION, "CSM_TEMPLATE_EXPLICIT_SPECIALIZATION"], #template_explicit_specialization); }

        |
	// Template explicit specialisation (DW 14/04/03)
		{if(statementTrace >= 1)
			printf("template_explicit_specialization_0e[%d]: template " +
				"explicit-specialisation\n", LT(1).getLine());
		}
		declaration
		{ #template_explicit_specialization = #(#[CSM_TEMPLATE_EXPLICIT_SPECIALIZATION, "CSM_TEMPLATE_EXPLICIT_SPECIALIZATION"], #template_explicit_specialization); }
	)
	;

//
// it's a caller's responsibility to check isCPlusPlus
//
protected
external_declaration_template { K_and_R = false; boolean ctrName=false;}
	:      
		(LITERAL_template LESSTHAN GREATERTHAN) => template_explicit_specialization
	|
		(LITERAL_template (LITERAL_class | LITERAL_struct| LITERAL_union)) =>
		LITERAL_template (LITERAL_class | LITERAL_struct| LITERAL_union) 
		ID LESSTHAN template_argument_list GREATERTHAN SEMICOLON
		{#external_declaration_template = #(#[CSM_TEMPLATE_EXPLICIT_INSTANTIATION, "CSM_TEMPLATE_EXPLICIT_INSTANTIATION"], #external_declaration_template);}
	|
		(LITERAL_template (~LESSTHAN)) =>
		LITERAL_template declaration
		{#external_declaration_template = #(#[CSM_TEMPLATE_EXPLICIT_INSTANTIATION, "CSM_TEMPLATE_EXPLICIT_INSTANTIATION"], #external_declaration_template);}
	|
		{beginTemplateDefinition();}               
		(template_head)
		(   
			// Class template definition
			(class_head)=>
			{if (statementTrace>=1) 
				printf("external_declaration_template_1b[%d]: Class template definition\n",
					LT(1).getLine());
			}                           
			declaration
			{ #external_declaration_template = #(#[CSM_TEMPLATE_CLASS_DECLARATION, "CSM_TEMPLATE_CLASS_DECLARATION"], #external_declaration_template); }
		|
			// templated forward class decl, init/decl of static member in template
			(declaration_specifiers
				(init_declarator_list)? SEMICOLON! /*{end_of_stmt();}*/)=>
			//{beginTemplateDeclaration();}
			{ if (statementTrace>=1) 
				printf("external_declaration_template_10[%d]: Class template declaration\n",
					LT(1).getLine());
			}
			declaration_specifiers
				(init_declarator_list)? SEMICOLON! //{end_of_stmt();}
			{/*endTemplateDeclaration();*/ #external_declaration_template = #(#[CSM_TEMPL_FWD_CL_OR_STAT_MEM, "CSM_TEMPL_FWD_CL_OR_STAT_MEM"], #external_declaration_template);}
		|  
		// Templated FUNCTIONS and CONSTRUCTORS matched here.
                       // Templated CONSTRUCTOR declaration
                        (	(template_head)?   // :)
                                ctor_decl_spec
                                /*{qualifiedItemIsOneOf(qiCtor)}?*/
                                ctor_declarator[false] (EOF|SEMICOLON)
                        )=>
                        {if (statementTrace>=1) 
                                printf("external_declaration_template_11a[%d]: Constructor or no-ret type fun declarator\n",
                                        LT(1).getLine());
                        }
                        (template_head)?   // :)
                        ctor_decl_spec
                        {ctrName = qualifiedItemIsOneOf(qiCtor);}
                        ctor_declarator[false] 	(EOF!|SEMICOLON) // Constructor declarator
                        {
                            // below is a workaround for know infinite loop bug in ANTLR 
                            // see http://www.jguru.com/faq/view.jsp?EID=271922
                            //if( #cds1 != null ) { #cds1.setNextSibling(null); }; 
                            if (ctrName) {
                                #external_declaration_template= #(#[CSM_CTOR_TEMPLATE_DECLARATION, "CSM_CTOR_TEMPLATE_DECLARATION"],  #external_declaration_template); //end_of_stmt();
                            } else {
                                #external_declaration_template= #(#[CSM_FUNCTION_TEMPLATE_DECLARATION, "CSM_FUNCTION_TEMPLATE_DECLARATION"],  #external_declaration_template); //end_of_stmt();
                            }
                        }

                  |   
			// Templated CONSTRUCTOR definition
			// JEL 4/3/96.. Added predicate that works once the
			// restriction is added that ctor cannot be virtual
			(	(template_head)?   // :) 
                                ctor_decl_spec                            
				{qualifiedItemIsOneOf(qiCtor)}?
			)=>
			{if (statementTrace>=1) 
				printf("external_declaration_template_11b[%d]: Template constructor " +
					"definition\n", LT(1).getLine());
			}
                        (template_head)?   // :)
			ctor_definition
			{ #external_declaration_template = #(#[CSM_CTOR_TEMPLATE_DEFINITION, "CSM_CTOR_TEMPLATE_DEFINITION"], #external_declaration_template); }
		|
			// Templated function declaration
			(declaration_specifiers function_declarator[false] SEMICOLON)=> 
			{if (statementTrace>=1) 
				printf("external_declaration_template_11c[%d]: Function template " +
					"declaration\n", LT(1).getLine());
			}
			declaration
			{ #external_declaration_template = #(#[CSM_FUNCTION_TEMPLATE_DECLARATION, "CSM_FUNCTION_TEMPLATE_DECLARATION"], #external_declaration_template); }
		|  
			// Templated function definition
			((template_head)? declaration_specifiers function_declarator[true] LCURLY)=> 
			{if (statementTrace>=1) 
				printf("external_declaration_template_11d[%d]: Function template " +
					"definition\n", LT(1).getLine());
			}
			(template_head)? function_definition
			{ #external_declaration_template = #(#[CSM_FUNCTION_TEMPLATE_DEFINITION, "CSM_FUNCTION_TEMPLATE_DEFINITION"], #external_declaration_template); }

		|
			// Destructor DEFINITION (templated)
			( dtor_head[true] LCURLY)=>
			{if (statementTrace>=1) 
				printf("external_declaration_4[%d]: Destructor definition\n",
					LT(1).getLine());
			}
			dtor_head[true] dtor_body
			{ #external_declaration_template = #(#[CSM_DTOR_TEMPLATE_DEFINITION, "CSM_DTOR_TEMPLATE_DEFINITION"], #external_declaration_template); }
		)
    		{endTemplateDefinition();}
	;

protected 
typedef_enum
        :
                {if(statementTrace>=1) 
                        printf("typedef_enum [%d]\n",LT(1).getLine());
                }                     
                LITERAL_typedef 
                {declarationSpecifier(true, false, scInvalid, tqInvalid, tsInvalid, dsInvalid);} 
                enum_specifier 
                (init_declarator_list)? SEMICOLON //{end_of_stmt();}
        ;

external_declaration {String s; K_and_R = false; boolean definition;}
	:  
	(
                {isCPlusPlus()}?
		// Suppressed instantiation of the following declaration
		{if (statementTrace>=1) 
			printf("external_declaration_0[%d]: Suppressed instantiation of the following declaration\n",
				LT(1).getLine());
		}
		LITERAL_extern LITERAL_template external_declaration                
		{ #external_declaration = #(#[CSM_EXTERN_TEMPLATE, "CSM_EXTERN_TEMPLATE"], #external_declaration); }
        |
	    {isCPlusPlus()}? ((LITERAL_export)? LITERAL_template) => external_declaration_template
        |
	// Class definition (templates too)
	// This is separated out otherwise the next alternative
	// would look for "class A { ... } f() {...}" which is
	// an unacceptable level of backtracking.

	// JEL Note:  Rule body does not need typedef, because
	// that is internal to "declaration", and it is invalid
	// to say "typedef template..."
	 	// Class definition
                // we need "static" here for the case "static struct XX {...} myVar; - see issue #106652
		((LITERAL_typedef | LITERAL_static)? class_head)=>
		{if (statementTrace>=1) 
			printf("external_declaration_1a[%d]: Class definition\n",
				LT(1).getLine());
		}
		declaration
		{ #external_declaration = #(#[CSM_CLASS_DECLARATION, "CSM_CLASS_DECLARATION"], #external_declaration); }

	|	
                //enum typedef )))	
                (LITERAL_typedef enum_specifier)=> typedef_enum
                {  #external_declaration = #(#[CSM_GENERIC_DECLARATION, "CSM_GENERIC_DECLARATION"], #external_declaration); }
	|
  
		// Enum definition (don't want to backtrack over this in other alts)
		(LITERAL_enum (ID)? (LCURLY))=>
		{if (statementTrace>=1) 
			printf("external_declaration_3[%d]: Enum definition\n",
				LT(1).getLine());
		}
		enum_specifier (init_declarator_list)? SEMICOLON! //{end_of_stmt();}
		{ #external_declaration = #(#[CSM_ENUM_DECLARATION, "CSM_ENUM_DECLARATION"], #external_declaration); }
	|
		// Destructor DEFINITION (templated or non-templated)
		{isCPlusPlus()}?
		((template_head)? dtor_head[true] LCURLY)=>
		{if (statementTrace>=1) 
			printf("external_declaration_4[%d]: Destructor definition\n",
				LT(1).getLine());
		}
		(template_head)? dtor_head[true] dtor_body
		{ #external_declaration = #(#[CSM_DTOR_DEFINITION, "CSM_DTOR_DEFINITION"], #external_declaration); }
	|
		// Constructor DEFINITION (non-templated)
		{isCPlusPlus()}?
		(	(options {warnWhenFollowAmbig = false;}: ctor_decl_spec)?
			{qualifiedItemIsOneOf(qiCtor)}?
		)=>
		{if (statementTrace>=1) 
			printf("external_declaration_5[%d]: Constructor definition\n",
				LT(1).getLine());
		}
		ctor_definition
		{ #external_declaration = #(#[CSM_CTOR_DEFINITION, "CSM_CTOR_DEFINITION"], #external_declaration); }
	|  
		// User-defined type cast
		{isCPlusPlus()}?
		((template_head)? (literal_inline)? scope_override conversion_function_decl_or_def)=>
		{if (statementTrace>=1) 
			printf("external_declaration_6[%d]: Operator function\n",
				LT(1).getLine());
		}
		(template_head)? (literal_inline)? s = scope_override definition = conversion_function_decl_or_def 
		{ if( definition ) #external_declaration = #(#[CSM_USER_TYPE_CAST_DEFINITION, "CSM_USER_TYPE_CAST_DEFINITION"], #external_declaration);
		    else	   #external_declaration = #(#[CSM_USER_TYPE_CAST, "CSM_USER_TYPE_CAST"], #external_declaration); }
	|   
		// Function declaration
		((LITERAL___extension__)? (options {greedy=true;} :function_attribute_specification)? declaration_specifiers function_declarator[false] (EOF|SEMICOLON))=> 
		{if (statementTrace>=1) 
			printf("external_declaration_7[%d]: Function prototype\n",
				LT(1).getLine());
		}
		(LITERAL___extension__!)? (options {greedy=true;} :function_attribute_specification!)? declaration
		{ #external_declaration = #(#[CSM_FUNCTION_DECLARATION, "CSM_FUNCTION_DECLARATION"], #external_declaration); }
	|
		// Function definition with return value
		((LITERAL___extension__)? declaration_specifiers function_declarator[true] LCURLY)=> 
		{if (statementTrace>=1) 
			printf("external_declaration_8[%d]: Function definition\n",
				LT(1).getLine());
		}
		(LITERAL___extension__!)? function_definition
		{ #external_declaration = #(#[CSM_FUNCTION_DEFINITION, "CSM_FUNCTION_DEFINITION"], #external_declaration); }
	|
		// FIXUP: Function definition without return value
                // till not correct hanlding in function_definition (external_declaration_7)
                // functions without return type
		(function_declarator[true] LCURLY)=> 
		{if (statementTrace>=1) 
			printf("external_declaration_8a[%d]: Function definition without ret value\n",
				LT(1).getLine());
		}
		function_definition_no_ret_type
		{ #external_declaration = #(#[CSM_FUNCTION_DEFINITION, "CSM_FUNCTION_DEFINITION"], #external_declaration); }
	|
		// K & R Function definition
		(declaration_specifiers	function_declarator[true] declaration)=>
		{K_and_R = true;
		 if (statementTrace>=1) 
			printf("external_declaration_9[%d]: K & R function definition\n",
				LT(1).getLine());
		}
		function_definition
		{ #external_declaration = #(#[CSM_FUNCTION_DEFINITION, "CSM_FUNCTION_DEFINITION"], #external_declaration); }
        |       // function declaration with function as return type
		((LITERAL___extension__)? declaration_specifiers function_declarator_with_fun_as_ret_type[false] (EOF|SEMICOLON))=> 
		{if (statementTrace>=1) 
			printf("external_declaration_7a[%d]: Function prototype with function as return type\n",
				LT(1).getLine());
		}
		function_declaration_with_fun_as_ret_type
		{ #external_declaration = #(#[CSM_FUNCTION_RET_FUN_DECLARATION, "CSM_FUNCTION_RET_FUN_DECLARATION"], #external_declaration); }
                
        |       // function definition with function as return type
                ((LITERAL___extension__)? declaration_specifiers function_declarator_with_fun_as_ret_type[true] LCURLY)=> 
		{if (statementTrace>=1) 
			printf("external_declaration_8b[%d]: Function definition with function as return type\n",
				LT(1).getLine());
		}
		function_definition_with_fun_as_ret_type
		{ #external_declaration = #(#[CSM_FUNCTION_RET_FUN_DEFINITION, "CSM_FUNCTION_RET_FUN_DEFINITION"], #external_declaration); }
	|  
		{isCPlusPlus()}?
		{if (statementTrace>=1) 
			printf("external_declaration_12[%d]: Namespace declaration\n",
				LT(1).getLine());
		}
		decl_namespace
		// moved to decl_namespace { #external_declaration = #(#[, ""], #external_declaration); }
	|	
		// everything else (except templates)
		{if (statementTrace>=1) 
			printf("external_declaration_13[%d]: Declaration\n",LT(1).getLine());
		}
                // VV: 23/05/06 support for gcc's "__extension__"
		(LITERAL___extension__!)?  declaration 
		{ 
		    // if declaration itself returned proper type, don't wrap it into generic declaration
		    if( #external_declaration != null ) {
			int type = #external_declaration.getType(); 
			int childrenCnt = #external_declaration.getNumberOfChildren();
			if( childrenCnt > 0 || type < CSM_START || CSM_END < type ) {
			    #external_declaration = #(#[CSM_GENERIC_DECLARATION, "CSM_GENERIC_DECLARATION"], #external_declaration);
			}
		    }
		}
	|	
		{if (statementTrace>=1) 
			printf("external_declaration_14[%d]: Semicolon\n",LT(1).getLine());
		}
		SEMICOLON! //{end_of_stmt();}
	)
	;	// end of external_declaration

decl_namespace
	{String qid; String name = "";}
	:	
		LITERAL_namespace 
		(
			(ns:ID{_td = true; name=ns.getText(); declaratorID(name,qiType);})?
			// The following statement can be invoked to trigger selective
			// antlr trace. Also see below
			//{
			//	if (strcmp((ns.getText()),"xyz")==0) {
			//	    antlrTrace(true);
			//	 }	// Used for diagnostic trigger
			//}
			(options {greedy=true;} : namespace_attribute_specification)?
			LCURLY!
			//{enterNewLocalScope();}
			((external_declaration)*)
			{/*exitLocalScope();*/{ #decl_namespace = #(#[CSM_NAMESPACE_DECLARATION, name], #decl_namespace); }}
			RCURLY
			// The following should be implemented to match the optional
			// statement above
			//{antlrTrace(false);}
		|
			ns2:ID{_td = true;name=ns2.getText();declaratorID((name),qiType);}
			ASSIGNEQUAL qid = qualified_id SEMICOLON! 
			{/*end_of_stmt();*/#decl_namespace = #(#[CSM_NAMESPACE_ALIAS, name], #decl_namespace);} 
		)
	;

//
// it's a caller's responsibility to check isCPlusPlus
//
member_declaration_template
	{String q; boolean definition=false;}
	:
		{beginTemplateDefinition();}
		template_head
 		(     
			(class_head)=>
			{if (statementTrace>=1) 
				printf("member_declaration_12[%d]: Class template declaration\n",
					LT(1).getLine());
			}                           
			declaration
			{ #member_declaration_template = #(#[CSM_TEMPLATE_CLASS_DECLARATION, "CSM_TEMPLATE_CLASS_DECLARATION"], #member_declaration_template); }
		|  
			// Templated FUNCTIONS and CONSTRUCTORS matched here.
			// DW 27/06/03 Copied here from external_declaration since templates
			// can now be nested

			// Templated CONSTRUCTOR declaration
                        (	ctor_decl_spec
                                {qualifiedItemIsOneOf(qiCtor)}?
                                ctor_declarator[false] (EOF|SEMICOLON)
                        )=>
                        {if (statementTrace>=1) 
                                printf("member_declaration_13[%d]: Constructor declarator\n",
                                        LT(1).getLine());
                        }
                        ctor_decl_spec
                        ctor_declarator[false] 	(EOF!|SEMICOLON) // Constructor declarator
                        {
                        // below is a workaround for know infinite loop bug in ANTLR 
                        // see http://www.jguru.com/faq/view.jsp?EID=271922
                        //if( #cds1 != null ) { #cds1.setNextSibling(null); }; 
                        #member_declaration_template = #(#[CSM_CTOR_TEMPLATE_DECLARATION, "CSM_CTOR_TEMPLATE_DECLARATION"],  #member_declaration_template); //end_of_stmt();
                        }   

                  |

			// Templated CONSTRUCTOR definition
			// JEL 4/3/96 Added predicate that works once the
			// restriction is added that ctor cannot be virtual
			(ctor_decl_spec
			 {qualifiedItemIsOneOf(qiCtor)}?
			 ctor_declarator[true]
			 ( COLON        // DEFINITION :ctor_initializer
			  |LCURLY       // DEFINITION (compound Statement) ?
			 )
			)=>
			{if (statementTrace>=1) 
				printf("member_declaration_13a[%d]: Template constructor " +
					"definition\n", LT(1).getLine());
			}
			ctor_definition
			{ #member_declaration_template = #(#[CSM_CTOR_TEMPLATE_DEFINITION, "CSM_CTOR_TEMPLATE_DEFINITION"], #member_declaration_template); }
		|
			// Templated function declaration
			(declaration_specifiers function_declarator[false] SEMICOLON)=>
			{if (statementTrace>=1) 
				printf("member_declaration_13b[%d]: Function template " +
					"declaration\n", LT(1).getLine());
			}
			declaration
			{ #member_declaration_template = #(#[CSM_FUNCTION_TEMPLATE_DECLARATION, "CSM_FUNCTION_TEMPLATE_DECLARATION"], #member_declaration_template); }
		|  
			// Templated function definition
			// Function definition DW 2/6/97
			(declaration_specifiers function_declarator[true] LCURLY)=> 
			{if (statementTrace>=1) 
				printf("member_declaration_13c[%d]: Function template " +
					    "definition\n", LT(1).getLine());
			}
			function_definition
			{ #member_declaration_template = #(#[CSM_FUNCTION_TEMPLATE_DEFINITION, "CSM_FUNCTION_TEMPLATE_DEFINITION"], #member_declaration_template); }
		|
			{if (statementTrace>=1) 
				printf("member_declaration_13d[%d]: Templated operator " +
					    "function\n", LT(1).getLine());
			}
			definition = conversion_function_decl_or_def
			{ if( definition ) #member_declaration_template = #(#[CSM_USER_TYPE_CAST_DEFINITION, "CSM_USER_TYPE_CAST_DEFINITION"], #member_declaration_template);
			    else	   #member_declaration_template = #(#[CSM_USER_TYPE_CAST, "CSM_USER_TYPE_CAST"], #member_declaration_template); }
		|         
                        // this rule must be after handling functions 
			// templated forward class decl, init/decl of static member in template
			(declaration_specifiers
				(init_declarator_list)? SEMICOLON! /*{end_of_stmt();}*/)=>
			//{beginTemplateDeclaration();}
			{ if (statementTrace>=1) 
				printf("member_declaration_12a[%d]: Class template declaration\n",
					LT(1).getLine());
			}
			declaration_specifiers
				(init_declarator_list)? SEMICOLON! //{end_of_stmt();}
			{/*endTemplateDeclaration();*/ #member_declaration_template = #(#[CSM_TEMPL_FWD_CL_OR_STAT_MEM, "CSM_TEMPL_FWD_CL_OR_STAT_MEM"], #member_declaration_template); } 		
		)
		{endTemplateDefinition();}

	;

member_declaration
	{String q; boolean definition;boolean ctrName=false;}
	:
	(
		// Class definition
		// This is separated out otherwise the next alternative
		// would look for "class A { ... } f() {...}" which is
		// an unacceptable level of backtracking.
		( (LITERAL_typedef)? class_head) => 
		{if (statementTrace>=1) 
			printf("member_declaration_1[%d]: Class definition\n",
				LT(1).getLine());
		}
		declaration
		{ #member_declaration = #(#[CSM_CLASS_DECLARATION, "CSM_CLASS_DECLARATION"], #member_declaration); }
	|  
		// Enum definition (don't want to backtrack over this in other alts)
		(LITERAL_enum (ID)? LCURLY)=>
		{if (statementTrace>=1) 
			printf("member_declaration_2[%d]: Enum definition\n",
				LT(1).getLine());
		}
		enum_specifier (member_declarator_list)? SEMICOLON!	//{end_of_stmt();}
		{ #member_declaration = #(#[CSM_ENUM_DECLARATION, "CSM_ENUM_DECLARATION"], #member_declaration); }
	|	
                //enum typedef )))	
                (LITERAL_typedef enum_specifier)=> typedef_enum
		{ #member_declaration = #(#[CSM_FIELD, "CSM_FIELD"], #member_declaration); }
	|
		// Constructor declarator
		(	ctor_decl_spec
			/*{qualifiedItemIsOneOf(qiCtor)}?*/
			ctor_declarator[false] (EOF|SEMICOLON)
		)=>
		{if (statementTrace>=1) 
			printf("member_declaration_3[%d]: Constructor or no-ret type fun declarator\n",
				LT(1).getLine());
		}
		cds:ctor_decl_spec
                {ctrName = qualifiedItemIsOneOf(qiCtor);}
		cd:ctor_declarator[false] 	(EOF!|SEMICOLON) // Constructor declarator
		{
                    // below is a workaround for know infinite loop bug in ANTLR 
                    // see http://www.jguru.com/faq/view.jsp?EID=271922
                    if( #cds != null ) { #cds.setNextSibling(null); }; 
                    if (ctrName) {
                        #member_declaration = #(#[CSM_CTOR_DECLARATION, "CSM_CTOR_DECLARATION"], #cds, #cd); //end_of_stmt();
                    } else {
                        #member_declaration = #(#[CSM_FUNCTION_DECLARATION, "CSM_FUNCTION_DECLARATION"], #cds, #cd); //end_of_stmt();
                    }
                }
		
	|  
		// JEL Predicate to distinguish ctor from function
		// This works now that ctor cannot have VIRTUAL
		// It unfortunately matches A::A where A is not enclosing
		// class -- this will have to be checked semantically
		(	ctor_decl_spec
			/*{qualifiedItemIsOneOf(qiCtor)}?*/
			ctor_declarator[true]
			(COLON        // DEFINITION :ctor_initializer
			|LCURLY       // DEFINITION (compound Statement) ?
			)
		)=>
		{if (statementTrace>=1) 
			printf("member_declaration_4[%d]: Constructor or no-ret type fun definition\n",
				LT(1).getLine());
		}
                ctor_decl_spec
                {ctrName = qualifiedItemIsOneOf(qiCtor);}
                ctor_declarator[true]
		ctor_body 
		{ 
                    if (ctrName) {
                        #member_declaration = #(#[CSM_CTOR_DEFINITION, "CSM_CTOR_DEFINITION"], #member_declaration); 
                    } else {
                        #member_declaration = #(#[CSM_FUNCTION_DEFINITION, "CSM_FUNCTION_DEFINITION"], #member_declaration); 
                    }
                }
	|  
		// No template_head allowed for dtor member
		// Backtrack if not a dtor (no TILDE)
		(dtor_head[false] (EOF|SEMICOLON))=>
		{if (statementTrace>=1) 
			printf("member_declaration_5a[%d]: Destructor declaration\n",
				LT(1).getLine());
		}
		dtor_head[false] (EOF!|SEMICOLON) //{end_of_stmt();}	// Declaration
		{ #member_declaration = #(#[CSM_DTOR_DECLARATION, "CSM_DTOR_DECLARATION"], #member_declaration); }
	|
		// No template_head allowed for dtor member
		// Backtrack if not a dtor (no TILDE)
		(dtor_head[true] LCURLY)=>
		{if (statementTrace>=1) 
			printf("member_declaration_5b[%d]: Destructor definition\n",
				LT(1).getLine());
		}
		dtor_head[true] dtor_body	// Definition
		{ #member_declaration = #(#[CSM_DTOR_DEFINITION, "CSM_DTOR_DEFINITION"], #member_declaration); }
	|
		// Function declaration
		(declaration_specifiers	function_declarator[false] (EOF|SEMICOLON))=>
		{if (statementTrace>=1) 
			printf("member_declaration_6[%d]: Function declaration\n",
				LT(1).getLine());
		}
		declaration
		{ #member_declaration = #(#[CSM_FUNCTION_DECLARATION, "CSM_FUNCTION_DECLARATION"], #member_declaration); }
	|  
		// Function definition
		(declaration_specifiers function_declarator[true] LCURLY)=>
		{beginFieldDeclaration();
		 if (statementTrace>=1) 
			printf("member_declaration_7[%d]: Function definition\n",
				LT(1).getLine());
		}
		function_definition
		{ #member_declaration = #(#[CSM_FUNCTION_DEFINITION, "CSM_FUNCTION_DEFINITION"], #member_declaration); }
	|  
		// Member without a type (I guess it can only be a function declaration
		// or definition)
		((LITERAL_static)? function_declarator[false] (EOF|SEMICOLON))=>
		{beginFieldDeclaration();
                if( reportOddWarnings ) {
                    printf("member_declaration[%d]: Warning Function declaration found without typename\n", LT(1).getLine());
                }
		if (statementTrace>=1) 
			printf("member_declaration_11a[%d]: Function declaration\n",
				LT(1).getLine());
		}
		(LITERAL_static)? function_declarator[false] (EOF!|SEMICOLON) //{end_of_stmt();}
		{ #member_declaration = #(#[CSM_FUNCTION_DECLARATION, "CSM_FUNCTION_DECLARATION"], #member_declaration); }
	|
		// Member without a type (I guess it can only be a function definition)
		((LITERAL_static)? function_declarator[true] LCURLY)=>
		{
                    if( reportOddWarnings ) {
                        printf("member_function[%d]: Warning Function definition found without typename\n", LT(1).getLine());
                    }
		    if (statementTrace>=1) {
			printf("member_declaration_11b[%d]: Function definition\n",
				LT(1).getLine());
		    }
		}
		(LITERAL_static)? function_declarator[true] compound_statement //{endFunctionDefinition();}
		{ #member_declaration = #(#[CSM_FUNCTION_DEFINITION, "CSM_FUNCTION_DEFINITION"], #member_declaration); }
	|  
		// User-defined type cast
		((literal_inline)? conversion_function_decl_or_def)=>
		{if (statementTrace>=1) 
			printf("member_declaration_8[%d]: Operator function\n",
				LT(1).getLine());
		}
		(literal_inline)? definition = conversion_function_decl_or_def
		{ if( definition ) #member_declaration = #(#[CSM_USER_TYPE_CAST_DEFINITION, "CSM_USER_TYPE_CAST_DEFINITION"], #member_declaration);
		    else	   #member_declaration = #(#[CSM_USER_TYPE_CAST, "CSM_USER_TYPE_CAST"], #member_declaration); }
	|  
		// Hack to handle decls like "superclass::member",
		// to redefine access to private base class public members
		(qualified_id (EOF|SEMICOLON))=>
		{if (statementTrace>=1) 
			printf("member_declaration_9[%d]: Qualified ID\n",
				LT(1).getLine());
		}
		q = qualified_id (EOF!|SEMICOLON) //{end_of_stmt();}
		{ #member_declaration = #(#[CSM_VISIBILITY_REDEF, "CSM_VISIBILITY_REDEF"], #member_declaration); }
	|  
		// Member with a type or just a type def
		// A::T a(), ::T a, ::B a, void a, E a (where E is the enclosing class)
		((LITERAL___extension__)? declaration_specifiers)=>
		{beginFieldDeclaration();
		 if (statementTrace>=1) 
			printf("member_declaration_10[%d]: Declaration(s)\n",
				LT(1).getLine());
		}
		(LITERAL___extension__!)? declaration_specifiers (member_declarator_list)? (EOF!|SEMICOLON) //{end_of_stmt();}
                // now member typedefs are placed under CSM_FIELD, so we do this here as well
                // TODO: separate imaginery AST nodes for typedefs and fields
		{ #member_declaration = #(#[CSM_FIELD, "CSM_FIELD"], #member_declaration); }
	|  
		{isCPlusPlus()}? ((LITERAL_export)? LITERAL_template) => member_declaration_template
	|  
		{if (statementTrace>=1) 
			printf("member_declaration_14[%d]: Access specifier\n",
			    LT(1).getLine());
		}
		access_specifier COLON!
	|  
		{if (statementTrace>=1) 
			printf("member_declaration_15[%d]: Semicolon\n",
				LT(1).getLine());
		}
		SEMICOLON! //{end_of_stmt();}
	|	using_declaration
	)
	;	// end member_declaration

// FIXUP: till qualifiedItemIsOneOf(qiType | qiCtor) is not correct in function_definition
function_definition_no_ret_type
	:	// don't want next action as an init-action due to (...)=> caller
	//{ beginFunctionDefinition(); }
	(	// Next line is equivalent to guarded predicate in PCCTS
		function_declarator[true]
		(	options{warnWhenFollowAmbig = false;}:
			//(declaration)*	// Possible for K & R definition
                        (function_K_R_parameter_list)?
			{in_parameter_list = false;}
		)?
		compound_statement
	)
	//{endFunctionDefinition();}
	;

function_declarator_with_fun_as_ret_type  [boolean definition]
        :
                (ptr_operator)=> ptr_operator function_declarator_with_fun_as_ret_type[definition]
                |
                LPAREN function_declarator[definition] RPAREN function_params
        ;
    
function_declaration_with_fun_as_ret_type
        :
            declaration_specifiers function_declarator_with_fun_as_ret_type[false] (EOF!|SEMICOLON)
        ;

function_definition_with_fun_as_ret_type
        :
		declaration_specifiers function_declarator_with_fun_as_ret_type[true]
		(	options{warnWhenFollowAmbig = false;}:
			//(declaration)*	// Possible for K & R definition
                        (function_K_R_parameter_list)?
			{in_parameter_list = false;}
		)?
		compound_statement

        ;

protected
function_K_R_parameter_list
    :
    (function_K_R_parameter)+
    {#function_K_R_parameter_list = #(#[CSM_KR_PARMLIST, "CSM_KR_PARMLIST"], #function_K_R_parameter_list);}
    ;

protected
function_K_R_parameter
    :
    declaration
    {#function_K_R_parameter=#(#[CSM_PARAMETER_DECLARATION, "CSM_PARAMETER_DECLARATION"], #function_K_R_parameter);}
    ;

function_definition
	:	// don't want next action as an init-action due to (...)=> caller
	//{ beginFunctionDefinition(); }
	(	// Next line is equivalent to guarded predicate in PCCTS
		// (SCOPE | ID)? => <<qualifiedItemIsOneOf(qiType|qiCtor)>>?
		{( !(LA(1)==SCOPE || LA(1)==ID) || qualifiedItemIsOneOf(qiType | qiCtor) )}?
		declaration_specifiers function_declarator[true]
		(	options{warnWhenFollowAmbig = false;}:
			//(declaration)*	// Possible for K & R definition
                        (function_K_R_parameter_list)?
			{in_parameter_list = false;}
		)?
		compound_statement
	|	// Next line is equivalent to guarded predicate in PCCTS
		// (SCOPE | ID)? => <<qualifiedItemIsOneOf(qiPtrMember)>>?
		//{( !(LA(1)==SCOPE||LA(1)==ID) || (qualifiedItemIsOneOf(qiPtrMember)) )}?
		function_declarator[true]
		(	options{warnWhenFollowAmbig = false;}:
			(declaration)*	// Possible for K & R definition
			{in_parameter_list = false;}
		)?		    
                compound_statement             
	)
	//{endFunctionDefinition();}
	;

// rule for predicting "declaration"
// must be updated together with declaration rule
protected
is_declaration
        :
        LITERAL_extern | LITERAL_using | (declaration_specifiers declarator)    
        ;

declaration
	:	
		(LITERAL_extern STRING_LITERAL)=> linkage_specification
	|	
		{beginDeclaration();}
		// LL 31/1/97: added (COMMA) ? below. This allows variables to
		// typedef'ed more than once. DW 18/08/03 ?
		declaration_specifiers ((COMMA!)? init_declarator_list)? (EOF!|SEMICOLON)
		//{end_of_stmt();}
		{endDeclaration();}
	|	
		using_declaration	// DW 19/04/04
	;

linkage_specification
	:	LITERAL_extern STRING_LITERAL
		(	LCURLY (external_declaration)* RCURLY
		|	external_declaration
		)
		{ #linkage_specification = #(#[CSM_LINKAGE_SPECIFICATION,"CSM_LINKAGE_SPECIFICATION"], #linkage_specification);}
	;

declaration_specifiers
	{
	    // Global flags to allow for nested declarations
	    _td = false;	// For typedef
	    _fd = false;	// For friend
	    _sc = scInvalid;	// For StorageClass
	    _tq = tqInvalid;	// For TypeQualifier
	    _ts = tsInvalid;	// For TypeSpecifier
	    _ds = dsInvalid;	// For DeclSpecifier


	     // Locals
	    boolean td = false;	// For typedef
	    boolean fd = false;	// For friend
	    StorageClass sc = scInvalid;	// auto,register,static,extern,mutable
	    TypeQualifier tq = tqInvalid;	// const,const_cast,volatile,cdecl
	    /*TypeSpecifier*/int ts = tsInvalid;	// char,int,double, etc., class,struct,union
	    DeclSpecifier ds = dsInvalid;	// inline,virtual,explicit
	}
	:
	(	
                (options {warnWhenFollowAmbig = false;}
		:	sc = storage_class_specifier
		|	tq = cv_qualifier 
		|	literal_inline                  {ds = dsINLINE;}
		|	LITERAL_virtual			{ds = dsVIRTUAL;}
		|	LITERAL_explicit			{ds = dsEXPLICIT;}
                |       LITERAL_enum
		|	
                        {if (statementTrace>=1) 
                                printf("declaration_specifiers_1[%d]: Typedef\n", LT(1).getLine());
                        }                        
                        LITERAL_typedef (options {greedy=true;} : LITERAL_typename)? {td=true;} 
		|	LITERAL_typename
		|	LITERAL_friend	{fd=true;}
		|	literal_stdcall
                |      { LT(1).getText().equals(LITERAL___global_ext) == true}? ID 
		)*
		(	
                        (options {greedy=true;} :type_attribute_specification)?
                        ts = type_specifier[ds] 
                        // support for "A const*";
                        // need to catch postfix_cv_qualifier
                        (postfix_cv_qualifier)? 

                        (
                            (literal_inline   {ds = dsINLINE;})
                        |
                            (sc = storage_class_specifier)
                        )*


                        (options {greedy=true;} :type_attribute_specification)?
//		|	LITERAL_typename	{td=true;}	direct_declarator 
                |       literal_typeof LPAREN typeof_param RPAREN
                                 
		)                
	)
	{declarationSpecifier(td, fd, sc, tq, ts, ds);}
	;

protected
typeof_param : 
            (type_name) => type_name
        |
            expression
        ;

storage_class_specifier returns [CPPParser.StorageClass sc = scInvalid]
	:	LITERAL_auto		{sc = scAUTO;}
	|	LITERAL_register	{sc = scREGISTER;}
	|	LITERAL_static	{sc = scSTATIC;}
	|	LITERAL_extern	{sc = scEXTERN;}        
	|	LITERAL_mutable	{sc = scMUTABLE;}                     
	;

cv_qualifier returns [CPPParser.TypeQualifier tq = tqInvalid] // aka cv_qualifier
	:  (literal_const|LITERAL_const_cast)	{tq = tqCONST;} 
	|  literal_volatile			{tq = tqVOLATILE;}
	;

type_specifier[DeclSpecifier ds] returns [/*TypeSpecifier*/int ts = tsInvalid]
	:	ts = simple_type_specifier
	|	ts = class_specifier[ds]
	|	enum_specifier	{ts=tsENUM;}
	;

simple_type_specifier returns [/*TypeSpecifier*/int ts = tsInvalid]
	:	(	{qualifiedItemIsOneOf(qiType|qiCtor)}? 
			qualified_type {ts=tsTYPEID;}	
			{ #simple_type_specifier = #([CSM_TYPE_COMPOUND, "CSM_TYPE_COMPOUND"], #simple_type_specifier); }
		|	
			(	LITERAL_char		{ts |= tsCHAR;}
			|	LITERAL_wchar_t	{ts |= tsWCHAR_T;}  
			|	LITERAL_bool	{ts |= tsBOOL;}
			|	LITERAL_short	{ts |= tsSHORT;}
			|	LITERAL_int		{ts |= tsINT;}
			|	literal_int64	{ts |= tsLONG;}
			|	LITERAL___w64		{ts |= tsLONG;}
			|	LITERAL_long		{ts |= tsLONG;}
			|	literal_signed	{ts |= tsSIGNED;}
			|	literal_unsigned	{ts |= tsUNSIGNED;}
			|	LITERAL_float		{ts |= tsFLOAT;}
			|	LITERAL_double	{ts |= tsDOUBLE;}
			|	LITERAL_void		{ts |= tsVOID;}
			)+
			{ #simple_type_specifier = #([CSM_TYPE_BUILTIN, "CSM_TYPE_BUILTIN"], #simple_type_specifier); }
		|
			// Fix towards allowing us to parse *.cpp files directly
			(qualified_type qualified_id)=> qualified_type { ts=tsTYPEID; }
			{ #simple_type_specifier = #([CSM_TYPE_COMPOUND, "CSM_TYPE_COMPOUND"], #simple_type_specifier); }
		)
	;

qualified_type
	{String s;}
	: 
		// JEL 3/29/96 removed this predicate and moved it upwards to
		// simple_type_specifier.  This was done to allow parsing of ~ID to 
		// be a unary_expression, which was never reached with this 
		// predicate on
		// {qualifiedItemIsOneOf(qiType|qiCtor)}?

		s = scope_override 
		id:ID 
		(options {warnWhenFollowAmbig = false;}:
		 LESSTHAN template_argument_list GREATERTHAN
		)?
	;

class_specifier[DeclSpecifier ds] returns [/*TypeSpecifier*/int ts = tsInvalid]
	{String saveClass = ""; String id = "";}
	:	(LITERAL_class	{ts = tsCLASS;}	
		|LITERAL_struct	{ts = tsSTRUCT;}
		|LITERAL_union	{ts = tsUNION;}
		)
                (options {greedy=true;} : type_attribute_specification)?
		(	id = qualified_id
			(options{generateAmbigWarnings = false;}:
				{
				    saveClass = enclosingClass;
				    enclosingClass = id;
				}
//                                (LESSTHAN template_argument_list GREATERTHAN)?
				(base_clause)?
				LCURLY
				// This stores class name in dictionary
				{beginClassDefinition(ts, id);}
				(member_declaration)*
				{endClassDefinition();}
				(EOF!|RCURLY)
				{enclosingClass = saveClass;}
			|       				
                                {classForwardDeclaration(ts, ds, id);}
			)
		|
			LCURLY
			{saveClass = enclosingClass; enclosingClass = (String ) "__anonymous";}
			{beginClassDefinition(ts, "anonymous");}
			(member_declaration)*
			{endClassDefinition();}
			(EOF!|RCURLY)
			{enclosingClass = saveClass;}
		)
	;

enum_specifier
	:	LITERAL_enum
		(	LCURLY! enumerator_list (EOF!|RCURLY)
		|	id:ID     // DW 22/04/03 Suggest qualified_id here to satisfy
				  // elaborated_type_specifier
			{beginEnumDefinition(id.getText());}
			(LCURLY! enumerator_list (EOF!|RCURLY))
			{endEnumDefinition();}
		)
	;

enumerator_list
    :           
                enumerator
                ( options {greedy=true;} : (COMMA!) enumerator )*  
                (COMMA!)?
		{ #enumerator_list = #(#[CSM_ENUMERATOR_LIST, "CSM_ENUMERATOR_LIST"], #enumerator_list); }           
    | 
    ;

enumerator
	:	id:ID (ASSIGNEQUAL constant_expression)?
		{enumElement((id.getText()));}
	;

/* This matches a generic qualified identifier ::T::B::foo
 * (including LITERAL_OPERATOR).
 * It might be a good idea to put T::~dtor in here
 * as well, but id_expression in expr.g puts it in manually.
 * Maybe not, 'cause many people use this assuming only A::B.
 * How about a 'qualified_complex_id'?
 */
qualified_id returns [String q = ""]
	{
	    String so;
	    StringBuilder qitem = new StringBuilder();
	}
	:
	so =  scope_override { qitem.append(so); }
	(  
		id:ID	(options{warnWhenFollowAmbig = false;}:
				 LESSTHAN template_argument_list GREATERTHAN)?
		{qitem.append(id.getText());}
		|  
		LITERAL_OPERATOR optor (options{warnWhenFollowAmbig = false;}:
				 LESSTHAN template_argument_list GREATERTHAN)?
		{qitem.append("operator"); qitem.append("NYI");} // TODO: understand
		|
		LITERAL_this  // DW 21/07/03 fix to pass test8.i
		|
		(LITERAL_true|LITERAL_false)	// DW 21/07/03 fix to pass test8.i
	)
	{q = qitem.toString(); #qualified_id = #(#[CSM_QUALIFIED_ID, q], #qualified_id);}
	;

typeID
	:	{isTypeName((LT(1).getText()))}?
		ID
	;

init_declarator_list
	:	init_declarator (COMMA init_declarator)*
	;

init_declarator
	:	declarator 
		(	
			ASSIGNEQUAL 
			initializer
		|	
			LPAREN expression_list RPAREN
		)?
	;

initializer
   :  remainder_expression // DW 18/4/01 assignment_expression
   |  LCURLY initializer (COMMA initializer)* (COMMA)? (EOF!|RCURLY)
   ;


// so far this one is used in predicates only
class_head     
        { String s; }
	:	// Used only by predicates	
	(
		LITERAL_struct  
	|	LITERAL_union 
	|	LITERAL_class 
	)
        (options {greedy=true;} : type_attribute_specification)?
	(
     
            s = scope_override  

            ID	
		(LESSTHAN template_argument_list GREATERTHAN)?
		(base_clause)? 
	)? LCURLY
	;


base_clause
	:	COLON base_specifier (COMMA base_specifier)*
	;

base_specifier
	:	// DW 13/08/03 Should check qualified_type for class-name?
	(	LITERAL_virtual (access_specifier)? qualified_type 
	|	access_specifier (LITERAL_virtual)? qualified_type
	|	qualified_type
	)
	{#base_specifier=#(#[CSM_BASE_SPECIFIER,"CSM_BASE_SPECIFIER"], #base_specifier);}
	;

access_specifier
	:	LITERAL_public
	|	LITERAL_protected
	|	LITERAL_private
	;

member_declarator_list
	:	member_declarator (ASSIGNEQUAL constant_expression)?
		(COMMA member_declarator (ASSIGNEQUAL constant_expression)?)*
	;

member_declarator
	:	
		((ID)? COLON constant_expression)=>(ID)? COLON constant_expression
	|  
		declarator
	;

conversion_function_decl_or_def returns [boolean definition = false]
	{CPPParser.TypeQualifier tq; }
	:	// DW 01/08/03 Use type_specifier here? see syntax
		LITERAL_OPERATOR declaration_specifiers (STAR | AMPERSAND)*
		(LESSTHAN template_parameter_list GREATERTHAN)?
		LPAREN (parameter_list)? RPAREN	
		(tq = cv_qualifier)?
		(exception_specification)?
		(	compound_statement { definition = true; }
		|	SEMICOLON! //{end_of_stmt();}
		)
	;

// JEL note:  does not use (const|volatile)* to avoid lookahead problems
cv_qualifier_seq
	{TypeQualifier tq;}
	:
	(options {warnWhenFollowAmbig = false;}:tq = cv_qualifier)*
	;

declarator
	:
		//{( !(LA(1)==SCOPE||LA(1)==ID) || qualifiedItemIsOneOf(qiPtrMember) )}?
                // VV: 23/05/06 added support for __restrict after pointers
                //i.e. void foo (char **__restrict a)
		(ptr_operator)=> ptr_operator // AMPERSAND or STAR
		restrict_declarator
	|	
		direct_declarator
	;

restrict_declarator
        :
		//{( !(LA(1)==SCOPE||LA(1)==ID) || qualifiedItemIsOneOf(qiPtrMember) )}?
		(ptr_operator)=> ptr_operator // AMPERSAND or STAR
		restrict_declarator
	|	
		(literal_restrict!)? direct_declarator
        ;

direct_declarator
	{String id;
	 TypeQualifier tq;}  
	:
		// Must be function declaration               
		((options {greedy=true;} :function_attribute_specification)? idInBalanceParensHard LPAREN (RPAREN|parameter_list))=>
		// TODO: refactor the grammar and use function_declarator here
		(options {greedy=true;} :function_attribute_specification)?
		id = idInBalanceParensHard                                                     
		{declaratorID(id, qiFun);}                
		LPAREN! //{declaratorParameterList(false);}
		(parameter_list)?
		RPAREN! //{declaratorEndParameterList(false);}                
		(tq = cv_qualifier)*
		(exception_specification)?
		(options {greedy=true;} :function_attribute_specification)?
		(asm_block!)?
	|	(qualified_id LPAREN qualified_id)=>	// Must be class instantiation
		id = qualified_id
		{
		    declaratorID(id, qiVar);
		}
		LPAREN
		expression_list
		RPAREN
		{#direct_declarator = #(#[CSM_VARIABLE_DECLARATION, "CSM_VARIABLE_DECLARATION"], #direct_declarator);}
	|
                (options {greedy=true;} :variable_attribute_specification)?
                (
                    (qualified_id LSQUARE)=>	// Must be array declaration
                    id = qualified_id 
                    {
                         if (_td==true) {
                            declaratorID(id,qiType);
                         } else {
                            declaratorID(id,qiVar);
                         }
                         is_address = false; is_pointer = false;
                    }
                    (options {warnWhenFollowAmbig = false;}:
                     LSQUARE (constant_expression)? RSQUARE)+
                    {declaratorArray();}
                    {
                        if (_td==true) {
                            // todo: build tree in this case
                        } else  {
                            #direct_declarator = #(#[CSM_ARRAY_DECLARATION, "CSM_ARRAY_DECLARATION"], #direct_declarator);
                        }
                    }
                |
                    id = qualified_id
                    {
                         if (_td==true) {
                            // todo: build tree in this case
                            declaratorID(id,qiType);
                         } else {
                            #direct_declarator = #(#[CSM_VARIABLE_DECLARATION, "CSM_VARIABLE_DECLARATION"], #direct_declarator);
                            declaratorID(id,qiVar);
                         }
                         is_address = false; is_pointer = false;
                    }
                )
                (options {greedy=true;} :variable_attribute_specification)?
	|	
		// DW 24/05/04 This block probably never entered as dtor selected out earlier
		//	Note 1: In fact no dictionary entries for ctor or dtor	
		//	Note 2: 2: "class" not recorded in CPPSymbol
		TILDE dtor:ID {declaratorID((dtor.getText()),qiDtor);}
		{
                    if( reportOddWarnings ) printf("direct_declarator[%d]: Warning direct_declarator5 entered unexpectedly with %s\n", LT(1).getLine(),(dtor.getText()));
		}
		LPAREN //{declaratorParameterList(false);}
		(parameter_list)?
		RPAREN //{declaratorEndParameterList(false);}
	|	
		LPAREN declarator RPAREN declarator_suffixes

/* **            
             // Issue #87792  Parser reports error on declarations with name in parenthesis.
                (  (LPAREN | LSQUARE)=> (declarator_suffixes)
                   | 
                ) 
** */
	;

declarator_suffixes
	{TypeQualifier tq;}  
	:
	(
		(options {warnWhenFollowAmbig = false;}:
		 LSQUARE (constant_expression)? RSQUARE)+
		{declaratorArray();}
	|	{(!((LA(1)==LPAREN)&&(LA(2)==ID))||(qualifiedItemIsOneOf(qiType|qiCtor,1)))}?
		LPAREN //{declaratorParameterList(false);}
		(parameter_list)?
		RPAREN //{declaratorEndParameterList(false);}
		(tq = cv_qualifier)*
		(exception_specification)?
//	|	// DW 28/06/04 deleted Assume either following bracketed declaration
//		// empty
	)
	;

/* I think something is weird with the context-guards for predicates;
 * as a result I manually hoist the appropriate pred from ptr_to_member
 *
 * TER: warning: seems that "ID::" will always bypass and go to 2nd alt :(
 */
function_declarator [boolean definition]
	:
		//{( !(LA(1)==SCOPE||LA(1)==ID) || qualifiedItemIsOneOf(qiPtrMember) )}?
		(ptr_operator)=> ptr_operator function_declarator[definition]
	|	
		function_direct_declarator[definition]
	;

function_direct_declarator [boolean definition] 
	{String q; CPPParser.TypeQualifier tq;}
	:
                (options {greedy=true;} : function_attribute_specification)?
		(
		function_direct_declarator_2[definition]		
		)

		(options{warnWhenFollowAmbig = false;}:
		 tq = cv_qualifier)*                
		(ASSIGNEQUAL OCTALINT)?	// The value of the octal must be 0
		//{functionEndParameterList(definition);}
		(exception_specification)?
                (options {greedy=true;} :function_attribute_specification)?
                (asm_block!)?
	;
        
protected
function_direct_declarator_2 [boolean definition] 
	{String q; CPPParser.TypeQualifier tq;}
	:
		/* predicate indicate that plain ID is ok here; this counteracts any
		 * other predicate that gets hoisted (along with this one) that
		 * indicates that an ID is a type or whatever.  E.g.,
		 * another rule testing isTypeName() alone, implies that the
		 * the ID *MUST* be a type name.  Combining isTypeName() and
		 * this predicate in an OR situation like this one:
		 * ( declaration_specifiers ... | function_declarator ... )
		 * would imply that ID can be a type name OR a plain ID.
		 */
/*
		(	// fix prompted by (isdigit)() in xlocnum
			LPAREN q = qualified_id { declaratorID(q, qiFun); } RPAREN
		|
			q = qualified_id { declaratorID(q, qiFun);}
		)
*/              q = idInBalanceParensHard { declaratorID(q, qiFun);}

		LPAREN
		{
		    //functionParameterList();
		    if (K_and_R == false) {
			    in_parameter_list = true;
		    }
		}
		(parameter_list)? 
		{
		    if (K_and_R == false) {
	  		in_parameter_list = false;
		    } else {
			in_parameter_list = true;
		    }
		}
		RPAREN
	;

protected
function_params
        :
		LPAREN
		{
		    //functionParameterList();
		    if (K_and_R == false) {
			    in_parameter_list = true;
		    }
		}
		(parameter_list)? 
		{
		    if (K_and_R == false) {
	  		in_parameter_list = false;
		    } else {
			in_parameter_list = true;
		    }
		}
		RPAREN
        ;

ctor_definition 
	:
	ctor_head
	ctor_body
	//{endConstructorDefinition();}
	;

ctor_head 
	:
	ctor_decl_spec
	ctor_declarator[true]
	;

ctor_decl_spec
	:
	(literal_inline|LITERAL_explicit)*
	;

ctor_declarator[boolean definition]
	{String q;}
	: 
	// JEL 4/3/96 qualified_id too broad DW 10/06/03 ?
	q = qualified_ctor_id
        // VV: 06/06/06 handle constructor of class template explicite specialization
        (LESSTHAN template_argument_list GREATERTHAN)?
	//{declaratorParameterList(definition);}
	LPAREN! (parameter_list)? RPAREN!
	//{declaratorEndParameterList(definition);}
	(exception_specification)?
	;

// This matches a generic qualified identifier ::T::B::foo
// that is satisfactory for a ctor (no operator, no trailing <>)
qualified_ctor_id returns [String q = ""]
	{
	    String so;
	    StringBuilder  qitem = new StringBuilder();
	}
	: 
	so = scope_override
	{qitem.append(so);}
	id:ID	// DW 24/05/04 Note. Neither Ctor or Dtor recorded in dictionary
/* ****        
//       Issue 86695 "Parser incorrect build CSM_QUALIFIED_ID branch for templated constructors"

        (options{warnWhenFollowAmbig = false;}:
				 LESSTHAN template_argument_list GREATERTHAN)? 
**** */
	{qitem.append(id.getText());        
	 q = qitem.toString();
	#qualified_ctor_id = #(#[CSM_QUALIFIED_ID, q], #qualified_ctor_id);} 
	;

ctor_body
	:
	(ctor_initializer)?
	compound_statement
	;

ctor_initializer
	:
	COLON! superclass_init (COMMA! superclass_init)*

        {#ctor_initializer = #(#[CSM_CTOR_INITIALIZER_LIST, "CSM_CTOR_INITIALIZER_LIST"], #ctor_initializer);}
	;

superclass_init
	{String q;} 
	: 
	q = qualified_id LPAREN! (expression_list)? RPAREN!

        {#superclass_init = #(#[CSM_CTOR_INITIALIZER, "CSM_CTOR_INITIALIZER"], #superclass_init);}
	;

dtor_head[boolean definition]
	:
	dtor_decl_spec
	dtor_declarator[definition]
	;

dtor_decl_spec
	:
	(literal_inline|LITERAL_virtual)*
	;

/* ********

// Issue 86683 "Parser incorrect build CSM_QUALIFIED_ID branch for destructors"

dtor_declarator[boolean definition]
	:	
	//({definition}? dtor_scope_override)
        dtor_scope_override	
	//{declaratorParameterList(definition);}
        // VV: /06/06/06 ~dtor(void) is valid construction
	LPAREN (LITERAL_void)? RPAREN
        //{declaratorEndParameterList(definition);}
        (ASSIGNEQUAL OCTALINT)?	
	(exception_specification)?        
	;

protected
dtor_scope_override
        {String q; StringBuilder  qitem = new StringBuilder();}
        :
        q = scope_override 
        { qitem.append(q); }
        TILDE 
        id:ID
        (options{warnWhenFollowAmbig = false;}:
				 LESSTHAN template_argument_list GREATERTHAN)?
        { qitem.append('~').append(id.getText()); 
          q = qitem.toString();  
        }        
        { if( q.length() > 0 ) #dtor_scope_override = #(#[CSM_QUALIFIED_ID, q], #dtor_scope_override); } 
        ; 

****** */


dtor_declarator[boolean definition]
	:	
	//({definition}? dtor_scope_override)
        dtor_scope_override
	TILDE ID
	//{declaratorParameterList(definition);}
        // VV: /06/06/06 ~dtor(void) is valid construction
	LPAREN (LITERAL_void)? RPAREN
        //{declaratorEndParameterList(definition);}
        (ASSIGNEQUAL OCTALINT)?	
	(exception_specification)?        
	;

protected
dtor_scope_override
        {String q;}
        :
        q = scope_override        
        { if( q.length() > 0 ) #dtor_scope_override = #(#[CSM_QUALIFIED_ID, q], #dtor_scope_override); } 
        ;

      

dtor_body
	:
	compound_statement
	//{endDestructorDefinition();}
	;

parameter_list
	:	
	parameter_declaration_list (ELLIPSIS)?
	{ #parameter_list = #(#[CSM_PARMLIST, "CSM_PARMLIST"], #parameter_list); }
	;

parameter_declaration_list
	:	
	(	parameter_declaration 
		(// Have not been able to find way of stopping warning of
		 // non-determinism between alt 1 and exit branch of block
		 COMMA! parameter_declaration
		)*
	)
	;

parameter_declaration
	:	{beginParameterDeclaration();}
		(
			{!((LA(1)==SCOPE) && (LA(2)==STAR||LA(2)==LITERAL_OPERATOR)) &&
			    (!(LA(1)==SCOPE||LA(1)==ID) ||
			    qualifiedItemIsOneOf(qiType|qiCtor) )}?
			declaration_specifiers	// DW 24/3/98 Mods for K & R
			(  
				(declarator)=> declarator        // if arg name given
			| 
				abstract_declarator  // if arg name not given  // can be empty
			)
		|
			(declarator)=> declarator	// DW 24/3/98 Mods for K & R
		|
			ELLIPSIS
		)
		(ASSIGNEQUAL 
		 remainder_expression // DW 18/4/01 assignment_expression
		)?
		{ #parameter_declaration = #(#[CSM_PARAMETER_DECLARATION, "CSM_PARAMETER_DECLARATION"], #parameter_declaration); }
	;

type_name // aka type_id
	:
	declaration_specifiers abstract_declarator
	;

/* This rule looks a bit weird because (...) can happen in two
 * places within the declaration such as "void (*)()" (ptr to
 * function returning nothing).  However, the () of a function
 * can only occur after having seen either a (abstract_declarator)
 * and not after a [..] or simple '*'.  These are the only two
 * valid () func-groups:
 *    int (*)();     // ptr to func
 *    int (*[])();   // array of ptr to func
 */
abstract_declarator
	:	//{( !(LA(1)==SCOPE||LA(1)==ID) || qualifiedItemIsOneOf(qiPtrMember) )}?
		ptr_operator (literal_restrict!)? abstract_declarator 
	|	
		LPAREN abstract_declarator RPAREN
		(abstract_declarator_suffix)*
	|	
		(LSQUARE (constant_expression )? RSQUARE {declaratorArray();}
		)+
	|	
		/* empty */
	;

abstract_declarator_suffix
	:	
		LSQUARE (constant_expression)? RSQUARE
		{declaratorArray();}
	|
		LPAREN
		//{declaratorParameterList(false);}
		(parameter_list)?
		RPAREN
		cv_qualifier_seq
		//{declaratorEndParameterList(false);}
		(exception_specification)?
	;

exception_specification
	{String so;}
	:	LITERAL_throw 
		LPAREN 
		(exception_type_id (COMMA exception_type_id)* )? 
		RPAREN
	;

// simplified version of type_id that is used in exception specification
protected 
exception_type_id
	{ /*TypeSpecifier*/int ts; String so; }
	:
	//( (so = scope_override ID) | built_in_type ) (STAR | AMPERSAND)*
        parameter_declaration
	;

protected
function_attribute_specification! 
        : 
            attribute_specification_list
        ;

protected
variable_attribute_specification!
        :
            attribute_specification_list
        ;

protected
declspec!
        : 
            literal_declspec balanceParens
        ;

protected
type_attribute_specification!
        :
            attribute_specification_list | declspec
        ;

protected
namespace_attribute_specification!
        :
            attribute_specification_list
        ;

protected
attribute_specification_list
	:
	    attribute_specification (options {greedy=true;} : attribute_specification_list)?
	;

attribute_specification
        :       LITERAL___attribute__
                LPAREN balanceParens RPAREN
        ;

protected
balanceParens
        : 
            LPAREN
            (options {greedy=false;}:
                balanceParens | .
            )*
            RPAREN
        ;
 
protected    
balanceCurlies
        : 
            LCURLY
            (options {greedy=false;}:
                balanceCurlies | .
            )*
            RCURLY
        ;

// Removed due to restrictions of clone antlr optimization
/*protected 
idInBalanceParensLight returns [String id = ""]
        { int count = 0; }
        :               
            (   LPAREN
                { count++; }
            )*          
            id = qualified_id
            (    RPAREN
                { count--; }
            )*
           {count == 0}?
       ;     */
 
protected
idInBalanceParensHard returns [String id = ""]
        :
             (
                LPAREN
                id = idInBalanceParensHard                 
                RPAREN
              )
              |
              id = qualified_id
        ;

template_head
	:	
               (LITERAL_export!)? 
		LITERAL_template^
		LESSTHAN! tpl:template_parameter_list GREATERTHAN!
		//{ #template_head = #(#[CSM_TEMPLATE_PARMLIST, "CSM_TEMPLATE_PARMLIST"], #tpl); }
	;

template_parameter_list
	:	
		//{beginTemplateParameterList();}
		template_parameter (COMMA template_parameter)*
		//{endTemplateParameterList();}
	;

/* Rule requires >2 lookahead tokens. The ambiguity is resolved 
 * correctly, however. According to the manual "...A template argument
 * that can be interpreted either as a parameter-declaration or a
 * type-argument (because its identifier is the name of an
 * already existing class) is taken as type-argument."
 * Therefore, any "class ID" that is seen on the input, should
 * match the first alternative here (it should be a type-argument).
 */
template_parameter
	:
	(options{generateAmbigWarnings = false;}:
		(LITERAL_class|LITERAL_typename) 
		(id:ID  (ASSIGNEQUAL assigned_type_name)? )?
		{templateTypeParameter((id == null) ? "" : id.getText());}
	|
		template_template_parameter
	|	
		parameter_declaration	// DW 30/06/03 This doesn't seem to match the
					// current standard
	)
	;

protected template_template_parameter
    :
	LITERAL_template LESSTHAN tpl:template_parameter_list GREATERTHAN 
	LITERAL_class ID
	{ #template_template_parameter = #(#[CSM_TEMPLATE_TEMPLATE_PARAMETER, "CSM_TEMPLATE_TEMPLATE_PARAMETER"], #template_template_parameter);}

    ;

/* This is to allow an assigned type_name in a template parameter
 *	list to be defined previously in the same parameter list,
 *	as type setting is ineffective whilst guessing
 */
assigned_type_name
	{/*TypeSpecifier*/int ts;}
	:
	(LITERAL_typename)?
	(options{generateAmbigWarnings = false;}:
		qualified_type abstract_declarator	
	|
		ts = simple_type_specifier abstract_declarator
	)
	;

// This rule refers to an instance of a template class or function
template_id	// aka template_class_name
	:	ID LESSTHAN template_argument_list GREATERTHAN
	;

template_argument_list
	:	template_argument (COMMA template_argument)*
        |    
	;

/* Here assignment_expression was changed to shift_expression to rule out
 *  x< 1<2 > which causes ambiguities. As a result, these can be used only
 *  by enclosing parentheses x<(1<2)>. This is true for x<1+2> ==> bad,
 *  x<(1+2)> ==> ok.
 */
template_argument
	:
		{( !(LA(1)==SCOPE||LA(1)==ID) || qualifiedItemIsOneOf(qiType|qiCtor) )}?
		type_name
	|	shift_expression // failed in iosfwd
//	|	assignment_expression	// Inserted as per grammar summary
	;

///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//////////////////////////////  STATEMENTS ////////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////

statement_list
	:	(statement)+
		//{#statement_list = #(#[CSM_STATEMENT_LIST, "CSM_STATEMENT_LIST"], #statement_list);}
	;

statement
	:
	(	

//              Issue 83496   C++ parser does not allow class definition inside function
//              Issue 83996   Code completion list doesn't appear if enum defined within function (without messages)
                
                ( (LITERAL_enum (ID)? LCURLY) | class_head ) => 
                {if (statementTrace>=1) 
			printf("statement_1[%d]: declaration\n", LT(1).getLine());
		}
                member_declaration                 
	|
		( LITERAL_typedef ) =>
		// TODO: external_declaration is too generic here. Refactor this!
		external_declaration
        |
                ( is_declaration ) => 
                {if (statementTrace>=1) 
			printf("statement_1[%d]: declaration\n", LT(1).getLine());
		}
                declaration  {#statement = #(#[CSM_DECLARATION_STATEMENT, "CSM_DECLARATION_STATEMENT"], #statement);}  
	|	
                {if (statementTrace>=1) 
			printf("statement_2[%d]: labeled_statement\n", LT(1).getLine());
		}                
                labeled_statement
	|
                {if (statementTrace>=1) 
			printf("statement_3[%d]: case_statement\n", LT(1).getLine());
		}	
                case_statement
	|
                {if (statementTrace>=1) 
			printf("statement_4[%d]: default_statement\n", LT(1).getLine());
		}	
                default_statement
	|
                {if (statementTrace>=1) 
			printf("statement_5[%d]: expression\n", LT(1).getLine());
		}	
                expression SEMICOLON! {/*end_of_stmt();*/#statement = #(#[CSM_EXPRESSION_STATEMENT, "CSM_EXPRESSION_STATEMENT"], #statement);}
	|
                {if (statementTrace>=1) 
			printf("statement_6[%d]: compound_statement\n", LT(1).getLine());
		}	
                compound_statement
	|
                {if (statementTrace>=1) 
			printf("statement_7[%d]: selection_statement\n", LT(1).getLine());
		}	
                selection_statement
	|
                {if (statementTrace>=1) 
			printf("statement_8[%d]: iteration_statement\n", LT(1).getLine());
		}	
                iteration_statement
	|
                {if (statementTrace>=1) 
			printf("statement_9[%d]: jump_statement\n", LT(1).getLine());
		}	
                jump_statement
	|
                {if (statementTrace>=1) 
			printf("statement_10[%d]: SEMICOLON\n", LT(1).getLine());
		}	
                SEMICOLON! //{end_of_stmt();}
	|
                {if (statementTrace>=1) 
			printf("statement_11[%d]: try_block\n", LT(1).getLine());
		}	
                try_block
	|
                {if (statementTrace>=1) 
			printf("statement_12[%d]: throw_statement\n", LT(1).getLine());
		}	
                throw_statement
	|
                {if (statementTrace>=1) 
			printf("statement_13[%d]: asm_block\n", LT(1).getLine());
		}	
                asm_block
//	|	preprocDirective
//        |       member_declaration
	)
	;

labeled_statement
	:	label COLON statement 
	;

protected
label
	:
	ID
	{#label = #([CSM_LABELED_STATEMENT, "CSM_LABELED_STATEMENT"], #label);}
	;

case_statement
	:	LITERAL_case
		case_expression COLON statement
	;

protected
case_expression
	:
	constant_expression
	{#case_expression = #(#[CSM_CASE_STATEMENT, "CSM_CASE_STATEMENT"], #case_expression);}
	;

default_statement
	:	default_label COLON statement
	;

protected
default_label
	:	
	LITERAL_default
		{#default_label = #(#[CSM_DEFAULT_STATEMENT, "CSM_DEFAULT_STATEMENT"], #default_label);}
	;

compound_statement
	:                    
            {isLazyCompound()}? balanceCurlies             
            {#compound_statement = #(#[CSM_COMPOUND_STATEMENT_LAZY, "CSM_COMPOUND_STATEMENT_LAZY"], #compound_statement);}
        |   {!isLazyCompound()}?
            (
                LCURLY
		/*{
		    //end_of_stmt();
		    //enterNewLocalScope();
		}*/
		(statement_list)?
		(EOF!|RCURLY)
		//{exitLocalScope();}
		{#compound_statement = #(#[CSM_COMPOUND_STATEMENT, "CSM_COMPOUND_STATEMENT"], #compound_statement);}
            )                      
	;

protected 
condition
	:
	((condition_declaration)=> condition_declaration | condition_expression)
	{#condition=#(#[CSM_CONDITION, "CSM_CONDITION"], #condition);}
	;

protected 
condition_expression
	:
	expression
	;

protected 
condition_declaration {int ts = tsInvalid;}
	:
	ts=type_specifier[dsInvalid] declarator ASSIGNEQUAL assignment_expression
	;

//	(declaration)=> declaration|	expression


/* NOTE: cannot remove ELSE ambiguity, but it parses correctly.
 * The warning is removed with the options statement
 */
selection_statement
	:	
		LITERAL_if LPAREN 
		condition RPAREN
		statement
		(options {warnWhenFollowAmbig = false;}:
		 LITERAL_else statement)?
		{#selection_statement = #(#[CSM_IF_STATEMENT, "CSM_IF_STATEMENT"], #selection_statement);}
	|	
		LITERAL_switch LPAREN  condition RPAREN statement
		{#selection_statement = #(#[CSM_SWITCH_STATEMENT, "CSM_SWITCH_STATEMENT"], #selection_statement);}
	;

iteration_statement
	:
	while_statement | do_while_statement | for_statement
	;

protected
while_statement
	:
		LITERAL_while	
		LPAREN! condition RPAREN! 
		statement  
		{#while_statement = #(#[CSM_WHILE_STATEMENT, "CSM_WHILE_STATEMENT"], #while_statement);}
	;

protected
do_while_statement
	:
		LITERAL_do 
		statement LITERAL_while
		LPAREN! expression RPAREN! 
		(EOF!|SEMICOLON) //{end_of_stmt();} 
		{#do_while_statement = #(#[CSM_DO_WHILE_STATEMENT, "CSM_DO_WHILE_STATEMENT"], #do_while_statement);}
	;

protected
for_statement
	:
		LITERAL_for LPAREN!
		for_init_statement
		(
		(condition)? (EOF!|SEMICOLON) //{end_of_stmt();}
		(expression)?
		)?
		RPAREN! statement	 
		{#for_statement = #(#[CSM_FOR_STATEMENT, "CSM_FOR_STATEMENT"], #for_statement);}
	;

protected
for_init_statement
	:
		(	(declaration)=> declaration 
		|	expression (EOF!|SEMICOLON) //{end_of_stmt();}
		|	(EOF!|SEMICOLON) //{end_of_stmt();} 
		)
		{#for_init_statement = #(#[CSM_FOR_INIT_STATEMENT, "CSM_FOR_INIT_STATEMENT"], #for_init_statement);}
	;

jump_statement
	:	
	(	LITERAL_goto ID (EOF!|SEMICOLON) {/*end_of_stmt();*/ #jump_statement = #(#[CSM_GOTO_STATEMENT, "CSM_GOTO_STATEMENT"], #jump_statement);}
	|	LITERAL_continue (EOF!|SEMICOLON) {/*end_of_stmt();*/ #jump_statement = #(#[CSM_CONTINUE_STATEMENT, "CSM_CONTINUE_STATEMENT"], #jump_statement);}
	|	LITERAL_break (EOF!|SEMICOLON) {/*end_of_stmt();*/ #jump_statement = #(#[CSM_BREAK_STATEMENT, "CSM_BREAK_STATEMENT"], #jump_statement);}
		// DW 16/05/03 May be problem here if return is followed by a cast expression 
	|	LITERAL_return {in_return = true;}
		(	
                        // VV 22/05/06: commented out alternatives, 
                        // because "return (a)==(b);" incorrectly handled
/*                        
                        options{warnWhenFollowAmbig = false;}:
			(LPAREN {(qualifiedItemIsOneOf(qiType) )}? ID RPAREN)=> 
			LPAREN ID RPAREN (expression)?
			// This is an unsatisfactory fix
			// for problem in xstring re
			// "return (allocator);"
			//  and in xlocale re 
			// "return (_E)(_Tolower((unsigned char)_C, &_Ctype));'
			//{printf("jump_statement[%d]: Return fix used\n",
			//		LT(1).getLine());}
		|	expression 
*/
                expression
		)?	(EOF!|SEMICOLON) {in_return = false; /*end_of_stmt();*/ #jump_statement = #(#[CSM_RETURN_STATEMENT, "CSM_RETURN_STATEMENT"], #jump_statement);} 
	)
	;

try_block
	:	LITERAL_try compound_statement (handler)*
	    {#try_block = #(#[CSM_TRY_STATEMENT, "CSM_TRY_STATEMENT"], #try_block);}
	;


handler
	:	LITERAL_catch
		//{exceptionBeginHandler();}
		//{declaratorParameterList(true);}
		LPAREN exception_declaration RPAREN
		//{declaratorEndParameterList(true);}
		compound_statement
		{/*exceptionEndHandler();*/{#handler = #(#[CSM_CATCH_CLAUSE, "CSM_CATCH_CLAUSE"], #handler);}}
	;

exception_declaration
	:	parameter_declaration_list
	;

/* This is an expression of type void according to the ARM, which
 * to me means "statement"; it removes some ambiguity to put it in
 * as a statement also.
 */
throw_statement
	:	LITERAL_throw (assignment_expression) ? (EOF!|SEMICOLON) //{ end_of_stmt();}
		{#throw_statement = #(#[CSM_THROW_STATEMENT, "CSM_THROW_STATEMENT"], #throw_statement);}
	;

using_declaration
	{String qid="";}
	:	u:LITERAL_using
		(LITERAL_namespace qid = qualified_id	// Using-directive
		    {#using_declaration = #[CSM_USING_DIRECTIVE, qid]; #using_declaration.addChild(#u);}
		|qid = qualified_id				// Using-declaration
		    {#using_declaration = #[CSM_USING_DECLARATION, qid]; #using_declaration.addChild(#u);}
		)
		SEMICOLON! //{end_of_stmt();}
	;

asm_block 	
	:	(
		literal_asm LCURLY (~RCURLY)* (EOF!|RCURLY) 
		|
		literal_asm (literal_volatile)? ({LA(1)==LPAREN}? balanceParens) // (gcc_asm_expr)* (EOF|RPAREN)
//		{balanceBraces(CPPTokenTypes.LPAREN, CPPTokenTypes.RPAREN);}
		)
		{#asm_block = #(#[CSM_ASM_BLOCK, "CSM_ASM_BLOCK"], #asm_block);}
	;

///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////
//////////////////////////////  EXPRESSIONS ///////////////////////////
///////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////

expression
	:	assignment_expression (COMMA assignment_expression)*
		{#expression = #(#[CSM_EXPRESSION, "CSM_EXPRESSION"], #expression);}

	;

/* right-to-left for assignment op */
assignment_expression
	:	conditional_expression
		(	(ASSIGNEQUAL|TIMESEQUAL|DIVIDEEQUAL|MINUSEQUAL|PLUSEQUAL
			|MODEQUAL
			|SHIFTLEFTEQUAL
			|SHIFTRIGHTEQUAL
			|BITWISEANDEQUAL
			|BITWISEXOREQUAL
			|BITWISEOREQUAL
			)
			remainder_expression
		)?
	;

remainder_expression
	:
/*
		(	(conditional_expression (COMMA|SEMICOLON|RPAREN)
			)=>
			{assign_stmt_RHS_found += 1;}
			assignment_expression
			{
                            if (assign_stmt_RHS_found > 0)
                                assign_stmt_RHS_found -= 1;
                            else {
                                if( reportOddWarnings ) {
                                    printf("remainder_expression[%d]: Warning Error in assign_stmt_RHS_found = %d\n", LT(1).getLine(),assign_stmt_RHS_found);
                                }
                            }
			}
		|	
*/
			assignment_expression
//		)
	;

conditional_expression
	:	
		general_logical_expression
		(QUESTIONMARK expression COLON conditional_expression)?
	;

constant_expression
	:	
		conditional_expression
		{#constant_expression = #(#[CSM_EXPRESSION, "CSM_EXPRESSION"], #constant_expression);}
	;

/* Due to problems with stack overflow on expressions like ((((....(((1+1)+1)+...)+1)
   RepositoryValidationTest started to fail, so we intentionally loose operator precedence here 
   greatly reducing peak stack size */
general_logical_expression
        :
                relational_expression ((OR | AND | BITWISEOR | BITWISEXOR | AMPERSAND | NOTEQUAL | EQUAL) relational_expression)*
        ;

/*
logical_or_expression
	:	
		logical_and_expression (OR logical_and_expression)* 
	;

logical_and_expression
	:	
		inclusive_or_expression (AND inclusive_or_expression)* 
	;

inclusive_or_expression
	:	
		exclusive_or_expression (BITWISEOR exclusive_or_expression)*
	;

exclusive_or_expression
	:	
		and_expression (BITWISEXOR and_expression)*
	;

and_expression
	:	
	equality_expression (AMPERSAND  equality_expression)*
	;

equality_expression
	:	
		relational_expression ((NOTEQUAL | EQUAL) relational_expression)*
	;
*/
relational_expression
	:	shift_expression
		(options {warnWhenFollowAmbig = false;}:
			(	LESSTHAN
			|	GREATERTHAN
			|	LESSTHANOREQUALTO
			|	GREATERTHANOREQUALTO
			)
		 shift_expression
		)*
	;

shift_expression
	:	additive_expression ((SHIFTLEFT | SHIFTRIGHT) additive_expression)*
	;

/* See comment for multiplicative_expression regarding #pragma */
additive_expression
	:	multiplicative_expression
		(options{warnWhenFollowAmbig = false;}:
			(PLUS | MINUS) multiplicative_expression
		)*
	;

/* ANTLR has trouble dealing with the analysis of the confusing unary/binary
 * operators such as STAR, AMPERSAND, PLUS, etc...
 * With the #pragma (now "(options{warnWhenFollowAmbig = false;}:" etc.)
 * we simply tell ANTLR to use the "quick-to-analyze" approximate lookahead
 * as full LL(k) lookahead will not resolve the ambiguity anyway.  Might
 * as well not bother.  This has the side-benefit that ANTLR doesn't go
 * off to lunch here (take infinite time to read grammar).
 */
multiplicative_expression
	:	pm_expression
		(options{warnWhenFollowAmbig = false;}:
			(STAR | DIVIDE | MOD) pm_expression
		)*
	;

pm_expression
	:	cast_expression ((DOTMBR | POINTERTOMBR) cast_expression)*
	;

/* The string "( ID" can be either the start of a cast or
 * the start of a unary_expression.  However, the ID must
 * be a type name for it to be a cast.  Since ANTLR can only hoist
 * semantic predicates that are visible without consuming a token,
 * the semantic predicate in rule type_name is not hoisted--hence, the
 * rule is reported to be ambiguous.  I am manually putting in the
 * correctly hoisted predicate.
 *
 * Ack! Actually "( ID" might be the start of "(T(expr))" which makes
 * the first parens just an ordinary expression grouping.  The solution
 * is to look at what follows the type, T.  Note, this could be a
 * qualified type.  Yucko.  I believe that "(T(" can only imply
 * function-style type cast in an expression (...) grouping.
 *
 * We DO NOT handle the following situation correctly at the moment:
 * Suppose you have
 *    struct rusage rusage;
 *    return (rusage.fp);
 *    return (rusage*)p;
 * Now essentially there is an ambiguity here. If rusage is followed by any
 * postix operators then it is an identifier else it is a type name. This
 * problem does not occur in C because, unless the tag struct is attached,
 * rusage is not a type name. However in C++ that restriction is removed.
 * No *real* programmer would do this, but it's in the C++ standard just for
 * fun..
 *
 * Another fun one (from an LL standpoint):
 *
 *   (A::B::T *)v;      // that's a cast of v to type A::B::T
 *   (A::B::foo);    // that's a simple member access
 *
 * The qualifiedItemIs(1) function scans ahead to what follows the
 * final "::" and returns qiType if the item is a type.  The offset of
 * '1' makes it ignore the initial LPAREN; normally, the offset is 0.
 */

cast_expression 
	:
/*
                // VV: fast predict of situations like
                // (Type)*ID
		(cast_expression_type_specifier is_unary_as_post_cast_expression)=>
		{if (statementTrace>=1) 
			printf("cast_expression_1[%d]: Cast expression, then identifier\n", LT(1).getLine());
		}
		 cast_expression_type_specifier unary_expression
                 {#cast_expression = #(#[CSM_CAST_EXPRESSION, "CSM_CAST_EXPRESSION"], #cast_expression);}
         |
                // VV: fast predict of situations like
                // (Type)(expression)
		(cast_expression_type_specifier balanceParens)=>
		{if (statementTrace>=1) 
			printf("cast_expression_1[%d]: Cast expression\n", LT(1).getLine());
		}
		 cast_expression_type_specifier cast_expression
                 {#cast_expression = #(#[CSM_CAST_EXPRESSION, "CSM_CAST_EXPRESSION"], #cast_expression);}
         |
               // VV: fast predict of unary expressions like
                // (id)%5 or (A::B::foo);
		(cast_expression_type_specifier is_end_of_expression)=>
		{if (statementTrace>=1) 
			printf("cast_expression_2[%d]: Parened unary\n", LT(1).getLine());
		}
		unary_expression
         |
*/
                // VV IZ#115549
                // fast predict of outer ( ... )
                // ((((( 1 + ...
                ((LPAREN)+ constant) => LPAREN expression RPAREN
         |
		// DW 23/06/03
                // VK Feb 13 '06    added trailing cast_expression to predicate -
                // otherwise parenthesized names were supposed to be casts
                // TODO: remove long time prediction
		(cast_expression_type_specifier cast_expression)=>
		{if (statementTrace>=1) 
			printf("cast_expression_1[%d]: Cast expression\n", LT(1).getLine());
		}
		 cast_expression_type_specifier cast_expression
                 {#cast_expression = #(#[CSM_CAST_EXPRESSION, "CSM_CAST_EXPRESSION"], #cast_expression);}
	|
                (cast_fun_type_specifier) => 
		{if (statementTrace>=1) 
			printf("cast_expression_2[%d]: Cast to function type expression\n", LT(1).getLine());
		}
		 cast_fun_type_specifier cast_expression
                 {#cast_expression = #(#[CSM_FUN_TYPE_CAST_EXPRESSION, "CSM_FUN_TYPE_CAST_EXPRESSION"], #cast_expression);}
        |
		unary_expression	// handles outer (...) of "(T(expr))"
	;

protected 
non_cast_prefix: // used only in predicates
    (LPAREN)+ constant
    ;

protected
cast_expression_type_specifier
	{TypeQualifier tq;
	 /*TypeSpecifier*/int ts;}
        :
            // usual cast in single parens like "(const char*)"            
            LPAREN 
                (tq = cv_qualifier)? 
                (LITERAL_struct|LITERAL_union|LITERAL_class|LITERAL_enum)? 
                ts = simple_type_specifier 
                (ptr_operator)*
            RPAREN
        ;

protected
cast_fun_type_specifier
        :
            // cast like (double (*)(UDF_INIT *, UDF_ARGS *, uchar *, uchar *)) 
            LPAREN
                declaration_specifiers
                LPAREN
                ptr_operator
                RPAREN
                function_params
            RPAREN
        ;

protected
postfix_cv_qualifier
        :
            ((literal_volatile|literal_const) 
                (options {warnWhenFollowAmbig = false;}:ptr:unnamed_ptr_operator
                 { #postfix_cv_qualifier=#(#[CSM_PTR_OPERATOR,"CSM_PTR_OPERATOR"], #postfix_cv_qualifier);}
                )*
            )+
        ;

protected
unnamed_ptr_operator
	:	(	AMPERSAND 	{is_address = true;}
		|	literal_cdecl 
		|	literal_near
		|	literal_far 
		|	LITERAL___interrupt 
		|	literal_pascal 
		|	literal_stdcall 
		|	STAR 
		)	
   ;

/*
protected
is_unary_as_post_cast_expression // used only in predicates
        :
            ID
            |constant
            |LITERAL_sizeof
            |LITERAL_this
            |LITERAL_new
        ;

protected
is_end_of_expression // used only in predicates
        :
            optor_simple_tokclass | SEMICOLON | COLON | EOF 
        ;
*/

unary_expression
	:
		(
                        {
                            (LA(1)==LITERAL_new) || 
                            ((LA(1)==SCOPE) && (LA(2)==LITERAL_new))
                        }?
			(SCOPE)? new_expression
		|
                        {
                            (LA(1)==LITERAL_delete) || 
                            ((LA(1)==SCOPE) && (LA(2)==LITERAL_delete))
                        }?  
			(SCOPE)? delete_expression
		|	PLUSPLUS unary_expression
		|	MINUSMINUS unary_expression
		|	LITERAL_sizeof
			(// see comment for rule cast_expression for info on predicate
			 // JEL NOTE 3/31/96 -- This won't work -- you really need to
			 // call qualifiedItemIsOneOf(qiType|qiCtor,1)
			 // The context should also be ( LPAREN (SCOPE|ID) )
			 // { LPAREN ID ) => {isTypeName((LT(2).getText()))}?
 			 //{!(((LA(1) == LPAREN&&(LA(2) == ID))))}?
                          (LPAREN type_name RPAREN)=>            
                              LPAREN type_name RPAREN
                         |        
		              unary_expression                        
			 )                        
		|	
                        // separate case, because of nondeterminism
                        // with postfix_expression
                        (TILDE cast_expression) =>
                        unary_operator cast_expression
		|
                        // TILDE was handled above
                        {LA(1)!=TILDE}? unary_operator cast_expression
                |
                        //{!(LA(1)==TILDE && LA(2)==ID) || 
			//	    qualifiedItemIsOneOf(qiVar | qiFun | qiDtor | qiCtor)}?
                        postfix_expression
		)
	;

postfix_expression
	{/*TypeSpecifier*/int ts;
	 DeclSpecifier ds = dsInvalid;	// Purpose ?
	}
	:
	(	
		options {warnWhenFollowAmbig = false;}:
		// Function-style cast must have a leading type
		{!(LA(1)==LPAREN)}?
		(ts = simple_type_specifier LPAREN RPAREN LPAREN)=>
                {if (statementTrace>=1) 
                        printf("postfix_expression_1[%d]: Function cast expression\n", LT(1).getLine());
                }
		    // DW 01/08/03 To cope with problem in xtree (see test10.i)
		ts = simple_type_specifier LPAREN RPAREN LPAREN (expression_list)? RPAREN
	|
		{!(LA(1)==LPAREN)}?
		((LITERAL_typename)? ts = simple_type_specifier LPAREN)=>
                {if (statementTrace>=1) 
                        printf("postfix_expression_2[%d]: Function call\n", LT(1).getLine());
                }
		(LITERAL_typename)? ts = simple_type_specifier
                LPAREN 
                        (
                            {if (statementTrace>=1)
                                    printf("postfix_expression_2[%d]: Function call parameters\n", LT(1).getLine());
                            }
                            fun_call_param_list
                            {if (statementTrace>=1) 
                                    printf("postfix_expression_2[%d]: End of function parameters\n", LT(1).getLine());
                            }
                        )? 
                RPAREN
//                {#postfix_expression = #(#[CSM_FUNCALL_EXPRESSION, "CSM_FUNCALL_EXPRESSION"], #postfix_expression);}
	|  
		primary_expression
	|
		(LITERAL_dynamic_cast|LITERAL_static_cast|LITERAL_reinterpret_cast|LITERAL_const_cast)
		    // Note const_cast in elsewhere
		LESSTHAN declaration_specifiers (ptr_operator)* GREATERTHAN
		LPAREN expression RPAREN
	) 
        // add possibility to have a().b().c()->d() etc.
        // but may be this rule should be in 2nd and 3rd alternatives only, 
        // not at the end of postfix_expression
        (post_postfix_expression)*
	;

protected
fun_call_param_list : fun_call_param (COMMA fun_call_param)*;

protected
fun_call_param
        :
                    // handle gcc's va_arg:
                    // #define va_end(v)	__builtin_va_end(v)
                    // 
                    // void foo(...) { 
                    //  ...
                    //  int fieldlen = va_arg(ap, int);
                    //  const wchar_t *wstr = va_arg(ap,const wchar_t *);
                    //  A* a = va_arg(ap, A*);
                    //  const B::C* b = va_arg(ap, const B::C*);
                    // }                       
                    (cv_qualifier_seq (built_in_type)+ (ptr_operator)* (COMMA|RPAREN)) =>
                    {if (statementTrace>=1) 
                            printf("fun_call_param1[%d]: alone built_in_type as function's parameter\n", LT(1).getLine());
                    }  
                    type_name
                |
                    (type_name {LA(0)==STAR||LA(0)==AMPERSAND/*||(LA(0)==RSQUARE&&LA(-1)==LSQUARE)*/}? (COMMA|RPAREN)) =>
                    {if (statementTrace>=1) 
                            printf("fun_call_param2[%d]: alone ptr type as function's parameter\n", LT(1).getLine());
                    }  
                    type_name
                |
                    (cv_qualifier type_name (COMMA|RPAREN)) =>
                    {if (statementTrace>=1) 
                            printf("fun_call_param3[%d]: alone cv_qualified type name as function's parameter\n", LT(1).getLine());
                    }  
                    type_name
            |
                assignment_expression
;

protected
built_in_type
    { /*TypeSpecifier*/int ts = tsInvalid;}
        :
                        LITERAL_char	{ts |= tsCHAR;}
                |	LITERAL_wchar_t	{ts |= tsWCHAR_T;}  
                |	LITERAL_bool	{ts |= tsBOOL;}
                |	LITERAL_short	{ts |= tsSHORT;}
                |	LITERAL_int	{ts |= tsINT;}
                |	literal_int64	{ts |= tsLONG;}
                |	LITERAL___w64	{ts |= tsLONG;}
                |	LITERAL_long	{ts |= tsLONG;}
                |	literal_signed	{ts |= tsSIGNED;}
                |	literal_unsigned{ts |= tsUNSIGNED;}
                |	LITERAL_float	{ts |= tsFLOAT;}
                |	LITERAL_double	{ts |= tsDOUBLE;}
                |	LITERAL_void	{ts |= tsVOID;}
        ;

post_postfix_expression
		:
                (options {warnWhenFollowAmbig = false;}:
                    LSQUARE expression RSQUARE
                    |	LPAREN (expression_list)? RPAREN 
                    |	DOT id_expression
                    |	POINTERTO id_expression
                    |	PLUSPLUS 
                    |	MINUSMINUS
		)
;

primary_expression
	:	id_expression
	|	constant
	|	LITERAL_this
	|	LPAREN expression RPAREN
	;

id_expression 
	{String s;}
	:
		s = scope_override
		(	ID 
		|	LITERAL_OPERATOR optor
		|	TILDE (STAR)? ID	// DW 29/07/03 STAR included to allow 
						// for *_S = ~*_S; seen in vector
		)
	;

unary_operator
	:	AMPERSAND
	|	STAR
	|	PLUS
	|	MINUS
	|	TILDE
	|	NOT
	;

/* JEL The first ()? is used to resolve "new (expr) (type)" because both
 * (expr) and (type) look identical until you've seen the whole thing.
 *
 * new_initializer appears to be conflicting with function arguments as
 * function arguments can follow a primary_expression.  [This is a full
 * LL(k) versus LALL(k) problem.  Enhancing context by duplication of
 * some rules might handle this.]
 */
new_expression
	:
	(  
		LITERAL_new
                // TODO: remove long-time prediction
		((LPAREN expression_list RPAREN)=> 
			LPAREN expression_list RPAREN)?
		(new_type_id | LPAREN type_name RPAREN)
		(options{warnWhenFollowAmbig = false;}:	
		(new_initializer)=> new_initializer)?
	)
	;

new_initializer
	:	LPAREN (expression_list)? RPAREN
	;

new_type_id
	:	declaration_specifiers 
		(options {warnWhenFollowAmbig = false;}:
		 //{( !(LA(1)==SCOPE||LA(1)==ID) || qualifiedItemIsOneOf(qiPtrMember) )}?
			new_declarator 
		)?
	;

new_declarator
	:	//{( !(LA(1)==SCOPE||LA(1)==ID) || qualifiedItemIsOneOf(qiPtrMember) )}?  
		//ptr_to_member cv_qualifier_seq 
		ptr_operator
		(options {warnWhenFollowAmbig = false;}:
		new_declarator ) ?
	|	direct_new_declarator
	;

ptr_operator
	:	(	AMPERSAND 	{is_address = true;}
		|	literal_cdecl 
		|	literal_near
		|	literal_far 
		|	LITERAL___interrupt 
		|	literal_pascal 
		|	literal_stdcall 
		|	ptr_to_member	// e.g. STAR 
		)	
		{#ptr_operator=#(#[CSM_PTR_OPERATOR,"CSM_PTR_OPERATOR"], #ptr_operator);}
   ;

// Match A::B::*
ptr_to_member
	{String s;}
	:
		s = scope_override STAR  {is_pointer = true;} cv_qualifier_seq
	;

// Match the A::B::C:: or nothing
scope_override returns [String s = ""]
	{
	    StringBuilder sitem = new StringBuilder();
	}
	:
		//{!(qualifiedItemIsOneOf(qiType))}?
		(
                    SCOPE { sitem.append("::");} 
                    (LITERAL_template)? // to support "_Alloc::template rebind<char>::other"
                )?
		(	options {warnWhenFollowAmbig = false;}:
			{scopedItem()}?                        
			id:ID (LESSTHAN template_argument_list GREATERTHAN)? 
                        SCOPE
                        (LITERAL_template)? // to support "_Alloc::template rebind<char>::other"
			{
			    //printf("scope_override entered\n");
			    sitem.append(id.getText());
			    sitem.append("::");
			}
		)* {s = sitem.toString();}
	;

/* The "[expression]" construct conflicts with the "new []" construct
 * (and possibly others).  We used approximate lookahead for the "new []"
 * construct so that it would not try to compute full LL(2) lookahead.
 * Here, we use #pragma approx again because anytime we see a [ followed
 * by token that can begin an expression, we always want to loop.
 * Approximate lookahead handles this correctly.  In fact, approximate
 * lookahead is the same as full lookahead when all but the last lookahead
 * depth are singleton sets; e.g., {"["} followed by FIRST(expression).
 */
direct_new_declarator
	:
		(options {warnWhenFollowAmbig = false;}:
			LSQUARE expression RSQUARE
		)+
	;

delete_expression
	:	LITERAL_delete (LSQUARE RSQUARE)? cast_expression
	;

expression_list
	:	assignment_expression (COMMA assignment_expression)*
	;

constant
	:	OCTALINT
	|	DECIMALINT
	|	HEXADECIMALINT
	|	CHAR_LITERAL
	|	(STRING_LITERAL)+
	|	FLOATONE
	|	FLOATTWO
	|	LITERAL_true
	|	LITERAL_false
	;

optor 
	:
		LITERAL_new
		(options {warnWhenFollowAmbig = false;}:
			LSQUARE RSQUARE | )		// check syntax
	|   
		LITERAL_delete
		(options {warnWhenFollowAmbig = false;}:
			LSQUARE RSQUARE | )		// check syntax
	|	LPAREN RPAREN
	|	LSQUARE RSQUARE
	|	optor_simple_tokclass	//OPTOR_SIMPLE_TOKCLASS
	;

//Zuo 5/11/2001
// This is the equivalent to "#tokclass OPTOR_SIMPLE_TOKCLASS" in cplusplus.g

optor_simple_tokclass
	:
    (PLUS|MINUS|STAR|DIVIDE|MOD|BITWISEXOR|AMPERSAND|BITWISEOR|TILDE|NOT|
	 SHIFTLEFT|SHIFTRIGHT|
	 ASSIGNEQUAL|TIMESEQUAL|DIVIDEEQUAL|MODEQUAL|PLUSEQUAL|MINUSEQUAL|
	 SHIFTLEFTEQUAL|SHIFTRIGHTEQUAL|BITWISEANDEQUAL|BITWISEXOREQUAL|BITWISEOREQUAL|
	 EQUAL|NOTEQUAL|LESSTHAN|GREATERTHAN|LESSTHANOREQUALTO|GREATERTHANOREQUALTO|OR|AND|
	 PLUSPLUS|MINUSMINUS|COMMA|POINTERTO|POINTERTOMBR
	)
	;

/*
// VV: some rules extracted from prev. optor_simple_tokclass, 
// by excluding tokens with several meaning, end grouping other with the same behavior
// i.e STAR could be multiply in expression, but could be dereference pointer,

//Zuo 5/11/2001
// This is the equivalent to "#tokclass OPTOR_SIMPLE_TOKCLASS" in cplusplus.g

optor_simple_tokclass
	:
            expression_unambig_optor
        |
            assign_unambig_optor
        |
            post_cast_unambig_unary_optor
        |
            // ambiguous operators
            (AMPERSAND | STAR | PLUS | MINUS | PLUSPLUS | MINUSMINUS)
	;

// this rule garantees, that on left is not casting for expressions like "(A) optor expr"
protected
expression_unambig_optor
	:
        (DIVIDE|MOD|BITWISEXOR|BITWISEOR|
	 SHIFTLEFT|SHIFTRIGHT|
	 EQUAL|NOTEQUAL|LESSTHAN|GREATERTHAN|LESSTHANOREQUALTO|GREATERTHANOREQUALTO|OR|AND|
	 COMMA|POINTERTO|POINTERTOMBR
	)
	;

// this rule garantees, that on left is not casting for expressions like "(A) optor expr" 
protected
assign_unambig_optor
	:
        (
	 ASSIGNEQUAL|TIMESEQUAL|DIVIDEEQUAL|MODEQUAL|PLUSEQUAL|MINUSEQUAL|
	 SHIFTLEFTEQUAL|SHIFTRIGHTEQUAL|BITWISEANDEQUAL|BITWISEXOREQUAL|BITWISEOREQUAL 
	)
	;

// this rule garantees, that on left is casting for expressions like "(A) optor expr"
protected
post_cast_unambig_unary_optor : (TILDE | NOT);
*/


// it's better to have them alphabetically ordered...

protected
literal_asm : LITERAL_asm|LITERAL__asm|LITERAL___asm|LITERAL___asm__;

protected
literal_cdecl : LITERAL__cdecl|LITERAL___cdecl;

protected
literal_const : LITERAL_const|LITERAL___const|LITERAL___const__;

protected
literal_declspec : LITERAL__declspec|LITERAL___declspec;

protected
literal_far : LITERAL__far|LITERAL___far;

protected
literal_inline : LITERAL_inline|LITERAL__inline|LITERAL___inline|LITERAL___inline__;

protected
literal_int64 : LITERAL__int64|LITERAL___int64;

protected
literal_signed: LITERAL_signed|LITERAL___signed|LITERAL___signed__;

protected
literal_unsigned: LITERAL_unsigned|LITERAL___unsigned__;

protected
literal_near : LITERAL__near|LITERAL___near;

protected
literal_pascal : LITERAL_pascal|LITERAL__pascal|LITERAL___pascal;

protected
literal_stdcall : LITERAL__stdcall|LITERAL___stdcall;

protected
literal_volatile : LITERAL_volatile|LITERAL___volatile|LITERAL___volatile__;

protected
literal_typeof : LITERAL_typeof | LITERAL___typeof | LITERAL___typeof__ ;

protected
literal_restrict : LITERAL_restrict | LITERAL___restrict;
