/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.spi.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.modules.profiler.selector.spi.nodes.ClassNode;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.IconResource;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageNode
extends ContainerNode {
    public static final String DEFAULT_NAME = "<default>";
    static final Comparator COMPARATOR = new Comparator<PackageNode>(){

        @Override
        public int compare(PackageNode packageNode, PackageNode packageNode2) {
            if (packageNode.getNodeName().equals(PackageNode.DEFAULT_NAME)) {
                return -1;
            }
            return packageNode.toString().compareTo(packageNode2.toString());
        }
    };
    private static final Logger LOGGER = Logger.getLogger(PackageNode.class.getName());
    private final ClientUtils.SourceCodeSelection signature;
    private final ClasspathInfo cpInfo;
    private final Set<ClassIndex.SearchScope> scope;
    private final String name;

    public PackageNode(ClasspathInfo classpathInfo, String string, ContainerNode containerNode, Set<ClassIndex.SearchScope> set) {
        super(PackageNode.stripName(PackageNode.defaultizeName(string)), IconResource.PACKAGE_ICON, containerNode);
        this.name = string;
        this.cpInfo = classpathInfo;
        this.signature = new ClientUtils.SourceCodeSelection(string + ".*", null, null);
        this.scope = set;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ClientUtils.SourceCodeSelection getSignature() {
        return this.signature;
    }

    @Override
    protected SelectorChildren getChildren() {
        return new PackageChildren();
    }

    ClasspathInfo getCpInfo() {
        return this.cpInfo;
    }

    private static String defaultizeName(String string) {
        return string == null || string.length() == 0 ? DEFAULT_NAME : string;
    }

    private static String stripName(String string) {
        int n = string.lastIndexOf(46);
        if (n > -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackageChildren
    extends SelectorChildren<PackageNode> {
        private PackageChildren() {
        }

        @Override
        protected List<SelectorNode> prepareChildren(PackageNode packageNode) {
            ArrayList<SelectorNode> arrayList = new ArrayList<SelectorNode>();
            List<PackageNode> list = this.getSubpackages(packageNode);
            List<ClassNode> list2 = this.getClasses(packageNode);
            arrayList.addAll(list);
            arrayList.addAll(list2);
            return arrayList;
        }

        private List<ClassNode> getClasses(final PackageNode packageNode) {
            final ArrayList<ClassNode> arrayList = new ArrayList<ClassNode>();
            JavaSource javaSource = JavaSource.create((ClasspathInfo)packageNode.cpInfo, (FileObject[])new FileObject[0]);
            try {
                javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.PARSED);
                        PackageElement packageElement = compilationController.getElements().getPackageElement(packageNode.getName());
                        if (packageElement != null) {
                            for (TypeElement typeElement : ElementFilter.typesIn(packageElement.getEnclosedElements())) {
                                if (typeElement.getKind() != ElementKind.CLASS && typeElement.getKind() != ElementKind.ENUM) continue;
                                arrayList.add(new ClassNode(packageNode.cpInfo, IconResource.CLASS_ICON, typeElement, (ContainerNode)packageNode));
                            }
                        } else {
                            LOGGER.log(Level.FINEST, "Package name {0} resulted into a NULL element", packageNode.getName());
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                LOGGER.severe(iOException.getLocalizedMessage());
            }
            Collections.sort(arrayList, ClassNode.COMPARATOR);
            return arrayList;
        }

        private List<PackageNode> getSubpackages(PackageNode packageNode) {
            ClassIndex classIndex = packageNode.cpInfo.getClassIndex();
            ArrayList<PackageNode> arrayList = new ArrayList<PackageNode>();
            for (String string : classIndex.getPackageNames(packageNode.getName() + ".", true, packageNode.scope)) {
                arrayList.add(new PackageNode(packageNode.cpInfo, string, packageNode, packageNode.scope));
            }
            Collections.sort(arrayList, COMPARATOR);
            return arrayList;
        }
    }
}

