/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyEditor;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.netbeans.modules.vmd.midp.screen.display.DisplayableDisplayPanel;
import org.netbeans.modules.vmd.midp.screen.display.property.ResourcePropertyEditor;
import org.netbeans.modules.vmd.midp.screen.display.property.ScreenStringPropertyEditor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayableDisplayPresenter
extends ScreenDisplayPresenter {
    private static final Image BATTERY = Utilities.loadImage((String)"org/netbeans/modules/vmd/midp/screen/display/resources/battery.png");
    private static final Image SIGNAL = Utilities.loadImage((String)"org/netbeans/modules/vmd/midp/screen/display/resources/signal.png");
    private DisplayableDisplayPanel panel = new DisplayableDisplayPanel(this);

    public DisplayableDisplayPresenter() {
        this.panel.getBattery().setIcon(new ImageIcon(BATTERY));
        this.panel.getSignal().setIcon(new ImageIcon(SIGNAL));
    }

    public DisplayableDisplayPresenter(Image image) {
        this();
        this.panel.add(new JLabel(new ImageIcon(image)));
    }

    public boolean isTopLevelDisplay() {
        return true;
    }

    public Collection<DesignComponent> getChildren() {
        return Collections.emptyList();
    }

    public JComponent getView() {
        return this.panel;
    }

    protected DisplayableDisplayPanel getPanel() {
        return this.panel;
    }

    public Shape getSelectionShape() {
        return new Rectangle(this.panel.getSize());
    }

    public void reload(ScreenDeviceInfo screenDeviceInfo) {
        String string = null;
        if (this.getComponent().readProperty("ticker").getKind() == PropertyValue.Kind.USERCODE) {
            string = NbBundle.getMessage(DisplayableDisplayPresenter.class, (String)"DISP_user_code");
        } else {
            DesignComponent designComponent = this.getComponent().readProperty("ticker").getComponent();
            if (designComponent != null) {
                PropertyValue propertyValue = designComponent.readProperty("string");
                if (propertyValue.getKind() == PropertyValue.Kind.USERCODE) {
                    string = NbBundle.getMessage(DisplayableDisplayPresenter.class, (String)"DISP_ticker_string_user_code");
                } else {
                    string = MidpValueSupport.getHumanReadableString(propertyValue);
                    if (string == null || string.length() == 0) {
                        string = NbBundle.getMessage(DisplayableDisplayPresenter.class, (String)"DISP_empty_ticker_string");
                    }
                }
            }
        }
        this.panel.getTicker().setText(string);
        this.panel.getTitle().setText(MidpValueSupport.getHumanReadableString(this.getComponent().readProperty("title")));
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        DesignComponent designComponent = this.getComponent().readProperty("ticker").getComponent();
        Object object = designComponent == null ? new ResourcePropertyEditor("ticker", this.getComponent()) : new ScreenStringPropertyEditor("string", "ticker", 0);
        return Arrays.asList(new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.panel.getTitle(), (ScreenPropertyEditor)new ScreenStringPropertyEditor("title", 0)), new ScreenPropertyDescriptor(this.getComponent(), (JComponent)this.panel.getTicker(), (ScreenPropertyEditor)object));
    }
}

