/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorString
extends PropertyEditorUserCode
implements PropertyEditorElement {
    public static final int DEPENDENCE_NONE = 0;
    public static final int DEPENDENCE_TEXT_BOX = 1;
    public static final int DEPENDENCE_TEXT_FIELD = 2;
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private int dependence;
    private String comment;
    private String defaultValue;
    private boolean useTextArea;
    private TypeID parentTypeID;
    private String label;

    private PropertyEditorString(String string, int n, boolean bl, String string2, TypeID typeID) {
        super(NbBundle.getMessage(PropertyEditorString.class, (String)"LBL_STRING_STR"));
        this.comment = string;
        this.dependence = n;
        this.useTextArea = bl;
        this.label = string2;
        this.parentTypeID = typeID;
        this.initComponents();
        this.initElements(Collections.singleton(this));
    }

    private PropertyEditorString(String string, int n, String string2, String string3) {
        this(string, n, true, string3, null);
        this.defaultValue = string2;
    }

    public static final PropertyEditorString createInstance(String string) {
        return new PropertyEditorString(null, 0, true, string, null);
    }

    public static final PropertyEditorString createInstance(int n, String string) {
        return new PropertyEditorString(null, n, true, string, null);
    }

    public static final PropertyEditorString createInstance(String string, TypeID typeID) {
        return new PropertyEditorString(null, 0, true, string, typeID);
    }

    public static final PropertyEditorString createTextFieldInstance(String string) {
        return new PropertyEditorString(null, 0, false, string, null);
    }

    public static final PropertyEditorString createInstanceWithDefaultValue(String string, String string2) {
        return new PropertyEditorString(null, 0, string, string2);
    }

    public static final PropertyEditorString createInstanceWithComment(String string, String string2) {
        return new PropertyEditorString(string, 0, null, string2);
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)this.label);
        this.customEditor = new CustomEditor(this.comment);
    }

    public Object getDefaultValue() {
        if (this.defaultValue == null) {
            return super.getDefaultValue();
        }
        return MidpTypes.createStringValue(this.defaultValue);
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor.getComponent();
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return this.useTextArea;
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        PropertyValue propertyValue = (PropertyValue)super.getValue();
        return (String)propertyValue.getPrimitiveValue();
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public boolean canWrite() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.canWrite();
    }

    public boolean supportsCustomEditor() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.supportsCustomEditor();
    }

    public void updateState(PropertyValue propertyValue) {
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.setText(null);
        } else {
            this.customEditor.setText((String)propertyValue.getPrimitiveValue());
        }
        if (!this.isCurrentValueAUserCodeType()) {
            this.radioButton.setSelected(true);
            this.radioButton.requestFocus();
        }
    }

    private void saveValue(String string) {
        super.setValue((Object)MidpTypes.createStringValue(string));
        if (this.component == null || this.component.get() == null) {
            return;
        }
        final DesignComponent designComponent = (DesignComponent)this.component.get();
        final int n = string.length();
        switch (this.dependence) {
            case 1: {
                designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                    public void run() {
                        PropertyValue propertyValue = designComponent.readProperty("maxSize");
                        if (MidpTypes.getInteger(propertyValue) < n) {
                            designComponent.writeProperty("maxSize", MidpTypes.createIntegerValue(n));
                        }
                    }
                });
                break;
            }
            case 2: {
                designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                    public void run() {
                        PropertyValue propertyValue = designComponent.readProperty("maxSize");
                        if (MidpTypes.getInteger(propertyValue) < n) {
                            designComponent.writeProperty("maxSize", MidpTypes.createIntegerValue(n));
                        }
                    }
                });
            }
        }
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    private boolean isWriteableByParentType() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        if (this.parentTypeID != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            final DesignComponent[] designComponentArray = new DesignComponent[1];
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    designComponentArray[0] = designComponent.getParentComponent();
                }
            });
            if (designComponentArray[0] != null && this.parentTypeID.equals((Object)designComponentArray[0].getType())) {
                return false;
            }
        }
        return true;
    }

    private class CustomEditor
    implements DocumentListener {
        private JPanel panel;
        private JTextComponent editorPane;
        private String comment;

        public CustomEditor(String string) {
            this.comment = string;
            this.initComponents();
        }

        private void initComponents() {
            JComponent jComponent;
            this.panel = new JPanel(new GridBagLayout());
            if (PropertyEditorString.this.useTextArea) {
                this.editorPane = new JTextArea();
                jComponent = new JScrollPane();
                ((JScrollPane)jComponent).setViewportView(this.editorPane);
                ((JScrollPane)jComponent).setPreferredSize(new Dimension(400, 100));
            } else {
                this.editorPane = new JTextField();
                jComponent = this.editorPane;
            }
            this.editorPane.getDocument().addDocumentListener(this);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.panel.add((Component)jComponent, gridBagConstraints);
            if (this.comment != null) {
                JLabel jLabel = new JLabel(this.comment);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.ipadx = 1;
                gridBagConstraints.ipady = 10;
                gridBagConstraints.anchor = 17;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                this.panel.add((Component)jLabel, gridBagConstraints);
            }
        }

        public JComponent getComponent() {
            return this.panel;
        }

        public void setText(String string) {
            this.editorPane.setText(string);
        }

        public String getText() {
            return this.editorPane.getText();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.editorPane.hasFocus()) {
                PropertyEditorString.this.radioButton.setSelected(true);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.editorPane.hasFocus()) {
                PropertyEditorString.this.radioButton.setSelected(true);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

