/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.debug;

import java.util.LinkedList;
import java.util.List;
import org.jruby.RubyThread;
import org.jruby.debug.DebugFrame;
import org.jruby.runtime.builtin.IRubyObject;

final class DebugContext {
    static final String AT_BREAKPOINT = "at_breakpoint";
    static final String AT_CATCHPOINT = "at_catchpoint";
    static final String AT_LINE = "at_line";
    static final String AT_TRACING = "at_tracing";
    static final String LIST = "list";
    private static int thnumMax = 0;
    private final RubyThread thread;
    private IRubyObject breakpoint;
    private final List<DebugFrame> frames;
    private int lastLine = 0;
    private String lastFile = null;
    private int destFrame = -1;
    private int stopFrame = -1;
    private int stopNext = -1;
    private int stopLine = -1;
    private int stackLen;
    private StopReason stopReason;
    private int thnum = ++thnumMax;
    private boolean dead;
    private boolean suspended;
    private boolean wasRunning;
    private boolean ignored;
    private boolean skipped;
    private boolean enableBreakpoint;
    private boolean stepped;
    private boolean tracing;
    private boolean forceMove;

    DebugContext(RubyThread thread) {
        this.stopReason = StopReason.NONE;
        this.frames = new LinkedList<DebugFrame>();
        this.breakpoint = thread.getRuntime().getNil();
        this.thread = thread;
    }

    void addFrame(DebugFrame debugFrame) {
        this.frames.add(debugFrame);
    }

    RubyThread getThread() {
        return this.thread;
    }

    DebugFrame getTopFrame() {
        return this.frames.get(this.getStackSize() - 1);
    }

    DebugFrame getFrame(int index) {
        return this.frames.get(this.getStackSize() - index - 1);
    }

    DebugFrame popFrame() {
        return this.frames.remove(this.getStackSize() - 1);
    }

    IRubyObject getBreakpoint() {
        return this.breakpoint;
    }

    void setBreakpoint(IRubyObject breakpoint) {
        this.breakpoint = breakpoint;
    }

    int getDestFrame() {
        return this.destFrame;
    }

    void setDestFrame(int destFrame) {
        this.destFrame = destFrame;
    }

    boolean isEnableBreakpoint() {
        return this.enableBreakpoint;
    }

    void setEnableBreakpoint(boolean enableBreakpoint) {
        this.enableBreakpoint = enableBreakpoint;
    }

    boolean isForceMove() {
        return this.forceMove;
    }

    void setForceMove(boolean forceMove) {
        this.forceMove = forceMove;
    }

    boolean isIgnored() {
        return this.ignored;
    }

    void setIgnored(boolean ignored) {
        this.ignored = ignored;
    }

    String getLastFile() {
        return this.lastFile;
    }

    void setLastFile(String lastFile) {
        this.lastFile = lastFile;
    }

    int getLastLine() {
        return this.lastLine;
    }

    void setLastLine(int lastLine) {
        this.lastLine = lastLine;
    }

    boolean isSkipped() {
        return this.skipped;
    }

    void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }

    int getStackLen() {
        return this.stackLen;
    }

    void setStackLen(int stackLen) {
        this.stackLen = stackLen;
    }

    int getStackSize() {
        return this.frames.size();
    }

    boolean isStepped() {
        return this.stepped;
    }

    void setStepped(boolean stepped) {
        this.stepped = stepped;
    }

    int getStopFrame() {
        return this.stopFrame;
    }

    void setStopFrame(int stopFrame) {
        this.stopFrame = stopFrame;
    }

    int getStopLine() {
        return this.stopLine;
    }

    void setStopLine(int stopLine) {
        this.stopLine = stopLine;
    }

    int getStopNext() {
        return this.stopNext;
    }

    void setStopNext(int stopNext) {
        this.stopNext = stopNext;
    }

    StopReason getStopReason() {
        return this.stopReason;
    }

    void setStopReason(StopReason stopReason) {
        this.stopReason = stopReason;
    }

    boolean isSuspended() {
        return this.suspended;
    }

    void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    int getThnum() {
        return this.thnum;
    }

    void setThnum(int thnum) {
        this.thnum = thnum;
    }

    boolean isTracing() {
        return this.tracing;
    }

    void setTracing(boolean tracing) {
        this.tracing = tracing;
    }

    boolean isWasRunning() {
        return this.wasRunning;
    }

    void setWasRunning(boolean wasRunning) {
        this.wasRunning = wasRunning;
    }

    boolean isDead() {
        return this.dead;
    }

    void setDead(boolean dead) {
        this.dead = dead;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum StopReason {
        NONE,
        STEP,
        BREAKPOINT,
        CATCHPOINT;

    }
}

