/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.awt.Dialog;
import java.awt.event.ActionListener;
import java.util.concurrent.Future;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.beans.PatternAnalyser;
import org.netbeans.modules.beans.beaninfo.BiAnalyser;
import org.netbeans.modules.beans.beaninfo.BiNode;
import org.netbeans.modules.beans.beaninfo.BiPanel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;

public final class GenerateBeanInfoAction
extends NodeAction
implements ActionListener {
    private Dialog biDialog;
    static final long serialVersionUID = -4937492476805017833L;

    public String getName() {
        return GenerateBeanInfoAction.getString("CTL_GENBI_MenuItem");
    }

    protected String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length != 1) {
            return false;
        }
        FileObject fileObject = GenerateBeanInfoAction.findFileObject(nodeArray[0]);
        return fileObject != null && JavaSource.forFileObject((FileObject)fileObject) != null && !fileObject.getName().endsWith("BeanInfo");
    }

    public void performAction(Node[] nodeArray) {
        if (nodeArray.length != 1) {
            return;
        }
        BiPanel biPanel = new BiPanel();
        FileObject fileObject = GenerateBeanInfoAction.findFileObject(nodeArray[0]);
        BeanInfoWorker beanInfoWorker = new BeanInfoWorker(fileObject, biPanel);
        beanInfoWorker.analyzePatterns();
        beanInfoWorker.waitFinished();
        if (beanInfoWorker.bia != null) {
            beanInfoWorker.bia.openSource();
        }
    }

    protected boolean asynchronous() {
        return false;
    }

    private void initAccessibility() {
        this.biDialog.getAccessibleContext().setAccessibleDescription(GenerateBeanInfoAction.getString("ACSD_BeanInfoEditorDialog"));
    }

    private static FileObject findFileObject(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        return dataObject != null ? dataObject.getPrimaryFile() : null;
    }

    static String getString(String string) {
        return NbBundle.getBundle((String)"org.netbeans.modules.beans.beaninfo.Bundle").getString(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BeanInfoWorker
    implements Runnable,
    Task<CompilationController> {
        private final BiPanel biPanel;
        private final FileObject javaFile;
        private boolean isCancelled = false;
        private Node biNode;
        private BiAnalyser bia;
        private RequestProcessor.Task task;
        private int state = 0;

        public BeanInfoWorker(FileObject fileObject, BiPanel biPanel) {
            this.javaFile = fileObject;
            this.biPanel = biPanel;
        }

        public RequestProcessor.Task analyzePatterns() {
            this.checkState(0);
            this.task = RequestProcessor.getDefault().post((Runnable)this);
            return this.task;
        }

        public void updateUI() {
            this.waitFinished();
            this.checkState(1);
            this.state = 2;
            this.fillBiPanel();
        }

        public void generateSources() {
            this.waitFinished();
            this.checkState(2);
            this.state = 3;
            this.run();
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }

        public void waitFinished() {
            if (this.task == null) {
                throw new IllegalStateException();
            }
            this.task.waitFinished();
        }

        public boolean isModelModified() {
            this.waitFinished();
            return this.bia != null ? this.bia.isModified() : false;
        }

        @Override
        public void run() {
            if (this.isCancelled) {
                return;
            }
            switch (this.state) {
                case 0: {
                    this.analyzePatternsImpl();
                    break;
                }
                case 2: {
                    this.fillBiPanel();
                    break;
                }
                case 3: {
                    this.generateSourcesImpl();
                }
            }
        }

        public void run(CompilationController compilationController) throws Exception {
            if (this.isCancelled) {
                return;
            }
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            switch (this.state) {
                case 1: {
                    this.analyzePatternsImpl((CompilationInfo)compilationController);
                }
            }
        }

        private void analyzePatternsImpl(CompilationInfo compilationInfo) {
            this.checkState(1);
            String string = this.javaFile.getName();
            TypeElement typeElement = null;
            for (TypeElement typeElement2 : compilationInfo.getTopLevelElements()) {
                if (!string.contentEquals(typeElement2.getSimpleName())) continue;
                typeElement = typeElement2;
            }
            PatternAnalyser patternAnalyser = new PatternAnalyser(this.javaFile, null);
            patternAnalyser.analyzeAll(compilationInfo, typeElement);
            try {
                this.bia = new BiAnalyser(patternAnalyser, compilationInfo);
            }
            catch (Exception exception) {
                this.isCancelled = true;
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        private void analyzePatternsImpl() {
            if (this.javaFile == null) {
                this.isCancelled = true;
                return;
            }
            this.checkState(0);
            this.state = 1;
            try {
                Future future = JavaSource.forFileObject((FileObject)this.javaFile).runWhenScanFinished((Task)this, true);
                future.get();
                this.isCancelled = future.isCancelled();
            }
            catch (Exception exception) {
                this.isCancelled = true;
                Exceptions.printStackTrace((Throwable)exception);
            }
        }

        private void fillBiPanel() {
            this.biNode = BiNode.createBiNode(this.bia);
            this.biPanel.setContext(this.biNode);
            this.biPanel.expandAll();
        }

        private void generateSourcesImpl() {
            if (!this.isCancelled() && this.bia != null && !this.bia.isBeanBroken()) {
                this.bia.regenerateSource();
            }
        }

        private void checkState(int n) {
            if (this.state != n) {
                throw new IllegalStateException();
            }
        }
    }
}

