/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.beaninfo;

import java.beans.PropertyVetoException;
import java.io.IOException;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.editor.guards.InteriorSection;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.beans.GenerateBeanException;
import org.netbeans.modules.beans.beaninfo.BIDataObject;
import org.netbeans.modules.beans.beaninfo.BIEditorSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public final class BeanInfoSource {
    private static final String BEANINFO_NAME_EXT = "BeanInfo";
    private static final String DESCRIPTOR_SECTION = "BeanDescriptor";
    private static final String PROPERTIES_SECTION = "Properties";
    private static final String EVENTSETS_SECTION = "Events";
    private static final String ICONS_SECTION = "Icons";
    private static final String IDX_SECTION = "Idx";
    private static final String METHODS_SECTION = "Methods";
    private static final String SUPERCLASS_SECTION = "Superclass";
    private DataObject javaDataObject;
    private DataObject biDataObject = null;
    private BIEditorSupport javaEditor = null;

    public BeanInfoSource(FileObject fileObject) throws GenerateBeanException {
        this.findBeanInfo(fileObject);
    }

    boolean exists() {
        return this.biDataObject != null;
    }

    boolean isNbBeanInfo() {
        GuardedSectionManager guardedSectionManager = null;
        if (!this.exists() || this.javaEditor == null || null == (guardedSectionManager = this.javaEditor.getGuardedSectionManager())) {
            return false;
        }
        InteriorSection interiorSection = guardedSectionManager.findInteriorSection(PROPERTIES_SECTION);
        InteriorSection interiorSection2 = guardedSectionManager.findInteriorSection(EVENTSETS_SECTION);
        SimpleSection simpleSection = guardedSectionManager.findSimpleSection(IDX_SECTION);
        return interiorSection != null && interiorSection2 != null && simpleSection != null;
    }

    boolean hasIconInfo() {
        GuardedSectionManager guardedSectionManager = this.javaEditor.getGuardedSectionManager();
        if (guardedSectionManager == null) {
            return false;
        }
        SimpleSection simpleSection = guardedSectionManager.findSimpleSection(ICONS_SECTION);
        return simpleSection != null;
    }

    boolean isNbBeanInfoDescriptor() {
        GuardedSectionManager guardedSectionManager = null;
        if (!this.exists() || this.javaEditor == null || null == (guardedSectionManager = this.javaEditor.getGuardedSectionManager())) {
            return false;
        }
        InteriorSection interiorSection = guardedSectionManager.findInteriorSection(DESCRIPTOR_SECTION);
        return interiorSection != null;
    }

    boolean isNbSuperclass() {
        GuardedSectionManager guardedSectionManager = null;
        if (!this.exists() || this.javaEditor == null || null == (guardedSectionManager = this.javaEditor.getGuardedSectionManager())) {
            return false;
        }
        InteriorSection interiorSection = guardedSectionManager.findInteriorSection(SUPERCLASS_SECTION);
        return interiorSection != null;
    }

    void findBeanInfo(FileObject fileObject) throws GenerateBeanException {
        this.javaEditor = null;
        try {
            this.javaDataObject = DataObject.find((FileObject)fileObject);
            FileObject fileObject2 = fileObject.getParent();
            FileObject fileObject3 = fileObject2.getFileObject(fileObject.getName() + BEANINFO_NAME_EXT, "java");
            if (fileObject3 != null) {
                this.biDataObject = DataObject.find((FileObject)fileObject3);
                this.javaEditor = (BIEditorSupport)((Object)this.biDataObject.getLookup().lookup(BIEditorSupport.class));
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            throw new GenerateBeanException();
        }
    }

    void delete() throws IOException {
        this.biDataObject.delete();
    }

    void createFromTemplate(boolean bl) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().findResource("Templates");
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = fileObject.getFileObject("Beans");
        if (fileObject2 == null) {
            return;
        }
        FileObject fileObject3 = null;
        fileObject3 = bl ? fileObject2.getFileObject(BEANINFO_NAME_EXT, "java") : fileObject2.getFileObject("NoIconBeanInfo", "java");
        if (fileObject3 == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject3);
            DataFolder dataFolder = this.javaDataObject.getFolder();
            this.biDataObject = dataObject.createFromTemplate(dataFolder, this.javaDataObject.getName() + BEANINFO_NAME_EXT);
            if (!(this.biDataObject instanceof BIDataObject)) {
                try {
                    this.biDataObject.setValid(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    Exceptions.printStackTrace((Throwable)propertyVetoException);
                }
                this.biDataObject = DataObject.find((FileObject)this.biDataObject.getPrimaryFile());
            }
            this.javaEditor = (BIEditorSupport)((Object)this.biDataObject.getLookup().lookup(BIEditorSupport.class));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    DataObject getDataObject() {
        return this.biDataObject;
    }

    DataObject getSourceDataObject() {
        return this.javaDataObject;
    }

    void open() {
        this.javaEditor.open();
    }

    void setDescriptorSection(String string, String string2) {
        this.setInteriorSection(DESCRIPTOR_SECTION, string, string2);
    }

    String getDescriptorSection() {
        GuardedSectionManager guardedSectionManager = this.javaEditor.getGuardedSectionManager();
        InteriorSection interiorSection = guardedSectionManager.findInteriorSection(DESCRIPTOR_SECTION);
        if (interiorSection != null) {
            return interiorSection.getText();
        }
        return null;
    }

    void setPropertiesSection(String string, String string2) {
        this.setInteriorSection(PROPERTIES_SECTION, string, string2);
    }

    String getPropertiesSection() {
        return this.getInteriorSection(PROPERTIES_SECTION);
    }

    void setMethodsSection(String string, String string2) {
        this.setInteriorSection(METHODS_SECTION, string, string2);
    }

    String getMethodsSection() {
        return this.getInteriorSection(METHODS_SECTION);
    }

    void setEventSetsSection(String string, String string2) {
        this.setInteriorSection(EVENTSETS_SECTION, string, string2);
    }

    String getEventSetsSection() {
        return this.getInteriorSection(EVENTSETS_SECTION);
    }

    String getIconsSection() {
        return this.getSimpleSection(ICONS_SECTION);
    }

    void setIconsSection(String string) {
        this.setSimpleSection(ICONS_SECTION, string);
    }

    String getDefaultIdxSection() {
        return this.getSimpleSection(IDX_SECTION);
    }

    void setDefaultIdxSection(String string) {
        this.setSimpleSection(IDX_SECTION, string);
    }

    void setSuperclassSection(String string, String string2) {
        this.setInteriorSection(SUPERCLASS_SECTION, string, string2);
    }

    String getSuperclassSection() {
        return this.getInteriorSection(SUPERCLASS_SECTION);
    }

    private void setInteriorSection(String string, String string2, String string3) {
        GuardedSectionManager guardedSectionManager = this.javaEditor.getGuardedSectionManager();
        if (guardedSectionManager == null) {
            return;
        }
        InteriorSection interiorSection = guardedSectionManager.findInteriorSection(string);
        if (interiorSection != null) {
            interiorSection.setHeader(string2);
            interiorSection.setFooter(string3);
        }
    }

    private String getInteriorSection(String string) {
        GuardedSectionManager guardedSectionManager = this.javaEditor.getGuardedSectionManager();
        if (guardedSectionManager == null) {
            return null;
        }
        InteriorSection interiorSection = guardedSectionManager.findInteriorSection(string);
        return interiorSection == null ? null : interiorSection.getText();
    }

    private void setSimpleSection(String string, String string2) {
        GuardedSectionManager guardedSectionManager = this.javaEditor.getGuardedSectionManager();
        if (guardedSectionManager == null) {
            return;
        }
        SimpleSection simpleSection = guardedSectionManager.findSimpleSection(string);
        if (simpleSection != null) {
            simpleSection.setText(string2);
        }
    }

    private String getSimpleSection(String string) {
        GuardedSectionManager guardedSectionManager = this.javaEditor.getGuardedSectionManager();
        if (guardedSectionManager == null) {
            return null;
        }
        SimpleSection simpleSection = guardedSectionManager.findSimpleSection(string);
        return simpleSection == null ? null : simpleSection.getText();
    }
}

