/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.viewmodel;

import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.viewmodel.DefaultTreeExpansionManager;
import org.netbeans.modules.viewmodel.ExceptionNode;
import org.netbeans.modules.viewmodel.TreeModelRoot;
import org.netbeans.modules.viewmodel.TreeTable;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeModelNode
extends AbstractNode {
    private static final int MAX_HTML_LENGTH = 511;
    private Models.CompoundModel model;
    private TreeModelRoot treeModelRoot;
    private Object object;
    private String htmlDisplayName;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private RequestProcessor.Task task;
    private static RequestProcessor requestProcessor;

    public TreeModelNode(Models.CompoundModel compoundModel, TreeModelRoot treeModelRoot, Object object) {
        super(TreeModelNode.createChildren(compoundModel, treeModelRoot, object), Lookups.singleton((Object)object));
        this.model = compoundModel;
        this.treeModelRoot = treeModelRoot;
        this.object = object;
        if (compoundModel.getHelpId() != null) {
            this.setValue("propertiesHelpID", compoundModel.getHelpId());
        }
        treeModelRoot.registerNode(object, this);
        this.refreshNode();
        this.initProperties();
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        ColumnModel[] columnModelArray = this.model.getColumns();
        int n = columnModelArray.length;
        for (int i = 0; i < n; ++i) {
            set.put((Node.Property)new MyProperty(columnModelArray[i], this.treeModelRoot));
        }
        sheet.put(set);
        this.setSheet(sheet);
    }

    private static Children createChildren(Models.CompoundModel compoundModel, TreeModelRoot treeModelRoot, Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        try {
            return compoundModel.isLeaf(object) ? Children.LEAF : new TreeModelChildren(compoundModel, treeModelRoot, object);
        }
        catch (UnknownTypeException unknownTypeException) {
            if (!(object instanceof String)) {
                Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + compoundModel);
                ErrorManager.getDefault().notify(1, throwable);
            }
            return Children.LEAF;
        }
    }

    public String getShortDescription() {
        try {
            String string = this.model.getShortDescription(this.object);
            if (string != null) {
                string = TreeModelNode.adjustHTML(string);
            }
            return string;
        }
        catch (UnknownTypeException unknownTypeException) {
            if (!(this.object instanceof String)) {
                Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
                ErrorManager.getDefault().notify(1, throwable);
            }
            return null;
        }
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return this.treeModelRoot.getRootNode().getActions(false);
        }
        try {
            return this.model.getActions(this.object);
        }
        catch (UnknownTypeException unknownTypeException) {
            return new Action[0];
        }
    }

    public Action getPreferredAction() {
        return new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TreeModelNode.this.model.performDefaultAction(TreeModelNode.this.object);
                }
                catch (UnknownTypeException unknownTypeException) {
                    // empty catch block
                }
            }
        };
    }

    public boolean canDestroy() {
        try {
            Action[] actionArray = this.model.getActions(this.object);
            int n = actionArray.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                if (actionArray[i] == null || (object = actionArray[i].getValue("AcceleratorKey")) == null || !object.equals(KeyStroke.getKeyStroke("DELETE"))) continue;
                return actionArray[i].isEnabled();
            }
            return false;
        }
        catch (UnknownTypeException unknownTypeException) {
            return false;
        }
    }

    public boolean canCopy() {
        try {
            return this.model.canCopy(this.object);
        }
        catch (UnknownTypeException unknownTypeException) {
            Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
            ErrorManager.getDefault().notify(1, throwable);
            return false;
        }
    }

    public boolean canCut() {
        try {
            return this.model.canCut(this.object);
        }
        catch (UnknownTypeException unknownTypeException) {
            Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
            ErrorManager.getDefault().notify(1, throwable);
            return false;
        }
    }

    public void destroy() {
        try {
            Action[] actionArray = this.model.getActions(this.object);
            int n = actionArray.length;
            for (int i = 0; i < n; ++i) {
                Object object;
                if (actionArray[i] == null || (object = actionArray[i].getValue("AcceleratorKey")) == null || !object.equals(KeyStroke.getKeyStroke("DELETE"))) continue;
                actionArray[i].actionPerformed(null);
                return;
            }
        }
        catch (UnknownTypeException unknownTypeException) {
            Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
            ErrorManager.getDefault().notify(1, throwable);
        }
    }

    void setObject(Object object) {
        this.setObjectNoRefresh(object);
        this.refresh();
    }

    private void setObjectNoRefresh(Object object) {
        this.object = object;
        Children children = this.getChildren();
        if (children instanceof TreeModelChildren) {
            ((TreeModelChildren)children).object = object;
        }
    }

    public Object getObject() {
        return this.object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.properties.clear();
        }
        if (this.task == null) {
            this.task = TreeModelNode.getRequestProcessor().create(new Runnable(){

                public void run() {
                    TreeModelNode.this.refreshNode();
                    TreeModelNode.this.fireShortDescriptionChange(null, null);
                    TreeModelNode.this.refreshTheChildren(true);
                }
            });
        }
        this.task.schedule(0);
    }

    void refresh(int n) {
        block15: {
            if (n == -1) {
                this.refresh();
                return;
            }
            if ((1 & n) != 0) {
                try {
                    String string = this.model.getDisplayName(this.object);
                    if (string == null) {
                        NullPointerException nullPointerException = new NullPointerException("Model: " + this.model + ".getDisplayName (" + this.object + ") = null!");
                        ErrorManager.getDefault().notify((Throwable)nullPointerException);
                    }
                    this.setName(string, false);
                }
                catch (UnknownTypeException unknownTypeException) {
                    Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
                    ErrorManager.getDefault().notify(1, throwable);
                }
            } else if ((2 & n) != 0) {
                try {
                    String string = this.model.getIconBaseWithExtension(this.object);
                    if (string != null) {
                        this.setIconBaseWithExtension(string);
                        break block15;
                    }
                    this.setIconBaseWithExtension("org/openide/resources/actions/empty.gif");
                }
                catch (UnknownTypeException unknownTypeException) {
                    Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
                    ErrorManager.getDefault().notify(1, throwable);
                }
            } else if ((4 & n) != 0) {
                this.fireShortDescriptionChange(null, null);
            } else if ((8 & n) != 0) {
                TreeModelNode.getRequestProcessor().post(new Runnable(){

                    public void run() {
                        TreeModelNode.this.refreshTheChildren(false);
                    }
                });
            } else {
                this.refresh();
            }
        }
    }

    static RequestProcessor getRequestProcessor() {
        if (requestProcessor == null) {
            requestProcessor = new RequestProcessor("TreeModel", 1);
        }
        return requestProcessor;
    }

    private void setName(String string, boolean bl) {
        String string2;
        String string3 = this.htmlDisplayName;
        String string4 = this.getDisplayName();
        if (string.startsWith("<html>")) {
            this.htmlDisplayName = string;
            string2 = TreeModelNode.removeHTML(string);
        } else {
            this.htmlDisplayName = null;
            string2 = string;
        }
        if (string4 == null || !string4.equals(string2)) {
            this.setDisplayName(string2);
        } else if (string3 != null && !string3.equals(this.htmlDisplayName) || this.htmlDisplayName != null && !this.htmlDisplayName.equals(string3)) {
            this.fireDisplayNameChange(string4 + "_HACK", this.getDisplayName());
        }
    }

    private void refreshNode() {
        try {
            Object object;
            String string = this.model.getDisplayName(this.object);
            if (string == null) {
                object = new NullPointerException("Model: " + this.model + ".getDisplayName (" + this.object + ") = null!");
                ErrorManager.getDefault().notify((Throwable)object);
            }
            this.setName(string, false);
            object = null;
            if (this.model.getRoot() != this.object) {
                object = this.model.getIconBaseWithExtension(this.object);
            }
            if (object != null) {
                this.setIconBaseWithExtension((String)object);
            } else {
                this.setIconBaseWithExtension("org/openide/resources/actions/empty.gif");
            }
            this.firePropertyChange(null, null, null);
        }
        catch (UnknownTypeException unknownTypeException) {
            Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
            ErrorManager.getDefault().notify(1, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshColumn(String string) {
        Map<String, Object> map = this.properties;
        synchronized (map) {
            this.properties.remove(string);
            this.properties.remove(string + "#html");
        }
        this.firePropertyChange(string, null, null);
    }

    private void refreshTheChildren(boolean bl) {
        Children children = this.getChildren();
        try {
            if (children instanceof TreeModelChildren) {
                if (this.model.isLeaf(this.object)) {
                    this.setChildren(Children.LEAF);
                } else {
                    ((TreeModelChildren)children).refreshChildren(bl);
                }
            } else if (!this.model.isLeaf(this.object)) {
                this.setChildren((Children)new TreeModelChildren(this.model, this.treeModelRoot, this.object));
            }
        }
        catch (UnknownTypeException unknownTypeException) {
            if (!(this.object instanceof String)) {
                Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
                ErrorManager.getDefault().notify(1, throwable);
            }
            this.setChildren(Children.LEAF);
        }
    }

    private static String htmlValue(String string) {
        if (string.length() <= 6 || !string.substring(0, 6).equalsIgnoreCase("<html>")) {
            return null;
        }
        if (string.length() > 511) {
            int n = TreeModelNode.findEndTagsPos(string);
            String string2 = string.substring(n + 1);
            string = string.substring(0, 508 - string2.length());
            int n2 = string.length();
            for (int i = n2 - 1; i > n2 - 6 && string.charAt(i) != ';'; --i) {
                if (string.charAt(i) != '&') continue;
                string = string.substring(0, i);
                break;
            }
            string = string + "..." + string2;
        }
        return TreeModelNode.adjustHTML(string);
    }

    private static int findEndTagsPos(String string) {
        int n;
        int n2 = 0;
        for (n = string.length() - 1; n >= 0; --n) {
            if (string.charAt(n) == '>') {
                ++n2;
                continue;
            }
            if (string.charAt(n) == '<') {
                --n2;
                continue;
            }
            if (n2 == 0) break;
        }
        return n;
    }

    private static String removeHTML(String string) {
        if (string.length() <= 6 || !string.substring(0, 6).equalsIgnoreCase("<html>")) {
            return string;
        }
        string = string.replaceAll("<i>", "");
        string = string.replaceAll("</i>", "");
        string = string.replaceAll("<b>", "");
        string = string.replaceAll("</b>", "");
        string = string.replaceAll("<html>", "");
        string = string.replaceAll("</html>", "");
        string = string.replaceAll("</font>", "");
        int n = string.indexOf("<font");
        while (n >= 0) {
            int n2 = string.indexOf(">", n);
            string = string.substring(0, n) + string.substring(n2 + 1);
            n = string.indexOf("<font");
        }
        string = string.replaceAll("&lt;", "<");
        string = string.replaceAll("&gt;", ">");
        string = string.replaceAll("&amp;", "&");
        return string;
    }

    private static String adjustHTML(String string) {
        string = string.replaceAll(Matcher.quoteReplacement("\\"), "\\\\\\\\");
        StringBuffer stringBuffer = null;
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            String string2 = null;
            if (c == '\n') {
                string2 = "\\n";
            } else if (c == '\r') {
                string2 = "\\r";
            } else if (c == '\f') {
                string2 = "\\f";
            } else if (c == '\b') {
                string2 = "\\b";
            }
            if (string2 == null) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(string.substring(0, i));
            } else {
                stringBuffer.append(string.substring(n, i));
            }
            stringBuffer.append(string2);
            n = i + 1;
        }
        if (stringBuffer == null) {
            return string;
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    public boolean canRename() {
        try {
            return this.model.canRename(this.object);
        }
        catch (UnknownTypeException unknownTypeException) {
            Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
            ErrorManager.getDefault().notify(1, throwable);
            return false;
        }
    }

    public void setName(String string) {
        try {
            this.model.setName(this.object, string);
            super.setName(string);
        }
        catch (UnknownTypeException unknownTypeException) {
            Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
            ErrorManager.getDefault().notify(1, throwable);
        }
    }

    public Transferable clipboardCopy() throws IOException {
        Transferable transferable;
        try {
            transferable = this.model.clipboardCopy(this.object);
        }
        catch (UnknownTypeException unknownTypeException) {
            Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
            ErrorManager.getDefault().notify(1, throwable);
            transferable = null;
        }
        if (transferable == null) {
            return super.clipboardCopy();
        }
        return transferable;
    }

    public Transferable clipboardCut() throws IOException {
        Transferable transferable;
        try {
            transferable = this.model.clipboardCut(this.object);
        }
        catch (UnknownTypeException unknownTypeException) {
            Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
            ErrorManager.getDefault().notify(1, throwable);
            transferable = null;
        }
        if (transferable == null) {
            return super.clipboardCut();
        }
        return transferable;
    }

    public void createPasteTypes(Transferable transferable, List<PasteType> list) {
        PasteType[] pasteTypeArray;
        try {
            pasteTypeArray = this.model.getPasteTypes(this.object, transferable);
        }
        catch (UnknownTypeException unknownTypeException) {
            Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
            ErrorManager.getDefault().notify(1, throwable);
            pasteTypeArray = null;
        }
        if (pasteTypeArray == null) {
            super.createPasteTypes(transferable, list);
        } else {
            list.addAll(Arrays.asList(pasteTypeArray));
        }
    }

    static class LazyEvaluator
    implements Runnable {
        private static final long EXPIRE_TIME = 60000L;
        private List<Object> objectsToEvaluate = new LinkedList<Object>();
        private Evaluable currentlyEvaluating;
        private RequestProcessor.Task evalTask = new RequestProcessor("Debugger Values Evaluator", 1).post((Runnable)this);

        public void evaluate(Evaluable evaluable) {
            this.evaluate(evaluable, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate(Evaluable evaluable, boolean bl) {
            List<Object> list = this.objectsToEvaluate;
            synchronized (list) {
                Iterator<Object> iterator = this.objectsToEvaluate.iterator();
                while (iterator.hasNext()) {
                    if (evaluable != iterator.next()) continue;
                    return;
                }
                if (bl && this.currentlyEvaluating == evaluable) {
                    return;
                }
                this.objectsToEvaluate.add(evaluable);
                this.objectsToEvaluate.notify();
                if (this.evalTask.isFinished()) {
                    this.evalTask.schedule(0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Evaluable evaluable;
                Object object = this.objectsToEvaluate;
                synchronized (object) {
                    if (this.objectsToEvaluate.size() == 0) {
                        try {
                            this.objectsToEvaluate.wait(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                        if (this.objectsToEvaluate.size() == 0) {
                            return;
                        }
                    }
                    this.currentlyEvaluating = evaluable = (Evaluable)this.objectsToEvaluate.remove(0);
                }
                object = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        List list = LazyEvaluator.this.objectsToEvaluate;
                        synchronized (list) {
                            LazyEvaluator.this.currentlyEvaluating = null;
                        }
                    }
                };
                evaluable.evaluateLazily((Runnable)object);
            }
        }

        public static interface Evaluable {
            public void evaluateLazily(Runnable var1);
        }
    }

    private class MyProperty
    extends PropertySupport
    implements LazyEvaluator.Evaluable {
        private final String EVALUATING_STR;
        private String id;
        private ColumnModel columnModel;
        private boolean nodeColumn;
        private TreeModelRoot treeModelRoot;
        private int[] evaluated;

        MyProperty(ColumnModel columnModel, TreeModelRoot treeModelRoot) {
            super(columnModel.getID(), columnModel.getType() == null ? String.class : columnModel.getType(), columnModel.getDisplayName(), columnModel.getShortDescription(), true, true);
            this.EVALUATING_STR = NbBundle.getMessage(TreeModelNode.class, (String)"EvaluatingProp");
            this.evaluated = new int[]{0};
            this.columnModel = columnModel;
            this.nodeColumn = columnModel.getType() == null;
            this.treeModelRoot = treeModelRoot;
            this.id = columnModel.getID();
        }

        public boolean canWrite() {
            if (this.nodeColumn) {
                return false;
            }
            try {
                return !TreeModelNode.this.model.isReadOnly(TreeModelNode.this.object, this.columnModel.getID());
            }
            catch (UnknownTypeException unknownTypeException) {
                if (!(TreeModelNode.this.object instanceof String)) {
                    Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Column id:" + this.columnModel.getID() + "\nModel: " + TreeModelNode.this.model);
                    ErrorManager.getDefault().notify(1, throwable);
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void evaluateLazily(Runnable runnable) {
            Object object = "";
            String string = null;
            String string2 = null;
            try {
                block24: {
                    try {
                        object = TreeModelNode.this.model.getValueAt(TreeModelNode.this.object, this.id);
                        if (!(object instanceof String)) break block24;
                        string = TreeModelNode.htmlValue((String)object);
                        string2 = TreeModelNode.removeHTML((String)object);
                    }
                    catch (UnknownTypeException unknownTypeException) {
                        if (!(TreeModelNode.this.object instanceof String)) {
                            unknownTypeException.printStackTrace();
                            System.out.println("  Column id:" + this.columnModel.getID());
                            System.out.println(TreeModelNode.this.model);
                            System.out.println();
                        }
                        Object var7_6 = null;
                        runnable.run();
                        Map map = TreeModelNode.this.properties;
                        // MONITORENTER : map
                        if (object instanceof String) {
                            TreeModelNode.this.properties.put(this.id, string2);
                            TreeModelNode.this.properties.put(this.id + "#html", string);
                        } else {
                            TreeModelNode.this.properties.put(this.id, object);
                        }
                        int[] nArray = this.evaluated;
                        // MONITORENTER : this.evaluated
                        boolean bl = this.evaluated[0] == -1;
                        this.evaluated[0] = 1;
                        this.evaluated.notifyAll();
                        // MONITOREXIT : nArray
                        // MONITOREXIT : map
                        if (!bl) return;
                        TreeModelNode.this.firePropertyChange(this.id, null, object);
                        return;
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        Object var7_7 = null;
                        runnable.run();
                        Map map = TreeModelNode.this.properties;
                        // MONITORENTER : map
                        if (object instanceof String) {
                            TreeModelNode.this.properties.put(this.id, string2);
                            TreeModelNode.this.properties.put(this.id + "#html", string);
                        } else {
                            TreeModelNode.this.properties.put(this.id, object);
                        }
                        int[] nArray = this.evaluated;
                        // MONITORENTER : this.evaluated
                        boolean bl = this.evaluated[0] == -1;
                        this.evaluated[0] = 1;
                        this.evaluated.notifyAll();
                        // MONITOREXIT : nArray
                        // MONITOREXIT : map
                        if (!bl) return;
                        TreeModelNode.this.firePropertyChange(this.id, null, object);
                        return;
                    }
                }
                Object var7_5 = null;
                runnable.run();
                Map map = TreeModelNode.this.properties;
                // MONITORENTER : map
                if (object instanceof String) {
                    TreeModelNode.this.properties.put(this.id, string2);
                    TreeModelNode.this.properties.put(this.id + "#html", string);
                } else {
                    TreeModelNode.this.properties.put(this.id, object);
                }
                int[] nArray = this.evaluated;
                // MONITORENTER : this.evaluated
                boolean bl = this.evaluated[0] == -1;
                this.evaluated[0] = 1;
                this.evaluated.notifyAll();
                // MONITOREXIT : nArray
                // MONITOREXIT : map
                if (!bl) return;
                TreeModelNode.this.firePropertyChange(this.id, null, object);
                return;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                runnable.run();
                Map map = TreeModelNode.this.properties;
                // MONITORENTER : map
                if (object instanceof String) {
                    TreeModelNode.this.properties.put(this.id, string2);
                    TreeModelNode.this.properties.put(this.id + "#html", string);
                } else {
                    TreeModelNode.this.properties.put(this.id, object);
                }
                int[] nArray = this.evaluated;
                // MONITORENTER : this.evaluated
                boolean bl = this.evaluated[0] == -1;
                this.evaluated[0] = 1;
                this.evaluated.notifyAll();
                // MONITOREXIT : nArray
                // MONITOREXIT : map
                if (!bl) throw throwable;
                TreeModelNode.this.firePropertyChange(this.id, null, object);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public synchronized Object getValue() {
            if (this.nodeColumn) {
                return TreeModelNode.this.getDisplayName();
            }
            Object object = TreeModelNode.this.properties;
            // MONITORENTER : object
            if (TreeModelNode.this.properties.containsKey(this.id)) {
                // MONITOREXIT : object
                return TreeModelNode.this.properties.get(this.id);
            }
            // MONITOREXIT : object
            object = this.evaluated;
            // MONITORENTER : this.evaluated
            this.evaluated[0] = 0;
            // MONITOREXIT : object
            this.treeModelRoot.getValuesEvaluator().evaluate(this);
            object = null;
            Object object2 = this.evaluated;
            // MONITORENTER : this.evaluated
            if (this.evaluated[0] != 1) {
                try {
                    this.evaluated.wait(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.evaluated[0] != 1) {
                    this.evaluated[0] = -1;
                    object = this.EVALUATING_STR;
                }
            }
            // MONITOREXIT : object2
            if (object == null) {
                Map map = TreeModelNode.this.properties;
                object2 = map;
                // MONITORENTER : map
                object = TreeModelNode.this.properties.get(this.id);
                // MONITOREXIT : object2
            }
            if (object != this.EVALUATING_STR) return object;
            if (this.getValueType() == null) return object;
            if (this.getValueType() == String.class) return object;
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(String string) {
            if (string.equals("htmlDisplayValue")) {
                if (this.nodeColumn) {
                    return TreeModelNode.this.getHtmlDisplayName();
                }
                Object object = this.evaluated;
                synchronized (this.evaluated) {
                    if (this.evaluated[0] != 1) {
                        // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                        return "<html><font color=\"0000CC\">" + this.EVALUATING_STR + "</font></html>";
                    }
                    // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                    Map map = TreeModelNode.this.properties;
                    object = map;
                    synchronized (map) {
                        // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                        return TreeModelNode.this.properties.get(this.id + "#html");
                    }
                }
            }
            return super.getValue(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getShortDescription() {
            if (this.nodeColumn) {
                return TreeModelNode.this.getShortDescription();
            }
            Object object = TreeModelNode.this.properties;
            synchronized (object) {
                if (!TreeModelNode.this.properties.containsKey(this.id)) {
                    return null;
                }
            }
            try {
                object = new JToolTip();
                ((JComponent)object).putClientProperty("getShortDescription", TreeModelNode.this.object);
                Object object2 = TreeModelNode.this.model.getValueAt(object, this.id);
                if (object2 == null) {
                    return null;
                }
                return TreeModelNode.adjustHTML(object2.toString());
            }
            catch (UnknownTypeException unknownTypeException) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            try {
                TreeModelNode.this.model.setValueAt(TreeModelNode.this.object, this.id, object);
                Map map = TreeModelNode.this.properties;
                synchronized (map) {
                    TreeModelNode.this.properties.put(this.id, object);
                }
                TreeModelNode.this.firePropertyChange(this.id, null, null);
            }
            catch (UnknownTypeException unknownTypeException) {
                Throwable throwable = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Column id:" + this.columnModel.getID() + "\nModel: " + TreeModelNode.this.model);
                ErrorManager.getDefault().notify(1, throwable);
            }
        }

        public PropertyEditor getPropertyEditor() {
            return this.columnModel.getPropertyEditor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TreeModelChildren
    extends Children.Keys<Object>
    implements LazyEvaluator.Evaluable {
        private boolean initialezed = false;
        private Models.CompoundModel model;
        private TreeModelRoot treeModelRoot;
        private Object object;
        private WeakHashMap<Object, WeakReference<TreeModelNode>> objectToNode = new WeakHashMap();
        private int[] evaluated = new int[]{0};
        private Object[] children_evaluated;
        private boolean refreshingSubNodes = true;
        private boolean refreshingStarted = true;
        private static final Object WAIT_KEY = new Object();
        private Integer depth;

        TreeModelChildren(Models.CompoundModel compoundModel, TreeModelRoot treeModelRoot, Object object) {
            this.model = compoundModel;
            this.treeModelRoot = treeModelRoot;
            this.object = object;
        }

        protected void addNotify() {
            this.initialezed = true;
            this.refreshChildren(true);
        }

        protected void removeNotify() {
            this.initialezed = false;
            this.setKeys(Collections.emptySet());
        }

        void refreshChildren(boolean bl) {
            if (!this.initialezed) {
                return;
            }
            this.refreshLazyChildren(bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void evaluateLazily(Runnable runnable) {
            Object[] objectArray = this.evaluated;
            synchronized (this.evaluated) {
                Object object;
                this.refreshingStarted = false;
                // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                try {
                    int n = this.model.getChildrenCount(this.object);
                    objectArray = this.model.getChildren(this.object, 0, n);
                }
                catch (UnknownTypeException unknownTypeException) {
                    objectArray = new Object[0];
                    if (!(this.object instanceof String)) {
                        object = ErrorManager.getDefault().annotate((Throwable)unknownTypeException, "Model: " + this.model);
                        ErrorManager.getDefault().notify(1, (Throwable)object);
                    }
                }
                catch (ThreadDeath threadDeath) {
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    ErrorManager.getDefault().notify(throwable);
                    objectArray = new Object[0];
                }
                runnable.run();
                object = this.evaluated;
                synchronized (this.evaluated) {
                    boolean bl;
                    int n = this.evaluated[0];
                    if (this.refreshingStarted) {
                        bl = false;
                    } else {
                        boolean bl2 = bl = this.evaluated[0] == -1;
                        if (!bl) {
                            this.children_evaluated = objectArray;
                        }
                        this.evaluated[0] = 1;
                        this.evaluated.notifyAll();
                    }
                    // ** MonitorExit[var4_9 /* !! */ ] (shouldn't be in output)
                    if (bl) {
                        this.applyChildren(objectArray, this.refreshingSubNodes);
                    }
                    return;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshLazyChildren(boolean bl) {
            Object[] objectArray = this.evaluated;
            synchronized (this.evaluated) {
                this.evaluated[0] = 0;
                this.refreshingStarted = true;
                this.refreshingSubNodes = bl;
                // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                this.treeModelRoot.getChildrenEvaluator().evaluate(this, false);
                int[] nArray = this.evaluated;
                synchronized (this.evaluated) {
                    if (this.evaluated[0] != 1) {
                        try {
                            this.evaluated.wait(200L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.evaluated[0] != 1) {
                            this.evaluated[0] = -1;
                            objectArray = null;
                        } else {
                            objectArray = this.children_evaluated;
                        }
                    } else {
                        objectArray = this.children_evaluated;
                    }
                    if (this.children_evaluated == null && this.evaluated[0] == 1) {
                        // ** MonitorExit[var3_4] (shouldn't be in output)
                        return;
                    }
                    this.children_evaluated = null;
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    if (objectArray == null) {
                        this.applyWaitChildren();
                    } else {
                        this.applyChildren(objectArray, bl);
                    }
                    return;
                }
            }
        }

        private void applyChildren(final Object[] objectArray, boolean bl) {
            int n = objectArray.length;
            WeakHashMap<Object, WeakReference<TreeModelNode>> weakHashMap = new WeakHashMap<Object, WeakReference<TreeModelNode>>();
            for (int i = 0; i < n; ++i) {
                TreeModelNode treeModelNode;
                if (objectArray[i] == null) {
                    throw (NullPointerException)ErrorManager.getDefault().annotate((Throwable)new NullPointerException(), "model: " + this.model + "\nparent: " + this.object);
                }
                WeakReference<TreeModelNode> weakReference = this.objectToNode.get(objectArray[i]);
                if (weakReference == null || (treeModelNode = (TreeModelNode)((Object)weakReference.get())) == null) continue;
                if (bl) {
                    treeModelNode.setObject(objectArray[i]);
                } else {
                    treeModelNode.setObjectNoRefresh(objectArray[i]);
                }
                weakHashMap.put(objectArray[i], weakReference);
            }
            this.objectToNode = weakHashMap;
            this.setKeys(objectArray);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        try {
                            TreeTable treeTable;
                            DefaultTreeExpansionManager.get(TreeModelChildren.this.model).setChildrenToActOn(TreeModelChildren.this.getTreeDepth());
                            if (!TreeModelChildren.this.model.isExpanded(objectArray[i]) || !(treeTable = TreeModelChildren.this.treeModelRoot.getTreeTable()).isExpanded(TreeModelChildren.this.object)) continue;
                            treeTable.expandNode(objectArray[i]);
                            continue;
                        }
                        catch (UnknownTypeException unknownTypeException) {
                            // empty catch block
                        }
                    }
                }
            });
        }

        Integer getTreeDepth() {
            Node node = this.getNode();
            if (node == null) {
                return 0;
            }
            if (this.depth != null) {
                return this.depth;
            }
            int n = 1;
            while ((node = node.getParentNode()) != null) {
                ++n;
            }
            this.depth = new Integer(n);
            return this.depth;
        }

        private void applyWaitChildren() {
            this.setKeys(new Object[]{WAIT_KEY});
        }

        protected Node[] createNodes(Object object) {
            if (object == WAIT_KEY) {
                AbstractNode abstractNode = new AbstractNode(Children.LEAF);
                abstractNode.setName(NbBundle.getMessage(TreeModelNode.class, (String)"WaitNode"));
                abstractNode.setIconBaseWithExtension("org/netbeans/modules/viewmodel/wait.gif");
                return new Node[]{abstractNode};
            }
            if (object instanceof Exception) {
                return new Node[]{new ExceptionNode((Exception)object)};
            }
            TreeModelNode treeModelNode = new TreeModelNode(this.model, this.treeModelRoot, object);
            this.objectToNode.put(object, new WeakReference<TreeModelNode>(treeModelNode));
            return new Node[]{treeModelNode};
        }
    }
}

