/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.ui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.netbeans.modules.j2ee.deployment.impl.ServerException;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ui.ProgressUI;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.NodeAction;

public class DebugAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(DebugAction.class, (String)"LBL_Debug");
    }

    protected void performAction(Node[] nodeArray) {
        DebugAction.performActionImpl(nodeArray);
    }

    protected boolean enable(Node[] nodeArray) {
        return DebugAction.enableImpl(nodeArray);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private static void performActionImpl(Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            ServerInstance serverInstance = (ServerInstance)nodeArray[i].getCookie(ServerInstance.class);
            DebugAction.performActionImpl(serverInstance);
        }
    }

    private static void performActionImpl(final ServerInstance serverInstance) {
        if (serverInstance != null) {
            RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    String string = NbBundle.getMessage(DebugAction.class, (String)"LBL_Debugging", (Object)serverInstance.getDisplayName());
                    ProgressUI progressUI = new ProgressUI(string, false);
                    try {
                        progressUI.start();
                        serverInstance.startDebug(progressUI);
                    }
                    catch (ServerException serverException) {
                        String string2 = serverException.getLocalizedMessage();
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                    finally {
                        progressUI.finish();
                    }
                }
            });
        }
    }

    private static boolean enableImpl(Node[] nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            ServerInstance serverInstance = (ServerInstance)nodeArray[i].getCookie(ServerInstance.class);
            if (DebugAction.enableImpl(serverInstance)) continue;
            return false;
        }
        return true;
    }

    private static boolean enableImpl(ServerInstance serverInstance) {
        return serverInstance != null && serverInstance.getServerState() == 2 && serverInstance.isDebugSupported();
    }

    public static class OutputAction
    extends AbstractAction
    implements ServerInstance.StateListener {
        private static final String ICON = "org/netbeans/modules/j2ee/deployment/impl/ui/resources/debug.png";
        private static final String PROP_ENABLED = "enabled";
        private final ServerInstance instance;

        public OutputAction(ServerInstance serverInstance) {
            super(NbBundle.getMessage(DebugAction.class, (String)"LBL_DebugOutput"), new ImageIcon(Utilities.loadImage((String)ICON)));
            this.putValue("ShortDescription", NbBundle.getMessage(DebugAction.class, (String)"LBL_DebugOutputDesc"));
            this.instance = serverInstance;
            serverInstance.addStateListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DebugAction.performActionImpl(this.instance);
        }

        public boolean isEnabled() {
            return DebugAction.enableImpl(this.instance);
        }

        public void stateChanged(int n, int n2) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    OutputAction.this.firePropertyChange(OutputAction.PROP_ENABLED, null, OutputAction.this.isEnabled() ? Boolean.TRUE : Boolean.FALSE);
                }
            });
        }
    }
}

