/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.deployment.impl.TargetModule;
import org.netbeans.spi.settings.DOMConvertor;
import org.netbeans.spi.settings.Saver;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TargetModuleConverter
extends DOMConvertor {
    private static final String PUBLIC_ID = "-//org_netbeans_modules_j2ee//DTD TargetModule 1.0//EN";
    private static final String SYSTEM_ID = "nbres:/org/netbeans/modules/j2ee/deployment/impl/target-module.dtd";
    private static final String E_TARGET_MODULE_LIST = "target-module-list";
    private static final String E_TARGET_MODULE = "target-module";
    private static final String A_ID = "id";
    private static final String A_INSTANCE_URL = "instance-url";
    private static final String A_TARGET_NAME = "target-name";
    private static final String A_TIMESTAMP = "timestamp";
    private static final String A_CONTENT_DIR = "content-dir";
    private static final String A_CONTEXT_ROOT = "context-root";
    private static final String DIR_TARGETMODULES = "TargetModules";
    private static FileObject targetModulesDir = null;

    public static DOMConvertor create() {
        return new TargetModuleConverter();
    }

    protected TargetModuleConverter() {
        super(PUBLIC_ID, SYSTEM_ID, E_TARGET_MODULE_LIST);
    }

    protected Object readElement(Element element) throws IOException, ClassNotFoundException {
        NodeList nodeList = element.getElementsByTagName(E_TARGET_MODULE);
        TargetModule[] targetModuleArray = new TargetModule[nodeList.getLength()];
        for (int i = 0; i < targetModuleArray.length; ++i) {
            Element element2 = (Element)nodeList.item(i);
            String string = element2.getAttribute(A_ID);
            String string2 = element2.getAttribute(A_INSTANCE_URL);
            String string3 = element2.getAttribute(A_TARGET_NAME);
            String string4 = element2.getAttribute(A_TIMESTAMP);
            String string5 = element2.getAttribute(A_CONTENT_DIR);
            String string6 = element2.getAttribute(A_CONTEXT_ROOT);
            if (string == null || string2 == null || string3 == null) {
                throw new IOException(NbBundle.getMessage(TargetModuleConverter.class, (String)"MSG_TargetModuleParseError"));
            }
            try {
                targetModuleArray[i] = new TargetModule(string, string2, string3, Long.parseLong(string4), string5, string6);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                IOException iOException = new IOException();
                iOException.initCause(numberFormatException);
                throw iOException;
            }
        }
        return new TargetModule.List(targetModuleArray);
    }

    protected void writeElement(Document document, Element element, Object object) throws IOException, DOMException {
        if (object == null) {
            return;
        }
        if (!(object instanceof TargetModule.List)) {
            throw new DOMException(9, NbBundle.getMessage(TargetModuleConverter.class, (String)"MSG_NotSupportedObject", object.getClass()));
        }
        TargetModule.List list = (TargetModule.List)object;
        TargetModule[] targetModuleArray = list.getTargetModules();
        for (int i = 0; i < targetModuleArray.length; ++i) {
            Element element2 = document.createElement(E_TARGET_MODULE);
            element2.setAttribute(A_ID, targetModuleArray[i].getId());
            element2.setAttribute(A_INSTANCE_URL, targetModuleArray[i].getInstanceUrl());
            element2.setAttribute(A_TARGET_NAME, targetModuleArray[i].getTargetName());
            element2.setAttribute(A_TIMESTAMP, String.valueOf(targetModuleArray[i].getTimestamp()));
            element2.setAttribute(A_CONTENT_DIR, targetModuleArray[i].getContentDirectory());
            element2.setAttribute(A_CONTEXT_ROOT, targetModuleArray[i].getContextRoot());
            element.appendChild(element2);
        }
    }

    public void registerSaver(Object object, Saver saver) {
    }

    public void unregisterSaver(Object object, Saver saver) {
    }

    private static FileObject getTargetModulesDir() throws IOException {
        FileObject fileObject;
        if (targetModulesDir == null && (targetModulesDir = (fileObject = Repository.getDefault().getDefaultFileSystem().findResource("/J2EE")).getFileObject(DIR_TARGETMODULES)) == null) {
            targetModulesDir = fileObject.createFolder(DIR_TARGETMODULES);
        }
        return targetModulesDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeTargetModule(TargetModule targetModule, String string, String string2, String string3) {
        FileLock fileLock = null;
        Writer writer = null;
        try {
            FileObject fileObject;
            FileObject fileObject2 = TargetModuleConverter.getTargetModulesDir().getFileObject(string);
            if (fileObject2 == null) {
                fileObject2 = TargetModuleConverter.getTargetModulesDir().createFolder(string);
            }
            if ((fileObject = fileObject2.getFileObject(string2)) == null) {
                fileObject = fileObject2.createFolder(string2);
            }
            FileObject fileObject3 = FileUtil.createData((FileObject)fileObject, (String)string3);
            fileLock = fileObject3.lock();
            writer = new OutputStreamWriter(fileObject3.getOutputStream(fileLock));
            TargetModuleConverter.create().write(writer, (Object)new TargetModule.List(targetModule));
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.WARNING, null, exception);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.WARNING, null, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TargetModule readTargetModule(String string, String string2, String string3) {
        FileObject fileObject;
        Reader reader = null;
        try {
            FileObject fileObject2 = TargetModuleConverter.getTargetModulesDir().getFileObject(string);
            if (fileObject2 != null && (fileObject2 = fileObject2.getFileObject(string2)) != null && (fileObject = fileObject2.getFileObject(string3)) != null) {
                reader = new InputStreamReader(fileObject.getInputStream());
                TargetModule.List list = (TargetModule.List)TargetModuleConverter.create().read(reader);
                if (list == null || list.getTargetModules().length < 1) {
                    TargetModule targetModule = null;
                    return targetModule;
                }
                TargetModule targetModule = list.getTargetModules()[0];
                return targetModule;
            }
            fileObject = null;
            return fileObject;
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.WARNING, null, exception);
            fileObject = null;
            return fileObject;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.WARNING, null, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTargetModulesByContextRoot(String string, String string2, String string3) {
        Reader reader = null;
        try {
            FileObject fileObject = TargetModuleConverter.getTargetModulesDir().getFileObject(string);
            if (fileObject != null && (fileObject = fileObject.getFileObject(string2)) != null) {
                FileObject fileObject2;
                Enumeration enumeration = fileObject.getChildren(false);
                FileObject fileObject3 = new ArrayList();
                while (enumeration.hasMoreElements()) {
                    TargetModule targetModule;
                    fileObject2 = (FileObject)enumeration.nextElement();
                    reader = new InputStreamReader(fileObject2.getInputStream());
                    TargetModule.List list = (TargetModule.List)TargetModuleConverter.create().read(reader);
                    if (list == null || list.getTargetModules().length <= 0 || !string3.equals((targetModule = list.getTargetModules()[0]).getContextRoot())) continue;
                    fileObject3.add(targetModule);
                }
                fileObject2 = fileObject3;
                return fileObject2;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.WARNING, null, exception);
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.WARNING, null, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TargetModule remove(String string, String string2, String string3) {
        FileLock fileLock = null;
        try {
            FileObject fileObject;
            FileObject fileObject2 = TargetModuleConverter.getTargetModulesDir().getFileObject(string);
            if (fileObject2 != null && (fileObject2 = fileObject2.getFileObject(string2)) != null && (fileObject = fileObject2.getFileObject(string3)) != null) {
                fileLock = fileObject.lock();
                fileObject.delete(fileLock);
            }
            fileObject = null;
            return fileObject;
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.WARNING, null, exception);
            TargetModule targetModule = null;
            return targetModule;
        }
        finally {
            try {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.WARNING, null, exception);
            }
        }
    }
}

