/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros.storage.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.editor.Settings;
import org.netbeans.modules.editor.macros.MacrosKeymapManager;
import org.netbeans.modules.editor.macros.storage.MacroDescription;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage;
import org.netbeans.modules.editor.settings.storage.spi.support.StorageSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MacrosModel {
    private static final Logger LOG = Logger.getLogger(MacrosModel.class.getName());
    public static final int NAME_COLUMN_IDX = 0;
    public static final int SHORTCUTS_COLUMN_IDX = 1;
    public static final int COLUMN_COUNT = 2;
    private Map<MimePath, Map<String, Macro>> mimeType2Macros = new HashMap<MimePath, Map<String, Macro>>();
    private List<Macro> allMacrosList = new ArrayList<Macro>();
    private final MacrosTableModel tableModel = new MacrosTableModel();
    private boolean changed = false;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean loaded = false;
    private static Reference<MacrosModel> ref = null;
    private static final Comparator<Macro> MACRO_COMPARATOR = new Comparator<Macro>(){

        @Override
        public int compare(Macro macro, Macro macro2) {
            return macro.getName().compareTo(macro2.getName());
        }
    };

    public static synchronized MacrosModel get() {
        MacrosModel macrosModel;
        MacrosModel macrosModel2 = macrosModel = ref == null ? null : ref.get();
        if (macrosModel == null) {
            macrosModel = new MacrosModel();
            ref = new WeakReference<MacrosModel>(macrosModel);
        }
        return macrosModel;
    }

    public void load() {
        EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get((String)"Macros");
        this.mimeType2Macros = new HashMap<MimePath, Map<String, Macro>>();
        this.allMacrosList = new ArrayList<Macro>();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("");
        hashSet.addAll(EditorSettings.getDefault().getAllMimeTypes());
        for (String string : hashSet) {
            Map map;
            MimePath mimePath = MimePath.parse((String)string);
            try {
                map = editorSettingsStorage.load(mimePath, null, false);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Can't load macros for '" + mimePath + "'", iOException);
                continue;
            }
            Map<String, Macro> map2 = this.mimeType2Macros.get(mimePath);
            if (map2 == null) {
                map2 = new HashMap<String, Macro>(map.size());
                this.mimeType2Macros.put(mimePath, map2);
            }
            for (String string2 : map.keySet()) {
                MacroDescription macroDescription = (MacroDescription)map.get(string2);
                Macro macro = new Macro(this, mimePath, macroDescription);
                map2.put(string2, macro);
                this.allMacrosList.add(macro);
            }
        }
        Collections.sort(this.allMacrosList, MACRO_COMPARATOR);
        this.loaded = true;
        this.tableModel.fireTableDataChanged();
        this.setChanged(false);
    }

    public void save() {
        EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get((String)"Macros");
        for (MimePath mimePath : this.mimeType2Macros.keySet()) {
            Map<String, Macro> map = this.mimeType2Macros.get(mimePath);
            HashMap<String, MacroDescription> hashMap = new HashMap<String, MacroDescription>(map.size());
            for (String string : map.keySet()) {
                Macro macro = map.get(string);
                hashMap.put(string, macro.getMacroDescription());
            }
            try {
                editorSettingsStorage.save(mimePath, null, false, hashMap);
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "Can't save macros for '" + mimePath + "'", iOException);
            }
        }
        this.setChanged(false);
        Settings.reset();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public String validateMacroName(String string) {
        if (string == null || string.trim().length() == 0) {
            return NbBundle.getMessage(MacrosModel.class, (String)"CTL_Empty_Macro_Name");
        }
        Map<String, Macro> map = this.mimeType2Macros.get(MimePath.EMPTY);
        if (map.containsKey(string)) {
            return NbBundle.getMessage(MacrosModel.class, (String)"CTL_Duplicate_Macro_Name");
        }
        return null;
    }

    public Macro getMacroByIndex(int n) {
        return this.allMacrosList.get(n);
    }

    public Macro createMacro(MimePath mimePath, String string) {
        Macro macro = new Macro(this, mimePath, string, "", Collections.emptyList());
        Map<String, Macro> map = this.mimeType2Macros.get(mimePath);
        if (map == null) {
            map = new HashMap<String, Macro>();
            this.mimeType2Macros.put(mimePath, map);
        }
        if (map.containsKey(string)) {
            throw new IllegalArgumentException("Can't create macro, the name is already used: '" + string + "'");
        }
        map.put(string, macro);
        this.allMacrosList.add(macro);
        this.tableModel.fireTableRowsInserted(this.allMacrosList.size() - 1, this.allMacrosList.size() - 1);
        this.setChanged(true);
        return macro;
    }

    public void deleteMacro(int n) {
        Macro macro = this.allMacrosList.get(n);
        Set<String> set = Collections.emptySet();
        macro.setShortcuts(set);
        this.allMacrosList.remove(n);
        Map<String, Macro> map = this.mimeType2Macros.get(macro.getMimeType());
        map.remove(macro.getName());
        this.tableModel.fireTableRowsDeleted(n, n);
        this.setChanged(true);
    }

    public List<Macro> getAllMacros() {
        return Collections.unmodifiableList(this.allMacrosList);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private MacrosModel() {
    }

    private void fireTableModelChange(Macro macro, int n) {
        assert (n >= 0 && n < 2);
        this.tableModel.fireTableDataChanged();
    }

    private void setChanged(boolean bl) {
        if (this.changed == bl) {
            return;
        }
        this.changed = bl;
        this.pcs.firePropertyChange("changed", !bl, bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MacrosTableModel
    extends AbstractTableModel {
        private MacrosTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return MacrosModel.this.allMacrosList.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return ((Macro)MacrosModel.this.allMacrosList.get(n)).getName();
                }
                case 1: {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < ((Macro)MacrosModel.this.allMacrosList.get(n)).getShortcuts().size(); ++i) {
                        MultiKeyBinding multiKeyBinding = ((Macro)MacrosModel.this.allMacrosList.get(n)).getShortcuts().get(i);
                        stringBuilder.append(StorageSupport.keyStrokesToString((Collection)multiKeyBinding.getKeyStrokeList(), (boolean)false));
                        if (i + 1 >= ((Macro)MacrosModel.this.allMacrosList.get(n)).getShortcuts().size()) continue;
                        stringBuilder.append(", ");
                    }
                    return stringBuilder.toString();
                }
            }
            throw new ArrayIndexOutOfBoundsException("Invalid column index: " + n2);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return NbBundle.getMessage(MacrosModel.class, (String)"MacrosTable_Name_Column_Title");
                }
                case 1: {
                    return NbBundle.getMessage(MacrosModel.class, (String)"MacrosTable_Shortcut_Column_Title");
                }
            }
            throw new ArrayIndexOutOfBoundsException("Invalid column index: " + n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Macro
    implements ShortcutAction {
        public static final String PROP_CODE = "Macro.PROP_CODE";
        public static final String PROP_SHORTCUTS = "Macro.PROP_SHORTCUTS";
        private final MacrosModel model;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final MimePath mimeType;
        private MacroDescription macroDescription;
        private String name;
        private String code;
        private List<? extends MultiKeyBinding> shortcuts;

        public MimePath getMimeType() {
            return this.mimeType;
        }

        public String getName() {
            return this.macroDescription != null ? this.macroDescription.getName() : this.name;
        }

        public String getCode() {
            return this.macroDescription != null ? this.macroDescription.getCode() : this.code;
        }

        public void setCode(String string) {
            if (Utilities.compareObjects((Object)this.getCode(), (Object)string)) {
                return;
            }
            this.cloneOnModify();
            String string2 = this.code;
            this.code = string;
            this.pcs.firePropertyChange(PROP_CODE, string2, string);
            this.model.setChanged(true);
        }

        public List<? extends MultiKeyBinding> getShortcuts() {
            return this.macroDescription != null ? this.macroDescription.getShortcuts() : this.shortcuts;
        }

        public void setShortcut(String string) {
            List<MultiKeyBinding> list = Collections.singletonList(new MultiKeyBinding(StorageSupport.stringToKeyStrokes((String)string, (boolean)false), "macro-" + this.getName()));
            if (Utilities.compareObjects(this.getShortcuts(), list)) {
                return;
            }
            this.cloneOnModify();
            List<? extends MultiKeyBinding> list2 = this.shortcuts;
            this.shortcuts = list;
            this.pcs.firePropertyChange(PROP_SHORTCUTS, list2, this.shortcuts);
            this.model.fireTableModelChange(this, 1);
            this.model.setChanged(true);
        }

        public void setShortcuts(Set<String> set) {
            ArrayList<? extends MultiKeyBinding> arrayList = new ArrayList<MultiKeyBinding>(set.size());
            for (String string : set) {
                arrayList.add((MultiKeyBinding)new MultiKeyBinding(StorageSupport.stringToKeyStrokes((String)string, (boolean)true), "macro-" + this.getName()));
            }
            if (Utilities.compareObjects(new HashSet<MultiKeyBinding>(this.getShortcuts()), new HashSet(arrayList))) {
                return;
            }
            this.cloneOnModify();
            List<? extends MultiKeyBinding> list = this.shortcuts;
            this.shortcuts = arrayList;
            this.pcs.firePropertyChange(PROP_SHORTCUTS, list, set);
            this.model.fireTableModelChange(this, 1);
            this.model.setChanged(true);
        }

        public String getDisplayName() {
            String string = EditorSettings.getDefault().getLanguageName(this.mimeType.getPath()).toLowerCase();
            if (this.mimeType == MimePath.EMPTY) {
                return NbBundle.getMessage(MacrosModel.class, (String)"MacroAction_DisplayName_1", (Object)this.getName(), (Object)string);
            }
            return NbBundle.getMessage(MacrosModel.class, (String)"MacroAction_DisplayName_2", (Object)this.getName(), (Object)string);
        }

        public String getId() {
            return this.getName() + "@" + this.mimeType.getPath();
        }

        public String getDelegatingActionId() {
            return null;
        }

        public ShortcutAction getKeymapManagerInstance(String string) {
            if (string != null && string.equals(MacrosKeymapManager.class.getName())) {
                return this;
            }
            return null;
        }

        private Macro(MacrosModel macrosModel, MimePath mimePath, String string, String string2, List<? extends MultiKeyBinding> list) {
            this.model = macrosModel;
            this.mimeType = mimePath;
            this.name = string;
            this.code = string2;
            this.shortcuts = list;
        }

        private Macro(MacrosModel macrosModel, MimePath mimePath, MacroDescription macroDescription) {
            this.model = macrosModel;
            this.mimeType = mimePath;
            this.macroDescription = macroDescription;
        }

        private void cloneOnModify() {
            if (this.macroDescription != null) {
                this.name = this.macroDescription.getName();
                this.code = this.macroDescription.getCode();
                this.shortcuts = this.macroDescription.getShortcuts();
                this.macroDescription = null;
            }
        }

        private MacroDescription getMacroDescription() {
            return this.macroDescription != null ? this.macroDescription : new MacroDescription(this.name, this.code, null, this.shortcuts);
        }
    }
}

