/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.modules.editor.lib.KitsTracker;
import org.netbeans.modules.editor.macros.MacroDialogSupport;
import org.netbeans.modules.editor.macros.storage.MacroDescription;
import org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage;
import org.openide.modules.ModuleInstall;

public final class Installer
extends ModuleInstall {
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());

    public void restored() {
        Settings.addInitializer((Settings.Initializer)new MacrosSettingsInitializer());
    }

    public void close() {
        this.finish();
    }

    public void uninstalled() {
        this.finish();
    }

    private void finish() {
        Settings.removeInitializer((String)"macros-settings-initializer");
        Settings.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MacrosSettingsInitializer
    extends Settings.AbstractInitializer {
        static final String NAME = "macros-settings-initializer";

        MacrosSettingsInitializer() {
            super(NAME);
        }

        public void updateSettingsMap(Class clazz, Map map) {
            HashMap<String, Action> hashMap = new HashMap<String, Action>();
            ArrayList<MultiKeyBinding> arrayList = new ArrayList<MultiKeyBinding>();
            this.collectMacroActions(clazz, hashMap, arrayList);
            if (clazz == BaseKit.class) {
                hashMap.put("start-macro-recording", (Action)((Object)new MacroDialogSupport.StartMacroRecordingAction()));
                hashMap.put("stop-macro-recording", (Action)((Object)new MacroDialogSupport.StopMacroRecordingAction()));
            }
            if (!hashMap.isEmpty()) {
                SettingsUtil.updateListSetting((Map)map, (String)"custom-action-list", (Object[])hashMap.values().toArray());
            }
            if (!arrayList.isEmpty()) {
                ArrayList<org.netbeans.editor.MultiKeyBinding> arrayList2 = new ArrayList<org.netbeans.editor.MultiKeyBinding>(arrayList.size());
                for (MultiKeyBinding multiKeyBinding : arrayList) {
                    arrayList2.add(new org.netbeans.editor.MultiKeyBinding(multiKeyBinding.getKeyStrokeList().toArray(new KeyStroke[multiKeyBinding.getKeyStrokeList().size()]), multiKeyBinding.getActionName()));
                }
                map.put("key-bindings", arrayList2);
            }
        }

        private void collectMacroActions(Class clazz, Map<String, Action> map, List<MultiKeyBinding> list) {
            String string = KitsTracker.getInstance().findMimeType(clazz);
            if (string != null) {
                Map map2;
                EditorSettingsStorage editorSettingsStorage = EditorSettingsStorage.get((String)"Macros");
                try {
                    map2 = editorSettingsStorage.load(MimePath.EMPTY, null, false);
                    this.collectMacrosWithShortcuts(map2, map, list);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
                try {
                    map2 = editorSettingsStorage.load(MimePath.parse((String)string), null, false);
                    this.collectMacrosWithShortcuts(map2, map, list);
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, null, iOException);
                }
            }
        }

        private void collectMacrosWithShortcuts(Map<String, MacroDescription> map, Map<String, Action> map2, List<MultiKeyBinding> list) {
            for (MacroDescription macroDescription : map.values()) {
                List<? extends MultiKeyBinding> list2 = macroDescription.getShortcuts();
                if (list2 == null || list2.size() <= 0) continue;
                MacroDialogSupport.RunMacroAction runMacroAction = new MacroDialogSupport.RunMacroAction(macroDescription.getName());
                String string = (String)runMacroAction.getValue("Name");
                map2.put(string, (Action)((Object)runMacroAction));
                list.addAll(list2);
            }
        }
    }
}

