/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.JFileChooser;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class Util {
    private Util() {
    }

    public static SourceGroup getPreselectedGroup(SourceGroup[] sourceGroupArray, String string) {
        if (string != null) {
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                if (!sourceGroupArray[i].getName().equals(string)) continue;
                return sourceGroupArray[i];
            }
        }
        return sourceGroupArray.length >= 0 ? sourceGroupArray[0] : null;
    }

    public static Project openProject() {
        return Util.openProject(null);
    }

    public static Project openProject(String string) {
        Project project;
        block4: {
            int n;
            Serializable serializable;
            project = null;
            if (string != null && ((File)(serializable = new File(string))).exists() && ((File)serializable).isDirectory()) {
                ProjectChooser.setProjectsFolder((File)serializable);
            }
            serializable = ProjectChooser.projectChooser();
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(Util.class, (String)"MSG_notProjectDir"), 2);
            NotifyDescriptor.Message message2 = new NotifyDescriptor.Message((Object)NbBundle.getMessage(Util.class, (String)"ERR_NoWebProject"), 2);
            while ((n = ((JFileChooser)serializable).showOpenDialog(WindowManager.getDefault().getMainWindow())) == 0) {
                File file = FileUtil.normalizeFile((File)((JFileChooser)serializable).getSelectedFile());
                project = Util.fileToProject(file);
                if (project == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    continue;
                }
                if (!Util.isWebProject(project)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message2);
                    continue;
                }
                break block4;
            }
            return null;
        }
        OpenProjects.getDefault().open(new Project[]{project}, true);
        return project;
    }

    public static boolean isWebProject(Project project) {
        if (project == null) {
            return false;
        }
        WebModuleProvider webModuleProvider = (WebModuleProvider)project.getLookup().lookup(WebModuleProvider.class);
        return webModuleProvider != null;
    }

    public static Project fileToProject(File file) {
        try {
            FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
            if (fileObject != null) {
                return ProjectManager.getDefault().findProject(fileObject);
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Project getServerProject(Configuration configuration) {
        Project project = null;
        OpenProjects openProjects = OpenProjects.getDefault();
        Project[] projectArray = openProjects.getOpenProjects();
        String string = configuration.getServerConfigutation().getProjectName();
        for (Project project2 : projectArray) {
            ProjectInformation projectInformation = (ProjectInformation)project2.getLookup().lookup(ProjectInformation.class);
            String string2 = projectInformation.getName();
            if (!string.equals(string2)) continue;
            project = project2;
            break;
        }
        return project;
    }

    public static void addServletToWebProject(Project project, JavonMapping javonMapping) {
        try {
            boolean bl = false;
            String string = javonMapping.getServerMapping().getClassName();
            String string2 = javonMapping.getServerMapping().getPackageName();
            String string3 = string2.length() != 0 ? string2 + '.' + string : string;
            FileObject fileObject = null;
            WebModuleProvider webModuleProvider = (WebModuleProvider)project.getLookup().lookup(WebModuleProvider.class);
            WebModule webModule = webModuleProvider.findWebModule(project.getProjectDirectory());
            fileObject = webModule.getDeploymentDescriptor();
            WebApp webApp = DDProvider.getDefault().getDDRootCopy(fileObject);
            Servlet[] servletArray = webApp.getServlet();
            for (int i = 0; i < servletArray.length; ++i) {
                if (!servletArray[i].getServletClass().equals(string3)) continue;
                bl = true;
            }
            if (!bl) {
                string = Util.findFreeName(string, webApp);
                Servlet servlet = (Servlet)webApp.createBean("Servlet");
                servlet.setServletName(string);
                servlet.setServletClass(string3);
                servlet.setDescription(NbBundle.getMessage(Util.class, (String)"TXT_servletElementDescription"));
                servlet.setDisplayName("Javon service for : " + string3);
                webApp.addServlet(servlet);
                ServletMapping servletMapping = (ServletMapping)webApp.createBean("ServletMapping");
                servletMapping.setServletName(string);
                servletMapping.setUrlPattern("/servlet/" + string3);
                webApp.addServletMapping(servletMapping);
            }
            if (!bl) {
                webApp.write(fileObject);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    private static String findFreeName(String string, WebApp webApp) {
        int n = 0;
        Servlet[] servletArray = webApp.getServlet();
        for (int i = 0; i < servletArray.length && servletArray[i].getServletName().equals(string); ++i) {
            string = string + ++n;
        }
        ServletMapping[] servletMappingArray = webApp.getServletMapping();
        for (int i = 0; i < servletMappingArray.length && servletMappingArray[i].getServletName().equals(string); ++i) {
            string = string + ++n;
        }
        return string;
    }

    public static String getServerURL(Project project, Configuration configuration) {
        InstanceProperties instanceProperties;
        String string = "8080";
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (instanceProperties = j2eeModuleProvider.getInstanceProperties()) != null) {
            string = instanceProperties.getProperty("httpportnumber") != null ? instanceProperties.getProperty("httpportnumber") : "8080";
        }
        return "http://localhost:" + string + "/" + configuration.getServerConfigutation().getProjectName() + "/servlet/" + configuration.getServerConfigutation().getClassDescriptor().getType();
    }

    public static boolean isSuitableProjectConfiguration(Project project) {
        if (!(project instanceof J2MEProject)) {
            return false;
        }
        String string = Util.evaluateProjectProperty((J2MEProject)project, "platform.profile");
        return "MIDP-2.0".equals(string);
    }

    private static String evaluateProjectProperty(J2MEProject j2MEProject, String string) {
        AntProjectHelper antProjectHelper = (AntProjectHelper)j2MEProject.getLookup().lookup(AntProjectHelper.class);
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        ProjectConfigurationsHelper projectConfigurationsHelper = j2MEProject.getConfigurationHelper();
        String string2 = projectConfigurationsHelper.getActiveConfiguration() != projectConfigurationsHelper.getDefaultConfiguration() ? projectConfigurationsHelper.getActiveConfiguration().getDisplayName() : null;
        return Util.evaluateProperty(editableProperties, string, string2);
    }

    private static String evaluateProperty(EditableProperties editableProperties, String string, String string2) {
        if (string2 == null) {
            return editableProperties.getProperty(string);
        }
        String string3 = editableProperties.getProperty("configs." + string2 + "." + string);
        return string3 != null ? string3 : Util.evaluateProperty(editableProperties, string, null);
    }

    public static String getServerLocation(Project project) {
        return "localhost";
    }

    public static String getServerPort(Project project) {
        InstanceProperties instanceProperties;
        String string = "8080";
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (instanceProperties = j2eeModuleProvider.getInstanceProperties()) != null) {
            string = instanceProperties.getProperty("httpportnumber") != null ? instanceProperties.getProperty("httpportnumber") : "8080";
        }
        return string;
    }

    public static boolean registerDataBindingLibrary(Project project) {
        Library[] libraryArray;
        ProjectClassPathExtender projectClassPathExtender = (ProjectClassPathExtender)project.getLookup().lookup(ProjectClassPathExtender.class);
        for (Library library : libraryArray = LibraryManager.getDefault().getLibraries()) {
            if (!library.getName().equals("DataBindingME")) continue;
            try {
                projectClassPathExtender.addLibrary(library);
                return true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return false;
            }
        }
        return false;
    }
}

