/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.ui.treeview;

import java.awt.event.FocusListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;
import org.netbeans.modules.mobility.end2end.ui.treeview.MethodCheckedNodeEditor;
import org.netbeans.modules.mobility.end2end.ui.treeview.MethodCheckedNodeRenderer;
import org.netbeans.modules.mobility.end2end.ui.treeview.MultiStateCheckBox;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class MethodCheckedTreeBeanView
extends BeanTreeView
implements Runnable {
    private Node root;
    private MethodCheckedNodeEditor editor;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    public static final String rootPath = "#root";
    private final Node waitNode = new AbstractNode(Children.LEAF);

    public MethodCheckedTreeBeanView() {
        FocusListener[] focusListenerArray = this.tree.getFocusListeners();
        for (int i = 0; i < focusListenerArray.length; ++i) {
            if (!focusListenerArray[i].getClass().getName().startsWith("org.openide")) continue;
            this.tree.removeFocusListener(focusListenerArray[i]);
        }
        MouseListener[] mouseListenerArray = this.tree.getMouseListeners();
        for (int i = 0; i < mouseListenerArray.length; ++i) {
            if (!mouseListenerArray[i].getClass().getName().startsWith("org.openide")) continue;
            this.tree.removeMouseListener(mouseListenerArray[i]);
        }
    }

    public Node getWaitNode() {
        return this.waitNode;
    }

    public void setEditable(boolean bl) {
        this.tree.setEditable(bl);
        this.tree.setBackground(UIManager.getDefaults().getColor(bl ? "Tree.background" : "TextField.inactiveBackground"));
    }

    public void setRoot(Node node) {
        this.root = node;
        this.tree.setCellRenderer(new MethodCheckedNodeRenderer());
        this.editor = new MethodCheckedNodeEditor(this.tree);
        this.tree.setCellEditor(this.editor);
        this.tree.setEditable(true);
        this.editor.setContentStorage(this);
        this.updateMixedStates(node);
    }

    public synchronized void updateTreeNodeStates(Node node) {
        if (this.root == null) {
            return;
        }
        if (node != null) {
            this.forceState(node.getChildren(), (MultiStateCheckBox.State)((Object)node.getValue("isSelected")));
        }
        this.updateMixedStates(this.root);
        this.fireChange();
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath != null) {
            this.tree.setSelectionPath(null);
        }
    }

    private void forceState(Children children, MultiStateCheckBox.State state) {
        for (Node node : children.getNodes()) {
            node.setValue("isSelected", (Object)state);
            this.forceState(node.getChildren(), state);
        }
    }

    private MultiStateCheckBox.State updateMixedStates(Node node) {
        Children children = node.getChildren();
        MultiStateCheckBox.State state = null;
        for (Node node2 : node.getChildren().getNodes()) {
            if (node2.getValue("isValid") == Boolean.FALSE) continue;
            MultiStateCheckBox.State state2 = this.updateMixedStates(node2);
            if (state == null) {
                state = state2;
                continue;
            }
            if (state2 == state) continue;
            state = MultiStateCheckBox.State.MIXED;
        }
        if (state == null) {
            state = (MultiStateCheckBox.State)((Object)node.getValue("isSelected"));
        }
        if (state == null) {
            state = MultiStateCheckBox.State.UNSELECTED;
        }
        node.setValue("isSelected", (Object)state);
        return state;
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }
}

