/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xpath.ext;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.xml.schema.model.Attribute;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.StepNodeTestType;
import org.netbeans.modules.xml.xpath.ext.StepNodeTypeTest;
import org.netbeans.modules.xml.xpath.ext.XPathAxis;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathSchemaContextHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface XPathSchemaContext {
    public XPathSchemaContext getParentContext();

    public Set<SchemaCompPair> getSchemaCompPairs();

    public Set<SchemaCompPair> getUsedSchemaCompPairs();

    public void setUsedSchemaComp(Set<SchemaComponent> var1);

    public boolean equalsChain(XPathSchemaContext var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Utilities {
        public static List<SchemaComponent> getSchemaCompChain(XPathSchemaContext xPathSchemaContext) {
            ArrayList<SchemaComponent> arrayList = new ArrayList<SchemaComponent>();
            do {
                SchemaComponent schemaComponent;
                if ((schemaComponent = Utilities.getSchemaComp(xPathSchemaContext)) == null) {
                    return null;
                }
                arrayList.add(schemaComponent);
            } while ((xPathSchemaContext = xPathSchemaContext.getParentContext()) != null);
            return arrayList;
        }

        public static SchemaComponent getSchemaComp(XPathSchemaContext xPathSchemaContext) {
            SchemaCompPair schemaCompPair;
            if (xPathSchemaContext == null) {
                return null;
            }
            Set<SchemaCompPair> set = xPathSchemaContext.getUsedSchemaCompPairs();
            if (set != null && set.size() == 1 && (schemaCompPair = set.iterator().next()) != null) {
                SchemaComponent schemaComponent = schemaCompPair.getComp();
                return schemaComponent;
            }
            return null;
        }

        public static boolean equalsChain(XPathSchemaContext xPathSchemaContext, XPathSchemaContext xPathSchemaContext2) {
            if (Utilities.equals(xPathSchemaContext, xPathSchemaContext2)) {
                boolean bl;
                XPathSchemaContext xPathSchemaContext3 = xPathSchemaContext.getParentContext();
                XPathSchemaContext xPathSchemaContext4 = xPathSchemaContext2.getParentContext();
                return !(xPathSchemaContext3 != null && xPathSchemaContext4 != null ? !(bl = Utilities.equalsChain(xPathSchemaContext3, xPathSchemaContext4)) : xPathSchemaContext3 == null && xPathSchemaContext4 != null || xPathSchemaContext3 != null && xPathSchemaContext4 == null);
            }
            return false;
        }

        public static boolean equals(XPathSchemaContext xPathSchemaContext, XPathSchemaContext xPathSchemaContext2) {
            assert (xPathSchemaContext != null && xPathSchemaContext2 != null);
            Set<SchemaCompPair> set = xPathSchemaContext.getSchemaCompPairs();
            Set<SchemaCompPair> set2 = xPathSchemaContext2.getSchemaCompPairs();
            assert (set != null && set2 != null);
            if (set.size() != set2.size()) {
                return false;
            }
            for (SchemaCompPair schemaCompPair : set) {
                if (set2.contains(schemaCompPair)) continue;
                return false;
            }
            return true;
        }

        public static XPathLocationPath generateRelativePath(XPathExpressionPath xPathExpressionPath, XPathSchemaContext xPathSchemaContext) {
            LocationStep locationStep;
            int n;
            Object object;
            Object object2;
            LocationStep[] locationStepArray = xPathExpressionPath.getSteps();
            if (locationStepArray == null || locationStepArray.length == 0) {
                return null;
            }
            LocationStep locationStep2 = locationStepArray[locationStepArray.length - 1];
            XPathSchemaContext xPathSchemaContext2 = locationStep2.getSchemaContext();
            if (xPathSchemaContext2 == null) {
                return null;
            }
            XPathExpression xPathExpression = xPathExpressionPath.getRootExpression();
            XPathSchemaContext xPathSchemaContext3 = null;
            if (xPathExpression instanceof XPathSchemaContextHolder) {
                xPathSchemaContext3 = ((XPathSchemaContextHolder)((Object)xPathExpression)).getSchemaContext();
            }
            if (xPathSchemaContext3 == null) {
                return null;
            }
            assert (xPathSchemaContext3.getParentContext() == null) : "the root expression has to have not chained schema context";
            List<XPathSchemaContext> list = Utilities.getInversedContextChain(xPathSchemaContext2);
            List<XPathSchemaContext> list2 = Utilities.getInversedContextChain(xPathSchemaContext);
            Iterator<XPathSchemaContext> iterator = list.iterator();
            Iterator<XPathSchemaContext> iterator2 = list2.iterator();
            Object object3 = null;
            int n2 = -1;
            while (iterator.hasNext() && iterator2.hasNext() && (object2 = iterator2.next()).equals(object = iterator.next())) {
                ++n2;
                object3 = object2;
            }
            if (object3 == null) {
                return null;
            }
            if (object3.equals(xPathSchemaContext3)) {
                return null;
            }
            object2 = locationStep2.getModel().getFactory();
            object = new ArrayList();
            int n3 = list2.size() - n2 - 1;
            XPathSchemaContext xPathSchemaContext4 = xPathSchemaContext.getParentContext();
            for (n = 0; n < n3; ++n) {
                locationStep = object2.newLocationStep(XPathAxis.PARENT, new StepNodeTypeTest(StepNodeTestType.NODETYPE_NODE, null), null);
                locationStep.setSchemaContext(xPathSchemaContext4);
                ((ArrayList)object).add(locationStep);
            }
            for (n = n2; n < locationStepArray.length; ++n) {
                locationStep = locationStepArray[n];
                ((ArrayList)object).add(locationStep);
            }
            if (((ArrayList)object).size() == 0 && xPathSchemaContext2.equalsChain(xPathSchemaContext)) {
                LocationStep locationStep3 = object2.newLocationStep(XPathAxis.SELF, new StepNodeTypeTest(StepNodeTestType.NODETYPE_NODE, null), null);
                ((ArrayList)object).add(locationStep3);
            }
            XPathLocationPath xPathLocationPath = object2.newXPathLocationPath(((ArrayList)object).toArray(new LocationStep[((ArrayList)object).size()]));
            return xPathLocationPath;
        }

        public static List<XPathSchemaContext> getInversedContextChain(XPathSchemaContext xPathSchemaContext) {
            LinkedList<XPathSchemaContext> linkedList = new LinkedList<XPathSchemaContext>();
            while (xPathSchemaContext != null) {
                linkedList.addFirst(xPathSchemaContext);
                xPathSchemaContext = xPathSchemaContext.getParentContext();
            }
            return linkedList;
        }
    }

    public static final class SchemaCompPair {
        private SchemaComponent mComp;
        private SchemaComponent mParentComp;

        public SchemaCompPair(SchemaComponent schemaComponent, SchemaComponent schemaComponent2) {
            this.mComp = schemaComponent;
            this.mParentComp = schemaComponent2;
        }

        public SchemaComponent getComp() {
            return this.mComp;
        }

        public SchemaComponent getParetnComp() {
            return this.mParentComp;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            SchemaComponent schemaComponent = this.getParetnComp();
            if (schemaComponent != null) {
                SchemaCompPair.appendCompName(stringBuffer, schemaComponent);
                stringBuffer.append(">");
            }
            SchemaComponent schemaComponent2 = this.getComp();
            SchemaCompPair.appendCompName(stringBuffer, schemaComponent2);
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof SchemaCompPair) {
                SchemaCompPair schemaCompPair = (SchemaCompPair)object;
                return schemaCompPair.mComp == this.mComp && schemaCompPair.mParentComp == this.mParentComp;
            }
            return false;
        }

        public static void appendCompName(StringBuffer stringBuffer, SchemaComponent schemaComponent) {
            if (schemaComponent instanceof Attribute) {
                stringBuffer.append("@");
            }
            if (schemaComponent instanceof Named) {
                String string = ((Named)schemaComponent).getName();
                stringBuffer.append(string);
            } else {
                stringBuffer.append("???");
            }
        }
    }
}

