/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.sunresources.beans;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.sun.api.ServerInterface;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.api.SunDeploymentManagerInterface;
import org.netbeans.modules.j2ee.sun.dd.api.DDProvider;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.AdminObjectResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.ConnectorResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcConnectionPool;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JdbcResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.JmsResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.MailResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.PersistenceManagerFactoryResource;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.PropertyElement;
import org.netbeans.modules.j2ee.sun.dd.api.serverresources.Resources;
import org.netbeans.modules.j2ee.sun.ide.editors.NameValuePair;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ConnPoolBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.DataSourceBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JMSBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.JavaMailSessionBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.PersistenceManagerBean;
import org.netbeans.modules.j2ee.sun.ide.sunresources.beans.ResourceConfigurator;
import org.netbeans.modules.j2ee.sun.ide.sunresources.wizards.ResourceConfigData;
import org.netbeans.modules.j2ee.sun.share.serverresources.SunDatasource;
import org.netbeans.modules.j2ee.sun.share.serverresources.SunMessageDestination;
import org.netbeans.modules.j2ee.sun.sunresources.beans.DatabaseUtils;
import org.netbeans.modules.j2ee.sun.sunresources.beans.WizardConstants;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ResourceUtils
implements WizardConstants {
    static final ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.j2ee.sun.ide.sunresources.beans.Bundle");
    static final String[] sysDatasources = new String[]{"jdbc/__TimerPool", "jdbc/__CallFlowPool"};
    static final String[] sysConnpools = new String[]{"__CallFlowPool", "__TimerPool"};
    static final String SAMPLE_DATASOURCE = "jdbc/sample";
    static final String SAMPLE_CONNPOOL = "SamplePool";
    static final String SUN_RESOURCE_FILENAME = "sun-resources.xml";
    static final String MAP_RESOURCES = "com.sun.appserv:type=resources,category=config";
    private static final char BLANK = ' ';
    private static final char DOT = '.';
    private static final char REPLACEMENT_CHAR = '_';
    private static final char[] ILLEGAL_FILENAME_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|', ','};
    private static final char[] ILLEGAL_RESOURCE_NAME_CHARS = new char[]{':', '*', '?', '\"', '<', '>', '|', ','};

    public static void saveNodeToXml(FileObject fileObject, Resources resources) {
        try {
            resources.write(FileUtil.toFile((FileObject)fileObject));
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    public static void register(Resources resources, SunDeploymentManagerInterface sunDeploymentManagerInterface, boolean bl, String string) throws Exception {
        if (sunDeploymentManagerInterface.isRunning()) {
            ServerInterface serverInterface = sunDeploymentManagerInterface.getManagement();
            if (string.equals("jdbc-connection-pool")) {
                ResourceUtils.register(resources.getJdbcConnectionPool(0), serverInterface, bl);
            } else if (string.equals("jdbc-resource")) {
                ResourceUtils.register(resources.getJdbcResource(0), serverInterface, bl);
            } else if (string.equals("persistence-manager-factory-resource")) {
                ResourceUtils.register(resources.getPersistenceManagerFactoryResource(0), serverInterface, bl);
            } else if (string.equals("mail-resource")) {
                ResourceUtils.register(resources.getMailResource(0), serverInterface, bl);
            } else if (string.equals("jms-resource")) {
                if (resources.getAdminObjectResource().length != 0) {
                    ResourceUtils.register(resources.getAdminObjectResource(0), serverInterface, bl);
                } else if (resources.getConnectorResource().length != 0 && resources.getConnectorConnectionPool().length != 0) {
                    ResourceUtils.register(resources.getConnectorConnectionPool(0), serverInterface, bl);
                    ResourceUtils.register(resources.getConnectorResource(0), serverInterface, bl);
                }
            }
        } else {
            throw new Exception(bundle.getString("Err_RegResServerStopped"));
        }
    }

    public static void register(JdbcConnectionPool jdbcConnectionPool, ServerInterface serverInterface, boolean bl) throws Exception {
        AttributeList attributeList = ResourceUtils.getResourceAttributes(jdbcConnectionPool, serverInterface);
        PropertyElement[] propertyElementArray = jdbcConnectionPool.getPropertyElement();
        Properties properties = ResourceUtils.getProperties(propertyElementArray);
        Object[] objectArray = new Object[]{attributeList, properties, null};
        String string = jdbcConnectionPool.getName();
        if (!ResourceUtils.isResourceUpdated(string, serverInterface, attributeList, properties, "getJdbcConnectionPool")) {
            ResourceUtils.createResource("createJdbcConnectionPool", objectArray, serverInterface);
        }
    }

    public static void register(JdbcResource jdbcResource, ServerInterface serverInterface, boolean bl) throws Exception {
        AttributeList attributeList = ResourceUtils.getResourceAttributes(jdbcResource);
        PropertyElement[] propertyElementArray = jdbcResource.getPropertyElement();
        Properties properties = ResourceUtils.getProperties(propertyElementArray);
        Object[] objectArray = new Object[]{attributeList, properties, null};
        String string = jdbcResource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(string, serverInterface, attributeList, properties, "getJdbcResource")) {
            ResourceUtils.createResource("createJdbcResource", objectArray, serverInterface);
        }
    }

    public static void register(PersistenceManagerFactoryResource persistenceManagerFactoryResource, ServerInterface serverInterface, boolean bl) throws Exception {
        AttributeList attributeList = ResourceUtils.getResourceAttributes(persistenceManagerFactoryResource);
        PropertyElement[] propertyElementArray = persistenceManagerFactoryResource.getPropertyElement();
        Properties properties = ResourceUtils.getProperties(propertyElementArray);
        Object[] objectArray = new Object[]{attributeList, properties, null};
        String string = persistenceManagerFactoryResource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(string, serverInterface, attributeList, properties, "getPersistenceManagerFactoryResource")) {
            ResourceUtils.createResource("createPersistenceManagerFactoryResource", objectArray, serverInterface);
        }
    }

    public static void register(AdminObjectResource adminObjectResource, ServerInterface serverInterface, boolean bl) throws Exception {
        AttributeList attributeList = ResourceUtils.getResourceAttributes(adminObjectResource);
        PropertyElement[] propertyElementArray = adminObjectResource.getPropertyElement();
        Properties properties = ResourceUtils.getProperties(propertyElementArray);
        Object[] objectArray = new Object[]{attributeList, properties, null};
        String string = adminObjectResource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(string, serverInterface, attributeList, properties, "getAdminObjectResource")) {
            ResourceUtils.createResource("createAdminObjectResource", objectArray, serverInterface);
        }
    }

    public static void register(ConnectorResource connectorResource, ServerInterface serverInterface, boolean bl) throws Exception {
        AttributeList attributeList = ResourceUtils.getResourceAttributes(connectorResource);
        Properties properties = new Properties();
        Object[] objectArray = new Object[]{attributeList, properties, null};
        String string = connectorResource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(string, serverInterface, attributeList, properties, "getConnectorResource")) {
            ResourceUtils.createResource("createConnectorResource", objectArray, serverInterface);
        }
    }

    public static void register(ConnectorConnectionPool connectorConnectionPool, ServerInterface serverInterface, boolean bl) throws Exception {
        AttributeList attributeList = ResourceUtils.getResourceAttributes(connectorConnectionPool);
        PropertyElement[] propertyElementArray = connectorConnectionPool.getPropertyElement();
        Properties properties = ResourceUtils.getProperties(propertyElementArray);
        Object[] objectArray = new Object[]{attributeList, properties, null};
        String string = connectorConnectionPool.getName();
        if (!ResourceUtils.isResourceUpdated(string, serverInterface, attributeList, properties, "getConnectorConnectionPool")) {
            ResourceUtils.createResource("createConnectorConnectionPool", objectArray, serverInterface);
        }
    }

    public static void register(MailResource mailResource, ServerInterface serverInterface, boolean bl) throws Exception {
        AttributeList attributeList = ResourceUtils.getResourceAttributes(mailResource);
        PropertyElement[] propertyElementArray = mailResource.getPropertyElement();
        Properties properties = ResourceUtils.getProperties(propertyElementArray);
        Object[] objectArray = new Object[]{attributeList, properties, null};
        String string = mailResource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(string, serverInterface, attributeList, properties, "getMailResource")) {
            ResourceUtils.createResource("createMailResource", objectArray, serverInterface);
        }
    }

    public static void register(JmsResource jmsResource, ServerInterface serverInterface, boolean bl) throws Exception {
        AttributeList attributeList = ResourceUtils.getResourceAttributes(jmsResource);
        PropertyElement[] propertyElementArray = jmsResource.getPropertyElement();
        Properties properties = ResourceUtils.getProperties(propertyElementArray);
        Object[] objectArray = new Object[]{attributeList, properties, null};
        String string = NbBundle.getMessage(ResourceUtils.class, (String)"CreateJMS");
        String string2 = jmsResource.getJndiName();
        if (!ResourceUtils.isResourceUpdated(string2, serverInterface, attributeList, properties, "getJmsResource")) {
            ResourceUtils.createResource(string, objectArray, serverInterface);
        }
    }

    private static boolean isResourceUpdated(String string, ServerInterface serverInterface, AttributeList attributeList, Properties properties, String string2) {
        boolean bl = false;
        try {
            Object object;
            ObjectName objectName = new ObjectName(MAP_RESOURCES);
            ObjectName[] objectNameArray = null;
            if (string2.equals("getPersistenceManagerFactoryResource") || string2.equals("getJmsResource")) {
                object = new String[]{"java.lang.String"};
                Object[] objectArray = new Object[]{null};
                objectNameArray = (ObjectName[])serverInterface.invoke(objectName, string2, objectArray, (String[])object);
            } else {
                objectNameArray = (ObjectName[])serverInterface.invoke(objectName, string2, null, null);
            }
            if (objectNameArray != null) {
                object = null;
                object = string2.equals("getJdbcConnectionPool") || string2.equals("getConnectorConnectionPool") ? ResourceUtils.getResourceDeployed(objectNameArray, string, false) : ResourceUtils.getResourceDeployed(objectNameArray, string, true);
                if (object != null) {
                    bl = true;
                    ResourceUtils.updateResourceAttributes((ObjectName)object, attributeList, serverInterface);
                    ResourceUtils.updateResourceProperties((ObjectName)object, properties, serverInterface);
                }
            }
        }
        catch (Exception exception) {
            String string3 = MessageFormat.format(bundle.getString("Err_ResourceUpdate"), string);
            System.out.println(string3);
        }
        return bl;
    }

    private static ObjectName getResourceDeployed(ObjectName[] objectNameArray, String string, boolean bl) {
        for (int i = 0; i < objectNameArray.length; ++i) {
            ObjectName objectName = objectNameArray[i];
            String string2 = null;
            string2 = bl ? objectName.getKeyProperty("jndi-name") : objectName.getKeyProperty("name");
            if (!string2.equals(string)) continue;
            return objectName;
        }
        return null;
    }

    public static void updateResourceAttributes(ObjectName objectName, AttributeList attributeList, ServerInterface serverInterface) throws Exception {
        try {
            Map map = ResourceUtils.getResourceAttributeNames(objectName, serverInterface);
            String[] stringArray = map.keySet().toArray(new String[map.size()]);
            AttributeList attributeList2 = serverInterface.getAttributes(objectName, stringArray);
            for (int i = 0; i < attributeList2.size(); ++i) {
                Attribute attribute = (Attribute)attributeList2.get(i);
                String string = attribute.getName();
                for (int j = 0; j < attributeList.size(); ++j) {
                    Attribute attribute2 = (Attribute)attributeList.get(j);
                    String string2 = attribute2.getName();
                    if (!string.equals(string2)) continue;
                    if (attribute2.getValue() == null && attribute.getValue() != null) {
                        serverInterface.setAttribute(objectName, attribute2);
                        continue;
                    }
                    if (attribute.getValue() == null) {
                        if (attribute2.getValue() == null || attribute2.getValue().toString().equals("")) continue;
                        serverInterface.setAttribute(objectName, attribute2);
                        continue;
                    }
                    if (attribute2.getValue().toString().equals(attribute.getValue().toString())) continue;
                    serverInterface.setAttribute(objectName, attribute2);
                }
            }
        }
        catch (Exception exception) {
            throw new Exception(exception.getLocalizedMessage());
        }
    }

    public static void updateResourceProperties(ObjectName objectName, Properties properties, ServerInterface serverInterface) throws Exception {
        try {
            String[] stringArray = new String[]{"javax.management.Attribute"};
            Object[] objectArray = null;
            AttributeList attributeList = (AttributeList)serverInterface.invoke(objectName, "getProperties", null, null);
            for (int i = 0; i < attributeList.size(); ++i) {
                Object object;
                Attribute attribute = (Attribute)attributeList.get(i);
                String string = attribute.getName();
                if (properties.containsKey(string)) {
                    if (attribute.getValue() != null) {
                        object = attribute.getValue().toString();
                        if (properties.getProperty(string).equals(object)) continue;
                        Attribute attribute2 = new Attribute(string, properties.getProperty(string));
                        objectArray = new Object[]{attribute2};
                        serverInterface.invoke(objectName, "setProperty", objectArray, stringArray);
                        continue;
                    }
                    if (properties.getProperty(string) == null) continue;
                    object = new Attribute(string, properties.getProperty(string));
                    objectArray = new Object[]{object};
                    serverInterface.invoke(objectName, "setProperty", objectArray, stringArray);
                    continue;
                }
                object = new Attribute(string, null);
                objectArray = new Object[]{object};
                serverInterface.invoke(objectName, "setProperty", objectArray, stringArray);
            }
            ResourceUtils.addNewExtraProperties(objectName, properties, attributeList, serverInterface);
        }
        catch (Exception exception) {
            throw new Exception(exception.getLocalizedMessage());
        }
    }

    public static Map getResourceAttributeNames(ObjectName objectName, ServerInterface serverInterface) throws Exception {
        try {
            HashMap<String, MBeanAttributeInfo> hashMap = new HashMap<String, MBeanAttributeInfo>();
            MBeanInfo mBeanInfo = serverInterface.getMBeanInfo(objectName);
            MBeanAttributeInfo[] mBeanAttributeInfoArray = mBeanInfo.getAttributes();
            for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                if (mBeanAttributeInfoArray[i] == null) continue;
                hashMap.put(mBeanAttributeInfoArray[i].getName(), mBeanAttributeInfoArray[i]);
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new Exception(exception.getLocalizedMessage());
        }
    }

    private static void addNewExtraProperties(ObjectName objectName, Properties properties, AttributeList attributeList, ServerInterface serverInterface) throws Exception {
        try {
            String[] stringArray = new String[]{"javax.management.Attribute"};
            Object[] objectArray = null;
            if (properties.size() > attributeList.size()) {
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement().toString();
                    if (attributeList.contains(string)) continue;
                    Attribute attribute = new Attribute(string, properties.getProperty(string));
                    objectArray = new Object[]{attribute};
                    serverInterface.invoke(objectName, "setProperty", objectArray, stringArray);
                }
            }
        }
        catch (Exception exception) {
            throw new Exception(exception.getLocalizedMessage());
        }
    }

    public static void createResource(String string, Object[] objectArray, ServerInterface serverInterface) throws Exception {
        try {
            ObjectName objectName = new ObjectName(MAP_RESOURCES);
            String[] stringArray = new String[]{"javax.management.AttributeList", "java.util.Properties", "java.lang.String"};
            serverInterface.invoke(objectName, string, objectArray, stringArray);
        }
        catch (Exception exception) {
            throw new Exception(exception.getLocalizedMessage());
        }
    }

    public static AttributeList getResourceAttributes(JdbcConnectionPool jdbcConnectionPool, ServerInterface serverInterface) {
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("name", jdbcConnectionPool.getName()));
        attributeList.add(new Attribute("datasource-classname", jdbcConnectionPool.getDatasourceClassname()));
        attributeList.add(new Attribute("res-type", jdbcConnectionPool.getResType()));
        attributeList.add(new Attribute("steady-pool-size", jdbcConnectionPool.getSteadyPoolSize()));
        attributeList.add(new Attribute("max-pool-size", jdbcConnectionPool.getMaxPoolSize()));
        attributeList.add(new Attribute("max-wait-time-in-millis", jdbcConnectionPool.getMaxWaitTimeInMillis()));
        attributeList.add(new Attribute("pool-resize-quantity", jdbcConnectionPool.getPoolResizeQuantity()));
        attributeList.add(new Attribute("idle-timeout-in-seconds", jdbcConnectionPool.getIdleTimeoutInSeconds()));
        String string = jdbcConnectionPool.getTransactionIsolationLevel();
        String string2 = ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/editors/Bundle").getString("LBL_driver_default");
        if (string != null && (string.length() == 0 || string.equals(string2))) {
            string = null;
        }
        attributeList.add(new Attribute("transaction-isolation-level", string));
        attributeList.add(new Attribute("is-isolation-level-guaranteed", jdbcConnectionPool.getIsIsolationLevelGuaranteed()));
        attributeList.add(new Attribute("is-connection-validation-required", jdbcConnectionPool.getIsConnectionValidationRequired()));
        attributeList.add(new Attribute("connection-validation-method", jdbcConnectionPool.getConnectionValidationMethod()));
        attributeList.add(new Attribute("validation-table-name", jdbcConnectionPool.getValidationTableName()));
        attributeList.add(new Attribute("fail-all-connections", jdbcConnectionPool.getFailAllConnections()));
        attributeList.add(new Attribute("description", jdbcConnectionPool.getDescription()));
        if (ResourceUtils.is90Server(serverInterface)) {
            attributeList.add(new Attribute("non-transactional-connections", jdbcConnectionPool.getNonTransactionalConnections()));
            attributeList.add(new Attribute("allow-non-component-callers", jdbcConnectionPool.getAllowNonComponentCallers()));
        }
        return attributeList;
    }

    public static AttributeList getResourceAttributes(JdbcResource jdbcResource) {
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("jndi-name", jdbcResource.getJndiName()));
        attributeList.add(new Attribute("pool-name", jdbcResource.getPoolName()));
        attributeList.add(new Attribute("object-type", jdbcResource.getObjectType()));
        attributeList.add(new Attribute("enabled", jdbcResource.getEnabled()));
        attributeList.add(new Attribute("description", jdbcResource.getDescription()));
        return attributeList;
    }

    public static AttributeList getResourceAttributes(PersistenceManagerFactoryResource persistenceManagerFactoryResource) {
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("jndi-name", persistenceManagerFactoryResource.getJndiName()));
        attributeList.add(new Attribute("factory-class", persistenceManagerFactoryResource.getFactoryClass()));
        attributeList.add(new Attribute("jdbc-resource-jndi-name", persistenceManagerFactoryResource.getJdbcResourceJndiName()));
        attributeList.add(new Attribute("enabled", persistenceManagerFactoryResource.getEnabled()));
        attributeList.add(new Attribute("description", persistenceManagerFactoryResource.getDescription()));
        return attributeList;
    }

    public static AttributeList getResourceAttributes(AdminObjectResource adminObjectResource) {
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("jndi-name", adminObjectResource.getJndiName()));
        attributeList.add(new Attribute("description", adminObjectResource.getDescription()));
        attributeList.add(new Attribute("enabled", adminObjectResource.getEnabled()));
        attributeList.add(new Attribute("res-type", adminObjectResource.getResType()));
        attributeList.add(new Attribute("res-adapter", adminObjectResource.getResAdapter()));
        return attributeList;
    }

    public static AttributeList getResourceAttributes(ConnectorResource connectorResource) {
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("jndi-name", connectorResource.getJndiName()));
        attributeList.add(new Attribute("pool-name", connectorResource.getPoolName()));
        attributeList.add(new Attribute("description", connectorResource.getDescription()));
        attributeList.add(new Attribute("enabled", connectorResource.getEnabled()));
        return attributeList;
    }

    public static AttributeList getResourceAttributes(ConnectorConnectionPool connectorConnectionPool) {
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("name", connectorConnectionPool.getName()));
        attributeList.add(new Attribute("resource-adapter-name", connectorConnectionPool.getResourceAdapterName()));
        attributeList.add(new Attribute("connection-definition-name", connectorConnectionPool.getConnectionDefinitionName()));
        return attributeList;
    }

    public static AttributeList getResourceAttributes(MailResource mailResource) {
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("jndi-name", mailResource.getJndiName()));
        attributeList.add(new Attribute("store-protocol", mailResource.getStoreProtocol()));
        attributeList.add(new Attribute("store-protocol-class", mailResource.getStoreProtocolClass()));
        attributeList.add(new Attribute("transport-protocol", mailResource.getTransportProtocol()));
        attributeList.add(new Attribute("transport-protocol-class", mailResource.getTransportProtocolClass()));
        attributeList.add(new Attribute("host", mailResource.getHost()));
        attributeList.add(new Attribute("user", mailResource.getUser()));
        attributeList.add(new Attribute("from", mailResource.getFrom()));
        attributeList.add(new Attribute("debug", mailResource.getDebug()));
        attributeList.add(new Attribute("enabled", mailResource.getEnabled()));
        attributeList.add(new Attribute("description", mailResource.getDescription()));
        return attributeList;
    }

    public static AttributeList getResourceAttributes(JmsResource jmsResource) {
        AttributeList attributeList = new AttributeList();
        attributeList.add(new Attribute("jndi_name", jmsResource.getJndiName()));
        attributeList.add(new Attribute("res-type", jmsResource.getResType()));
        attributeList.add(new Attribute("enabled", jmsResource.getEnabled()));
        attributeList.add(new Attribute("description", jmsResource.getDescription()));
        return attributeList;
    }

    private static Properties getProperties(PropertyElement[] propertyElementArray) throws Exception {
        Properties properties = new Properties();
        for (int i = 0; i < propertyElementArray.length; ++i) {
            String string = propertyElementArray[i].getName();
            String string2 = propertyElementArray[i].getValue();
            if (string2 == null || string2.trim().length() == 0) continue;
            properties.put(string, string2);
        }
        return properties;
    }

    public List getTargetServers() {
        String[] stringArray = InstanceProperties.getInstanceList();
        ArrayList<DeploymentManager> arrayList = new ArrayList<DeploymentManager>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].startsWith("deployer:Sun:AppServer::")) {
                arrayList.add(InstanceProperties.getInstanceProperties((String)stringArray[i]).getDeploymentManager());
                continue;
            }
            if (!stringArray[i].startsWith("[")) continue;
            arrayList.add(InstanceProperties.getInstanceProperties((String)stringArray[i]).getDeploymentManager());
        }
        return arrayList;
    }

    public static void saveConnPoolDatatoXml(ResourceConfigData resourceConfigData) {
        Resources resources = ResourceUtils.getServerResourcesGraph(resourceConfigData.getTargetFileObject());
        ResourceUtils.saveConnPoolDatatoXml(resourceConfigData, resources);
    }

    public static void saveConnPoolDatatoXml(ResourceConfigData resourceConfigData, Resources resources) {
        try {
            Vector vector = resourceConfigData.getProperties();
            JdbcConnectionPool jdbcConnectionPool = resources.newJdbcConnectionPool();
            String[] stringArray = resourceConfigData.getFieldNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                String string = stringArray[i];
                if (string.equals("properties")) {
                    object = resourceConfigData.getProperties();
                    for (int j = 0; j < ((Vector)object).size(); ++j) {
                        NameValuePair nameValuePair = (NameValuePair)((Vector)object).elementAt(j);
                        PropertyElement propertyElement = jdbcConnectionPool.newPropertyElement();
                        propertyElement = ResourceUtils.populatePropertyElement(propertyElement, nameValuePair);
                        jdbcConnectionPool.addPropertyElement(propertyElement);
                    }
                    continue;
                }
                object = resourceConfigData.getString(string);
                if (string.equals("name")) {
                    jdbcConnectionPool.setName((String)object);
                    resourceConfigData.setTargetFile((String)object);
                    continue;
                }
                if (string.equals("datasource-classname")) {
                    jdbcConnectionPool.setDatasourceClassname((String)object);
                    continue;
                }
                if (string.equals("res-type")) {
                    jdbcConnectionPool.setResType((String)object);
                    continue;
                }
                if (string.equals("steady-pool-size")) {
                    jdbcConnectionPool.setSteadyPoolSize((String)object);
                    continue;
                }
                if (string.equals("max-pool-size")) {
                    jdbcConnectionPool.setMaxPoolSize((String)object);
                    continue;
                }
                if (string.equals("max-wait-time-in-millis")) {
                    jdbcConnectionPool.setMaxWaitTimeInMillis((String)object);
                    continue;
                }
                if (string.equals("pool-resize-quantity")) {
                    jdbcConnectionPool.setPoolResizeQuantity((String)object);
                    continue;
                }
                if (string.equals("idle-timeout-in-seconds")) {
                    jdbcConnectionPool.setIdleTimeoutInSeconds((String)object);
                    continue;
                }
                if (string.equals("transaction-isolation-level")) {
                    String string2 = ResourceBundle.getBundle("org/netbeans/modules/j2ee/sun/ide/editors/Bundle").getString("LBL_driver_default");
                    if (((String)object).equals(string2)) {
                        object = null;
                    }
                    jdbcConnectionPool.setTransactionIsolationLevel((String)object);
                    continue;
                }
                if (string.equals("is-isolation-level-guaranteed")) {
                    jdbcConnectionPool.setIsIsolationLevelGuaranteed((String)object);
                    continue;
                }
                if (string.equals("is-connection-validation-required")) {
                    jdbcConnectionPool.setIsConnectionValidationRequired((String)object);
                    continue;
                }
                if (string.equals("connection-validation-method")) {
                    jdbcConnectionPool.setConnectionValidationMethod((String)object);
                    continue;
                }
                if (string.equals("validation-table-name")) {
                    jdbcConnectionPool.setValidationTableName((String)object);
                    continue;
                }
                if (string.equals("fail-all-connections")) {
                    jdbcConnectionPool.setFailAllConnections((String)object);
                    continue;
                }
                if (string.equals("description")) {
                    jdbcConnectionPool.setDescription((String)object);
                    continue;
                }
                if (string.equals("non-transactional-connections")) {
                    jdbcConnectionPool.setNonTransactionalConnections((String)object);
                    continue;
                }
                if (!string.equals("allow-non-component-callers")) continue;
                jdbcConnectionPool.setAllowNonComponentCallers((String)object);
            }
            resources.addJdbcConnectionPool(jdbcConnectionPool);
            ResourceUtils.createFile(resourceConfigData.getTargetFileObject(), resources);
        }
        catch (Exception exception) {
            System.out.println("Unable to saveConnPoolDatatoXml ");
        }
    }

    public static void saveJDBCResourceDatatoXml(ResourceConfigData resourceConfigData, ResourceConfigData resourceConfigData2) {
        try {
            Resources resources = ResourceUtils.getServerResourcesGraph(resourceConfigData.getTargetFileObject());
            JdbcResource jdbcResource = resources.newJdbcResource();
            String[] stringArray = resourceConfigData.getFieldNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                String string = stringArray[i];
                if (string.equals("properties")) {
                    object = resourceConfigData.getProperties();
                    for (int j = 0; j < ((Vector)object).size(); ++j) {
                        NameValuePair nameValuePair = (NameValuePair)((Vector)object).elementAt(j);
                        PropertyElement propertyElement = jdbcResource.newPropertyElement();
                        propertyElement = ResourceUtils.populatePropertyElement(propertyElement, nameValuePair);
                        jdbcResource.addPropertyElement(propertyElement);
                    }
                    continue;
                }
                object = resourceConfigData.getString(string);
                if (string.equals("jndi-name")) {
                    jdbcResource.setJndiName((String)object);
                    resourceConfigData.setTargetFile((String)object);
                    continue;
                }
                if (string.equals("pool-name")) {
                    jdbcResource.setPoolName((String)object);
                    continue;
                }
                if (string.equals("object-type")) {
                    jdbcResource.setObjectType((String)object);
                    continue;
                }
                if (string.equals("enabled")) {
                    jdbcResource.setEnabled((String)object);
                    continue;
                }
                if (!string.equals("description")) continue;
                jdbcResource.setDescription((String)object);
            }
            resources.addJdbcResource(jdbcResource);
            if (resourceConfigData2 != null) {
                ResourceUtils.saveConnPoolDatatoXml(resourceConfigData2, resources);
            }
            ResourceUtils.createFile(resourceConfigData.getTargetFileObject(), resources);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to saveJDBCResourceDatatoXml ");
        }
    }

    public static void savePMFResourceDatatoXml(ResourceConfigData resourceConfigData, ResourceConfigData resourceConfigData2, ResourceConfigData resourceConfigData3) {
        try {
            Resources resources = ResourceUtils.getServerResourcesGraph(resourceConfigData.getTargetFileObject());
            PersistenceManagerFactoryResource persistenceManagerFactoryResource = resources.newPersistenceManagerFactoryResource();
            String[] stringArray = resourceConfigData.getFieldNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                String string = stringArray[i];
                if (string.equals("properties")) {
                    object = resourceConfigData.getProperties();
                    for (int j = 0; j < ((Vector)object).size(); ++j) {
                        NameValuePair nameValuePair = (NameValuePair)((Vector)object).elementAt(j);
                        PropertyElement propertyElement = persistenceManagerFactoryResource.newPropertyElement();
                        propertyElement = ResourceUtils.populatePropertyElement(propertyElement, nameValuePair);
                        persistenceManagerFactoryResource.addPropertyElement(propertyElement);
                    }
                    continue;
                }
                object = resourceConfigData.getString(string);
                if (string.equals("jndi-name")) {
                    persistenceManagerFactoryResource.setJndiName((String)object);
                    resourceConfigData.setTargetFile((String)object);
                    continue;
                }
                if (string.equals("factory-class")) {
                    persistenceManagerFactoryResource.setFactoryClass((String)object);
                    continue;
                }
                if (string.equals("jdbc-resource-jndi-name")) {
                    persistenceManagerFactoryResource.setJdbcResourceJndiName((String)object);
                    continue;
                }
                if (string.equals("enabled")) {
                    persistenceManagerFactoryResource.setEnabled((String)object);
                    continue;
                }
                if (!string.equals("description")) continue;
                persistenceManagerFactoryResource.setDescription((String)object);
            }
            resources.addPersistenceManagerFactoryResource(persistenceManagerFactoryResource);
            ResourceUtils.createFile(resourceConfigData.getTargetFileObject(), resources);
            if (resourceConfigData2 != null) {
                ResourceUtils.saveJDBCResourceDatatoXml(resourceConfigData2, resourceConfigData3);
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to savePMFResourceDatatoXml ");
        }
    }

    public static void saveJMSResourceDatatoXml(ResourceConfigData resourceConfigData) {
        try {
            Resources resources = ResourceUtils.getServerResourcesGraph(resourceConfigData.getTargetFileObject());
            String string = resourceConfigData.getString("res-type");
            if (string.equals("javax.jms.Queue") || string.equals("javax.jms.Topic")) {
                AdminObjectResource adminObjectResource = resources.newAdminObjectResource();
                adminObjectResource.setDescription(resourceConfigData.getString("description"));
                adminObjectResource.setEnabled(resourceConfigData.getString("enabled"));
                adminObjectResource.setJndiName(resourceConfigData.getString("jndi-name"));
                adminObjectResource.setResType(resourceConfigData.getString("res-type"));
                adminObjectResource.setResAdapter("jmsra");
                Vector vector = resourceConfigData.getProperties();
                for (int i = 0; i < vector.size(); ++i) {
                    NameValuePair nameValuePair = (NameValuePair)vector.elementAt(i);
                    PropertyElement propertyElement = adminObjectResource.newPropertyElement();
                    propertyElement = ResourceUtils.populatePropertyElement(propertyElement, nameValuePair);
                    adminObjectResource.addPropertyElement(propertyElement);
                }
                resources.addAdminObjectResource(adminObjectResource);
            } else {
                ConnectorResource connectorResource = resources.newConnectorResource();
                connectorResource.setDescription(resourceConfigData.getString("description"));
                connectorResource.setEnabled(resourceConfigData.getString("enabled"));
                connectorResource.setJndiName(resourceConfigData.getString("jndi-name"));
                connectorResource.setPoolName(resourceConfigData.getString("jndi-name"));
                ConnectorConnectionPool connectorConnectionPool = resources.newConnectorConnectionPool();
                connectorConnectionPool.setName(resourceConfigData.getString("jndi-name"));
                connectorConnectionPool.setConnectionDefinitionName(resourceConfigData.getString("res-type"));
                connectorConnectionPool.setResourceAdapterName("jmsra");
                Vector vector = resourceConfigData.getProperties();
                for (int i = 0; i < vector.size(); ++i) {
                    NameValuePair nameValuePair = (NameValuePair)vector.elementAt(i);
                    PropertyElement propertyElement = connectorConnectionPool.newPropertyElement();
                    propertyElement = ResourceUtils.populatePropertyElement(propertyElement, nameValuePair);
                    connectorConnectionPool.addPropertyElement(propertyElement);
                }
                resources.addConnectorResource(connectorResource);
                resources.addConnectorConnectionPool(connectorConnectionPool);
            }
            ResourceUtils.createFile(resourceConfigData.getTargetFileObject(), resources);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Unable to saveJMSResourceDatatoXml ");
        }
    }

    public static void saveMailResourceDatatoXml(ResourceConfigData resourceConfigData) {
        try {
            Vector vector = resourceConfigData.getProperties();
            Resources resources = ResourceUtils.getServerResourcesGraph(resourceConfigData.getTargetFileObject());
            MailResource mailResource = resources.newMailResource();
            String[] stringArray = resourceConfigData.getFieldNames();
            for (int i = 0; i < stringArray.length; ++i) {
                Object object;
                String string = stringArray[i];
                if (string.equals("properties")) {
                    object = resourceConfigData.getProperties();
                    for (int j = 0; j < ((Vector)object).size(); ++j) {
                        NameValuePair nameValuePair = (NameValuePair)((Vector)object).elementAt(j);
                        PropertyElement propertyElement = mailResource.newPropertyElement();
                        propertyElement = ResourceUtils.populatePropertyElement(propertyElement, nameValuePair);
                        mailResource.addPropertyElement(propertyElement);
                    }
                    continue;
                }
                object = resourceConfigData.getString(string);
                if (string.equals("jndi-name")) {
                    mailResource.setJndiName((String)object);
                    resourceConfigData.setTargetFile((String)object);
                    continue;
                }
                if (string.equals("store-protocol")) {
                    mailResource.setStoreProtocol((String)object);
                    continue;
                }
                if (string.equals("store-protocol-class")) {
                    mailResource.setStoreProtocolClass((String)object);
                    continue;
                }
                if (string.equals("transport-protocol")) {
                    mailResource.setTransportProtocol((String)object);
                    continue;
                }
                if (string.equals("transport-protocol-class")) {
                    mailResource.setTransportProtocolClass((String)object);
                    continue;
                }
                if (string.equals("host")) {
                    mailResource.setHost((String)object);
                    continue;
                }
                if (string.equals("user")) {
                    mailResource.setUser((String)object);
                    continue;
                }
                if (string.equals("from")) {
                    mailResource.setFrom((String)object);
                    continue;
                }
                if (string.equals("debug")) {
                    mailResource.setDebug((String)object);
                    continue;
                }
                if (!string.equals("description")) continue;
                mailResource.setDescription((String)object);
            }
            resources.addMailResource(mailResource);
            ResourceUtils.createFile(resourceConfigData.getTargetFileObject(), resources);
        }
        catch (Exception exception) {
            System.out.println("Unable to saveMailResourceDatatoXml ");
        }
    }

    public static String createUniqueFileName(String string, FileObject fileObject, String string2) {
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            string3 = string2;
        }
        string3 = ResourceUtils.makeLegalFilename(string3);
        string3 = FileUtil.findFreeFileName((FileObject)fileObject, (String)string3, (String)"sun-resource");
        string3 = ResourceUtils.revertToResName(string3);
        return string3;
    }

    public static List getRegisteredConnectionPools(ResourceConfigData resourceConfigData) {
        List<String> list = new ArrayList();
        try {
            String string = "getJdbcConnectionPool";
            String string2 = "name";
            InstanceProperties instanceProperties = ResourceUtils.getTargetServer(resourceConfigData.getTargetFileObject());
            if (instanceProperties != null) {
                list = ResourceUtils.getResourceNames(instanceProperties, string, string2);
            }
            list.removeAll(Arrays.asList(sysConnpools));
            List list2 = ResourceUtils.getProjectResources(resourceConfigData, "connectionPool");
            for (int i = 0; i < list2.size(); ++i) {
                String string3 = list2.get(i).toString();
                if (list.contains(string3)) continue;
                list.add(string3);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return list;
    }

    public static List getRegisteredJdbcResources(ResourceConfigData resourceConfigData) {
        List<String> list = new ArrayList();
        try {
            String string = "jndi-name";
            InstanceProperties instanceProperties = ResourceUtils.getTargetServer(resourceConfigData.getTargetFileObject());
            if (instanceProperties != null) {
                list = ResourceUtils.getResourceNames(instanceProperties, "getJdbcResource", string);
            }
            list.removeAll(Arrays.asList(sysDatasources));
            List list2 = ResourceUtils.getProjectResources(resourceConfigData, "jdbc/myDatasource");
            for (int i = 0; i < list2.size(); ++i) {
                String string2 = list2.get(i).toString();
                if (list.contains(string2)) continue;
                list.add(string2);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return list;
    }

    private static List getResourceNames(InstanceProperties instanceProperties, String string, String string2) {
        List list;
        DeploymentManager deploymentManager = instanceProperties.getDeploymentManager();
        if (deploymentManager instanceof SunDeploymentManagerInterface) {
            SunDeploymentManagerInterface sunDeploymentManagerInterface = (SunDeploymentManagerInterface)deploymentManager;
            list = ResourceUtils.getResourceNames(sunDeploymentManagerInterface, string, string2);
        } else {
            list = Collections.EMPTY_LIST;
        }
        return list;
    }

    private static List getResourceNames(SunDeploymentManagerInterface sunDeploymentManagerInterface, String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string3 = MAP_RESOURCES;
        try {
            ServerInterface serverInterface = sunDeploymentManagerInterface.getManagement();
            ObjectName objectName = new ObjectName(string3);
            ObjectName[] objectNameArray = (ObjectName[])serverInterface.invoke(objectName, string, null, null);
            for (int i = 0; i < objectNameArray.length; ++i) {
                String string4 = objectNameArray[i].getKeyProperty(string2);
                arrayList.add(string4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    private static List getProjectResources(ResourceConfigData resourceConfigData, String string) {
        List list = new ArrayList();
        FileObject fileObject = resourceConfigData.getTargetFileObject();
        if (fileObject != null) {
            FileObject fileObject2 = ResourceUtils.setUpExists(fileObject);
            Enumeration enumeration = fileObject2.getData(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject3 = (FileObject)enumeration.nextElement();
                File file = FileUtil.toFile((FileObject)fileObject3);
                if (string.equals("connectionPool")) {
                    list = ResourceUtils.filterConnectionPools(file, list);
                    continue;
                }
                list = ResourceUtils.filterDataSources(file, list);
            }
        }
        return list;
    }

    private static List filterConnectionPools(File file, List list) {
        try {
            if (!file.isDirectory()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)fileInputStream);
                JdbcConnectionPool[] jdbcConnectionPoolArray = resources.getJdbcConnectionPool();
                for (int i = 0; i < jdbcConnectionPoolArray.length; ++i) {
                    list.add(jdbcConnectionPoolArray[i].getName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    private static List filterDataSources(File file, List list) {
        try {
            if (!file.isDirectory()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                Resources resources = DDProvider.getDefault().getResourcesGraph((InputStream)fileInputStream);
                JdbcResource[] jdbcResourceArray = resources.getJdbcResource();
                for (int i = 0; i < jdbcResourceArray.length; ++i) {
                    list.add(jdbcResourceArray[i].getJndiName());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    public static FileObject setUpExists(FileObject fileObject) {
        FileObject fileObject2 = ResourceUtils.getResourceDirectory(fileObject);
        if (fileObject2 == null) {
            return fileObject;
        }
        return fileObject2;
    }

    private static Resources getResourceGraph() {
        return DDProvider.getDefault().getResourcesGraph();
    }

    private static PropertyElement populatePropertyElement(PropertyElement propertyElement, NameValuePair nameValuePair) {
        propertyElement.setName(nameValuePair.getParamName());
        propertyElement.setValue(nameValuePair.getParamValue());
        return propertyElement;
    }

    public static boolean isLegalFilename(String string) {
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            if (string.indexOf(ILLEGAL_FILENAME_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isFriendlyFilename(String string) {
        if (string.indexOf(32) >= 0 || string.indexOf(46) >= 0) {
            return false;
        }
        return ResourceUtils.isLegalFilename(string);
    }

    public static String makeLegalFilename(String string) {
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length; ++i) {
            string = string.replace(ILLEGAL_FILENAME_CHARS[i], '_');
        }
        return string;
    }

    public static boolean isLegalResourceName(String string) {
        for (int i = 0; i < ILLEGAL_RESOURCE_NAME_CHARS.length; ++i) {
            if (string.indexOf(ILLEGAL_RESOURCE_NAME_CHARS[i]) < 0) continue;
            return false;
        }
        return true;
    }

    public static FileObject getResourceDirectory(FileObject fileObject) {
        File file;
        J2eeModuleProvider j2eeModuleProvider;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        FileObject fileObject2 = null;
        if (project != null && (j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null && (file = j2eeModuleProvider.getJ2eeModule().getResourceDirectory()) != null) {
            if (file.exists()) {
                fileObject2 = FileUtil.toFileObject((File)file);
            } else {
                try {
                    fileObject2 = FileUtil.createFolder((File)file);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
        return fileObject2;
    }

    private static DeploymentManager getDeploymentManager(J2eeModuleProvider j2eeModuleProvider) {
        DeploymentManager deploymentManager = null;
        InstanceProperties instanceProperties = j2eeModuleProvider.getInstanceProperties();
        if (instanceProperties != null) {
            deploymentManager = instanceProperties.getDeploymentManager();
        }
        return deploymentManager;
    }

    public static void createSampleDataSource(J2eeModuleProvider j2eeModuleProvider) {
        DeploymentManager deploymentManager = ResourceUtils.getDeploymentManager(j2eeModuleProvider);
        if (deploymentManager != null) {
            SunDeploymentManagerInterface sunDeploymentManagerInterface = (SunDeploymentManagerInterface)deploymentManager;
            try {
                ObjectName objectName = new ObjectName(MAP_RESOURCES);
                if (sunDeploymentManagerInterface.isRunning()) {
                    ResourceUtils.updateSampleDatasource(sunDeploymentManagerInterface, objectName);
                } else {
                    sunDeploymentManagerInterface.createSampleDataSourceinDomain();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static HashSet getServerDataSources(DeploymentManager deploymentManager) {
        HashSet hashSet = new HashSet();
        try {
            ObjectName objectName = new ObjectName(MAP_RESOURCES);
            SunDeploymentManagerInterface sunDeploymentManagerInterface = (SunDeploymentManagerInterface)deploymentManager;
            ServerInterface serverInterface = sunDeploymentManagerInterface.getManagement();
            List<String> list = Arrays.asList(sysDatasources);
            if (sunDeploymentManagerInterface.isRunning()) {
                ResourceUtils.updateSampleDatasource(sunDeploymentManagerInterface, objectName);
                ObjectName[] objectNameArray = (ObjectName[])serverInterface.invoke(objectName, "getJdbcResource", null, null);
                for (int i = 0; i < objectNameArray.length; ++i) {
                    String string;
                    HashMap hashMap;
                    ObjectName objectName2 = objectNameArray[i];
                    String string2 = (String)serverInterface.getAttribute(objectName2, "jndi-name");
                    if (list.contains(string2) || (hashMap = ResourceUtils.fillInPoolValues(sunDeploymentManagerInterface, objectName, string = (String)serverInterface.getAttribute(objectName2, "pool-name"))).isEmpty()) continue;
                    String string3 = (String)hashMap.get("User");
                    String string4 = (String)hashMap.get("Password");
                    String string5 = (String)hashMap.get("URL");
                    String string6 = (String)hashMap.get("driverClass");
                    SunDatasource sunDatasource = new SunDatasource(string2, string5, string3, string4, string6);
                    hashSet.add(sunDatasource);
                }
            } else if (sunDeploymentManagerInterface.isLocal()) {
                hashSet = ResourceUtils.formatXmlSunDatasources(sunDeploymentManagerInterface.getSunDatasourcesFromXml());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashSet;
    }

    private static void updateSampleDatasource(SunDeploymentManagerInterface sunDeploymentManagerInterface, ObjectName objectName) {
        try {
            if (!sunDeploymentManagerInterface.isLocal()) {
                return;
            }
            List list = ResourceUtils.getResourceNames(sunDeploymentManagerInterface, "getJdbcResource", "jndi-name");
            if (!list.contains(SAMPLE_DATASOURCE)) {
                Object[] objectArray;
                AttributeList attributeList;
                ServerInterface serverInterface = sunDeploymentManagerInterface.getManagement();
                if (ResourceUtils.getConnectionPoolObjByName(serverInterface, objectName, SAMPLE_CONNPOOL) == null) {
                    attributeList = new AttributeList();
                    objectArray = new Attribute("name", SAMPLE_CONNPOOL);
                    attributeList.add((Attribute)objectArray);
                    objectArray = new Attribute("datasource-classname", "org.apache.derby.jdbc.ClientDataSource");
                    attributeList.add((Attribute)objectArray);
                    objectArray = new Attribute("res-type", "javax.sql.DataSource");
                    attributeList.add((Attribute)objectArray);
                    Properties properties = new Properties();
                    properties.put("User", "app");
                    properties.put("Password", "app");
                    properties.put("serverName", "localhost");
                    properties.put("PortNumber", "1527");
                    properties.put("DatabaseName", "sample");
                    properties.put("URL", "jdbc:derby://localhost:1527/sample");
                    Object[] objectArray2 = new Object[]{attributeList, properties, null};
                    ResourceUtils.createResource("createJdbcConnectionPool", objectArray2, serverInterface);
                }
                attributeList = new AttributeList();
                attributeList.add(new Attribute("jndi-name", SAMPLE_DATASOURCE));
                attributeList.add(new Attribute("pool-name", SAMPLE_CONNPOOL));
                attributeList.add(new Attribute("object-type", "user"));
                attributeList.add(new Attribute("enabled", "true"));
                objectArray = new Object[]{attributeList, new Properties(), null};
                ResourceUtils.createResource("createJdbcResource", objectArray, serverInterface);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static HashMap fillInPoolValues(SunDeploymentManagerInterface sunDeploymentManagerInterface, ObjectName objectName, String string) throws Exception {
        String string2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ServerInterface serverInterface = sunDeploymentManagerInterface.getManagement();
        ObjectName objectName2 = ResourceUtils.getConnectionPoolByName(serverInterface, objectName, string);
        String string3 = (String)serverInterface.getAttribute(objectName2, "datasource-classname");
        String string4 = (String)serverInterface.getAttribute(objectName2, "res-type");
        String string5 = "";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "";
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        String string15 = "";
        AttributeList attributeList = (AttributeList)serverInterface.invoke(objectName2, "getProperties", null, null);
        HashMap hashMap2 = ResourceUtils.getObjMap(attributeList);
        Object[] objectArray = hashMap2.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            string2 = (String)objectArray[i];
            if (string2.equalsIgnoreCase("databaseName")) {
                if (string3.indexOf("pointbase") != -1) {
                    string5 = ResourceUtils.getStringVal(hashMap2.get(string2));
                    continue;
                }
                string10 = ResourceUtils.getStringVal(hashMap2.get(string2));
                continue;
            }
            if (string2.equalsIgnoreCase("User")) {
                string6 = ResourceUtils.getStringVal(hashMap2.get(string2));
                continue;
            }
            if (string2.equalsIgnoreCase("Password")) {
                string7 = ResourceUtils.getStringVal(hashMap2.get(string2));
                continue;
            }
            if (string2.equalsIgnoreCase("URL")) {
                string5 = ResourceUtils.getStringVal(hashMap2.get(string2));
                continue;
            }
            if (string2.equalsIgnoreCase("serverName")) {
                string8 = ResourceUtils.getStringVal(hashMap2.get(string2));
                continue;
            }
            if (string2.equalsIgnoreCase("PortNumber")) {
                string9 = ResourceUtils.getStringVal(hashMap2.get(string2));
                continue;
            }
            if (string2.equalsIgnoreCase("SID")) {
                string11 = ResourceUtils.getStringVal(hashMap2.get(string2));
                continue;
            }
            if (string2.equalsIgnoreCase("driverClass")) {
                string12 = ResourceUtils.getStringVal(hashMap2.get(string2));
                continue;
            }
            if (string2.equalsIgnoreCase("InformixServer")) {
                string13 = ResourceUtils.getStringVal(hashMap2.get(string2));
                continue;
            }
            if (string2.equalsIgnoreCase("IfxIFXHOST")) {
                string14 = ResourceUtils.getStringVal(hashMap2.get(string2));
                continue;
            }
            if (!string2.equalsIgnoreCase("connectionAttributes")) continue;
            string15 = ResourceUtils.getStringVal(hashMap2.get(string2));
        }
        if (string5 == null || string5.equals("")) {
            if (string3.indexOf("derby") != -1) {
                string5 = "jdbc:derby://";
                if (string8 != null) {
                    string5 = string5 + string8;
                    if (string9 != null && string9.length() > 0) {
                        string5 = string5 + ":" + string9;
                    }
                    string5 = string5 + "/" + string10;
                    if (string15 != null && !string15.equals("")) {
                        string5 = string5 + string15;
                    }
                }
            } else if (string5.equals("")) {
                String string16 = DatabaseUtils.getUrlPrefix(string3, string4);
                string2 = ResourceConfigurator.getDatabaseVendorName(string16, null);
                if (string8 != null) {
                    if (string2.equals("sybase2")) {
                        string5 = string16 + string8;
                    }
                    string5 = string2.equals("informix") ? string16 + "//" + string14 : string16 + "//" + string8;
                    if (string9 != null && string9.length() > 0) {
                        string5 = string5 + ":" + string9;
                    }
                }
                if (string2.equals("sun_oracle") || string2.equals("datadirect_oracle")) {
                    string5 = string5 + ";SID=" + string11;
                } else if (Arrays.asList(Reqd_DBName).contains(string2)) {
                    string5 = string5 + ";databaseName=" + string10;
                } else if (Arrays.asList(VendorsDBNameProp).contains(string2)) {
                    string5 = string5 + "/" + string10;
                }
                if (string2.equals("informix")) {
                    string5 = string5 + ":INFORMIXSERVER=" + string8;
                } else if (string2.equals("datadirect_informix")) {
                    string5 = string5 + ";InformixServer=" + string13;
                }
            }
        }
        if (!sunDeploymentManagerInterface.isLocal() && string5.indexOf("localhost") != -1) {
            String string17 = sunDeploymentManagerInterface.getHost();
            string5 = string5.replaceFirst("localhost", string17);
        }
        DatabaseConnection databaseConnection = ResourceUtils.getDatabaseConnection(string5);
        if (string12 == null || string12.equals("")) {
            if (databaseConnection != null) {
                string12 = databaseConnection.getDriverClass();
            } else {
                string2 = DatabaseUtils.getDriverName(string5);
                if (string2 != null) {
                    string12 = string2;
                }
            }
        }
        hashMap.put("User", string6);
        hashMap.put("Password", string7);
        hashMap.put("URL", string5);
        hashMap.put("driverClass", string12);
        return hashMap;
    }

    private static ObjectName getConnectionPoolByName(ServerInterface serverInterface, ObjectName objectName, String string) throws Exception {
        String[] stringArray = new String[]{"java.lang.String"};
        Object[] objectArray = new Object[]{string};
        ObjectName objectName2 = (ObjectName)serverInterface.invoke(objectName, "getJdbcConnectionPoolByName", objectArray, stringArray);
        return objectName2;
    }

    private static ObjectName getConnectionPoolObjByName(ServerInterface serverInterface, ObjectName objectName, String string) {
        ObjectName objectName2 = null;
        try {
            objectName2 = ResourceUtils.getConnectionPoolByName(serverInterface, objectName, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objectName2;
    }

    private static String getStringVal(Object object) {
        String string = null;
        if (object != null) {
            string = object.toString();
        }
        return string;
    }

    private static HashMap getObjMap(AttributeList attributeList) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < attributeList.size(); ++i) {
            Attribute attribute = (Attribute)attributeList.get(i);
            String string = attribute.getName();
            Object object = attribute.getValue();
            hashMap.put(string, object);
        }
        return hashMap;
    }

    public static String revertToResName(String string) {
        if (string.indexOf("jdbc_") != -1) {
            string = string.replaceFirst("jdbc_", "jdbc/");
        }
        if (string.indexOf("mail_") != -1) {
            string = string.replaceFirst("mail_", "mail/");
        }
        if (string.indexOf("jms_") != -1) {
            string = string.replaceFirst("jms_", "jms/");
        }
        return string;
    }

    public static boolean isUniqueFileName(String string, FileObject fileObject, String string2) {
        boolean bl = true;
        String string3 = string;
        if (string3 != null && string3.length() != 0) {
            string3 = ResourceUtils.makeLegalFilename(string3);
            string3 = string3 + "." + "sun-resource";
            File file = new File(fileObject.getPath(), string3);
            if (file.exists()) {
                bl = false;
            }
        }
        return bl;
    }

    public static DatabaseConnection getDatabaseConnection(String string) {
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            String string2 = databaseConnectionArray[i].getDatabaseURL();
            if (!string2.startsWith(string)) continue;
            return databaseConnectionArray[i];
        }
        return null;
    }

    public static InstanceProperties getTargetServer(FileObject fileObject) {
        J2eeModuleProvider j2eeModuleProvider;
        InstanceProperties instanceProperties = null;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null) {
            instanceProperties = j2eeModuleProvider.getInstanceProperties();
        }
        return instanceProperties;
    }

    public static HashMap getConnPoolValues(File file, String string) {
        HashMap hashMap = new HashMap();
        try {
            ObjectName objectName = new ObjectName(MAP_RESOURCES);
            InstanceProperties instanceProperties = ResourceUtils.getTargetServer(FileUtil.toFileObject((File)file));
            if (instanceProperties != null) {
                SunDeploymentManagerInterface sunDeploymentManagerInterface = (SunDeploymentManagerInterface)instanceProperties.getDeploymentManager();
                if (sunDeploymentManagerInterface.isRunning()) {
                    ServerInterface serverInterface = sunDeploymentManagerInterface.getManagement();
                    hashMap = ResourceUtils.fillInPoolValues(sunDeploymentManagerInterface, objectName, string);
                } else if (sunDeploymentManagerInterface.isLocal()) {
                    HashMap hashMap2 = sunDeploymentManagerInterface.getConnPoolsFromXml();
                    hashMap = ResourceUtils.formatPoolMap((HashMap)hashMap2.get(string));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashMap;
    }

    public static HashSet formatXmlSunDatasources(HashMap hashMap) {
        HashSet<SunDatasource> hashSet = new HashSet<SunDatasource>();
        String[] stringArray = hashMap.keySet().toArray(new String[hashMap.size()]);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            HashMap hashMap2 = (HashMap)hashMap.get(string);
            hashMap2 = ResourceUtils.formatPoolMap(hashMap2);
            String string2 = ResourceUtils.getStringVal(hashMap2.get("URL"));
            String string3 = ResourceUtils.getStringVal(hashMap2.get("User"));
            String string4 = ResourceUtils.getStringVal(hashMap2.get("Password"));
            String string5 = ResourceUtils.getStringVal(hashMap2.get("driverClass"));
            if (string2 == null || string2.equals("")) continue;
            SunDatasource sunDatasource = new SunDatasource(string, string2, string3, string4, string5);
            hashSet.add(sunDatasource);
        }
        return hashSet;
    }

    private static HashMap formatPoolMap(HashMap hashMap) {
        String string;
        String string2;
        String string3 = ResourceUtils.getStringVal(hashMap.get("dsClassName"));
        String string4 = ResourceUtils.getStringVal(hashMap.get("resType"));
        String string5 = "";
        String string6 = ResourceUtils.getStringVal(hashMap.get("serverName"));
        String string7 = ResourceUtils.getStringVal(hashMap.get("PortNumber"));
        String string8 = ResourceUtils.getStringVal(hashMap.get("DatabaseName"));
        String string9 = ResourceUtils.getStringVal(hashMap.get("databaseName"));
        String string10 = ResourceUtils.getStringVal(hashMap.get("portNumber"));
        String string11 = ResourceUtils.getStringVal(hashMap.get("SID"));
        String string12 = ResourceUtils.getStringVal(hashMap.get("URL"));
        String string13 = ResourceUtils.getStringVal(hashMap.get("driverClass"));
        String string14 = ResourceUtils.getStringVal(hashMap.get("connectionAttributes"));
        if (string3.indexOf("pointbase") != -1) {
            string5 = ResourceUtils.getStringVal(hashMap.get("databaseName"));
        }
        if (string12 == null || string12.equals("")) {
            if (string3.indexOf("derby") != -1) {
                if (string6 != null) {
                    string5 = "jdbc:derby://" + string6;
                    if (string7 != null && string7.length() > 0) {
                        string5 = string5 + ":" + string7;
                    }
                    string5 = string5 + "/" + string8;
                    if (string14 != null && !string14.equals("")) {
                        string5 = string5 + string14;
                    }
                }
            } else {
                string2 = ResourceUtils.getStringVal(hashMap.get("URL"));
                if (string2 != null) {
                    string5 = string2;
                }
                if (string5.equals("")) {
                    string = DatabaseUtils.getUrlPrefix(string3, string4);
                    String string15 = ResourceConfigurator.getDatabaseVendorName(string, null);
                    if (string6 != null) {
                        string5 = string15.equals("sun_oracle") ? string + string6 : string + "//" + string6;
                        if (string10 != null && string10.length() > 0) {
                            string5 = string5 + ":" + string10;
                        }
                    }
                    if (string15.equals("sun_oracle") || string15.equals("datadirect_oracle")) {
                        string5 = string5 + ";SID=" + string11;
                    } else if (Arrays.asList(Reqd_DBName).contains(string15)) {
                        string5 = string5 + ";databaseName=" + string9;
                    } else if (Arrays.asList(VendorsDBNameProp).contains(string15)) {
                        string5 = string5 + "/" + string9;
                    }
                }
            }
        } else {
            string5 = string12;
        }
        if (string13 == null || string13.equals("")) {
            string2 = ResourceUtils.getDatabaseConnection(string5);
            if (string2 != null) {
                string13 = string2.getDriverClass();
            } else {
                string = DatabaseUtils.getDriverName(string5);
                if (string != null) {
                    string13 = string;
                }
            }
        }
        hashMap.put("URL", string5);
        hashMap.put("driverClass", string13);
        return hashMap;
    }

    public static HashSet getServerDestinations(DeploymentManager deploymentManager) {
        HashSet<SunMessageDestination> hashSet = new HashSet<SunMessageDestination>();
        try {
            ObjectName objectName = new ObjectName(MAP_RESOURCES);
            SunDeploymentManagerInterface sunDeploymentManagerInterface = (SunDeploymentManagerInterface)deploymentManager;
            ServerInterface serverInterface = sunDeploymentManagerInterface.getManagement();
            if (sunDeploymentManagerInterface.isRunning()) {
                ObjectName[] objectNameArray = (ObjectName[])serverInterface.invoke(objectName, "getAdminObjectResource", null, null);
                for (int i = 0; i < objectNameArray.length; ++i) {
                    ObjectName objectName2 = objectNameArray[i];
                    String string = (String)serverInterface.getAttribute(objectName2, "jndi-name");
                    String string2 = (String)serverInterface.getAttribute(objectName2, "res-type");
                    SunMessageDestination sunMessageDestination = null;
                    sunMessageDestination = string2.equals("javax.jms.Queue") ? new SunMessageDestination(string, MessageDestination.Type.QUEUE) : new SunMessageDestination(string, MessageDestination.Type.TOPIC);
                    hashSet.add(sunMessageDestination);
                }
            } else if (sunDeploymentManagerInterface.isLocal()) {
                HashMap hashMap = sunDeploymentManagerInterface.getAdminObjectResourcesFromXml();
                String[] stringArray = hashMap.keySet().toArray(new String[hashMap.size()]);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    String string3 = (String)hashMap.get(string);
                    SunMessageDestination sunMessageDestination = null;
                    sunMessageDestination = string3.equals("javax.jms.Queue") ? new SunMessageDestination(string, MessageDestination.Type.QUEUE) : new SunMessageDestination(string, MessageDestination.Type.TOPIC);
                    hashSet.add(sunMessageDestination);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashSet;
    }

    public static boolean is90Server(ServerInterface serverInterface) {
        boolean bl = true;
        SunDeploymentManagerInterface sunDeploymentManagerInterface = (SunDeploymentManagerInterface)serverInterface.getDeploymentManager();
        if (sunDeploymentManagerInterface.isLocal()) {
            bl = ResourceUtils.is90ServerLocal(sunDeploymentManagerInterface);
        } else {
            try {
                ObjectName objectName = new ObjectName("com.sun.appserv:j2eeType=J2EEServer,name=server,category=runtime");
                String string = (String)serverInterface.getAttribute(objectName, "serverVersion");
                if (string != null && string.indexOf("8.") != -1) {
                    bl = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private static boolean is90ServerLocal(SunDeploymentManagerInterface sunDeploymentManagerInterface) {
        boolean bl = true;
        try {
            bl = ServerLocationManager.isGlassFish(sunDeploymentManagerInterface.getPlatformRoot());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static Resources getServerResourcesGraph(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file.getParentFile());
        try {
            fileObject = FileUtil.createFolder((File)file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ResourceUtils.getServerResourcesGraph(fileObject);
    }

    public static Resources getServerResourcesGraph(FileObject fileObject) {
        Resources resources = ResourceUtils.getResourceGraph();
        File file = ResourceUtils.getServerResourcesFile(fileObject = ResourceUtils.setUpExists(fileObject));
        if (file != null) {
            resources = ResourceUtils.getResourcesGraph(file);
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resources getResourcesGraph(File file) {
        Resources resources = null;
        if (file != null) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                resources = DDProvider.getDefault().getResourcesGraph((InputStream)fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                ErrorManager.getDefault().notify(4096, (Throwable)fileNotFoundException);
            }
            finally {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                }
            }
        }
        return resources;
    }

    public static void createFile(File file, Resources resources) {
        ResourceUtils.createFile(FileUtil.toFileObject((File)file), resources);
    }

    public static void createFile(FileObject fileObject, Resources resources) {
        File file = ResourceUtils.getServerResourcesFile(fileObject = ResourceUtils.setUpExists(fileObject));
        if (file != null && file.exists()) {
            try {
                resources.write(file);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(4096, (Throwable)exception);
            }
        } else {
            ResourceUtils.writeServerResource(fileObject, resources);
        }
    }

    private static void writeServerResource(FileObject fileObject, final Resources resources) {
        try {
            final FileObject fileObject2 = fileObject;
            FileSystem fileSystem = fileObject.getFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileObject fileObject = fileObject2.createData("sun-resources", "xml");
                    FileLock fileLock = fileObject.lock();
                    Object var3_3 = null;
                    try {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF8");
                        resources.write((Writer)outputStreamWriter);
                        ((Writer)outputStreamWriter).flush();
                        ((Writer)outputStreamWriter).close();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        fileLock.releaseLock();
                    }
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(4096, (Throwable)exception);
        }
    }

    public static File getServerResourcesFile(FileObject fileObject) {
        File file = null;
        if (fileObject != null) {
            FileObject fileObject2 = ResourceUtils.setUpExists(fileObject);
            Enumeration enumeration = fileObject2.getData(false);
            while (enumeration.hasMoreElements()) {
                FileObject fileObject3 = (FileObject)enumeration.nextElement();
                File file2 = FileUtil.toFile((FileObject)fileObject3);
                if (!file2.getName().equals(SUN_RESOURCE_FILENAME)) continue;
                file = file2;
            }
        }
        return file;
    }

    public static void migrateResources(File file) {
        ResourceUtils.migrateResources(FileUtil.toFileObject((File)file));
    }

    public static void migrateResources(FileObject fileObject) {
        File file;
        File[] fileArray;
        fileObject = ResourceUtils.setUpExists(fileObject);
        File file2 = ResourceUtils.getServerResourcesFile(fileObject);
        boolean bl = false;
        if (!(file2 != null && file2.exists() || (fileArray = (file = FileUtil.toFile((FileObject)fileObject)).listFiles(new ResourceFileFilter())).length <= 0)) {
            Resources resources = DDProvider.getDefault().getResourcesGraph();
            try {
                for (int i = 0; i < fileArray.length; ++i) {
                    FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                    Resources resources2 = DDProvider.getDefault().getResourcesGraph((InputStream)fileInputStream);
                    resources = ResourceUtils.getResourceGraphs(resources, resources2);
                }
                ResourceUtils.createFile(fileObject, resources);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(4096, (Throwable)exception);
            }
        }
    }

    private static Resources getResourceGraphs(Resources resources, Resources resources2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        JdbcConnectionPool[] jdbcConnectionPoolArray = resources2.getJdbcConnectionPool();
        if (jdbcConnectionPoolArray.length != 0) {
            object6 = ConnPoolBean.createBean(jdbcConnectionPoolArray[0]);
            ((ConnPoolBean)object6).getBeanInGraph(resources);
        }
        if (((JdbcResource[])(object6 = resources2.getJdbcResource())).length != 0) {
            object5 = DataSourceBean.createBean((JdbcResource)object6[0]);
            ((DataSourceBean)object5).getBeanInGraph(resources);
        }
        if (((MailResource[])(object5 = resources2.getMailResource())).length != 0) {
            object4 = JavaMailSessionBean.createBean((MailResource)object5[0]);
            ((JavaMailSessionBean)object4).getBeanInGraph(resources);
        }
        if (((JmsResource[])(object4 = resources2.getJmsResource())).length != 0) {
            object3 = JMSBean.createBean((JmsResource)object4[0]);
            ((JMSBean)object3).getAdminObjectBeanInGraph(resources);
        }
        if (((AdminObjectResource[])(object3 = resources2.getAdminObjectResource())).length != 0) {
            object2 = JMSBean.createBean((AdminObjectResource)object3[0]);
            ((JMSBean)object2).getAdminObjectBeanInGraph(resources);
        }
        object2 = resources2.getConnectorResource();
        ConnectorConnectionPool[] connectorConnectionPoolArray = resources2.getConnectorConnectionPool();
        if (((Object)object2).length != 0 && connectorConnectionPoolArray.length != 0) {
            object = JMSBean.createBean(resources2);
            ((JMSBean)object).getConnectorBeanInGraph(resources);
        }
        if (((PersistenceManagerFactoryResource[])(object = resources2.getPersistenceManagerFactoryResource())).length != 0) {
            PersistenceManagerBean persistenceManagerBean = PersistenceManagerBean.createBean((PersistenceManagerFactoryResource)object[0]);
            persistenceManagerBean.getBeanInGraph(resources);
        }
        return resources;
    }

    public static String getUniqueResourceName(String string, HashMap hashMap) {
        int n = 1;
        String string2;
        while (hashMap.containsKey(string2 = string + "_" + n)) {
            ++n;
        }
        return string2;
    }

    private static class ResourceFileFilter
    implements FileFilter {
        private ResourceFileFilter() {
        }

        public boolean accept(File file) {
            return !file.isDirectory() && file.getName().toLowerCase(Locale.ENGLISH).endsWith(".sun-resource");
        }
    }
}

