/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6.optional;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.j2ee.websphere6.WSDeploymentManager;
import org.netbeans.modules.j2ee.websphere6.ui.nodes.actions.ShowServerLogAction;
import org.netbeans.modules.j2ee.websphere6.util.WSTailer;
import org.netbeans.modules.j2ee.websphere6.util.WSUtil;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class WSStartServer
extends StartServer {
    private static final Logger LOGGER = Logger.getLogger(WSStartServer.class.getName());
    private final WSDeploymentManager dm;
    private int state;
    private static Map isDebugModeMap = Collections.synchronizedMap(new HashMap(2, 1.0f));
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTING = 1;
    private static final int STATE_STARTED = 2;
    private static final int STATE_STOPPING = 3;

    public WSStartServer(DeploymentManager deploymentManager) {
        this.dm = (WSDeploymentManager)deploymentManager;
        this.state = this.isRunning() ? 2 : 0;
    }

    public boolean supportsStartDebugging(Target target) {
        return true;
    }

    public ProgressObject startDebugging(Target target) {
        LOGGER.log(Level.FINEST, "Starting server in debug mode");
        WSServerProgress wSServerProgress = new WSServerProgress((Object)this);
        wSServerProgress.notifyStart(StateType.RUNNING, "");
        if (this.state == 3) {
            for (int i = 0; i < 120000; i += 5000) {
                if (this.state == 3) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.state == 0) break;
            }
        }
        if (this.state == 1 || this.state == 2) {
            wSServerProgress.notifyStart(StateType.COMPLETED, "");
            return wSServerProgress;
        }
        RequestProcessor.getDefault().post((Runnable)new WSStartDebugRunnable(wSServerProgress), 0, 5);
        isDebugModeMap.put(this.dm.getHost() + this.dm.getPort() + this.dm.getDomainRoot(), new Object());
        this.state = 1;
        return wSServerProgress;
    }

    public boolean isDebuggable(Target target) {
        if (!isDebugModeMap.containsKey(this.dm.getHost() + this.dm.getPort() + this.dm.getDomainRoot())) {
            return false;
        }
        if (!this.isRunning()) {
            isDebugModeMap.remove(this.dm.getHost() + this.dm.getPort() + this.dm.getDomainRoot());
            return false;
        }
        return true;
    }

    public boolean isAlsoTargetServer(Target target) {
        return true;
    }

    public ServerDebugInfo getDebugInfo(Target target) {
        return new ServerDebugInfo(this.dm.getHost(), new Integer(this.dm.getInstanceProperties().getProperty("debuggerPort")).intValue());
    }

    public boolean supportsStartDeploymentManager() {
        InstanceProperties instanceProperties = this.dm.getInstanceProperties();
        return instanceProperties != null && Boolean.parseBoolean(instanceProperties.getProperty("isLocal"));
    }

    public ProgressObject stopDeploymentManager() {
        LOGGER.log(Level.FINEST, "Stopping server");
        WSServerProgress wSServerProgress = new WSServerProgress((Object)this);
        wSServerProgress.notifyStop(StateType.RUNNING, "");
        if (this.state == 1) {
            for (int i = 0; i < 120000; i += 5000) {
                if (this.state == 1) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.state == 2) break;
            }
        }
        if (this.state == 3 || this.state == 0) {
            wSServerProgress.notifyStop(StateType.COMPLETED, "");
            return wSServerProgress;
        }
        RequestProcessor.getDefault().post((Runnable)new WSStopRunnable(wSServerProgress), 0, 5);
        isDebugModeMap.remove(this.dm.getHost() + this.dm.getPort() + this.dm.getDomainRoot());
        this.state = 3;
        return wSServerProgress;
    }

    public ProgressObject startDeploymentManager() {
        LOGGER.log(Level.FINEST, "Starting server");
        WSServerProgress wSServerProgress = new WSServerProgress((Object)this);
        wSServerProgress.notifyStart(StateType.RUNNING, "");
        if (this.state == 3) {
            for (int i = 0; i < 120000; i += 5000) {
                if (this.state == 3) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.state == 0) break;
            }
        }
        if (this.state == 1 || this.state == 2) {
            wSServerProgress.notifyStart(StateType.COMPLETED, "");
            return wSServerProgress;
        }
        RequestProcessor.getDefault().post((Runnable)new WSStartRunnable(wSServerProgress), 0, 5);
        isDebugModeMap.remove(this.dm.getHost() + this.dm.getPort() + this.dm.getDomainRoot());
        this.state = 1;
        return wSServerProgress;
    }

    public boolean needsStartForTargetList() {
        return true;
    }

    public boolean needsStartForConfigure() {
        return false;
    }

    public boolean needsStartForAdminConfig() {
        return true;
    }

    public boolean isRunning() {
        try {
            new Socket(this.dm.getHost(), Integer.parseInt(this.dm.getPort()));
            return true;
        }
        catch (UnknownHostException unknownHostException) {
            Logger.getLogger("global").log(Level.SEVERE, null, unknownHostException);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static String[] properties2StringArray(Properties properties) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            arrayList.add(string + "=" + properties.getProperty(string));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void setDebugMode(boolean bl, int n) {
        File file = new File(this.dm.getInstanceProperties().getProperty("configXmlPath"));
        String string = WSUtil.readFile(file);
        if (bl) {
            string = string.replaceAll("debugMode=\"false\"", "debugMode=\"true\"");
            string = string.replaceFirst("suspend=n,address=[0-9]+\" genericJvmArguments", "suspend=n,address=" + n + "\" genericJvmArguments");
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Setting the address string to: suspend=n,address=" + n);
            }
        } else {
            string = string.replaceAll("debugMode=\"true\"", "debugMode=\"false\"");
        }
        WSUtil.writeFile(file, string);
    }

    private static class WSDeploymentStatus
    implements DeploymentStatus {
        private ActionType action;
        private CommandType command;
        private StateType state;
        private String message;

        public WSDeploymentStatus(ActionType actionType, CommandType commandType, StateType stateType, String string) {
            this.action = actionType;
            this.command = commandType;
            this.state = stateType;
            this.message = string;
        }

        public ActionType getAction() {
            return this.action;
        }

        public CommandType getCommand() {
            return this.command;
        }

        public String getMessage() {
            return this.message;
        }

        public StateType getState() {
            return this.state;
        }

        public boolean isCompleted() {
            return StateType.COMPLETED.equals(this.state);
        }

        public boolean isFailed() {
            return StateType.FAILED.equals(this.state);
        }

        public boolean isRunning() {
            return StateType.RUNNING.equals(this.state);
        }
    }

    private static class WSServerProgress
    implements ProgressObject {
        private Vector listeners = new Vector();
        private DeploymentStatus deploymentStatus;
        private Object source;

        public WSServerProgress(Object object) {
            this.source = object;
        }

        public void notifyStart(StateType stateType, String string) {
            this.notify(new WSDeploymentStatus(ActionType.EXECUTE, CommandType.START, stateType, string));
        }

        public void notifyStop(StateType stateType, String string) {
            this.notify(new WSDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, stateType, string));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notify(DeploymentStatus deploymentStatus) {
            ProgressEvent progressEvent = new ProgressEvent(this.source, null, deploymentStatus);
            this.deploymentStatus = deploymentStatus;
            Vector vector = null;
            WSServerProgress wSServerProgress = this;
            synchronized (wSServerProgress) {
                if (this.listeners != null) {
                    vector = (Vector)this.listeners.clone();
                }
            }
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    ProgressListener progressListener = (ProgressListener)vector.elementAt(i);
                    progressListener.handleProgressEvent(progressEvent);
                }
            }
        }

        public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
            return null;
        }

        public void removeProgressListener(ProgressListener progressListener) {
            this.listeners.remove(progressListener);
        }

        public void addProgressListener(ProgressListener progressListener) {
            this.listeners.add(progressListener);
        }

        public DeploymentStatus getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public TargetModuleID[] getResultTargetModuleIDs() {
            return new TargetModuleID[0];
        }

        public boolean isStopSupported() {
            return false;
        }

        public void stop() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("");
        }

        public boolean isCancelSupported() {
            return false;
        }

        public void cancel() throws OperationUnsupportedException {
            throw new OperationUnsupportedException("");
        }
    }

    private class WSStopRunnable
    implements Runnable {
        private String domainHome;
        private String serverName;
        private WSServerProgress serverProgress;
        private static final int TIMEOUT = 120000;
        private static final int DELAY = 5000;
        private static final String SHUTDOWN_SH = "stopServer.sh";
        private static final String SHUTDOWN_BAT = "stopServer.bat";

        public WSStopRunnable(WSServerProgress wSServerProgress) {
            this.serverProgress = wSServerProgress;
            this.domainHome = WSStartServer.this.dm.getInstanceProperties().getProperty("domainRoot");
            this.serverName = WSStartServer.this.dm.getInstanceProperties().getProperty("serverName");
        }

        public void run() {
            try {
                long l = System.currentTimeMillis();
                Process process = Runtime.getRuntime().exec(new String[]{this.domainHome + "/bin/" + (Utilities.isWindows() ? SHUTDOWN_BAT : SHUTDOWN_SH), this.serverName});
                new WSTailer(process.getInputStream(), NbBundle.getMessage(WSStartServer.class, (String)"TXT_ioWindowTitle", (Object)WSStartServer.this.dm.getServerTitleMessage())).start();
                new WSTailer(new File(WSStartServer.this.dm.getLogFilePath()), NbBundle.getMessage(ShowServerLogAction.class, (String)"LBL_LogWindowTitle", (Object)WSStartServer.this.dm.getServerTitleMessage())).start();
                while (System.currentTimeMillis() - l < 120000L) {
                    if (!WSStartServer.this.isRunning()) {
                        this.serverProgress.notifyStop(StateType.COMPLETED, "");
                        WSStartServer.this.state = 0;
                        return;
                    }
                    this.serverProgress.notifyStop(StateType.RUNNING, "");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.serverProgress.notifyStop(StateType.FAILED, NbBundle.getMessage(WSStartServer.class, (String)"MSG_StartFailed"));
                process.destroy();
                WSStartServer.this.state = 2;
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.WARNING, null, iOException);
            }
        }
    }

    private class WSStartDebugRunnable
    implements Runnable {
        private String domainHome;
        private String serverName;
        private String debuggerPort;
        private WSServerProgress serverProgress;
        private static final int TIMEOUT = 120000;
        private static final int DELAY = 5000;
        private static final String STARTUP_SH = "startServer.sh";
        private static final String STARTUP_BAT = "startServer.bat";

        public WSStartDebugRunnable(WSServerProgress wSServerProgress) {
            this.serverProgress = wSServerProgress;
            this.domainHome = WSStartServer.this.dm.getInstanceProperties().getProperty("domainRoot");
            this.debuggerPort = WSStartServer.this.dm.getInstanceProperties().getProperty("debuggerPort");
            this.serverName = WSStartServer.this.dm.getInstanceProperties().getProperty("serverName");
        }

        public void run() {
            try {
                long l = System.currentTimeMillis();
                WSStartServer.this.setDebugMode(true, new Integer(this.debuggerPort));
                Process process = Runtime.getRuntime().exec(new String[]{this.domainHome + "/bin/" + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH), this.serverName});
                new WSTailer(process.getInputStream(), NbBundle.getMessage(WSStartServer.class, (String)"TXT_ioWindowTitle", (Object)WSStartServer.this.dm.getServerTitleMessage())).start();
                new WSTailer(new File(WSStartServer.this.dm.getLogFilePath()), NbBundle.getMessage(ShowServerLogAction.class, (String)"LBL_LogWindowTitle", (Object)WSStartServer.this.dm.getServerTitleMessage())).start();
                while (System.currentTimeMillis() - l < 120000L) {
                    if (WSStartServer.this.isRunning()) {
                        this.serverProgress.notifyStart(StateType.COMPLETED, "");
                        WSStartServer.this.state = 2;
                        return;
                    }
                    this.serverProgress.notifyStart(StateType.RUNNING, "");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.serverProgress.notifyStart(StateType.FAILED, "");
                process.destroy();
                WSStartServer.this.state = 0;
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.WARNING, null, iOException);
            }
        }
    }

    private class WSStartRunnable
    implements Runnable {
        private String domainHome;
        private String serverName;
        private WSServerProgress serverProgress;
        private static final int TIMEOUT = 120000;
        private static final int DELAY = 5000;
        private static final String STARTUP_SH = "startServer.sh";
        private static final String STARTUP_BAT = "startServer.bat";

        public WSStartRunnable(WSServerProgress wSServerProgress) {
            this.serverProgress = wSServerProgress;
            this.domainHome = WSStartServer.this.dm.getInstanceProperties().getProperty("domainRoot");
            this.serverName = WSStartServer.this.dm.getInstanceProperties().getProperty("serverName");
        }

        public void run() {
            try {
                long l = System.currentTimeMillis();
                WSStartServer.this.setDebugMode(false, 0);
                Process process = Runtime.getRuntime().exec(new String[]{this.domainHome + "/bin/" + (Utilities.isWindows() ? STARTUP_BAT : STARTUP_SH), this.serverName});
                new WSTailer(process.getInputStream(), NbBundle.getMessage(WSStartServer.class, (String)"TXT_ioWindowTitle", (Object)WSStartServer.this.dm.getServerTitleMessage())).start();
                new WSTailer(new File(WSStartServer.this.dm.getLogFilePath()), NbBundle.getMessage(ShowServerLogAction.class, (String)"LBL_LogWindowTitle", (Object)WSStartServer.this.dm.getServerTitleMessage())).start();
                while (System.currentTimeMillis() - l < 120000L) {
                    if (WSStartServer.this.isRunning()) {
                        this.serverProgress.notifyStart(StateType.COMPLETED, "");
                        WSStartServer.this.state = 2;
                        return;
                    }
                    this.serverProgress.notifyStart(StateType.RUNNING, "");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.serverProgress.notifyStart(StateType.FAILED, NbBundle.getMessage(WSStartServer.class, (String)"MSG_StartFailed"));
                process.destroy();
                WSStartServer.this.state = 0;
            }
            catch (IOException iOException) {
                Logger.getLogger("global").log(Level.WARNING, null, iOException);
            }
        }
    }
}

