/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.websphere6;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = Logger.getLogger(WSClassLoader.class.getName());
    private static Map instances = new HashMap();
    private String serverRoot;
    private String domainRoot;
    private ClassLoader oldLoader;

    public static WSClassLoader getInstance(String string, String string2) {
        WSClassLoader wSClassLoader;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "getInstance(" + string + ", " + string2 + ")");
        }
        if ((wSClassLoader = (WSClassLoader)instances.get(string2)) == null) {
            wSClassLoader = new WSClassLoader(string, string2);
            instances.put(string2, wSClassLoader);
        }
        return wSClassLoader;
    }

    private WSClassLoader(String string, String string2) {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
        System.out.println("serverRoot:" + string);
        System.out.println("domainRoot:" + string2);
        this.serverRoot = string;
        this.domainRoot = string2;
        String string3 = "derby";
        if (new File(string + File.separator + "cloudscape").exists()) {
            string3 = "cloudscape";
        }
        File[] fileArray = null;
        fileArray = string3.equals("cloudscape") ? new File[]{new File(string + "/lib/"), new File(string + "/java/jre/lib/"), new File(string + "/java/jre/lib/ext/"), new File(string + "/lib/WMQ/java/lib/"), new File(string + "/cloudscape/lib/"), new File(string + "/cloudscape/lib/locales/"), new File(string + "/cloudscape/lib/otherjars/"), new File(string + "/deploytool/itp/"), new File(string + "/deploytool/itp/plugins/"), new File(string + "/installedChannels/"), new File(string + "/etc/"), new File(string + "/optionalLibraries/Apache/Struts/1.1/")} : new File[]{new File(string + "/lib/"), new File(string + "/java/jre/lib/"), new File(string + "/java/jre/lib/ext/"), new File(string + "/java/jre/lib/endorsed//"), new File(string + "/lib/WMQ/java/lib/"), new File(string + "/derby/lib/"), new File(string + "/derby/lib/locales/"), new File(string + "/deploytool/itp/"), new File(string + "/deploytool/itp/plugins/"), new File(string + "/plugins/"), new File(string + "/etc/"), new File(string + "/optionalLibraries/Apache/Struts/1.1/")};
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (file.exists() && file.isDirectory()) {
                File[] fileArray2 = file.listFiles(new JarFileFilter());
                for (int j = 0; j < fileArray2.length; ++j) {
                    try {
                        this.addURL(fileArray2[j].toURL());
                        continue;
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            try {
                this.addURL(file.toURL());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public void updateLoader() {
        LOGGER.log(Level.FINEST, "updateLoader()");
        System.setProperty("websphere.home", this.serverRoot);
        System.setProperty("was.install.root", this.serverRoot);
        System.setProperty("was.repository.root", this.domainRoot + File.separator + "config");
        try {
            System.setProperty("com.ibm.SOAP.ConfigURL", new File(this.domainRoot + File.separator + "properties" + File.separator + "soap.client.props").toURI().toURL().toString());
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.log(Level.INFO, null, malformedURLException);
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            System.setProperty("traceSettingsFile", "TraceSettings.properties");
        }
        if (!Thread.currentThread().getContextClassLoader().equals(this)) {
            this.oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this);
        }
    }

    public void restoreLoader() {
        LOGGER.log(Level.FINEST, "restoreLoader()");
        if (this.oldLoader != null) {
            Thread.currentThread().setContextClassLoader(this.oldLoader);
            this.oldLoader = null;
        }
    }

    private static class JarFileFilter
    implements FileFilter {
        private JarFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".jar");
        }
    }
}

