/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.util.Hashtable;
import org.w3c.tidy.CheckAttribsImpl;
import org.w3c.tidy.Configuration;
import org.w3c.tidy.Dict;
import org.w3c.tidy.Node;
import org.w3c.tidy.Parser;
import org.w3c.tidy.ParserImpl;

public class TagTable {
    private Configuration configuration = null;
    private Hashtable tagHashtable = new Hashtable();
    private static Dict[] tags = new Dict[]{new Dict("html", 31, 0x208002, ParserImpl.getParseHTML(), CheckAttribsImpl.getCheckHTML()), new Dict("head", 31, 0x208002, ParserImpl.getParseHead(), null), new Dict("title", 31, 4, ParserImpl.getParseTitle(), null), new Dict("base", 31, 5, null, null), new Dict("link", 31, 5, null, CheckAttribsImpl.getCheckLINK()), new Dict("meta", 31, 5, null, null), new Dict("style", 30, 4, ParserImpl.getParseScript(), CheckAttribsImpl.getCheckSTYLE()), new Dict("script", 30, 131100, ParserImpl.getParseScript(), CheckAttribsImpl.getCheckSCRIPT()), new Dict("server", 64, 131100, ParserImpl.getParseScript(), null), new Dict("body", 31, 0x208002, ParserImpl.getParseBody(), null), new Dict("frameset", 16, 8194, ParserImpl.getParseFrameSet(), null), new Dict("p", 31, 32776, ParserImpl.getParseInline(), null), new Dict("h1", 31, 16392, ParserImpl.getParseInline(), null), new Dict("h2", 31, 16392, ParserImpl.getParseInline(), null), new Dict("h3", 31, 16392, ParserImpl.getParseInline(), null), new Dict("h4", 31, 16392, ParserImpl.getParseInline(), null), new Dict("h5", 31, 16392, ParserImpl.getParseInline(), null), new Dict("h6", 31, 16392, ParserImpl.getParseInline(), null), new Dict("ul", 31, 8, ParserImpl.getParseList(), null), new Dict("ol", 31, 8, ParserImpl.getParseList(), null), new Dict("dl", 31, 8, ParserImpl.getParseDefList(), null), new Dict("dir", 26, 524296, ParserImpl.getParseList(), null), new Dict("menu", 26, 524296, ParserImpl.getParseList(), null), new Dict("pre", 31, 8, ParserImpl.getParsePre(), null), new Dict("listing", 31, 524296, ParserImpl.getParsePre(), null), new Dict("xmp", 31, 524296, ParserImpl.getParsePre(), null), new Dict("plaintext", 31, 524296, ParserImpl.getParsePre(), null), new Dict("address", 31, 8, ParserImpl.getParseBlock(), null), new Dict("blockquote", 31, 8, ParserImpl.getParseBlock(), null), new Dict("form", 31, 8, ParserImpl.getParseBlock(), null), new Dict("isindex", 26, 9, null, null), new Dict("fieldset", 28, 8, ParserImpl.getParseBlock(), null), new Dict("table", 30, 8, ParserImpl.getParseTableTag(), CheckAttribsImpl.getCheckTABLE()), new Dict("hr", 31, 9, null, CheckAttribsImpl.getCheckHR()), new Dict("div", 30, 8, ParserImpl.getParseBlock(), null), new Dict("multicol", 64, 8, ParserImpl.getParseBlock(), null), new Dict("nosave", 64, 8, ParserImpl.getParseBlock(), null), new Dict("layer", 64, 8, ParserImpl.getParseBlock(), null), new Dict("ilayer", 64, 16, ParserImpl.getParseInline(), null), new Dict("nolayer", 64, 131096, ParserImpl.getParseBlock(), null), new Dict("align", 64, 8, ParserImpl.getParseBlock(), null), new Dict("center", 26, 8, ParserImpl.getParseBlock(), null), new Dict("ins", 28, 131096, ParserImpl.getParseInline(), null), new Dict("del", 28, 131096, ParserImpl.getParseInline(), null), new Dict("li", 31, 294944, ParserImpl.getParseBlock(), null), new Dict("dt", 31, 294976, ParserImpl.getParseInline(), null), new Dict("dd", 31, 294976, ParserImpl.getParseBlock(), null), new Dict("caption", 30, 128, ParserImpl.getParseInline(), CheckAttribsImpl.getCheckCaption()), new Dict("colgroup", 28, 32896, ParserImpl.getParseColGroup(), null), new Dict("col", 28, 129, null, null), new Dict("thead", 28, 33152, ParserImpl.getParseRowGroup(), null), new Dict("tfoot", 28, 33152, ParserImpl.getParseRowGroup(), null), new Dict("tbody", 28, 33152, ParserImpl.getParseRowGroup(), null), new Dict("tr", 30, 32896, ParserImpl.getParseRow(), null), new Dict("td", 30, 295424, ParserImpl.getParseBlock(), CheckAttribsImpl.getCheckTableCell()), new Dict("th", 30, 295424, ParserImpl.getParseBlock(), CheckAttribsImpl.getCheckTableCell()), new Dict("q", 28, 16, ParserImpl.getParseInline(), null), new Dict("a", 31, 16, ParserImpl.getParseInline(), CheckAttribsImpl.getCheckAnchor()), new Dict("br", 31, 17, null, null), new Dict("img", 31, 65553, null, CheckAttribsImpl.getCheckIMG()), new Dict("object", 28, 71700, ParserImpl.getParseBlock(), null), new Dict("applet", 26, 71696, ParserImpl.getParseBlock(), null), new Dict("servlet", 256, 71696, ParserImpl.getParseBlock(), null), new Dict("param", 30, 17, null, null), new Dict("embed", 64, 65553, null, null), new Dict("noembed", 64, 16, ParserImpl.getParseInline(), null), new Dict("iframe", 8, 16, ParserImpl.getParseBlock(), null), new Dict("frame", 16, 8193, null, null), new Dict("noframes", 24, 8200, ParserImpl.getParseNoFrames(), null), new Dict("noscript", 28, 131096, ParserImpl.getParseBlock(), null), new Dict("b", 31, 16, ParserImpl.getParseInline(), null), new Dict("i", 31, 16, ParserImpl.getParseInline(), null), new Dict("u", 26, 16, ParserImpl.getParseInline(), null), new Dict("tt", 31, 16, ParserImpl.getParseInline(), null), new Dict("s", 26, 16, ParserImpl.getParseInline(), null), new Dict("strike", 26, 16, ParserImpl.getParseInline(), null), new Dict("big", 30, 16, ParserImpl.getParseInline(), null), new Dict("small", 30, 16, ParserImpl.getParseInline(), null), new Dict("sub", 30, 16, ParserImpl.getParseInline(), null), new Dict("sup", 30, 16, ParserImpl.getParseInline(), null), new Dict("em", 31, 16, ParserImpl.getParseInline(), null), new Dict("strong", 31, 16, ParserImpl.getParseInline(), null), new Dict("dfn", 31, 16, ParserImpl.getParseInline(), null), new Dict("code", 31, 16, ParserImpl.getParseInline(), null), new Dict("samp", 31, 16, ParserImpl.getParseInline(), null), new Dict("kbd", 31, 16, ParserImpl.getParseInline(), null), new Dict("var", 31, 16, ParserImpl.getParseInline(), null), new Dict("cite", 31, 16, ParserImpl.getParseInline(), null), new Dict("abbr", 28, 16, ParserImpl.getParseInline(), null), new Dict("acronym", 28, 16, ParserImpl.getParseInline(), null), new Dict("span", 30, 16, ParserImpl.getParseInline(), null), new Dict("blink", 448, 16, ParserImpl.getParseInline(), null), new Dict("nobr", 448, 16, ParserImpl.getParseInline(), null), new Dict("wbr", 448, 17, null, null), new Dict("marquee", 128, 32784, ParserImpl.getParseInline(), null), new Dict("bgsound", 128, 5, null, null), new Dict("comment", 128, 16, ParserImpl.getParseInline(), null), new Dict("spacer", 64, 17, null, null), new Dict("keygen", 64, 17, null, null), new Dict("nolayer", 64, 131096, ParserImpl.getParseBlock(), null), new Dict("ilayer", 64, 16, ParserImpl.getParseInline(), null), new Dict("map", 30, 16, ParserImpl.getParseBlock(), CheckAttribsImpl.getCheckMap()), new Dict("area", 31, 9, null, CheckAttribsImpl.getCheckAREA()), new Dict("input", 31, 65553, null, null), new Dict("select", 31, 1040, ParserImpl.getParseSelect(), null), new Dict("option", 31, 33792, ParserImpl.getParseText(), null), new Dict("optgroup", 28, 33792, ParserImpl.getParseOptGroup(), null), new Dict("textarea", 31, 1040, ParserImpl.getParseText(), null), new Dict("label", 28, 16, ParserImpl.getParseInline(), null), new Dict("legend", 28, 16, ParserImpl.getParseInline(), null), new Dict("button", 28, 16, ParserImpl.getParseInline(), null), new Dict("basefont", 26, 17, null, null), new Dict("font", 26, 16, ParserImpl.getParseInline(), null), new Dict("bdo", 28, 16, ParserImpl.getParseInline(), null), new Dict("jsp:directive.include", 26, 16, ParserImpl.getParseInline(), null), new Dict("jsp:root", 31, 8, ParserImpl.getParseBlock(), null), new Dict("jsp:directive.page", 31, 8, ParserImpl.getParseBlock(), null), new Dict("f:view", 31, 8, ParserImpl.getParseBlock(), null), new Dict("f:loadBundle", 31, 8, ParserImpl.getParseBlock(), null)};
    public Dict xmlTags = new Dict(null, 31, 8, null, null);
    public Dict tagHtml = null;
    public Dict tagHead = null;
    public Dict tagBody = null;
    public Dict tagFrameset = null;
    public Dict tagFrame = null;
    public Dict tagNoframes = null;
    public Dict tagMeta = null;
    public Dict tagTitle = null;
    public Dict tagBase = null;
    public Dict tagHr = null;
    public Dict tagPre = null;
    public Dict tagListing = null;
    public Dict tagH1 = null;
    public Dict tagH2 = null;
    public Dict tagP = null;
    public Dict tagUl = null;
    public Dict tagOl = null;
    public Dict tagDir = null;
    public Dict tagLi = null;
    public Dict tagDt = null;
    public Dict tagDd = null;
    public Dict tagDl = null;
    public Dict tagTd = null;
    public Dict tagTh = null;
    public Dict tagTr = null;
    public Dict tagCol = null;
    public Dict tagBr = null;
    public Dict tagA = null;
    public Dict tagLink = null;
    public Dict tagB = null;
    public Dict tagI = null;
    public Dict tagStrong = null;
    public Dict tagEm = null;
    public Dict tagBig = null;
    public Dict tagSmall = null;
    public Dict tagParam = null;
    public Dict tagOption = null;
    public Dict tagOptgroup = null;
    public Dict tagImg = null;
    public Dict tagMap = null;
    public Dict tagArea = null;
    public Dict tagNobr = null;
    public Dict tagWbr = null;
    public Dict tagFont = null;
    public Dict tagSpacer = null;
    public Dict tagLayer = null;
    public Dict tagCenter = null;
    public Dict tagStyle = null;
    public Dict tagScript = null;
    public Dict tagNoscript = null;
    public Dict tagTable = null;
    public Dict tagCaption = null;
    public Dict tagForm = null;
    public Dict tagTextarea = null;
    public Dict tagBlockquote = null;
    public Dict tagApplet = null;
    public Dict tagObject = null;
    public Dict tagDiv = null;
    public Dict tagSpan = null;
    public Dict tagJspRoot = null;
    public Dict tagFView = null;
    public Dict tagJspDirectivePage = null;
    public Dict tagJspDirectiveInclude = null;

    public TagTable() {
        for (int i = 0; i < tags.length; ++i) {
            this.install(tags[i]);
        }
        this.tagHtml = this.lookup("html");
        this.tagHead = this.lookup("head");
        this.tagBody = this.lookup("body");
        this.tagFrameset = this.lookup("frameset");
        this.tagFrame = this.lookup("frame");
        this.tagNoframes = this.lookup("noframes");
        this.tagMeta = this.lookup("meta");
        this.tagTitle = this.lookup("title");
        this.tagBase = this.lookup("base");
        this.tagHr = this.lookup("hr");
        this.tagPre = this.lookup("pre");
        this.tagListing = this.lookup("listing");
        this.tagH1 = this.lookup("h1");
        this.tagH2 = this.lookup("h2");
        this.tagP = this.lookup("p");
        this.tagUl = this.lookup("ul");
        this.tagOl = this.lookup("ol");
        this.tagDir = this.lookup("dir");
        this.tagLi = this.lookup("li");
        this.tagDt = this.lookup("dt");
        this.tagDd = this.lookup("dd");
        this.tagDl = this.lookup("dl");
        this.tagTd = this.lookup("td");
        this.tagTh = this.lookup("th");
        this.tagTr = this.lookup("tr");
        this.tagCol = this.lookup("col");
        this.tagBr = this.lookup("br");
        this.tagA = this.lookup("a");
        this.tagLink = this.lookup("link");
        this.tagB = this.lookup("b");
        this.tagI = this.lookup("i");
        this.tagStrong = this.lookup("strong");
        this.tagEm = this.lookup("em");
        this.tagBig = this.lookup("big");
        this.tagSmall = this.lookup("small");
        this.tagParam = this.lookup("param");
        this.tagOption = this.lookup("option");
        this.tagOptgroup = this.lookup("optgroup");
        this.tagImg = this.lookup("img");
        this.tagMap = this.lookup("map");
        this.tagArea = this.lookup("area");
        this.tagNobr = this.lookup("nobr");
        this.tagWbr = this.lookup("wbr");
        this.tagFont = this.lookup("font");
        this.tagSpacer = this.lookup("spacer");
        this.tagLayer = this.lookup("layer");
        this.tagCenter = this.lookup("center");
        this.tagStyle = this.lookup("style");
        this.tagScript = this.lookup("script");
        this.tagNoscript = this.lookup("noscript");
        this.tagTable = this.lookup("table");
        this.tagCaption = this.lookup("caption");
        this.tagForm = this.lookup("form");
        this.tagTextarea = this.lookup("textarea");
        this.tagBlockquote = this.lookup("blockquote");
        this.tagApplet = this.lookup("applet");
        this.tagObject = this.lookup("object");
        this.tagDiv = this.lookup("div");
        this.tagSpan = this.lookup("span");
        this.tagJspRoot = this.lookup("jsp:root");
        this.tagFView = this.lookup("f:view");
        this.tagJspDirectivePage = this.lookup("jsp:directive.page");
        this.tagJspDirectiveInclude = this.lookup("jsp:directive.include");
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Dict lookup(String name) {
        return (Dict)this.tagHashtable.get(name);
    }

    public Dict install(Dict dict) {
        Dict d = (Dict)this.tagHashtable.get(dict.name);
        if (d != null) {
            d.versions = dict.versions;
            d.model |= dict.model;
            d.parser = dict.parser;
            d.chkattrs = dict.chkattrs;
            return d;
        }
        this.tagHashtable.put(dict.name, dict);
        return dict;
    }

    public boolean findTag(Node node) {
        Dict np;
        if (this.configuration != null && this.configuration.XmlTags) {
            node.tag = this.xmlTags;
            return true;
        }
        if (node.element != null && (np = this.lookup(node.element)) != null) {
            node.tag = np;
            return true;
        }
        return false;
    }

    public Parser findParser(Node node) {
        Dict np;
        if (node.element != null && (np = this.lookup(node.element)) != null) {
            return np.parser;
        }
        return null;
    }

    public void defineInlineTag(String name) {
        this.install(new Dict(name, 448, 0x140010, ParserImpl.getParseBlock(), null));
    }

    public void defineBlockTag(String name) {
        this.install(new Dict(name, 448, 1310728, ParserImpl.getParseBlock(), null));
    }

    public void defineEmptyTag(String name) {
        this.install(new Dict(name, 448, 0x140001, ParserImpl.getParseBlock(), null));
    }

    public void definePreTag(String name) {
        this.install(new Dict(name, 448, 1310728, ParserImpl.getParsePre(), null));
    }
}

