/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support.lang;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.apt.impl.support.lang.APTBaseLanguageFilter;
import org.netbeans.modules.cnd.apt.impl.support.lang.APTGnuCFilter;
import org.netbeans.modules.cnd.apt.impl.support.lang.APTGnuCppFilter;
import org.netbeans.modules.cnd.apt.impl.support.lang.APTStdCFilter;
import org.netbeans.modules.cnd.apt.impl.support.lang.APTStdCppFilter;
import org.netbeans.modules.cnd.apt.support.APTLanguageFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTLanguageSupportImpl {
    private static Map<String, APTLanguageFilter> langFilters = new HashMap<String, APTLanguageFilter>();

    private APTLanguageSupportImpl() {
    }

    public static APTLanguageFilter getFilter(String string) {
        APTLanguageFilter aPTLanguageFilter = langFilters.get(string);
        if (aPTLanguageFilter == null) {
            aPTLanguageFilter = APTLanguageSupportImpl.createFilter(string);
        }
        return aPTLanguageFilter;
    }

    public static void addFilter(String string, APTLanguageFilter aPTLanguageFilter) {
        langFilters.put(string, aPTLanguageFilter);
    }

    private static Map<String, APTLanguageFilter> getFilters() {
        return langFilters;
    }

    private static APTLanguageFilter createFilter(String string) {
        assert (APTLanguageSupportImpl.getFilters().get(string) == null);
        APTBaseLanguageFilter aPTBaseLanguageFilter = null;
        if (string.equalsIgnoreCase("Std C Language")) {
            aPTBaseLanguageFilter = new APTStdCFilter();
        } else if (string.equalsIgnoreCase("Std C++ Language")) {
            aPTBaseLanguageFilter = new APTStdCppFilter();
        } else if (string.equalsIgnoreCase("Gnu C Language")) {
            aPTBaseLanguageFilter = new APTGnuCFilter();
        } else if (string.equalsIgnoreCase("Gnu C++ Language")) {
            aPTBaseLanguageFilter = new APTGnuCppFilter();
        }
        if (aPTBaseLanguageFilter != null) {
            APTLanguageSupportImpl.addFilter(string, aPTBaseLanguageFilter);
        }
        return aPTBaseLanguageFilter;
    }
}

