/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.model;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.CanvasRendererContext;
import org.netbeans.modules.soa.mappercore.model.GraphListener;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph
implements TargetPin {
    private MapperModel mapperModel;
    private List<Link> links;
    private List<Vertex> verteces;
    private int preferredHeight = 2;
    private List<Link> ingoingLinks = null;
    private boolean hasOutgoingLinks = false;
    private Set<Link> connectedIngoingLinks = null;
    private Set<Link> connectedOutgoingLinks = null;
    private boolean validLinks = false;
    private boolean validBounds = false;
    private Rectangle bounds = null;
    private List<GraphListener> graphListeners = null;
    private Object dataObject;
    private static final Comparator<Vertex> VERTEX_COMPARATOR = new Comparator<Vertex>(){

        @Override
        public int compare(Vertex vertex, Vertex vertex2) {
            int n = vertex.getX() - vertex2.getX();
            if (n != 0) {
                return n;
            }
            n = vertex.getY() - vertex2.getY();
            if (n != 0) {
                return n;
            }
            long l = vertex.uid - vertex2.uid;
            if (l > 0L) {
                return 1;
            }
            if (l < 0L) {
                return -1;
            }
            return 0;
        }
    };
    private static final Comparator<Link> LINK_COMPARATOR = new Comparator<Link>(){

        @Override
        public int compare(Link link, Link link2) {
            Vertex vertex;
            if (link == link2) {
                return 0;
            }
            if (link.getTarget() instanceof Graph) {
                return -1;
            }
            if (link2.getTarget() instanceof Graph) {
                return 1;
            }
            Vertex vertex2 = ((VertexItem)link.getTarget()).getVertex();
            if (vertex2 == (vertex = ((VertexItem)link2.getTarget()).getVertex())) {
                int n = vertex2.getItemIndex((VertexItem)link.getTarget());
                int n2 = vertex.getItemIndex((VertexItem)link2.getTarget());
                return n - n2;
            }
            int n = vertex2.getY() - vertex.getY();
            if (n != 0) {
                return n;
            }
            n = vertex2.getX() - vertex.getX();
            if (n != 0) {
                return n;
            }
            long l = vertex2.uid - vertex.uid;
            if (l > 0L) {
                return 1;
            }
            if (l < 0L) {
                return -1;
            }
            return 0;
        }
    };

    public Graph(MapperModel mapperModel) {
        this(mapperModel, null);
    }

    public Graph(MapperModel mapperModel, Object object) {
        this.mapperModel = mapperModel;
        this.dataObject = object;
    }

    public Object getDataObject() {
        return this.dataObject;
    }

    public Link getPrevLink(Link link, List<Link> list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        Link link2 = null;
        if (link == null) {
            link2 = list.get(0);
            for (Link link3 : list) {
                if (LINK_COMPARATOR.compare(link2, link3) >= 0) continue;
                link2 = link3;
            }
            return link2;
        }
        if (!list.contains(link)) {
            return null;
        }
        for (Link link4 : list) {
            if (LINK_COMPARATOR.compare(link, link4) <= 0) continue;
            if (link2 == null) {
                link2 = link4;
                continue;
            }
            if (LINK_COMPARATOR.compare(link2, link4) >= 0) continue;
            link2 = link4;
        }
        return link2;
    }

    public Link getPrevLink(Link link) {
        return this.getPrevLink(link, this.ingoingLinks);
    }

    public void setDataObject(Object object) {
        this.dataObject = object;
    }

    public boolean hasVerteces() {
        return this.verteces != null && !this.verteces.isEmpty();
    }

    public boolean hasLinks() {
        return this.links != null && !this.links.isEmpty();
    }

    public boolean isEmpty() {
        return !this.hasLinks() && !this.hasVerteces();
    }

    public boolean isEmptyOrOneLink() {
        return !this.hasVerteces() && (this.links == null || this.links.size() <= 1);
    }

    public void addGraphListener(GraphListener graphListener) {
        if (graphListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.graphListeners == null) {
            this.graphListeners = new ArrayList<GraphListener>();
        }
        this.graphListeners.add(graphListener);
    }

    public void removeGraphListener(GraphListener graphListener) {
        int n;
        if (graphListener == null) {
            throw new IllegalArgumentException();
        }
        if (this.graphListeners != null && (n = this.graphListeners.lastIndexOf(graphListener)) >= 0) {
            this.graphListeners.remove(n);
            if (this.graphListeners.isEmpty()) {
                this.graphListeners = null;
            }
        }
    }

    void fireGraphBoundsChanged() {
        if (this.graphListeners != null) {
            for (int i = this.graphListeners.size() - 1; i >= 0; --i) {
                this.graphListeners.get(i).graphBoundsChanged(this);
            }
        }
    }

    void fireGraphLinksChanges() {
        if (this.graphListeners != null) {
            for (int i = this.graphListeners.size() - 1; i >= 0; --i) {
                this.graphListeners.get(i).graphLinksChanged(this);
            }
        }
    }

    void fireGraphContentChanged() {
        if (this.graphListeners != null) {
            for (int i = this.graphListeners.size() - 1; i >= 0; --i) {
                this.graphListeners.get(i).graphContentChanged(this);
            }
        }
    }

    public boolean hasIngoingLinks() {
        this.validateLinks();
        return this.ingoingLinks != null && !this.ingoingLinks.isEmpty();
    }

    public boolean hasOutgoingLinks() {
        this.validateLinks();
        return this.hasOutgoingLinks;
    }

    public boolean hasConnectedOutgoingLinks() {
        this.validateLinks();
        return this.connectedOutgoingLinks != null && !this.connectedOutgoingLinks.isEmpty();
    }

    public List<Link> getIngoingLinks() {
        return this.getIngoingLinks(null);
    }

    public List<Link> getIngoingLinks(List<Link> arrayList) {
        this.validateLinks();
        if (arrayList == null) {
            ArrayList<Link> arrayList2 = arrayList = this.ingoingLinks != null ? new ArrayList<Link>(this.ingoingLinks.size()) : new ArrayList();
        }
        if (this.ingoingLinks != null) {
            arrayList.addAll(this.ingoingLinks);
        }
        return arrayList;
    }

    public List<Link> getConnectedIngoingLinks(List<Link> arrayList) {
        this.validateLinks();
        if (arrayList == null) {
            ArrayList<Link> arrayList2 = arrayList = this.connectedIngoingLinks != null ? new ArrayList<Link>(this.connectedIngoingLinks.size()) : new ArrayList();
        }
        if (this.connectedIngoingLinks != null) {
            arrayList.addAll(this.connectedIngoingLinks);
        }
        return arrayList;
    }

    public boolean isConnectedIngoingLink(Link link) {
        this.validateLinks();
        return this.connectedIngoingLinks != null && this.connectedIngoingLinks.contains(link);
    }

    public boolean isConnectedOutgoingLink(Link link) {
        this.validateLinks();
        return this.connectedOutgoingLinks != null && this.connectedOutgoingLinks.contains(link);
    }

    public Rectangle getBounds() {
        this.validateBounds();
        return new Rectangle(this.bounds);
    }

    public int getHeight() {
        this.validateBounds();
        return this.bounds.height;
    }

    public int getX() {
        this.validateBounds();
        return this.bounds.x;
    }

    public int getWidth() {
        this.validateBounds();
        return this.bounds.width;
    }

    public void addVertex(Vertex vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException();
        }
        Graph graph = vertex.getGraph();
        if (graph != null && graph != this) {
            graph.removeVertex(vertex);
        }
        if (this.verteces == null) {
            this.verteces = new ArrayList<Vertex>();
            this.verteces.add(vertex);
        } else {
            this.verteces.remove(vertex);
            this.verteces.add(vertex);
        }
        vertex.setGraph(this);
        this.invalidateBounds();
        this.fireGraphContentChanged();
    }

    public void moveOnTop(Vertex vertex) {
        if (vertex == null) {
            return;
        }
        if (this.verteces == null) {
            return;
        }
        int n = this.verteces.indexOf(vertex);
        if (n < 0 || n + 1 == this.verteces.size()) {
            return;
        }
        this.verteces.add(this.verteces.remove(n));
        this.fireGraphContentChanged();
    }

    public void moveOnTop(Link link) {
        if (link == null) {
            return;
        }
        if (this.links == null) {
            return;
        }
        int n = this.links.indexOf(link);
        if (n < 0 || n + 1 == this.links.size()) {
            return;
        }
        this.links.add(this.links.remove(n));
        this.fireGraphContentChanged();
    }

    public void removeVertex(Vertex vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException();
        }
        if (vertex.getGraph() != this) {
            throw new IllegalArgumentException();
        }
        this.verteces.remove(vertex);
        if (this.verteces.isEmpty()) {
            this.verteces = null;
        }
        vertex.setGraph(null);
        this.invalidateBounds();
        this.fireGraphContentChanged();
    }

    public int getVertexCount() {
        return this.verteces == null ? 0 : this.verteces.size();
    }

    public Vertex getVertex(int n) {
        return this.verteces.get(n);
    }

    public List<Vertex> getVerteces() {
        return this.getVerteces(null);
    }

    public List<Vertex> getVerteces(List<Vertex> list) {
        if (list == null) {
            list = new ArrayList<Vertex>(this.getVertexCount());
        }
        if (this.verteces != null) {
            list.addAll(this.verteces);
        }
        return list;
    }

    public void addLink(Link link) {
        if (link == null) {
            throw new IllegalArgumentException();
        }
        Graph graph = link.getGraph();
        if (graph != null && graph != this) {
            graph.removeLink(link);
        }
        if (this.links == null) {
            this.links = new ArrayList<Link>();
            this.links.add(link);
        } else {
            this.links.remove(link);
            this.links.add(link);
        }
        link.setGraph(this);
        this.invalidateLinks();
        this.fireGraphContentChanged();
    }

    public void removeLink(Link link) {
        if (link == null) {
            throw new IllegalArgumentException();
        }
        if (link.getGraph() != this) {
            throw new IllegalArgumentException();
        }
        this.links.remove(link);
        if (this.links.isEmpty()) {
            this.links = null;
        }
        link.setGraph(null);
        this.invalidateLinks();
        this.fireGraphContentChanged();
    }

    public int getLinkCount() {
        return this.links == null ? 0 : this.links.size();
    }

    public Link getLink(int n) {
        return this.links.get(n);
    }

    public List<Link> getLinks() {
        return this.getLinks(null);
    }

    public List<Link> getLinks(List<Link> list) {
        if (list == null) {
            list = new ArrayList<Link>(this.getLinkCount());
        }
        if (this.links != null) {
            list.addAll(this.links);
        }
        return list;
    }

    public void paintLinks(Graphics2D graphics2D, TreePath treePath, CanvasRendererContext canvasRendererContext, int n) {
        int n2 = this.getLinkCount();
        for (int i = 0; i < n2; ++i) {
            this.getLink(i).paint(graphics2D, treePath, canvasRendererContext, n);
        }
    }

    public void paintVerteces(Graphics2D graphics2D, TreePath treePath, CanvasRendererContext canvasRendererContext, int n) {
        int n2 = this.getVertexCount();
        for (int i = 0; i < n2; ++i) {
            this.getVertex(i).paint(graphics2D, treePath, canvasRendererContext, n);
        }
    }

    public Point getTargetPinPoint(int n, int n2, int n3) {
        return new Point(Integer.MAX_VALUE, n2 + this.getHeight() * n3 / 2);
    }

    private void validateBounds() {
        if (this.validBounds) {
            return;
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (Vertex vertex : this.getVerteces()) {
            int n5 = vertex.getX();
            int n6 = vertex.getY();
            int n7 = vertex.getWidth();
            int n8 = vertex.getHeight();
            n = Math.min(n, n5);
            n3 = Math.min(n3, n6);
            n2 = Math.max(n2, n5 + n7);
            n4 = Math.max(n4, n6 + n8);
        }
        this.bounds = n <= n2 && n3 <= n4 ? new Rectangle(n, 0, n2 - n, Math.max(n4, this.preferredHeight)) : new Rectangle(2, Math.max(2, this.preferredHeight));
        this.validBounds = true;
    }

    void invalidateBounds() {
        if (this.validBounds) {
            this.validBounds = false;
            this.bounds = null;
            this.fireGraphBoundsChanged();
        }
    }

    public Vertex getNextVertex(Vertex vertex) {
        if (this.verteces == null || this.verteces.isEmpty()) {
            return null;
        }
        int n = this.verteces.size();
        Vertex vertex2 = null;
        if (vertex == null) {
            vertex2 = this.verteces.get(0);
            for (Vertex vertex3 : this.verteces) {
                if (VERTEX_COMPARATOR.compare(vertex3, vertex2) >= 0) continue;
                vertex2 = vertex3;
            }
            return vertex2;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            Vertex vertex4 = this.verteces.get(i);
            if (vertex4 == vertex || (n2 = VERTEX_COMPARATOR.compare(vertex, vertex4)) >= 0) continue;
            if (vertex2 == null) {
                vertex2 = vertex4;
                continue;
            }
            n2 = VERTEX_COMPARATOR.compare(vertex4, vertex2);
            if (n2 >= 0) continue;
            vertex2 = vertex4;
        }
        return vertex2 != null ? vertex2 : vertex;
    }

    public Vertex getPrevVertex(Vertex vertex) {
        if (this.verteces == null || this.verteces.isEmpty()) {
            return null;
        }
        int n = this.verteces.size();
        Vertex vertex2 = null;
        if (vertex == null) {
            vertex2 = this.verteces.get(0);
            for (Vertex vertex3 : this.verteces) {
                if (VERTEX_COMPARATOR.compare(vertex3, vertex2) <= 0) continue;
                vertex2 = vertex3;
            }
            return vertex2;
        }
        for (int i = 0; i < n; ++i) {
            int n2;
            Vertex vertex4 = this.verteces.get(i);
            if (vertex4 == vertex || (n2 = VERTEX_COMPARATOR.compare(vertex4, vertex)) >= 0) continue;
            if (vertex2 == null) {
                vertex2 = vertex4;
                continue;
            }
            n2 = VERTEX_COMPARATOR.compare(vertex2, vertex4);
            if (n2 >= 0) continue;
            vertex2 = vertex4;
        }
        return vertex2 != null ? vertex2 : vertex;
    }

    private void validateLinks() {
        Object object;
        if (this.validLinks) {
            return;
        }
        ArrayList<Link> arrayList = new ArrayList<Link>();
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Link> hashSet2 = new HashSet<Link>();
        HashSet<Link> hashSet3 = new HashSet<Link>();
        for (int i = this.getLinkCount() - 1; i >= 0; --i) {
            object = this.getLink(i);
            SourcePin sourcePin = ((Link)object).getSource();
            Object object2 = ((Link)object).getTarget();
            if (sourcePin instanceof TreeSourcePin) {
                arrayList.add((Link)object);
            }
            if (!(object2 instanceof Graph)) continue;
            this.hasOutgoingLinks = true;
            hashSet.add(object);
        }
        if (this.hasOutgoingLinks) {
            HashSet<Link> hashSet4 = new HashSet<Link>();
            object = new HashSet();
            for (Object object2 : hashSet) {
                this.findConnectedIngoingLinks((Link)object2, hashSet4, (Set<Vertex>)object);
                if (!hashSet4.isEmpty()) {
                    hashSet3.add((Link)object2);
                    hashSet2.addAll(hashSet4);
                    hashSet4.clear();
                }
                object.clear();
            }
        }
        this.ingoingLinks = arrayList.isEmpty() ? null : arrayList;
        this.connectedIngoingLinks = hashSet2.isEmpty() ? null : hashSet2;
        this.connectedOutgoingLinks = hashSet3.isEmpty() ? null : hashSet3;
        this.validLinks = true;
    }

    void invalidateLinks() {
        if (this.validLinks) {
            this.hasOutgoingLinks = false;
            this.ingoingLinks = null;
            this.connectedIngoingLinks = null;
            this.connectedOutgoingLinks = null;
            this.validLinks = false;
            this.fireGraphLinksChanges();
        }
    }

    private void findConnectedIngoingLinks(Link link, Set<Link> set, Set<Vertex> set2) {
        Vertex vertex;
        SourcePin sourcePin = link.getSource();
        if (sourcePin instanceof TreeSourcePin) {
            set.add(link);
        } else if (sourcePin instanceof Vertex && !set2.contains(vertex = (Vertex)sourcePin)) {
            set2.add(vertex);
            for (int i = vertex.getItemCount() - 1; i >= 0; --i) {
                Link link2 = vertex.getItem(i).getIngoingLink();
                if (link2 == null) continue;
                this.findConnectedIngoingLinks(link2, set, set2);
            }
        }
    }
}

