/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.netbeans.modules.soa.mappercore.Mapper;

public class Grid {
    private Image opaqueImage = null;
    private Image image = null;
    private Color background = null;
    private int step;
    private Color gridColor;
    private int texturePreferredSize;

    public Grid() {
        this(Mapper.CANVAS_GRID_COLOR, 160);
    }

    public Grid(Color color, int n) {
        this.gridColor = color;
        this.texturePreferredSize = n;
    }

    public void paintGrid(Component component, Graphics graphics, int n, int n2, int n3, int n4, int n5, boolean bl) {
        int n6 = n + n3;
        int n7 = n2 + n4;
        Rectangle rectangle = graphics.getClipBounds();
        int n8 = Math.max(n, rectangle.x);
        int n9 = Math.max(n2, rectangle.y);
        int n10 = Math.min(n6, rectangle.x + rectangle.width);
        int n11 = Math.min(n7, rectangle.y + rectangle.height);
        if (n8 < n10 && n9 < n11) {
            graphics.setClip(n8, n9, n10 - n8, n11 - n9);
            this.prepareGridImages(component, n5);
            Image image = bl ? this.opaqueImage : this.image;
            int n12 = (int)Math.floor((double)n / (double)n5) * n5;
            int n13 = image.getWidth(null);
            for (int i = n2; i < n7; i += n13) {
                for (int j = n12; j < n6; j += n13) {
                    graphics.drawImage(image, j, i, null);
                }
            }
            graphics.setClip(rectangle);
        }
    }

    private void prepareGridImages(Component component, int n) {
        Color color = component.getBackground();
        if (this.image == null || this.opaqueImage == null || this.step != n || !this.equal(color, this.background)) {
            this.step = n;
            this.background = color;
            int n2 = (this.texturePreferredSize + n - 1) / n * n;
            this.image = new BufferedImage(n2, n2, 2);
            this.opaqueImage = component.createImage(n2, n2);
            Graphics graphics = this.image.getGraphics();
            graphics.setColor(this.gridColor);
            for (int i = 0; i < n2; i += n) {
                for (int j = 0; j < n2; j += n) {
                    graphics.drawLine(i, j, i, j);
                }
            }
            graphics.dispose();
            graphics = this.opaqueImage.getGraphics();
            graphics.setColor(color);
            graphics.fillRect(0, 0, n2, n2);
            graphics.drawImage(this.image, 0, 0, null);
            graphics.dispose();
        }
    }

    private boolean equal(Color color, Color color2) {
        if (color == color2) {
            return true;
        }
        if (color == null) {
            return false;
        }
        if (color2 == null) {
            return false;
        }
        return color.equals(color2);
    }
}

