/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.MapperKeyboardAction;
import org.netbeans.modules.soa.mappercore.SelectionModel;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;

public class MoveRightCanvasAction
extends MapperKeyboardAction {
    private Canvas canvas;

    public MoveRightCanvasAction(Canvas canvas) {
        this.canvas = canvas;
    }

    public String getActionKey() {
        return "press-move-right-action";
    }

    public KeyStroke[] getShortcuts() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(39, 0), KeyStroke.getKeyStroke(39, 2), KeyStroke.getKeyStroke(39, 1)};
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TreePath treePath;
        Object object;
        Object object2;
        if (this.isShiftPress(actionEvent)) {
            if (this.canvas.getScrollPane().getViewport() == null) {
                return;
            }
            object2 = this.canvas.getAutoscrollInsets();
            int n = this.canvas.getScrollPane().getViewport().getViewRect().y;
            object = new Rectangle(0, n, 1, 1);
            ((Rectangle)object).x = this.canvas.getWidth() - ((Insets)object2).right + 16 + 2 * this.canvas.getScrollPane().getHorizontalScrollBar().getUnitIncrement();
            this.canvas.scrollRectToVisible((Rectangle)object);
        }
        if ((treePath = ((SelectionModel)(object2 = this.canvas.getSelectionModel())).getSelectedPath()) == null) {
            return;
        }
        object = ((SelectionModel)object2).getSelectedGraph();
        if (object == null || ((Graph)object).isEmpty()) {
            this.canvas.getRightTree().requestFocus();
            return;
        }
        List<Vertex> list = ((SelectionModel)object2).getSelectedVerteces();
        List<Link> list2 = ((SelectionModel)object2).getSelectedLinks();
        VertexItem vertexItem = ((SelectionModel)object2).getSelectedVertexItem();
        if (this.isControlPress(actionEvent)) {
            if (list != null && list.size() > 0) {
                Vertex vertex = list.get(0);
                Link link = vertex.getOutgoingLink();
                if (link == null) {
                    if (vertex.getGraph().getNextVertex(vertex) == vertex) {
                        this.canvas.getRightTree().requestFocus();
                    }
                    return;
                }
                ((SelectionModel)object2).setSelected(treePath, link);
                return;
            }
            if (list2 != null && list2.size() > 0) {
                Link link = list2.get(0);
                if (link.getTarget() instanceof VertexItem) {
                    VertexItem vertexItem2 = (VertexItem)link.getTarget();
                    if (vertexItem2 == null) {
                        return;
                    }
                    ((SelectionModel)object2).setSelected(treePath, vertexItem2);
                } else {
                    this.canvas.getRightTree().requestFocus();
                }
                return;
            }
            if (vertexItem != null) {
                ((SelectionModel)object2).setSelected(treePath, vertexItem.getVertex());
                return;
            }
            this.canvas.getRightTree().requestFocus();
        }
        if (this.isNothingPress(actionEvent)) {
            if (list != null && list.size() > 0) {
                int n = list.size();
                Vertex vertex = list.get(n - 1);
                Vertex vertex2 = vertex.getGraph().getNextVertex(vertex);
                if (vertex2 == null) {
                    return;
                }
                ((SelectionModel)object2).setSelected(treePath, vertex2);
                return;
            }
            if (list2 != null && list2.size() > 0) {
                int n = list2.size();
                Link link = list2.get(0);
                if (link.getTarget().getClass() == VertexItem.class) {
                    VertexItem vertexItem3 = (VertexItem)link.getTarget();
                    if (vertexItem3 == null) {
                        return;
                    }
                    Vertex vertex = vertexItem3.getVertex();
                    ((SelectionModel)object2).setSelected(treePath, vertex);
                } else {
                    this.canvas.getRightTree().requestFocus();
                }
                return;
            }
            if (vertexItem != null) {
                return;
            }
            if (((Graph)object).getVerteces() != null && ((Graph)object).getVerteces().size() > 0) {
                ((SelectionModel)object2).setSelected(treePath, ((Graph)object).getNextVertex(null));
                return;
            }
            this.canvas.getRightTree().requestFocus();
        }
    }

    private boolean isControlPress(ActionEvent actionEvent) {
        return (actionEvent.getModifiers() & 2) != 0;
    }

    private boolean isShiftPress(ActionEvent actionEvent) {
        return (actionEvent.getModifiers() & 1) != 0;
    }

    private boolean isNothingPress(ActionEvent actionEvent) {
        return actionEvent.getModifiers() == 0;
    }
}

