/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.Canvas;
import org.netbeans.modules.soa.mappercore.MapperKeyboardAction;
import org.netbeans.modules.soa.mappercore.SelectionModel;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;

public class MoveLeftCanvasAction
extends MapperKeyboardAction {
    private Canvas canvas;

    public MoveLeftCanvasAction(Canvas canvas) {
        this.canvas = canvas;
    }

    public String getActionKey() {
        return "press-move-left-action";
    }

    public KeyStroke[] getShortcuts() {
        return new KeyStroke[]{KeyStroke.getKeyStroke(37, 0), KeyStroke.getKeyStroke(37, 1), KeyStroke.getKeyStroke(37, 2)};
    }

    public void actionPerformed(ActionEvent actionEvent) {
        TreePath treePath;
        Object object;
        Object object2;
        if (this.isShiftPress(actionEvent)) {
            if (this.canvas.getScrollPane().getViewport() == null) {
                return;
            }
            object2 = this.canvas.getAutoscrollInsets();
            int n = this.canvas.getScrollPane().getViewport().getViewRect().y;
            object = new Rectangle(0, n, 1, 1);
            ((Rectangle)object).x = ((Insets)object2).left - 16 - 2 * this.canvas.getScrollPane().getHorizontalScrollBar().getUnitIncrement();
            this.canvas.scrollRectToVisible((Rectangle)object);
        }
        if ((treePath = ((SelectionModel)(object2 = this.canvas.getSelectionModel())).getSelectedPath()) == null) {
            return;
        }
        object = ((SelectionModel)object2).getSelectedGraph();
        if (object == null || ((Graph)object).isEmpty()) {
            this.canvas.getLeftTree().requestFocus();
            return;
        }
        List<Vertex> list = ((SelectionModel)object2).getSelectedVerteces();
        List<Link> list2 = ((SelectionModel)object2).getSelectedLinks();
        VertexItem vertexItem = ((SelectionModel)object2).getSelectedVertexItem();
        if (this.isControlPress(actionEvent)) {
            if (list != null && list.size() > 0) {
                Vertex vertex = list.get(0);
                if (vertex.getItemCount() == 0) {
                    return;
                }
                for (int i = 0; i < vertex.getItemCount(); ++i) {
                    Link link = vertex.getItem(i).getIngoingLink();
                    if (link == null) continue;
                    ((SelectionModel)object2).setSelected(treePath, link);
                    return;
                }
                if (vertex.getGraph().getPrevVertex(vertex) == vertex) {
                    this.canvas.getLeftTree().requestFocus();
                }
                return;
            }
            if (list2 != null && list2.size() > 0) {
                Link link = list2.get(0);
                if (link.getSource() instanceof TreeSourcePin) {
                    TreePath treePath2 = ((TreeSourcePin)link.getSource()).getTreePath();
                    this.canvas.getLeftTree().setSelectionPath(treePath2);
                    this.canvas.getLeftTree().requestFocus();
                } else {
                    Vertex vertex = (Vertex)link.getSource();
                    if (vertex == null) {
                        return;
                    }
                    ((SelectionModel)object2).setSelected(treePath, vertex);
                }
                return;
            }
            if (vertexItem != null) {
                Link link = vertexItem.getIngoingLink();
                if (link == null) {
                    ((SelectionModel)object2).setSelected(treePath, vertexItem.getVertex());
                    return;
                }
                ((SelectionModel)object2).setSelected(treePath, link);
                return;
            }
        }
        if (this.isNothingPress(actionEvent)) {
            if (list != null && list.size() > 0) {
                Vertex vertex = list.get(0);
                Vertex vertex2 = vertex.getGraph().getPrevVertex(vertex);
                if (vertex2 == null) {
                    return;
                }
                ((SelectionModel)object2).setSelected(treePath, vertex2);
                return;
            }
            if (list2 != null && list2.size() > 0) {
                Link link = list2.get(0);
                if (link.getSource() instanceof TreeSourcePin) {
                    TreePath treePath3 = ((TreeSourcePin)link.getSource()).getTreePath();
                    this.canvas.getLeftTree().setSelectionPath(treePath3);
                    this.canvas.getLeftTree().requestFocus();
                } else {
                    Vertex vertex = (Vertex)link.getSource();
                    if (vertex == null) {
                        return;
                    }
                    ((SelectionModel)object2).setSelected(treePath, vertex);
                }
                return;
            }
            if (vertexItem != null) {
                return;
            }
            if (((Graph)object).getVerteces() != null && ((Graph)object).getVerteces().size() > 0) {
                ((SelectionModel)object2).setSelected(treePath, ((Graph)object).getPrevVertex(null));
            }
        }
    }

    private boolean isControlPress(ActionEvent actionEvent) {
        return (actionEvent.getModifiers() & 2) != 0;
    }

    private boolean isShiftPress(ActionEvent actionEvent) {
        return (actionEvent.getModifiers() & 1) != 0;
    }

    private boolean isNothingPress(ActionEvent actionEvent) {
        return actionEvent.getModifiers() == 0;
    }
}

