/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.openide.util.NbBundle;

public class FiltersToolBar
extends JToolBar
implements ActionListener {
    private Mapper mapper;
    private JToggleButton leftAllButton;
    private JToggleButton leftOutputButton;
    private ButtonGroup leftGroup;
    private JToggleButton rightAllButton;
    private JToggleButton rightInputButton;
    private ButtonGroup rightGroup;
    private SwitchLeftFilterAction switchLeftFilterAction;
    private SwitchRightFilterAction switchRightFilterAction;

    public FiltersToolBar(Mapper mapper) {
        this.setFloatable(false);
        this.setBorder(new EmptyBorder(2, 1, 2, 1));
        this.mapper = mapper;
        boolean bl = mapper.isFilterLeft();
        boolean bl2 = mapper.isFilterRight();
        this.switchLeftFilterAction = new SwitchLeftFilterAction();
        this.switchRightFilterAction = new SwitchRightFilterAction();
        InputMap inputMap = mapper.getInputMap(1);
        ActionMap actionMap = mapper.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(76, 192), "SwitchLeftFilter");
        inputMap.put(KeyStroke.getKeyStroke(82, 192), "SwitchRightFilter");
        actionMap.put("SwitchLeftFilter", this.switchLeftFilterAction);
        actionMap.put("SwitchRightFilter", this.switchRightFilterAction);
        String string = NbBundle.getMessage(this.getClass(), (String)"TTT_LeftTreeFilter");
        String string2 = NbBundle.getMessage(this.getClass(), (String)"TTT_RightTreeFilter");
        this.leftAllButton = new JToggleButton(NbBundle.getMessage(this.getClass(), (String)"LBL_LeftTreeFilterAll"));
        this.leftAllButton.setSelected(!bl);
        this.leftAllButton.setToolTipText(string);
        this.leftAllButton.addActionListener(this);
        this.leftOutputButton = new JToggleButton(NbBundle.getMessage(this.getClass(), (String)"LBL_LeftTreeFilterOutput"));
        this.leftOutputButton.setSelected(bl);
        this.leftOutputButton.setToolTipText(string);
        this.leftOutputButton.addActionListener(this);
        this.leftGroup = new ButtonGroup();
        this.leftGroup.add(this.leftAllButton);
        this.leftGroup.add(this.leftOutputButton);
        this.rightAllButton = new JToggleButton(NbBundle.getMessage(this.getClass(), (String)"LBL_RightTreeFilterAll"));
        this.rightAllButton.setSelected(!bl2);
        this.rightAllButton.setToolTipText(string2);
        this.rightAllButton.addActionListener(this);
        this.rightInputButton = new JToggleButton(NbBundle.getMessage(this.getClass(), (String)"LBL_RightTreeFilterInput"));
        this.rightInputButton.setSelected(bl2);
        this.rightInputButton.setToolTipText(string2);
        this.rightInputButton.addActionListener(this);
        this.rightGroup = new ButtonGroup();
        this.rightGroup.add(this.rightAllButton);
        this.rightGroup.add(this.rightInputButton);
        this.configureAccessibleContext(this.leftAllButton, "LeftTreeFilterAll");
        this.configureAccessibleContext(this.leftOutputButton, "LeftTreeFilterOutput");
        this.configureAccessibleContext(this.rightAllButton, "RightTreeFilterAll");
        this.configureAccessibleContext(this.rightInputButton, "RightTreeFilterInput");
        this.add(this.leftAllButton);
        this.add(this.leftOutputButton);
        this.add(this.rightInputButton);
        this.add(this.rightAllButton);
    }

    private void configureAccessibleContext(JComponent jComponent, String string) {
        AccessibleContext accessibleContext = jComponent.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)("ACSN_" + string)));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)("ACSD_" + string)));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.leftAllButton) {
            this.mapper.setFilter(false, this.mapper.isFilterRight());
        } else if (object == this.leftOutputButton) {
            this.mapper.setFilter(true, this.mapper.isFilterRight());
        } else if (object == this.rightAllButton) {
            this.mapper.setFilter(this.mapper.isFilterLeft(), false);
        } else if (object == this.rightInputButton) {
            this.mapper.setFilter(this.mapper.isFilterLeft(), true);
        }
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (JComponent jComponent : new JComponent[]{this.leftAllButton, this.leftOutputButton, this.rightAllButton, this.rightInputButton}) {
            Dimension dimension = jComponent.getPreferredSize();
            n = Math.max(n, dimension.width);
            n2 = Math.max(n2, dimension.height);
            if (!jComponent.isVisible()) continue;
            ++n3;
        }
        n = insets.left + n * n3 + insets.right;
        n2 = insets.top + n2 + insets.bottom;
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = this.getInsets();
        int n3 = insets.left;
        int n4 = n - insets.right;
        int n5 = insets.top;
        int n6 = n2 - insets.top - insets.bottom;
        int n7 = 0;
        for (JComponent jComponent : new JComponent[]{this.leftAllButton, this.leftOutputButton, this.rightAllButton, this.rightInputButton}) {
            n7 = Math.max(n7, jComponent.getPreferredSize().width);
        }
        if (this.leftAllButton.isVisible()) {
            this.leftAllButton.setBounds(n3, n5, n7, n6);
            n3 += n7;
        }
        if (this.leftOutputButton.isVisible()) {
            this.leftOutputButton.setBounds(n3, n5, n7, n6);
            n3 += n7;
        }
        int n8 = n4;
        if (this.rightAllButton.isVisible()) {
            n8 -= n7;
        }
        if (this.rightInputButton.isVisible()) {
            n8 -= n7;
        }
        n8 = Math.max(n8, n3);
        if (this.rightInputButton.isVisible()) {
            this.rightInputButton.setBounds(n8, n5, n7, n6);
            n8 += n7;
        }
        if (this.rightAllButton.isVisible()) {
            this.rightAllButton.setBounds(n8, n5, n7, n6);
        }
    }

    public void updateButtonsState() {
        boolean bl = this.mapper.isFilterLeft();
        boolean bl2 = this.mapper.isFilterRight();
        this.leftAllButton.setSelected(!bl);
        this.leftOutputButton.setSelected(bl);
        this.rightAllButton.setSelected(!bl2);
        this.rightInputButton.setSelected(bl2);
    }

    protected void paintBorder(Graphics graphics) {
        Color color = graphics.getColor();
        int n = this.getWidth() - 1;
        int n2 = this.getHeight() - 1;
        graphics.setColor(this.getBackground().brighter());
        graphics.drawLine(0, 0, n, 0);
        graphics.setColor(this.getBackground().darker());
        graphics.drawLine(0, n2, n, n2);
        graphics.setColor(color);
    }

    private class SwitchRightFilterAction
    extends AbstractAction {
        private SwitchRightFilterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FiltersToolBar.this.mapper.setFilter(FiltersToolBar.this.mapper.isFilterLeft(), !FiltersToolBar.this.mapper.isFilterRight());
        }
    }

    private class SwitchLeftFilterAction
    extends AbstractAction {
        private SwitchLeftFilterAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FiltersToolBar.this.mapper.setFilter(!FiltersToolBar.this.mapper.isFilterLeft(), FiltersToolBar.this.mapper.isFilterRight());
        }
    }
}

