/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mappercore;

import java.awt.Rectangle;
import javax.swing.tree.TreePath;
import org.netbeans.modules.soa.mappercore.MapperNode;
import org.netbeans.modules.soa.mappercore.RightTree;
import org.netbeans.modules.soa.mappercore.event.MapperSelectionEvent;
import org.netbeans.modules.soa.mappercore.event.MapperSelectionListener;

public class AutoScrollSelectionRightTree
implements MapperSelectionListener {
    private RightTree rightTree;
    private TreePath currentPath;

    public AutoScrollSelectionRightTree(RightTree rightTree) {
        this.rightTree = rightTree;
        rightTree.getSelectionModel().addSelectionListener(this);
        this.currentPath = null;
    }

    public void mapperSelectionChanged(MapperSelectionEvent mapperSelectionEvent) {
        Rectangle rectangle;
        TreePath treePath = this.rightTree.getSelectionModel().getSelectedPath();
        if (treePath == this.currentPath) {
            return;
        }
        this.currentPath = treePath;
        if (treePath == null) {
            return;
        }
        MapperNode mapperNode = this.rightTree.getMapper().getNode(treePath, true);
        int n = mapperNode.getContentHeight();
        int n2 = mapperNode.getContentCenterY();
        n2 = mapperNode.yToView(n2);
        Rectangle rectangle2 = this.rightTree.getScrollPane().getViewport().getViewRect();
        if (n2 + n / 2 > rectangle2.y + rectangle2.height && n < rectangle2.height) {
            rectangle = new Rectangle(rectangle2.x, n2 + n / 2, 2, 2);
            this.rightTree.scrollRectToVisible(rectangle);
        }
        if (n2 - n / 2 < rectangle2.y && n < rectangle2.height) {
            rectangle = new Rectangle(rectangle2.x, n2 - n / 2, 2, 2);
            this.rightTree.scrollRectToVisible(rectangle);
        }
        if (n2 + n / 2 > rectangle2.y + rectangle2.height && n > rectangle2.height) {
            rectangle = new Rectangle(rectangle2.x, n2 - n / 2, 2, rectangle2.height);
            this.rightTree.scrollRectToVisible(rectangle);
            return;
        }
        if (n2 - n / 2 < rectangle2.y && n > rectangle2.height) {
            rectangle = new Rectangle(rectangle2.x, n2 + n / 2 - rectangle2.height, 2, rectangle2.height);
            this.rightTree.scrollRectToVisible(rectangle);
            return;
        }
    }
}

