/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.propertysupport.nodes;

import java.awt.Image;
import java.util.LinkedList;
import java.util.List;
import javax.swing.UIManager;
import org.netbeans.modules.uml.core.coreapplication.IPreferenceManager2;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyDefinition;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElement;
import org.netbeans.modules.uml.propertysupport.nodes.PreferenceHelper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public final class PreferenceNode
extends AbstractNode {
    static final String FOLDER_ICON_BASE = "org/openide/loaders/defaultFolder";
    private final IPropertyElement elment;
    private final PreferenceChildren prefChildren;

    public PreferenceNode() {
        this(PreferenceNode.findRootElement());
        this.setDisplayName(NbBundle.getMessage(PreferenceNode.class, (String)"LAB_PreferenceNodeDisplayName"));
    }

    public PreferenceNode(IPropertyElement iPropertyElement) {
        this(iPropertyElement, new PreferenceChildren(iPropertyElement));
    }

    private PreferenceNode(IPropertyElement iPropertyElement, PreferenceChildren preferenceChildren) {
        super((Children)(preferenceChildren.getChildren().isEmpty() ? Children.LEAF : preferenceChildren));
        this.elment = iPropertyElement;
        this.prefChildren = preferenceChildren;
        IPropertyDefinition iPropertyDefinition = iPropertyElement.getPropertyDefinition();
        this.setDisplayName(iPropertyDefinition.getDisplayName());
        this.resolveIconBase(iPropertyDefinition);
    }

    private IPropertyElement getElement() {
        return this.elment;
    }

    public Image getIcon(int n) {
        if (this.getElement() == PreferenceNode.findRootElement()) {
            Image image = (Image)UIManager.get("Nb.Explorer.Folder.icon");
            if (image == null) {
                this.setIconBase(FOLDER_ICON_BASE);
                image = super.getIcon(n);
            }
            return image;
        }
        return super.getIcon(n);
    }

    public Image getOpenedIcon(int n) {
        if (this.getElement() == PreferenceNode.findRootElement()) {
            Image image = (Image)UIManager.get("Nb.Explorer.Folder.openedIcon");
            if (image == null) {
                this.setIconBase(FOLDER_ICON_BASE);
                image = super.getOpenedIcon(n);
            }
            return image;
        }
        return super.getOpenedIcon(n);
    }

    private void resolveIconBase(IPropertyDefinition iPropertyDefinition) {
        String string = iPropertyDefinition.getImage();
        if (string != null && string.length() > 0) {
            int n = string.indexOf(46);
            if (n > 0) {
                string = string.substring(0, n);
            }
            this.setIconBase(string);
        }
    }

    public String getShortDescription() {
        return this.elment.getPropertyDefinition().getHelpDescription();
    }

    protected Sheet createSheet() {
        List<IPropertyElement> list = this.prefChildren.getProperties();
        return PreferenceHelper.createNodeProperties(list);
    }

    public static Node factory() {
        IPropertyElement iPropertyElement = PreferenceNode.findRootElement();
        PreferenceNode preferenceNode = new PreferenceNode(iPropertyElement);
        preferenceNode.setDisplayName(NbBundle.getMessage(PreferenceNode.class, (String)"LAB_PreferenceNodeDisplayName"));
        preferenceNode.setIconBaseWithExtension("org/netbeans/modules/uml/resources/uml");
        return preferenceNode;
    }

    private static IPropertyElement findRootElement() {
        IPropertyElement[] iPropertyElementArray;
        IPropertyElement iPropertyElement = null;
        IPreferenceManager2 iPreferenceManager2 = ProductRetriever.retrieveProduct().getPreferenceManager();
        if (iPreferenceManager2 != null && (iPropertyElementArray = iPreferenceManager2.getPropertyElements()) != null && iPropertyElementArray.length == 1) {
            iPropertyElement = iPropertyElementArray[0];
        }
        return iPropertyElement;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PreferenceChildren
    extends Children.Keys {
        private final List<IPropertyElement> children = new LinkedList<IPropertyElement>();
        private final List<IPropertyElement> properties = new LinkedList<IPropertyElement>();
        private boolean initSubElements = true;
        private final IPropertyElement parentEl;

        public PreferenceChildren(IPropertyElement iPropertyElement) {
            if (iPropertyElement == null) {
                throw new NullPointerException();
            }
            this.parentEl = iPropertyElement;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getChildren());
        }

        protected Node[] createNodes(Object object) {
            Node[] nodeArray = object instanceof IPropertyElement ? new Node[]{new PreferenceNode((IPropertyElement)object)} : new Node[]{};
            return nodeArray;
        }

        public List<IPropertyElement> getChildren() {
            this.initSubElements();
            return this.children;
        }

        public List<IPropertyElement> getProperties() {
            this.initSubElements();
            return this.properties;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initSubElements() {
            List<IPropertyElement> list = this.children;
            synchronized (list) {
                if (this.initSubElements) {
                    PreferenceHelper.analyzeSubElements(this.parentEl, this.children, this.properties);
                    this.initSubElements = false;
                }
            }
        }
    }
}

