/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.treetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;

public class TreeTableCellRenderer
extends JTree
implements TableCellRenderer {
    protected int visibleRow;

    public TreeTableCellRenderer() {
    }

    public TreeTableCellRenderer(TreeModel treeModel) {
        super(treeModel);
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setShowsRootHandles(true);
    }

    public void updateUI() {
        super.updateUI();
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
            defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
            defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
        }
    }

    public void setRowHeight(int n) {
        if (n > 0) {
            super.setRowHeight(n);
            if (this != null && this.getRowHeight() != n) {
                this.setRowHeight(this.getRowHeight());
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, 0, n3, this.getHeight());
    }

    public void paint(Graphics graphics) {
        graphics.translate(0, -this.visibleRow * this.getRowHeight());
        super.paint(graphics);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setShowsRootHandles(true);
        if (bl) {
            this.setBackground(jTable.getSelectionBackground());
        } else {
            this.setBackground(jTable.getBackground());
        }
        this.visibleRow = n;
        return this;
    }
}

