/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.treetable;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyDefinition;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElement;
import org.netbeans.modules.uml.ui.swing.propertyeditor.PropertyEditor;
import org.netbeans.modules.uml.ui.swing.propertyeditor.PropertyEditorResources;
import org.netbeans.modules.uml.ui.swing.treetable.JDefaultMutableTreeNode;
import org.netbeans.modules.uml.ui.swing.treetable.JTreeTable;
import org.netbeans.modules.uml.ui.swing.treetable.PropertyValueCellRenderer;
import org.netbeans.modules.uml.ui.swing.treetable.TreeTableCellEditor;
import org.netbeans.modules.uml.ui.swing.treetable.TreeTableModel;
import org.netbeans.modules.uml.ui.swing.treetable.TreeTablePopupListener;

public class JPropertyTreeTable
extends JTreeTable
implements ActionListener {
    private JPopupMenu m_popup = null;
    private PropertyEditor m_editor = null;
    private int m_CurRow = 0;
    private IPropertyElement m_CurElement = null;

    public JPropertyTreeTable(TreeTableModel treeTableModel, PropertyEditor propertyEditor) {
        super(treeTableModel);
        this.m_editor = propertyEditor;
        this.m_popup = new JPopupMenu();
        GridBagLayout gridBagLayout = new GridBagLayout();
        double[] dArray = new double[]{0.0, 0.5, 0.5};
        gridBagLayout.columnWeights = dArray;
        this.setLayout(gridBagLayout);
        gridBagLayout.invalidateLayout(this);
        this.doLayout();
        TableColumnModel tableColumnModel = this.getColumnModel();
        TreeTableCellEditor treeTableCellEditor = new TreeTableCellEditor(this.tree, propertyEditor);
        tableColumnModel.getColumn(1).setCellEditor(treeTableCellEditor);
        tableColumnModel.getColumn(2).setCellEditor(treeTableCellEditor);
        tableColumnModel.getColumn(0).setCellEditor(treeTableCellEditor);
        tableColumnModel.getColumn(0).setMinWidth(20);
        tableColumnModel.getColumn(0).setMaxWidth(20);
        PropertyValueCellRenderer propertyValueCellRenderer = new PropertyValueCellRenderer();
        tableColumnModel.getColumn(1).setCellRenderer(this.tree);
        tableColumnModel.getColumn(2).setCellRenderer(propertyValueCellRenderer);
        TreeTablePopupListener treeTablePopupListener = new TreeTablePopupListener();
        this.addMouseListener(treeTablePopupListener);
        this.getTree().addMouseListener(new TreeMouseHandler());
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setShowVerticalLines(true);
        this.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 39 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 155 || keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 10) {
                    JPropertyTreeTable.this.m_editor.onKeyDownGrid(keyEvent);
                    keyEvent.consume();
                } else if (keyEvent.getKeyCode() == 9) {
                    JPropertyTreeTable.this.m_editor.onKeyDownGrid(keyEvent);
                    if (keyEvent.isShiftDown()) {
                        JPropertyTreeTable.this.m_CurRow--;
                    } else {
                        JPropertyTreeTable.this.m_CurRow++;
                    }
                    keyEvent.consume();
                } else if (keyEvent.getKeyCode() == 38) {
                    JPropertyTreeTable.this.m_editor.onKeyDownGrid(keyEvent);
                    JPropertyTreeTable.this.m_CurRow--;
                    keyEvent.consume();
                } else if (keyEvent.getKeyCode() == 40) {
                    JPropertyTreeTable.this.m_editor.onKeyDownGrid(keyEvent);
                    JPropertyTreeTable.this.m_CurRow++;
                    keyEvent.consume();
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                keyEvent.consume();
            }
        });
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public void startEditingRow(int n) {
        this.m_editor.startEditingRowAt(n);
        this.m_CurRow = n;
    }

    public void handlePopupDisplay(MouseEvent mouseEvent) {
        this.m_popup.removeAll();
        int n = this.rowAtPoint(mouseEvent.getPoint());
        TreePath treePath = this.getTree().getPathForRow(n);
        if (treePath != null) {
            this.m_editor.handleSave(true, null);
            this.m_editor.setEditingComponent(null);
            Object object = treePath.getLastPathComponent();
            ETSystem.out.println(object.getClass());
            JDefaultMutableTreeNode jDefaultMutableTreeNode = (JDefaultMutableTreeNode)object;
            IPropertyElement iPropertyElement = (IPropertyElement)jDefaultMutableTreeNode.getUserObject();
            if (iPropertyElement != null) {
                this.m_CurRow = n;
                this.m_CurElement = iPropertyElement;
                IPropertyDefinition iPropertyDefinition = iPropertyElement.getPropertyDefinition();
                String[] stringArray = this.m_editor.showMenuBasedOnDefinition(iPropertyDefinition, iPropertyElement);
                this.m_editor.setRightClickRow(n);
                if (stringArray != null) {
                    int n2 = stringArray.length;
                    for (int i = 0; i < n2; ++i) {
                        JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
                        jMenuItem.addActionListener(this);
                        this.m_popup.add(jMenuItem);
                    }
                }
            }
        }
        if (this.m_popup != null) {
            this.m_popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public PropertyEditor getPropertyEditor() {
        return this.m_editor;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getText();
        if (string.equals(PropertyEditorResources.getString("PropertyEditor.Create_Menu"))) {
            this.m_editor.onPopupCreate(this.m_CurRow, this.m_CurElement);
        } else if (string.equals(PropertyEditorResources.getString("PropertyEditor.Delete_Menu"))) {
            this.m_editor.onPopupDelete();
        } else if (string.equals(PropertyEditorResources.getString("PropertyEditor.Navigate_Menu"))) {
            this.m_editor.onPopupNavigate();
        } else if (string.equals(PropertyEditorResources.getString("PropertyEditor.Fill_Down_Menu"))) {
            this.m_editor.onPopupFill();
        }
    }

    public class TreeMouseHandler
    extends MouseInputAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            int n = JPropertyTreeTable.this.getTree().getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath = JPropertyTreeTable.this.getTree().getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n != -1) {
                Object object;
                if (mouseEvent.getClickCount() == 2) {
                    JPropertyTreeTable.this.m_editor.handleDoubleClick(n, treePath);
                    JPropertyTreeTable.this.m_editor.refresh();
                } else if (mouseEvent.getClickCount() != 1 || (object = treePath.getLastPathComponent()) instanceof JDefaultMutableTreeNode) {
                    // empty if block
                }
            }
        }
    }
}

