/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.projecttree;

import java.awt.Container;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputAdapter;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.support.umlsupport.FileExtensions;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeItem;
import org.netbeans.modules.uml.ui.controls.projecttree.ProjectTreeDragVerifyImpl;
import org.netbeans.modules.uml.ui.support.ADTransferable;
import org.netbeans.modules.uml.ui.swing.projecttree.JProjectTree;

public class ProjectTreeTransferHandler
extends TransferHandler
implements FileExtensions {
    private ProjectTreeMouseHandler m_DragMoveListener = new ProjectTreeMouseHandler();
    private int m_MoveAction = 0;

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        boolean bl = false;
        if (jComponent != null) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (dataFlavorArray[i].equals(ADTransferable.ADDataFlavor)) {
                    bl = true;
                    continue;
                }
                if (!dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
                bl = true;
            }
        }
        return bl;
    }

    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        this.m_MoveAction = n;
        super.exportAsDrag(jComponent, inputEvent, n);
        JProjectTree jProjectTree = this.getProjectTree(jComponent);
        if (jProjectTree != null) {
            jProjectTree.resetDragState();
        }
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        JProjectTree jProjectTree = this.getProjectTree(jComponent);
        if (jProjectTree != null) {
            this.m_DragMoveListener.setDataObject(null);
            jProjectTree.removeMouseMotionListener(this.m_DragMoveListener);
        }
        super.exportDone(jComponent, transferable, n);
    }

    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
        super.exportToClipboard(jComponent, clipboard, n);
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        boolean bl = false;
        JProjectTree jProjectTree = this.getProjectTree(jComponent);
        if (jProjectTree != null) {
            bl = jProjectTree.fireEndDrag(transferable, this.m_MoveAction);
        }
        return bl;
    }

    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        Transferable transferable = null;
        JProjectTree jProjectTree = this.getProjectTree(jComponent);
        if (jProjectTree != null && jProjectTree.fireBeginDrag(jProjectTree.getSelected())) {
            transferable = this.populateDragSource(jProjectTree);
        }
        return transferable;
    }

    protected JProjectTree getProjectTree(Container container) {
        JProjectTree jProjectTree = null;
        Container container2 = container.getParent();
        if (container2 instanceof JProjectTree) {
            jProjectTree = (JProjectTree)container2;
        } else if (container2 != null) {
            jProjectTree = this.getProjectTree(container2);
        }
        return jProjectTree;
    }

    private Transferable populateDragSource(JProjectTree jProjectTree) {
        ADTransferable aDTransferable = null;
        IProjectTreeItem[] iProjectTreeItemArray = jProjectTree.getSelected();
        if (iProjectTreeItemArray != null && iProjectTreeItemArray.length > 0) {
            aDTransferable = new ADTransferable("DRAGGEDITEMS");
            for (int i = 0; i < iProjectTreeItemArray.length; ++i) {
                Object object;
                if (iProjectTreeItemArray[i].isModelElement() && !iProjectTreeItemArray[i].isProject()) {
                    object = iProjectTreeItemArray[i].getModelElement();
                    aDTransferable.addModelElement((IElement)object);
                    continue;
                }
                if (iProjectTreeItemArray[i].isProject()) continue;
                object = iProjectTreeItemArray[i].getDescription();
                if (StringUtilities.hasExtension((String)object, ".etld")) {
                    aDTransferable.addDiagramLocation((String)object);
                    continue;
                }
                if (((String)object).length() <= 0) continue;
                aDTransferable.addGenericElement((String)object);
            }
        }
        if (aDTransferable != null) {
            this.m_DragMoveListener.setDataObject(aDTransferable);
            jProjectTree.addMouseMotionListener(this.m_DragMoveListener);
        }
        return aDTransferable;
    }

    public class ProjectTreeMouseHandler
    extends MouseInputAdapter {
        private Transferable m_DataObject = null;

        public void mouseDragged(MouseEvent mouseEvent) {
            JProjectTree jProjectTree = ProjectTreeTransferHandler.this.getProjectTree((Container)mouseEvent.getComponent());
            if (jProjectTree != null) {
                ProjectTreeDragVerifyImpl projectTreeDragVerifyImpl = new ProjectTreeDragVerifyImpl();
                if (jProjectTree.fireMoveDrag(this.getDataObject(), projectTreeDragVerifyImpl)) {
                    // empty if block
                }
            }
        }

        public Transferable getDataObject() {
            return this.m_DataObject;
        }

        public void setDataObject(Transferable transferable) {
            this.m_DataObject = transferable;
        }
    }
}

