/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.preferencedialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.uml.common.generics.ETPairT;
import org.netbeans.modules.uml.core.coreapplication.IPreferenceManager2;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IConfigManager;
import org.netbeans.modules.uml.core.preferenceframework.IPreferenceManagerEventsSink;
import org.netbeans.modules.uml.core.preferenceframework.PreferenceManagerEventsAdapter;
import org.netbeans.modules.uml.core.support.umlsupport.ProductRetriever;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyDefinition;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyElement;
import org.netbeans.modules.uml.ui.support.DispatchHelper;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.QuestionResponse;
import org.netbeans.modules.uml.ui.support.drawingproperties.FontChooser;
import org.netbeans.modules.uml.ui.support.drawingproperties.FontColorDialogs.ApplicationColorsAndFonts;
import org.netbeans.modules.uml.ui.swing.commondialogs.JCenterDialog;
import org.netbeans.modules.uml.ui.swing.commondialogs.SwingErrorDialog;
import org.netbeans.modules.uml.ui.swing.commondialogs.SwingQuestionDialogImpl;
import org.netbeans.modules.uml.ui.swing.preferencedialog.DefaultPreferenceDialogResource;
import org.netbeans.modules.uml.ui.swing.preferencedialog.JPreferenceDialogTable;
import org.netbeans.modules.uml.ui.swing.preferencedialog.JPreferenceDialogTree;
import org.netbeans.modules.uml.ui.swing.preferencedialog.PreferenceDialogTableModel;
import org.netbeans.modules.uml.ui.swing.preferencedialog.PreferenceDialogTreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceDialogUI
extends JCenterDialog {
    private JPanel jAdvancedPanel;
    private JPanel jDetailsSplitPanel;
    private JSplitPane jSplitPane;
    private JButton jDefaultsButton;
    private JButton jOKButton;
    private JButton jCancelButton;
    private JPanel jButtonsPanel;
    private JPanel jCategoryPanel;
    private JCheckBox jCheckBox1;
    private JPanel jDetailsPanel;
    private JPanel jHelpPanel;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JTextArea jTextArea1;
    private JScrollPane jScrollPaneTextArea;
    private JPreferenceDialogTree jTree1;
    private PreferenceDialogTableModel m_TableModel = null;
    private boolean m_Advanced = false;
    private boolean m_isFileReadOnly = false;
    private IPreferenceManagerEventsSink m_EventsSink = null;

    public PreferenceDialogUI(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.jTree1.setSelectionRow(0);
        this.center(frame);
    }

    private void initComponents() {
        this.jCategoryPanel = new JPanel();
        PreferenceDialogTreeModel preferenceDialogTreeModel = new PreferenceDialogTreeModel(this);
        this.jTree1 = new JPreferenceDialogTree(preferenceDialogTreeModel, this);
        this.jScrollPane1 = new JScrollPane(this.jTree1);
        this.jDetailsPanel = new JPanel();
        this.jAdvancedPanel = new JPanel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jHelpPanel = new JPanel();
        this.jTextArea1 = new JTextArea(" ");
        this.jTextArea1.setEditable(false);
        this.jButtonsPanel = new JPanel();
        this.jDefaultsButton = new JButton();
        this.jOKButton = new JButton();
        this.jCancelButton = new JButton();
        this.jDetailsSplitPanel = new JPanel();
        this.jDetailsSplitPanel.setLayout(new GridBagLayout());
        this.setTitle(DefaultPreferenceDialogResource.getString("IDS_PREFERENCES"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PreferenceDialogUI.this.closeDialog(windowEvent);
            }

            public void windowClosed(WindowEvent windowEvent) {
            }
        });
        this.jCancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialogUI.this.performCancelAction();
            }
        });
        this.jOKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PreferenceDialogUI.this.jTable1.isEditing()) {
                    PreferenceDialogUI.this.jTable1.getCellEditor().stopCellEditing();
                }
                PreferenceDialogUI.this.performSaveAction(true);
            }
        });
        this.jDefaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PreferenceDialogUI.this.performRestoreDefaultsAction();
            }
        });
        Font font = UIManager.getFont("controlFont");
        int n = font != null ? font.getSize() : 12;
        Font font2 = new Font("Dialog", 0, n);
        this.jCategoryPanel.setLayout(new GridBagLayout());
        this.jCategoryPanel.setBorder(new TitledBorder(DefaultPreferenceDialogResource.getString("IDS_CATEGORIES")));
        this.jCategoryPanel.setFont(font2);
        this.jTree1.setShowsRootHandles(true);
        this.jScrollPane1.setViewportView(this.jTree1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jCategoryPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weighty = 0.5;
        this.jDetailsSplitPanel.add((Component)this.jCategoryPanel, gridBagConstraints);
        this.jDetailsPanel.setLayout(new GridBagLayout());
        this.jDetailsPanel.setBorder(new TitledBorder(DefaultPreferenceDialogResource.getString("IDS_DETAILS")));
        this.jDetailsPanel.setFont(font2);
        this.m_TableModel = new PreferenceDialogTableModel(this);
        this.jTable1 = new JPreferenceDialogTable(this.m_TableModel, this);
        this.jScrollPane2 = new JScrollPane(this.jTable1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jDetailsPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jAdvancedPanel.setLayout(new GridBagLayout());
        this.jCheckBox1.setFont(font2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.jAdvancedPanel.add((Component)this.jCheckBox1, gridBagConstraints);
        this.jCheckBox1.setEnabled(true);
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox) {
                    JCheckBox jCheckBox = (JCheckBox)object;
                    boolean bl = jCheckBox.isSelected();
                    if (PreferenceDialogUI.this.m_Advanced != bl) {
                        PreferenceDialogUI.this.m_Advanced = bl;
                        PreferenceDialogUI.this.jTree1.reload();
                        PreferenceDialogUI.this.jTree1.doLayout();
                    }
                }
            }
        });
        this.jLabel1.setFont(font2);
        this.jLabel1.setText(DefaultPreferenceDialogResource.determineText(DefaultPreferenceDialogResource.getString("IDS_ADVANCED")));
        DefaultPreferenceDialogResource.setMnemonic(this.jLabel1, DefaultPreferenceDialogResource.getString("IDS_ADVANCED"));
        DefaultPreferenceDialogResource.setMnemonic(this.jCheckBox1, DefaultPreferenceDialogResource.getString("IDS_ADVANCED"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.jAdvancedPanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        this.jDetailsSplitPanel.add((Component)this.jAdvancedPanel, gridBagConstraints);
        this.jSplitPane = new JSplitPane(1, this.jDetailsSplitPanel, this.jDetailsPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.jSplitPane, gridBagConstraints);
        this.jSplitPane.setDividerLocation(200);
        this.jHelpPanel.setLayout(new GridBagLayout());
        this.jHelpPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setRows(2);
        this.jTextArea1.setOpaque(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setFont(font2);
        this.jTextArea1.setMargin(new Insets(2, 2, 2, 2));
        this.jScrollPaneTextArea = new JScrollPane(this.jTextArea1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jHelpPanel.add((Component)this.jScrollPaneTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.1;
        this.getContentPane().add((Component)this.jHelpPanel, gridBagConstraints);
        this.jButtonsPanel.setLayout(new BorderLayout());
        this.jDefaultsButton.setFont(font2);
        this.jDefaultsButton.setText(DefaultPreferenceDialogResource.determineText(DefaultPreferenceDialogResource.getString("IDS_RESTOREDEFAULTS")));
        DefaultPreferenceDialogResource.setMnemonic(this.jDefaultsButton, DefaultPreferenceDialogResource.getString("IDS_RESTOREDEFAULTS"));
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.jDefaultsButton);
        this.jButtonsPanel.add((Component)box, "West");
        Dimension dimension = new Dimension(75, 25);
        this.jOKButton.setFont(font2);
        this.jOKButton.setText(DefaultPreferenceDialogResource.getString("IDS_OK"));
        box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.jOKButton);
        box.add(Box.createHorizontalStrut(1));
        box.add(Box.createHorizontalGlue());
        box.add(this.jCancelButton);
        this.jButtonsPanel.add((Component)box, "East");
        this.jCancelButton.setFont(font2);
        this.jCancelButton.setText(DefaultPreferenceDialogResource.getString("IDS_CANCEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 2, 5);
        this.getContentPane().add((Component)this.jButtonsPanel, gridBagConstraints);
        this.pack();
        this.setSize(new Dimension(this.setPanelSize()));
        this.initializePreferenceEventsSink();
        this.initializeButtonStates();
    }

    private Dimension setPanelSize() {
        Font font = UIManager.getFont("controlFont");
        int n = font != null ? font.getSize() : 12;
        int n2 = 600;
        int n3 = 500;
        int n4 = 2;
        if (n > 17) {
            n4 = 3;
        }
        n2 += Math.round((float)n2 * ((float)(n4 * n) / 100.0f));
        n3 += Math.round((float)n3 * ((float)(n4 * n) / 100.0f));
        return new Dimension(n2, n3);
    }

    private void initializeButtonStates() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        Object object2 = this.jTree1.getModel().getRoot();
        if (object2 != null && object2 instanceof DefaultMutableTreeNode && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)object2).getUserObject()) != null && object instanceof IPropertyElement) {
            IPropertyElement iPropertyElement = (IPropertyElement)object;
            IPreferenceManager2 iPreferenceManager2 = ProductRetriever.retrieveProduct().getPreferenceManager();
            if (iPreferenceManager2 != null) {
                if (iPreferenceManager2.isEditable(iPropertyElement)) {
                    this.m_isFileReadOnly = false;
                } else {
                    this.m_isFileReadOnly = true;
                    this.jDefaultsButton.setEnabled(false);
                    this.jOKButton.setEnabled(false);
                }
            }
        }
    }

    private void initializePreferenceEventsSink() {
        if (this.m_EventsSink == null) {
            this.m_EventsSink = new PreferenceManagerEventsAdapter();
        }
        if (this.m_EventsSink != null) {
            DispatchHelper dispatchHelper = new DispatchHelper();
            dispatchHelper.registerForPreferenceManagerEvents(this.m_EventsSink);
        }
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public void refreshUI() {
        this.doLayout();
        this.setVisible(true);
        this.paintAll(this.getGraphics());
    }

    public Vector<DefaultMutableTreeNode> loadTree() {
        IPropertyElement[] iPropertyElementArray;
        Vector<DefaultMutableTreeNode> vector = new Vector<DefaultMutableTreeNode>();
        IPreferenceManager2 iPreferenceManager2 = ProductRetriever.retrieveProduct().getPreferenceManager();
        if (iPreferenceManager2 != null && (iPropertyElementArray = iPreferenceManager2.getPropertyElements()) != null) {
            for (IPropertyElement iPropertyElement : iPropertyElementArray) {
                IPropertyDefinition iPropertyDefinition = iPropertyElement.getPropertyDefinition();
                if (iPropertyDefinition == null) continue;
                String string = iPropertyDefinition.getDisplayName();
                boolean bl = true;
                String string2 = iPropertyDefinition.getFromAttrMap("advanced");
                if (string2 != null && string2.equals("PSK_TRUE") && !this.m_Advanced) {
                    bl = false;
                }
                if (!bl) continue;
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(iPropertyElement);
                vector.add(defaultMutableTreeNode);
                this.loadTreeWithSubElements(defaultMutableTreeNode, iPropertyDefinition, iPropertyElement);
            }
        }
        return vector;
    }

    private void loadTreeWithSubElements(DefaultMutableTreeNode defaultMutableTreeNode, IPropertyDefinition iPropertyDefinition, IPropertyElement iPropertyElement) {
        Vector<IPropertyElement> vector;
        if (this.hasGrandChildren(iPropertyElement) && (vector = iPropertyElement.getSubElements()) != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                IPropertyDefinition iPropertyDefinition2;
                IPropertyElement iPropertyElement2 = vector.elementAt(i);
                if (!this.hasChildren(iPropertyElement2) || (iPropertyDefinition2 = iPropertyElement2.getPropertyDefinition()) == null) continue;
                String string = iPropertyDefinition2.getDisplayName();
                String string2 = iPropertyDefinition2.getControlType();
                if (!(string != null && string.length() != 0 || string2 != null && string2.length() != 0)) continue;
                boolean bl = true;
                String string3 = iPropertyDefinition2.getFromAttrMap("advanced");
                if (string3 != null && string3.equals("PSK_TRUE") && !this.m_Advanced) {
                    bl = false;
                }
                if (!bl) continue;
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(iPropertyElement2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                this.loadTreeWithSubElements(defaultMutableTreeNode2, iPropertyDefinition2, iPropertyElement2);
            }
        }
    }

    private boolean hasChildren(IPropertyElement iPropertyElement) {
        Vector<IPropertyElement> vector;
        boolean bl = false;
        if (iPropertyElement != null && (vector = iPropertyElement.getSubElements()) != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                IPropertyElement iPropertyElement2 = vector.elementAt(i);
                IPropertyDefinition iPropertyDefinition = iPropertyElement2.getPropertyDefinition();
                if (iPropertyDefinition == null) continue;
                String string = iPropertyDefinition.getDisplayName();
                String string2 = iPropertyDefinition.getControlType();
                if (!(string != null && string.length() != 0 || string2 != null && string2.length() != 0)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean hasGrandChildren(IPropertyElement iPropertyElement) {
        Vector<IPropertyElement> vector;
        boolean bl = false;
        if (iPropertyElement != null && (vector = iPropertyElement.getSubElements()) != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                int n2;
                IPropertyElement iPropertyElement2 = vector.elementAt(i);
                Vector<IPropertyElement> vector2 = iPropertyElement2.getSubElements();
                if (vector2 == null || (n2 = vector2.size()) <= 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public PreferenceDialogUI() {
        this.initComponents();
        this.jTree1.setSelectionRow(0);
    }

    public ETList<ETPairT<IPropertyElement, String>> loadTable(IPropertyElement iPropertyElement) {
        if (this.jTable1.getCellEditor() != null) {
            this.jTable1.getCellEditor().stopCellEditing();
        }
        ETList<ETPairT<IPropertyElement, String>> eTList = this.loadGrid(iPropertyElement);
        this.loadHelp(iPropertyElement);
        this.enableButtons();
        this.jDetailsPanel.removeAll();
        this.jTable1 = null;
        this.jScrollPane2 = null;
        this.m_TableModel = new PreferenceDialogTableModel(this, eTList);
        this.jTable1 = new JPreferenceDialogTable(this.m_TableModel, this);
        this.jTable1.setRowHeight(this.jTable1.getRowHeight() + 1);
        this.jScrollPane2 = new JScrollPane(this.jTable1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jDetailsPanel.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jTable1.updateUI();
        this.jScrollPane2.doLayout();
        this.jDetailsPanel.doLayout();
        this.doLayout();
        return eTList;
    }

    private void enableButtons() {
    }

    public void loadHelp(IPropertyElement iPropertyElement) {
        IPropertyDefinition iPropertyDefinition;
        if (iPropertyElement != null && (iPropertyDefinition = iPropertyElement.getPropertyDefinition()) != null) {
            String string = iPropertyDefinition.getHelpDescription();
            this.jTextArea1.setText(string);
            this.jTextArea1.setCaretPosition(0);
        }
    }

    private ETList<ETPairT<IPropertyElement, String>> loadGrid(IPropertyElement iPropertyElement) {
        Vector<IPropertyElement> vector;
        ETArrayList<ETPairT<IPropertyElement, String>> eTArrayList = new ETArrayList<ETPairT<IPropertyElement, String>>();
        if (iPropertyElement != null && (vector = iPropertyElement.getSubElements()) != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                IPropertyDefinition iPropertyDefinition;
                IPropertyDefinition iPropertyDefinition2;
                IPropertyElement iPropertyElement2 = vector.elementAt(i);
                if (this.hasChildren(iPropertyElement2) || (iPropertyDefinition2 = iPropertyElement.getPropertyDefinition()) == null || (iPropertyDefinition = iPropertyElement2.getPropertyDefinition()) == null) continue;
                boolean bl = true;
                String string = iPropertyDefinition.getFromAttrMap("advanced");
                if (string != null && string.equals("PSK_TRUE") && !this.m_Advanced) {
                    bl = false;
                }
                if (!bl) continue;
                String string2 = iPropertyDefinition.getName();
                int n2 = string2.indexOf("Font");
                if (n2 >= 0) {
                    this.specialFontProcessing(iPropertyDefinition, iPropertyElement2, eTArrayList);
                    continue;
                }
                n2 = string2.indexOf("Color");
                if (n2 >= 0) {
                    this.specialColorProcessing(iPropertyDefinition, iPropertyElement2, eTArrayList);
                    continue;
                }
                String string3 = iPropertyDefinition.getDisplayName();
                if (string3 == null || string3.length() <= 0) continue;
                String string4 = iPropertyElement2.getTranslatedValue();
                if (string4 == null) {
                    string4 = "";
                }
                eTArrayList.add(new ETPairT<IPropertyElement, String>(iPropertyElement2, string4));
            }
        }
        return eTArrayList;
    }

    private void specialColorProcessing(IPropertyDefinition iPropertyDefinition, IPropertyElement iPropertyElement, ETList<ETPairT<IPropertyElement, String>> eTList) {
        if (iPropertyDefinition != null && iPropertyElement != null) {
            String string = iPropertyDefinition.getDisplayName();
            eTList.add(new ETPairT<IPropertyElement, String>(iPropertyElement, string));
        }
    }

    private void specialFontProcessing(IPropertyDefinition iPropertyDefinition, IPropertyElement iPropertyElement, ETList<ETPairT<IPropertyElement, String>> eTList) {
        if (iPropertyDefinition != null && iPropertyElement != null) {
            String string = iPropertyDefinition.getDisplayName();
            IPropertyElement iPropertyElement2 = iPropertyElement.getSubElement("FaceName", null);
            if (iPropertyElement2 != null) {
                String string2 = iPropertyElement2.getTranslatedValue();
                eTList.add(new ETPairT<IPropertyElement, String>(iPropertyElement, string2));
            }
        }
    }

    private void performSaveAction(boolean bl) {
        try {
            if (!this.m_isFileReadOnly) {
                IPreferenceManager2 iPreferenceManager2 = ProductRetriever.retrieveProduct().getPreferenceManager();
                iPreferenceManager2.save();
                if (bl) {
                    this.closeDialog(null);
                }
            } else {
                this.displaySaveErrorMessage();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void displaySaveErrorMessage() {
        String string = this.loadString("IDS_PROJNAME2");
        String string2 = this.loadString("IDS_SAVEMESSAGE");
        IConfigManager iConfigManager = ProductHelper.getConfigManager();
        if (iConfigManager != null) {
            String string3 = iConfigManager.getDefaultConfigLocation();
            string3 = string3 + "PreferenceProperties.etcd";
            String string4 = StringUtilities.replaceAllSubstrings(string2, "%s", string3);
            SwingErrorDialog swingErrorDialog = new SwingErrorDialog(this);
            if (swingErrorDialog != null) {
                swingErrorDialog.display(string4, 3, string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRestoreDefaultsAction() {
        SwingQuestionDialogImpl swingQuestionDialogImpl = new SwingQuestionDialogImpl(this);
        if (swingQuestionDialogImpl != null) {
            String string = this.loadString("IDS_RESTORETITLE");
            String string2 = this.loadString("IDS_RESTOREWARNING");
            QuestionResponse questionResponse = swingQuestionDialogImpl.displaySimpleQuestionDialog(4, 2, string2, 5, null, string);
            if (questionResponse.getResult() == 5) {
                this.refreshUI();
                IPreferenceManager2 iPreferenceManager2 = ProductRetriever.retrieveProduct().getPreferenceManager();
                if (iPreferenceManager2 != null) {
                    try {
                        this.getRootPane().setCursor(new Cursor(3));
                        iPreferenceManager2.restore();
                        this.performSaveAction(false);
                        this.jTree1.reload();
                        this.jTree1.setSelectionRow(0);
                    }
                    finally {
                        this.getRootPane().setCursor(new Cursor(0));
                    }
                }
            }
        }
    }

    private void performCancelAction() {
        if (!this.m_isFileReadOnly) {
            IPreferenceManager2 iPreferenceManager2 = ProductRetriever.retrieveProduct().getPreferenceManager();
            iPreferenceManager2.reloadPreferences();
        }
        this.closeDialog(null);
    }

    public IPropertyElement getElementAtGridRow(int n) {
        Object object;
        IPropertyElement iPropertyElement = null;
        if (n > -1 && this.jTable1 != null && (object = this.m_TableModel.getValueAt(n, 0)) instanceof IPropertyElement) {
            iPropertyElement = (IPropertyElement)object;
        }
        return iPropertyElement;
    }

    public void onCellButtonClicked(int n, IPropertyElement iPropertyElement) {
        IPropertyDefinition iPropertyDefinition;
        if (iPropertyElement != null && (iPropertyDefinition = iPropertyElement.getPropertyDefinition()) != null) {
            Font font;
            Font font2;
            String string = iPropertyDefinition.getName();
            int n2 = string.indexOf("Resources");
            int n3 = string.indexOf("Font");
            if (n2 == 0 && string.length() == 9) {
                ApplicationColorsAndFonts applicationColorsAndFonts = new ApplicationColorsAndFonts(this);
                applicationColorsAndFonts.center(this);
                applicationColorsAndFonts.show();
                this.jTable1.editCellAt(n, 1);
            } else if (n3 > -1 && (font2 = FontChooser.selectFont(font = this.buildCurrentFont(iPropertyElement))) != null) {
                this.updateFontOnPropertyElement(iPropertyElement, font2);
                this.jTable1.editCellAt(n, 1);
            }
        }
    }

    public Font buildCurrentFont(IPropertyElement iPropertyElement) {
        Font font = null;
        if (iPropertyElement != null) {
            IPropertyElement iPropertyElement2 = iPropertyElement.getSubElement("FaceName", null);
            String string = iPropertyElement2.getValue();
            String string2 = iPropertyElement.getSubElement("Height", null).getValue();
            String string3 = iPropertyElement.getSubElement("Weight", null).getValue();
            int n = new Integer(string3);
            String string4 = iPropertyElement.getSubElement("Italic", null).getValue();
            int n2 = 0;
            if (n > 400) {
                n2 |= 1;
            }
            if (string4.equals("1")) {
                n2 |= 2;
            }
            if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
                font = new Font(string, n2, new Integer(string2));
            }
        }
        return font;
    }

    public Color buildCurrentColor(IPropertyElement iPropertyElement) {
        int n;
        ETList<String> eTList;
        String string;
        Color color = null;
        if (iPropertyElement != null && (string = iPropertyElement.getValue()) != null && string.length() > 0 && (eTList = StringUtilities.splitOnDelimiter(string, ", ")) != null && (n = eTList.size()) == 3) {
            Integer n2 = new Integer((String)eTList.get(0));
            Integer n3 = new Integer((String)eTList.get(1));
            Integer n4 = new Integer((String)eTList.get(2));
            color = new Color(n2, n3, n4);
        }
        return color;
    }

    public void updateFontOnPropertyElement(IPropertyElement iPropertyElement, Font font) {
        if (iPropertyElement != null && font != null) {
            String string = font.getName();
            IPropertyElement iPropertyElement2 = iPropertyElement.getSubElement("FaceName", null);
            if (iPropertyElement2 != null) {
                iPropertyElement2.setValue(string);
                iPropertyElement2.setModified(true);
            }
            Integer n = new Integer(font.getSize());
            IPropertyElement iPropertyElement3 = iPropertyElement.getSubElement("Height", null);
            if (iPropertyElement3 != null) {
                iPropertyElement3.setValue(n.toString());
                iPropertyElement3.setModified(true);
            }
            boolean bl = font.isBold();
            IPropertyElement iPropertyElement4 = iPropertyElement.getSubElement("Weight", null);
            if (bl && iPropertyElement4 != null) {
                iPropertyElement4.setValue("700");
                iPropertyElement4.setModified(true);
            } else if (iPropertyElement4 != null) {
                iPropertyElement4.setValue("400");
                iPropertyElement4.setModified(true);
            }
            boolean bl2 = font.isItalic();
            IPropertyElement iPropertyElement5 = iPropertyElement.getSubElement("Italic", null);
            if (bl2 && iPropertyElement5 != null) {
                iPropertyElement5.setValue("1");
                iPropertyElement5.setModified(true);
            } else if (iPropertyElement5 != null) {
                iPropertyElement5.setValue("0");
                iPropertyElement5.setModified(true);
            }
            iPropertyElement.setModified(true);
        }
    }

    public void updateColorOnPropertyElement(IPropertyElement iPropertyElement, Color color) {
        if (iPropertyElement != null && color != null) {
            int n = color.getRed();
            int n2 = color.getGreen();
            int n3 = color.getBlue();
            Integer n4 = new Integer(n);
            Integer n5 = new Integer(n2);
            Integer n6 = new Integer(n3);
            String string = n4.toString() + ", " + n5.toString() + ", " + n6.toString();
            iPropertyElement.setValue(string);
            iPropertyElement.setModified(true);
        }
    }

    public void refreshFontElement(IPropertyElement iPropertyElement) {
        if (iPropertyElement != null) {
            this.jTable1.updateUI();
        }
    }

    private String loadString(String string) {
        return DefaultPreferenceDialogResource.getString(string);
    }
}

