/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.netbeans.modules.uml.ui.swing.plaf.PullDownButtonUI;
import org.netbeans.modules.uml.ui.swing.pulldownbutton.IPulldownButtonInvoker;
import org.netbeans.modules.uml.ui.swing.pulldownbutton.JPullDownButton;

public class BasicPullDownButtonUI
extends PullDownButtonUI {
    private static final BasicPullDownButtonUI buttonUI = new BasicPullDownButtonUI();
    protected int defaultTextIconGap;
    private int shiftOffset = 0;
    protected int defaultTextShiftOffset;
    private boolean defaults_initialized = false;
    private JPullDownButton m_Button = null;
    private int m_ArrowWidth = 6;
    private int m_ArrowInsetWidth = 3;
    private int m_LargeArrowWidth = 16;
    private static final String propertyPrefix = "Button.";
    private Color defaultForeground = null;
    private Color defaultBackground = null;
    private Font defaultFont = null;
    private Border defaultBorder = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return buttonUI;
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    public void installUI(JComponent jComponent) {
        this.m_Button = (JPullDownButton)jComponent;
        this.installDefaults(this.m_Button);
        this.installListeners(this.m_Button);
        this.installKeyboardActions(this.m_Button);
        BasicHTML.updateRenderer(jComponent, this.m_Button.getText());
    }

    protected void installDefaults(AbstractButton abstractButton) {
        String string = this.getPropertyPrefix();
        if (!this.defaults_initialized) {
            this.defaultTextIconGap = (Integer)UIManager.get(string + "textIconGap");
            this.defaultTextShiftOffset = (Integer)UIManager.get(string + "textShiftOffset");
            this.defaults_initialized = true;
        }
        if (abstractButton.isContentAreaFilled()) {
            abstractButton.setOpaque(true);
        } else {
            abstractButton.setOpaque(false);
        }
        if (abstractButton.getMargin() == null || abstractButton.getMargin() instanceof UIResource) {
            abstractButton.setMargin(UIManager.getInsets(string + "margin"));
        }
        LookAndFeel.installColorsAndFont(abstractButton, string + "background", string + "foreground", string + "font");
        LookAndFeel.installBorder(abstractButton, string + "border");
    }

    protected void installListeners(AbstractButton abstractButton) {
        InvocationMouseHandler invocationMouseHandler;
        BasicButtonListener basicButtonListener = this.createButtonListener(abstractButton);
        if (basicButtonListener != null) {
            abstractButton.putClientProperty(this, basicButtonListener);
            abstractButton.addMouseListener(basicButtonListener);
            abstractButton.addMouseMotionListener(basicButtonListener);
            abstractButton.addFocusListener(basicButtonListener);
            abstractButton.addPropertyChangeListener(basicButtonListener);
            abstractButton.addChangeListener(basicButtonListener);
        }
        if ((invocationMouseHandler = new InvocationMouseHandler()) != null) {
            abstractButton.addMouseListener(invocationMouseHandler);
        }
    }

    protected void installKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        if (basicButtonListener != null) {
            basicButtonListener.installKeyboardActions(abstractButton);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.setPopupVisible(this.m_Button, false);
        this.uninstallKeyboardActions((AbstractButton)jComponent);
        this.uninstallListeners((AbstractButton)jComponent);
        this.uninstallDefaults((AbstractButton)jComponent);
        BasicHTML.updateRenderer(jComponent, "");
    }

    protected void uninstallKeyboardActions(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        if (basicButtonListener != null) {
            basicButtonListener.uninstallKeyboardActions(abstractButton);
        }
    }

    protected void uninstallListeners(AbstractButton abstractButton) {
        BasicButtonListener basicButtonListener = (BasicButtonListener)abstractButton.getClientProperty(this);
        abstractButton.putClientProperty(this, null);
        if (basicButtonListener != null) {
            abstractButton.removeMouseListener(basicButtonListener);
            abstractButton.removeMouseListener(basicButtonListener);
            abstractButton.removeMouseMotionListener(basicButtonListener);
            abstractButton.removeFocusListener(basicButtonListener);
            abstractButton.removeChangeListener(basicButtonListener);
            abstractButton.removePropertyChangeListener(basicButtonListener);
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        LookAndFeel.uninstallBorder(abstractButton);
        this.defaults_initialized = false;
    }

    public boolean isPopupVisible() {
        IPulldownButtonInvoker iPulldownButtonInvoker;
        boolean bl = false;
        if (this.m_Button != null && (iPulldownButtonInvoker = this.m_Button.getPulldownInvoker()) != null) {
            bl = iPulldownButtonInvoker.isPulldownVisible();
        }
        return bl;
    }

    public void setPopupVisible(JPullDownButton jPullDownButton, boolean bl) {
        bl = true;
        if (true) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void show() {
        IPulldownButtonInvoker iPulldownButtonInvoker;
        if (this.m_Button != null && (iPulldownButtonInvoker = this.m_Button.getPulldownInvoker()) != null) {
            iPulldownButtonInvoker.showPulldown(this.m_Button);
        }
    }

    public void hide() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (menuElementArray[i] != this) continue;
            menuSelectionManager.clearSelectedPath();
            break;
        }
        if (menuElementArray.length > 0) {
            this.m_Button.repaint();
        }
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new BasicButtonListener(abstractButton){

            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                    if (BasicPullDownButtonUI.this.isButtonPressed(mouseEvent.getX(), mouseEvent.getY())) {
                        if (abstractButton.contains(mouseEvent.getX(), mouseEvent.getY())) {
                            long l = abstractButton.getMultiClickThreshhold();
                            ButtonModel buttonModel = abstractButton.getModel();
                            if (buttonModel.isEnabled()) {
                                if (!buttonModel.isArmed()) {
                                    buttonModel.setArmed(true);
                                }
                                BasicPullDownButtonUI.this.m_Button.setArrowButtonPressed(true);
                                if (!abstractButton.hasFocus() && abstractButton.isRequestFocusEnabled()) {
                                    abstractButton.requestFocus();
                                }
                            }
                        }
                    } else {
                        super.mousePressed(mouseEvent);
                        BasicPullDownButtonUI.this.m_Button.setArrowButtonPressed(false);
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                BasicPullDownButtonUI.this.m_Button.setArrowButtonPressed(false);
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    super.mouseReleased(mouseEvent);
                    AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
                    if (BasicPullDownButtonUI.this.isButtonPressed(mouseEvent.getX(), mouseEvent.getY())) {
                        BasicPullDownButtonUI.this.show();
                    }
                }
            }
        };
    }

    protected boolean isButtonPressed(int n, int n2) {
        boolean bl = false;
        if (!this.isArrowButton()) {
            Insets insets = this.m_Button.getInsets();
            int n3 = this.m_ArrowWidth + this.m_ArrowInsetWidth * 2 + insets.right;
            if (n < this.m_Button.getWidth() && n > this.m_Button.getWidth() - n3) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public int getDefaultTextIconGap(AbstractButton abstractButton) {
        return this.defaultTextIconGap;
    }

    protected Color getSelectColor() {
        return UIManager.getColor(this.getPropertyPrefix() + "select");
    }

    protected Color getDisabledTextColor() {
        return UIManager.getColor(this.getPropertyPrefix() + "disabledText");
    }

    protected Color getFocusColor() {
        return UIManager.getColor(this.getPropertyPrefix() + "focus");
    }

    protected void togglePopup() {
        if (this.isPopupVisible()) {
            this.hide();
        } else {
            this.show();
        }
    }

    protected Point computePopupLocation(int n) {
        return new Point(0, this.m_Button.getHeight());
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Object object;
        int n;
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        graphics.setColor(jComponent.getForeground());
        int n2 = this.m_LargeArrowWidth;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        if (buttonModel.isArmed() && buttonModel.isPressed() || this.m_Button.isArrowButtonPressed()) {
            this.paintButtonPressed(graphics, abstractButton);
        }
        if (!this.isArrowButton()) {
            n2 = this.m_ArrowWidth;
            n = abstractButton.getWidth() - (this.m_ArrowWidth + this.m_ArrowInsetWidth * 2);
            rectangle.x = insets.left;
            rectangle.y = insets.top;
            rectangle.width = n - (insets.right + rectangle.x);
            rectangle.height = abstractButton.getHeight() - (insets.bottom + rectangle.y);
            rectangle2.height = 0;
            rectangle2.width = 0;
            rectangle2.y = 0;
            rectangle2.x = 0;
            rectangle3.height = 0;
            rectangle3.width = 0;
            rectangle3.y = 0;
            rectangle3.x = 0;
            Font font = jComponent.getFont();
            graphics.setFont(font);
            object = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle3, rectangle2, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
            this.clearTextShiftOffset();
            if (abstractButton.getIcon() != null) {
                this.paintIcon(graphics, jComponent, rectangle3);
            }
            if (object != null && !((String)object).equals("")) {
                View view = (View)jComponent.getClientProperty("html");
                if (view != null) {
                    view.paint(graphics, rectangle2);
                } else {
                    this.paintText(graphics, abstractButton, rectangle2, (String)object);
                }
            }
        }
        if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
            this.paintFocus(graphics, abstractButton, rectangle, rectangle2, rectangle3);
        }
        n = 0;
        int n3 = 0;
        object = jComponent.getInsets();
        if (rectangle3 != null && rectangle3.width > 0) {
            n = rectangle3.x + rectangle3.width + this.m_ArrowInsetWidth;
            n3 = rectangle3.height / 2 + ((Insets)object).top;
        }
        if (rectangle2 != null && rectangle2.width > 0) {
            n = rectangle2.x + rectangle2.width + this.m_ArrowInsetWidth;
            n3 = rectangle2.height / 2 + ((Insets)object).top;
        }
        if (n == 0 && n3 == 0) {
            n = jComponent.getWidth() / 2 / 2;
            n3 = jComponent.getHeight() / 3;
        }
        this.paintArrow(graphics, n, n3, n2);
    }

    protected void paintArrow(Graphics graphics, int n, int n2, int n3) {
        int[] nArray = new int[]{n, n + n3, n + n3 / 2};
        int[] nArray2 = new int[]{n2, n2, n2 + n3 / 2};
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Icon icon = abstractButton.getIcon();
        Icon icon2 = null;
        if (icon == null) {
            return;
        }
        if (!buttonModel.isEnabled()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon2 = abstractButton.getPressedIcon();
            if (icon2 != null) {
                this.clearTextShiftOffset();
            }
        } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            icon2 = buttonModel.isSelected() ? abstractButton.getRolloverSelectedIcon() : abstractButton.getRolloverIcon();
        } else if (buttonModel.isSelected()) {
            icon2 = abstractButton.getSelectedIcon();
        }
        if (icon2 != null) {
            icon = icon2;
        }
        if (buttonModel.isPressed() && buttonModel.isArmed()) {
            icon.paintIcon(jComponent, graphics, rectangle.x + this.getTextShiftOffset(), rectangle.y + this.getTextShiftOffset());
        } else {
            icon.paintIcon(jComponent, graphics, rectangle.x, rectangle.y);
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = abstractButton.getDisplayedMnemonicIndex();
        if (buttonModel.isEnabled()) {
            graphics.setColor(abstractButton.getForeground());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, rectangle.x + this.getTextShiftOffset(), rectangle.y + fontMetrics.getAscent() + this.getTextShiftOffset());
        } else {
            graphics.setColor(abstractButton.getBackground().brighter());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent());
            graphics.setColor(abstractButton.getBackground().darker());
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, string, n, rectangle.x - 1, rectangle.y + fontMetrics.getAscent() - 1);
        }
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        this.paintText(graphics, (JComponent)abstractButton, rectangle, string);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isContentAreaFilled()) {
            Dimension dimension = abstractButton.getSize();
            graphics.setColor(this.getSelectColor());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }

    protected void clearTextShiftOffset() {
        this.shiftOffset = 0;
    }

    protected void setTextShiftOffset() {
        this.shiftOffset = this.defaultTextShiftOffset;
    }

    protected int getTextShiftOffset() {
        return this.shiftOffset;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        this.adjustForArrow(jComponent, dimension);
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Dimension dimension = null;
        Insets insets = jComponent.getInsets();
        dimension = BasicGraphicsUtils.getPreferredButtonSize(abstractButton, abstractButton.getIconTextGap());
        if (!this.isArrowButton()) {
            dimension.width += this.m_ArrowWidth + this.m_ArrowInsetWidth * 2;
        } else {
            dimension.width += insets.left + this.m_LargeArrowWidth;
            dimension.height += insets.top + this.m_LargeArrowWidth;
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
            dimension.width += this.m_ArrowWidth + this.m_ArrowInsetWidth * 2;
        }
        return dimension;
    }

    protected void adjustForArrow(JComponent jComponent, Dimension dimension) {
    }

    protected boolean isArrowButton() {
        String string = this.m_Button.getText();
        Icon icon = this.m_Button.getIcon();
        boolean bl = true;
        if (string != null && string.length() > 0) {
            bl = false;
        } else if (icon != null) {
            bl = false;
        }
        return bl;
    }

    protected class InvocationMouseHandler
    extends MouseAdapter {
        protected InvocationMouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

