/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools;

import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEWindowInputTool;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.support.umlsupport.ETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.ETRect;
import org.netbeans.modules.uml.core.support.umlsupport.IETPoint;
import org.netbeans.modules.uml.core.support.umlsupport.IETRect;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.drawengines.INodeDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ICompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IStretchContext;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.PointConversions;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.StretchContext;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADGraphWindow;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.ETHorzDragCursor;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.ETHorzNoDragCursor;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.ETVertDragCursor;
import org.netbeans.modules.uml.ui.swing.drawingarea.cursors.ETVertNoDragCursor;
import org.netbeans.modules.uml.ui.swing.drawingarea.diagramtools.IDragManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DragManager
extends TSEWindowInputTool
implements IDragManager {
    protected int m_orientation = 0;
    protected ETList<IPresentationElement> m_abovePEs = null;
    IETRect m_rectAbovePEs = new ETRect();
    protected int m_topLogical = Integer.MAX_VALUE;
    protected int m_bottomLogical = Integer.MIN_VALUE;
    private ICompartment m_cpStretchCompartment = null;
    private IStretchContext m_stretchContext = null;
    private INodeDrawEngine m_engine = null;
    ETRect m_rectLastMouseMove = new ETRect();
    protected ETList<IPresentationElement> m_belowPEs = null;
    IETRect m_rectBelowPEs = new ETRect();

    public DragManager(TSEGraphWindow tSEGraphWindow) {
        super(tSEGraphWindow.getCurrentState());
        this.setGraphWindow(tSEGraphWindow);
    }

    @Override
    public void reset() {
        super.resetTool();
        this.m_orientation = 0;
        this.m_topLogical = Integer.MAX_VALUE;
        this.m_bottomLogical = Integer.MIN_VALUE;
        this.m_cpStretchCompartment = null;
        this.m_abovePEs = null;
        this.m_belowPEs = null;
        this.m_rectAbovePEs.setRectEmpty();
        this.m_rectBelowPEs.setRectEmpty();
        this.m_stretchContext = null;
        this.m_engine = null;
    }

    @Override
    public int getOrientation() {
        return this.m_orientation;
    }

    @Override
    public void setOrientation(int n) {
        this.m_orientation = n;
    }

    @Override
    public void setStretchCompartment(ICompartment iCompartment) {
        this.m_cpStretchCompartment = iCompartment;
    }

    @Override
    public void setTop(int n) {
        this.m_topLogical = n;
    }

    @Override
    public void setBottom(int n) {
        this.m_bottomLogical = n;
    }

    @Override
    public void addElementsAbove(ETList<IPresentationElement> eTList) {
        this.m_abovePEs = eTList;
        this.m_rectAbovePEs = this.getLogicalBoundingRect(eTList);
    }

    @Override
    public void addElementsBelow(ETList<IPresentationElement> eTList) {
        this.m_belowPEs = eTList;
        this.m_rectBelowPEs = this.getLogicalBoundingRect(eTList);
    }

    public void onMouseClicked(MouseEvent mouseEvent) {
        super.onMouseClicked(mouseEvent);
    }

    public void onMouseDragged(MouseEvent mouseEvent) {
        if (this.validateMouseMove(mouseEvent) && !this.sendStretchContext(mouseEvent, 1)) {
            this.invalidateDrawLine();
            this.m_rectLastMouseMove = new ETRect(this.getGraphWindow().getBounds());
            switch (this.m_orientation) {
                case 0: {
                    this.m_rectLastMouseMove.setTop(mouseEvent.getY());
                    this.m_rectLastMouseMove.setBottom(this.m_rectLastMouseMove.getTop() + 1);
                    break;
                }
                case 1: {
                    this.m_rectLastMouseMove.setLeft(mouseEvent.getX());
                    this.m_rectLastMouseMove.setRight(this.m_rectLastMouseMove.getLeft() + 1);
                    break;
                }
            }
            this.invalidateDrawLine();
        }
    }

    public void onMouseMoved(MouseEvent mouseEvent) {
        super.onMouseMoved(mouseEvent);
    }

    public void onMousePressed(MouseEvent mouseEvent) {
        super.onMousePressed(mouseEvent);
    }

    public void onMouseReleased(MouseEvent mouseEvent) {
        this.sendStretchContext(mouseEvent, 3);
        this.invalidateDrawLine();
        this.reset();
        this.finalizeTool();
    }

    protected boolean validateMouseMove(MouseEvent mouseEvent) {
        boolean bl = false;
        Cursor cursor = null;
        switch (this.getOrientation()) {
            case 0: {
                int n = (int)this.getNonalignedWorldY(mouseEvent);
                if ((double)n < (double)this.m_topLogical - this.m_rectAbovePEs.getHeight() && (double)n > (double)this.m_bottomLogical + this.m_rectBelowPEs.getHeight()) {
                    int n2;
                    bl = true;
                    cursor = ETHorzDragCursor.getCursor();
                    int n3 = n - this.m_rectAbovePEs.getBottom();
                    if (n3 > 0) {
                        this.movePresentationElements(this.m_abovePEs, new ETPoint(0, n3));
                        this.m_rectAbovePEs = this.getLogicalBoundingRect(this.m_abovePEs);
                    }
                    if ((n2 = n - this.m_rectBelowPEs.getTop()) >= 0) break;
                    this.movePresentationElements(this.m_belowPEs, new ETPoint(0, n2));
                    this.m_rectBelowPEs = this.getLogicalBoundingRect(this.m_belowPEs);
                    break;
                }
                cursor = ETHorzNoDragCursor.getCursor();
                break;
            }
            case 1: {
                int n = (int)this.getNonalignedWorldX(mouseEvent);
                if ((double)n < (double)this.m_topLogical - this.m_rectAbovePEs.getWidth() && (double)n > (double)this.m_bottomLogical + this.m_rectBelowPEs.getWidth()) {
                    int n4;
                    bl = true;
                    cursor = ETVertDragCursor.getCursor();
                    int n5 = n - this.m_rectAbovePEs.getLeft();
                    if (n5 > 0) {
                        this.movePresentationElements(this.m_abovePEs, new ETPoint(n5, 0));
                        this.m_rectAbovePEs = this.getLogicalBoundingRect(this.m_abovePEs);
                    }
                    if ((n4 = n - this.m_rectBelowPEs.getRight()) >= 0) break;
                    this.movePresentationElements(this.m_belowPEs, new ETPoint(n4, 0));
                    this.m_rectBelowPEs = this.getLogicalBoundingRect(this.m_belowPEs);
                    break;
                }
                cursor = ETVertNoDragCursor.getCursor();
                break;
            }
        }
        if (cursor != null) {
            this.setCursor(cursor);
        }
        return bl;
    }

    protected IDrawingAreaControl getDrawingArea() {
        ADGraphWindow aDGraphWindow = this.getGraphWindow() instanceof ADGraphWindow ? (ADGraphWindow)this.getGraphWindow() : null;
        return aDGraphWindow != null ? aDGraphWindow.getDrawingArea() : null;
    }

    protected void invalidateDrawLine() {
        IDrawingAreaControl iDrawingAreaControl = this.getDrawingArea();
        if (iDrawingAreaControl != null) {
            if (this.m_engine != null) {
                iDrawingAreaControl.refreshRect(this.m_engine.getLogicalBoundingRect(true));
            } else {
                iDrawingAreaControl.refreshRect(this.m_rectLastMouseMove);
            }
        }
    }

    protected boolean sendStretchContext(MouseEvent mouseEvent, int n) {
        boolean bl = false;
        try {
            if (this.m_cpStretchCompartment != null) {
                IETPoint iETPoint;
                TSConstPoint tSConstPoint = this.getWorldPoint(mouseEvent);
                if (this.m_stretchContext == null) {
                    this.m_stretchContext = new StretchContext();
                    if (this.m_stretchContext != null) {
                        iETPoint = PointConversions.newETPoint(tSConstPoint);
                        this.m_stretchContext.setStartPoint(iETPoint);
                    }
                }
                if (this.m_stretchContext != null) {
                    this.m_stretchContext.setType(n);
                    iETPoint = PointConversions.newETPoint(tSConstPoint);
                    this.m_stretchContext.setFinishPoint(iETPoint);
                    this.sendStretchContext(this.m_cpStretchCompartment);
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    protected void sendStretchContext(ICompartment iCompartment) {
        IDrawEngine iDrawEngine;
        if (this.m_engine == null && (iDrawEngine = iCompartment.getEngine()) instanceof INodeDrawEngine) {
            this.m_engine = (INodeDrawEngine)iDrawEngine;
        }
        if (this.m_engine != null) {
            this.m_stretchContext.setCompartment(iCompartment);
            this.m_engine.stretch(this.m_stretchContext);
        }
    }

    protected void movePresentationElements(ETList<IPresentationElement> eTList, IETPoint iETPoint) {
        if (eTList != null && iETPoint != null && (iETPoint.getX() != 0 || iETPoint.getY() != 0)) {
            Iterator iterator = eTList.iterator();
            while (iterator.hasNext()) {
                TSENode tSENode;
                IDrawEngine iDrawEngine = TypeConversions.getDrawEngine((IPresentationElement)iterator.next());
                if (iDrawEngine == null || (tSENode = TypeConversions.getOwnerNode(iDrawEngine)) == null) continue;
                iDrawEngine.onGraphEvent(2);
                tSENode.moveBy((double)iETPoint.getX(), (double)iETPoint.getY());
                iDrawEngine.onGraphEvent(3);
            }
        }
    }

    protected IETRect getLogicalBoundingRect(ETList<IPresentationElement> eTList) {
        IETRect iETRect = null;
        iETRect = eTList != null ? TypeConversions.getLogicalBoundingRect(eTList, false) : new ETRect();
        return iETRect;
    }
}

