/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.drawingarea;

import com.tomsawyer.editor.TSENode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Document;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.support.applicationmanager.INodePresentation;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResizeElementsPanel
extends JPanel
implements DocumentListener,
VetoableChangeListener,
ActionListener {
    private long resizeHeight = 0L;
    private long resizeWidth = 0L;
    private int anchorPoint = 0;
    private StatisticsTable statisticsTable = null;
    private String statusMsg = " ";
    private boolean enableOk = false;
    private JRadioButton anchorBLRadio;
    private JRadioButton anchorBRRadio;
    private JRadioButton anchorCenterRadio;
    private ButtonGroup anchorPointGroup;
    private JLabel anchorPointLabel;
    private JRadioButton anchorTLRadio;
    private JRadioButton anchorTRRadio;
    private JLabel heightLabel;
    private JTextField heightText;
    private JPanel jPanel1;
    private JPanel statsPanel;
    private JScrollPane statsScrollPane;
    private JTable statsTable;
    private JLabel statsTableLabel;
    private JLabel statusLabel;
    private JLabel widthLabel;
    private JTextField widthText;

    public ResizeElementsPanel(long l, long l2, int n, ETList<IPresentationElement> eTList) {
        this.resizeHeight = l;
        this.resizeWidth = l2;
        this.anchorPoint = n;
        this.initComponents();
        this.statusLabel.setText(this.statusMsg);
        this.heightText.setText(String.valueOf(this.resizeHeight));
        this.widthText.setText(String.valueOf(this.resizeWidth));
        this.updateAnchorPointGroup(n);
        this.populateStatsTable(eTList);
        this.heightText.getDocument().addDocumentListener(this);
        this.widthText.getDocument().addDocumentListener(this);
    }

    @Override
    public void requestFocus() {
        this.heightText.requestFocus();
        this.updateValidStatus();
    }

    private void initComponents() {
        this.anchorPointGroup = new ButtonGroup();
        this.heightLabel = new JLabel();
        this.heightText = new JTextField();
        this.widthLabel = new JLabel();
        this.widthText = new JTextField();
        this.statsPanel = new JPanel();
        this.statsTableLabel = new JLabel();
        this.statsScrollPane = new JScrollPane();
        this.statsTable = new JTable();
        this.statusLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.anchorPointLabel = new JLabel();
        this.anchorCenterRadio = new JRadioButton();
        this.anchorTLRadio = new JRadioButton();
        this.anchorBLRadio = new JRadioButton();
        this.anchorTRRadio = new JRadioButton();
        this.anchorBRRadio = new JRadioButton();
        this.heightLabel.setLabelFor(this.heightText);
        Mnemonics.setLocalizedText((JLabel)this.heightLabel, (String)NbBundle.getMessage(ResizeElementsPanel.class, (String)"LBL_HeightLabel"));
        this.heightText.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ResizeElementsPanel.this.heightTextFocusGained(focusEvent);
            }
        });
        this.widthLabel.setLabelFor(this.widthText);
        Mnemonics.setLocalizedText((JLabel)this.widthLabel, (String)NbBundle.getMessage(ResizeElementsPanel.class, (String)"LBL_WidthLabel"));
        this.widthText.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ResizeElementsPanel.this.widthTextFocusGained(focusEvent);
            }
        });
        this.statsTableLabel.setLabelFor(this.statsTable);
        this.statsTableLabel.setText(NbBundle.getMessage(ResizeElementsPanel.class, (String)"LBL_StatisticsTableLabel"));
        this.statsScrollPane.setHorizontalScrollBarPolicy(31);
        this.statsScrollPane.setVerticalScrollBarPolicy(21);
        this.statsScrollPane.setEnabled(false);
        this.statsScrollPane.setWheelScrollingEnabled(false);
        this.statsTable.setModel(new DefaultTableModel(new Object[][]{{"  Height:", null, null, null}, {"  Width:", null, null, null}}, new String[]{"Size Stats", "Min", "Avg ", "Max"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, Double.class, Double.class, Double.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.statsTable.setAutoResizeMode(4);
        this.statsTable.setColumnSelectionAllowed(true);
        this.statsTable.setEnabled(false);
        this.statsTable.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.statsTable.setRowSelectionAllowed(false);
        this.statsScrollPane.setViewportView(this.statsTable);
        GroupLayout groupLayout = new GroupLayout((Container)this.statsPanel);
        this.statsPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.statsTableLabel).addContainerGap(102, Short.MAX_VALUE)).add((Component)this.statsScrollPane, -1, 294, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.statsTableLabel).addPreferredGap(0).add((Component)this.statsScrollPane, -1, 126, Short.MAX_VALUE).addContainerGap()));
        this.statusLabel.setForeground(new Color(255, 0, 0));
        this.statusLabel.setText("<error status>");
        Mnemonics.setLocalizedText((JLabel)this.anchorPointLabel, (String)NbBundle.getMessage(ResizeElementsPanel.class, (String)"LBL_ResizeAnchorPointLabel"));
        this.anchorPointGroup.add(this.anchorCenterRadio);
        this.anchorCenterRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.anchorCenterRadio, (String)NbBundle.getMessage(ResizeElementsPanel.class, (String)"LBL_AnchorPointCenter"));
        this.anchorCenterRadio.setAlignmentY(0.0f);
        this.anchorCenterRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.anchorCenterRadio.setMargin(new Insets(0, 0, 0, 0));
        this.anchorCenterRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ResizeElementsPanel.this.anchorCenterRadioItemStateChanged(itemEvent);
            }
        });
        this.anchorPointGroup.add(this.anchorTLRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.anchorTLRadio, (String)NbBundle.getMessage(ResizeElementsPanel.class, (String)"LBL_AnchorPointTopLeft"));
        this.anchorTLRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.anchorTLRadio.setMargin(new Insets(0, 0, 0, 0));
        this.anchorTLRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ResizeElementsPanel.this.anchorTLRadioItemStateChanged(itemEvent);
            }
        });
        this.anchorPointGroup.add(this.anchorBLRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.anchorBLRadio, (String)NbBundle.getMessage(ResizeElementsPanel.class, (String)"LBL_AnchorPointBottomLeft"));
        this.anchorBLRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.anchorBLRadio.setMargin(new Insets(0, 0, 0, 0));
        this.anchorBLRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ResizeElementsPanel.this.anchorBLRadioItemStateChanged(itemEvent);
            }
        });
        this.anchorPointGroup.add(this.anchorTRRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.anchorTRRadio, (String)NbBundle.getMessage(ResizeElementsPanel.class, (String)"LBL_AnchorPointTopRight"));
        this.anchorTRRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.anchorTRRadio.setMargin(new Insets(0, 0, 0, 0));
        this.anchorTRRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ResizeElementsPanel.this.anchorTRRadioItemStateChanged(itemEvent);
            }
        });
        this.anchorPointGroup.add(this.anchorBRRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.anchorBRRadio, (String)NbBundle.getMessage(ResizeElementsPanel.class, (String)"LBL_AnchorPointBottomRight"));
        this.anchorBRRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.anchorBRRadio.setMargin(new Insets(0, 0, 0, 0));
        this.anchorBRRadio.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ResizeElementsPanel.this.anchorBRRadioItemStateChanged(itemEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.anchorTLRadio).add((Component)this.anchorBLRadio)).add(37, 37, 37).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.anchorBRRadio).add((Component)this.anchorTRRadio))).add((Component)this.anchorPointLabel).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.anchorCenterRadio))).addContainerGap(95, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.anchorPointLabel).addPreferredGap(0).add((Component)this.anchorCenterRadio).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.anchorTRRadio).add((Component)this.anchorTLRadio)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.anchorBRRadio).add((Component)this.anchorBLRadio)).addContainerGap()));
        this.anchorPointLabel.getAccessibleContext().setAccessibleName("");
        this.anchorCenterRadio.getAccessibleContext().setAccessibleName("");
        this.anchorCenterRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResizeElementsPanel.class, (String)"ACSD_AnchorPointCenter"));
        this.anchorTLRadio.getAccessibleContext().setAccessibleName("");
        this.anchorTLRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResizeElementsPanel.class, (String)"ACSD_AnchorPointTopLeft"));
        this.anchorBLRadio.getAccessibleContext().setAccessibleName("");
        this.anchorBLRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResizeElementsPanel.class, (String)"ACSD_AnchorPointBottomLeft"));
        this.anchorTRRadio.getAccessibleContext().setAccessibleName("");
        this.anchorTRRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResizeElementsPanel.class, (String)"ACSD_AnchorPointTopRight"));
        this.anchorBRRadio.getAccessibleContext().setAccessibleName("");
        this.anchorBRRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResizeElementsPanel.class, (String)"ACSD_AnchorPointBottomRight"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.heightLabel).addPreferredGap(0).add((Component)this.heightText, -2, 59, -2).add(17, 17, 17).add((Component)this.widthLabel).addPreferredGap(0).add((Component)this.widthText, -2, 63, -2)).add((Component)this.statusLabel, -1, 294, Short.MAX_VALUE)).addContainerGap()).add(2, (GroupLayout.Group)groupLayout3.createSequentialGroup().add((GroupLayout.Group)groupLayout3.createParallelGroup(2).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.statsPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(3).add((Component)this.heightLabel).add((Component)this.heightText, -2, -1, -2).add((Component)this.widthLabel).add((Component)this.widthText, -2, -1, -2)).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.statsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.statusLabel)));
        this.heightLabel.getAccessibleContext().setAccessibleName("");
        this.heightLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResizeElementsPanel.class, (String)"ACSD_HeightLabel"));
        this.widthLabel.getAccessibleContext().setAccessibleName("");
        this.widthLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResizeElementsPanel.class, (String)"ACSD_WidthLabel"));
        this.statusLabel.getAccessibleContext().setAccessibleName("");
    }

    private void widthTextFocusGained(FocusEvent focusEvent) {
        this.widthText.selectAll();
    }

    private void heightTextFocusGained(FocusEvent focusEvent) {
        this.heightText.selectAll();
    }

    private void anchorCenterRadioItemStateChanged(ItemEvent itemEvent) {
        this.anchorPoint = 0;
    }

    private void anchorBRRadioItemStateChanged(ItemEvent itemEvent) {
        this.anchorPoint = 4;
    }

    private void anchorBLRadioItemStateChanged(ItemEvent itemEvent) {
        this.anchorPoint = 3;
    }

    private void anchorTRRadioItemStateChanged(ItemEvent itemEvent) {
        this.anchorPoint = 2;
    }

    private void anchorTLRadioItemStateChanged(ItemEvent itemEvent) {
        this.anchorPoint = 1;
    }

    private void updateAnchorPointGroup(int n) {
        switch (n) {
            case 1: {
                this.anchorTLRadio.setSelected(true);
                break;
            }
            case 2: {
                this.anchorTRRadio.setSelected(true);
                break;
            }
            case 3: {
                this.anchorBLRadio.setSelected(true);
                break;
            }
            case 4: {
                this.anchorBRRadio.setSelected(true);
                break;
            }
            default: {
                this.anchorCenterRadio.setSelected(true);
            }
        }
    }

    public double getResizeHeight() {
        return this.resizeHeight;
    }

    public double getResizeWidth() {
        return this.resizeWidth;
    }

    public int getAnchorPoint() {
        return this.anchorPoint;
    }

    private void populateStatsTable(ETList<IPresentationElement> eTList) {
        if (eTList == null || eTList.size() == 0) {
            return;
        }
        if (eTList.size() > 1) {
            this.heightText.setText("");
            this.widthText.setText("");
            this.resizeHeight = 0L;
            this.resizeWidth = 0L;
            this.enableOk = false;
            if (this.statisticsTable == null) {
                this.statisticsTable = new StatisticsTable();
            }
            this.statisticsTable.computeStats(eTList);
            StatsTableModel statsTableModel = new StatsTableModel(this.statisticsTable.getStatsData());
            this.statsTable.setModel(statsTableModel);
            this.statsPanel.setVisible(true);
            this.updateValidStatus();
        } else {
            this.resizeHeight = ((INodePresentation)eTList.get(0)).getHeight();
            this.resizeWidth = ((INodePresentation)eTList.get(0)).getWidth();
            this.heightText.setText(String.valueOf(this.resizeHeight));
            this.widthText.setText(String.valueOf(this.resizeWidth));
            this.statsPanel.setVisible(false);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateSizeFields(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateSizeFields(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateSizeFields(documentEvent);
    }

    private void updateSizeFields(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        if (document == this.heightText.getDocument()) {
            this.resizeHeight = this.validNumber(this.heightText.getText()) ? Long.valueOf(this.heightText.getText()) : 0L;
            this.updateValidStatus();
        } else if (document == this.widthText.getDocument()) {
            this.resizeWidth = this.validNumber(this.widthText.getText()) ? Long.valueOf(this.widthText.getText()) : 0L;
            this.updateValidStatus();
        }
    }

    private boolean validNumber(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        try {
            return Long.valueOf(string) > 0L;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean updateValidStatus() {
        this.enableOk = true;
        this.statusMsg = " ";
        if (this.resizeHeight < 5L || this.resizeWidth < 5L) {
            this.enableOk = Boolean.FALSE;
            this.statusMsg = "MSG_STATUS_InvalidDimensions";
            return this.notifyPropertyListeners();
        }
        return this.notifyPropertyListeners();
    }

    private boolean notifyPropertyListeners() {
        this.firePropertyChange("valid", !this.enableOk, this.enableOk);
        if (!this.statusMsg.equals(" ")) {
            this.statusMsg = NbBundle.getMessage(ResizeElementsPanel.class, (String)this.statusMsg);
        }
        this.statusLabel.setText(this.statusMsg);
        return this.enableOk;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        if (propertyChangeEvent.getSource() == this.heightText ? this.heightText.getText() != null && this.heightText.getText().length() > 0 && !this.validNumber(this.heightText.getText()) : propertyChangeEvent.getSource() == this.widthText && this.widthText.getText() != null && this.widthText.getText().length() > 0 && !this.validNumber(this.widthText.getText())) {
            throw new PropertyVetoException("Must be positive, whole number", propertyChangeEvent);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public static class StatsTableModel
    extends DefaultTableModel {
        static String colStatName = NbBundle.getMessage(ResizeElementsPanel.class, (String)"LBL_ColumnStatName");
        static String colMin = NbBundle.getMessage(ResizeElementsPanel.class, (String)"LBL_ColumnStatMin");
        static String colAvg = NbBundle.getMessage(ResizeElementsPanel.class, (String)"LBL_ColumnStatAvg");
        static String colMax = NbBundle.getMessage(ResizeElementsPanel.class, (String)"LBL_ColumnStatMax");

        public StatsTableModel(Object[][] objectArray) {
            super(objectArray, new Object[]{colStatName, colMin, colAvg, colMax});
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
            }
            return Long.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StatisticsTable {
        long widthMin = 0L;
        long widthAvg = 0L;
        long widthMax = 0L;
        long heightMin = 0L;
        long heightAvg = 0L;
        long heightMax = 0L;

        private StatisticsTable() {
        }

        Object[][] getStatsData() {
            Object[][] objectArray = new Object[2][4];
            objectArray[0][0] = NbBundle.getMessage(ResizeElementsPanel.class, (String)"TXT_HeightRowValue");
            objectArray[0][1] = new Long(this.heightMin);
            objectArray[0][2] = new Long(this.heightAvg);
            objectArray[0][3] = new Long(this.heightMax);
            objectArray[1][0] = NbBundle.getMessage(ResizeElementsPanel.class, (String)"TXT_WidthRowValue");
            objectArray[1][1] = new Long(this.widthMin);
            objectArray[1][2] = new Long(this.widthAvg);
            objectArray[1][3] = new Long(this.widthMax);
            return objectArray;
        }

        void computeStats(ETList<IPresentationElement> eTList) {
            long l = 0L;
            long l2 = 0L;
            int n = 0;
            for (IPresentationElement iPresentationElement : eTList) {
                if (!(iPresentationElement instanceof INodePresentation)) continue;
                INodePresentation iNodePresentation = (INodePresentation)iPresentationElement;
                TSENode tSENode = iNodePresentation.getTSNode();
                ++n;
                long l3 = Math.round(tSENode.getHeight());
                long l4 = Math.round(tSENode.getWidth());
                l += l3;
                this.heightMin = this.heightMin == 0L ? l3 : Math.min(l3, this.heightMin);
                this.heightMax = Math.max(l3, this.heightMax);
                l2 += l4;
                this.widthMin = this.widthMin == 0L ? l4 : Math.min(l4, this.widthMin);
                this.widthMax = Math.max(l4, this.widthMax);
            }
            this.heightAvg = Math.round(l / (long)n);
            this.widthAvg = Math.round(l2 / (long)n);
        }
    }
}

