/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.drawingarea;

import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.TSEGraph;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.ui.support.umltsconversions.RectConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADGraphWindow;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;

public class DrawingAreaRefreshHelper {
    private static Map m_BusyMap = Collections.synchronizedMap(new HashMap());

    private DrawingAreaRefreshHelper() {
    }

    public static void refreshDrawingArea(final IDrawingAreaControl iDrawingAreaControl, boolean bl) {
        if (iDrawingAreaControl == null) {
            return;
        }
        if (m_BusyMap.containsKey(iDrawingAreaControl)) {
            m_BusyMap.remove(iDrawingAreaControl);
        }
        m_BusyMap.put(iDrawingAreaControl, new Boolean(bl));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    if (m_BusyMap.containsKey(iDrawingAreaControl)) {
                        boolean bl = (Boolean)m_BusyMap.get(iDrawingAreaControl);
                        ADGraphWindow aDGraphWindow = iDrawingAreaControl.getGraphWindow();
                        if (aDGraphWindow != null) {
                            if (bl) {
                                TSEGraph tSEGraph = aDGraphWindow.getGraph();
                                if (tSEGraph != null && tSEGraph.getUI() != null) {
                                    aDGraphWindow.addInvalidRegion((TSConstRect)RectConversions.inflate(tSEGraph.getUI().getBounds(), 10.0, 10.0));
                                    aDGraphWindow.updateInvalidRegions(true);
                                } else {
                                    aDGraphWindow.invalidate();
                                }
                            } else {
                                aDGraphWindow.updateInvalidRegions(true);
                            }
                        }
                        iDrawingAreaControl.updateSecondaryWindows();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                m_BusyMap.remove(iDrawingAreaControl);
            }
        });
    }

    public static void refreshDrawingArea(IDrawingAreaControl iDrawingAreaControl) {
        DrawingAreaRefreshHelper.refreshDrawingArea(iDrawingAreaControl, false);
    }
}

