/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.drawingarea;

import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.command.TSDeleteNodeCommand;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.editor.TSEGraph;
import com.tomsawyer.editor.TSEGraphManager;
import com.tomsawyer.editor.TSEGraphWindow;
import com.tomsawyer.editor.TSEHitTesting;
import com.tomsawyer.editor.TSEInnerCanvas;
import com.tomsawyer.editor.TSENode;
import com.tomsawyer.editor.TSEObjectUI;
import com.tomsawyer.editor.TSEPreferences;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.command.TSERoutingCommand;
import com.tomsawyer.editor.event.TSEEventManager;
import com.tomsawyer.editor.event.TSESelectionChangeEvent;
import com.tomsawyer.editor.event.TSESelectionChangeEventData;
import com.tomsawyer.editor.event.TSESelectionChangeListener;
import com.tomsawyer.editor.event.TSEViewportChangeEvent;
import com.tomsawyer.editor.event.TSEViewportChangeListener;
import com.tomsawyer.editor.graphics.TSEGraphics;
import com.tomsawyer.editor.ui.TSEGraphUI;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeListener;
import com.tomsawyer.util.TSObject;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.command.TSGroupCommand;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Locale;
import java.util.WeakHashMap;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import org.netbeans.modules.uml.common.ETSystem;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.products.ad.drawengines.ETClassDrawEngine;
import org.netbeans.modules.uml.ui.products.ad.graphobjects.ETGraph;
import org.netbeans.modules.uml.ui.products.ad.graphobjects.ETGraphManager;
import org.netbeans.modules.uml.ui.products.ad.viewfactory.IETGraphObjectUI;
import org.netbeans.modules.uml.ui.support.accessibility.AccessibleSelectionParent;
import org.netbeans.modules.uml.ui.support.helpers.ETSmartWaitCursor;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IDrawEngine;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETGraphObject;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETLabel;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ILabelManager;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.TypeConversions;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADMoveSelectedKeyAdapter;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;

public class ADGraphWindow
extends TSEGraphWindow
implements ActionListener,
Accessible {
    String status;
    boolean changed;
    String graphFileName;
    protected boolean hasFileName;
    ADMoveSelectedKeyAdapter moveAdapter;
    boolean needsFitInWindow = true;
    IDrawingAreaControl m_drawingAreaCtrl = null;
    public static final int MAX_ZOOM = 5000;
    public static final double MIN_ZOOM = 0.01;
    private boolean allowRedraw = true;
    private boolean bUpdatingScrollBars = false;
    private TSEHitTesting m_hitTesting;
    AccessibleContext accessibleContext;

    public ADGraphWindow(IDrawingAreaControl iDrawingAreaControl) {
        this(iDrawingAreaControl, null, true);
    }

    public ADGraphWindow(IDrawingAreaControl iDrawingAreaControl, ETGraphManager eTGraphManager) {
        this(iDrawingAreaControl, eTGraphManager, true);
    }

    public ADGraphWindow(IDrawingAreaControl iDrawingAreaControl, ETGraphManager eTGraphManager, boolean bl) {
        this(eTGraphManager, bl);
        this.setDrawFullUIOnDragging(false);
        this.setHitTolerance(5);
        this.m_drawingAreaCtrl = iDrawingAreaControl;
    }

    public TSEPreferences newPreferences(TSEGraphWindow tSEGraphWindow) {
        return new ADDrawingPreferences(tSEGraphWindow);
    }

    protected ADGraphWindow(ETGraphManager eTGraphManager, boolean bl) {
        super((TSEGraphManager)eTGraphManager, bl);
        TSEInnerCanvas tSEInnerCanvas = new TSEInnerCanvas(this){

            public Image createImage(int n, int n2) {
                return new BufferedImage(n, n2, 1);
            }
        };
        this.setCanvas(tSEInnerCanvas);
        tSEInnerCanvas.putClientProperty(Printable.class, (Object)"");
        this.moveAdapter = new ADMoveSelectedKeyAdapter(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (ADGraphWindow.this.getDrawingArea() != null && ADGraphWindow.this.getDrawingArea().isAutoFitInWindow()) {
                    ADGraphWindow.this.fitInWindow(true);
                }
                if (ADGraphWindow.this.isAutoHidingScrollBars()) {
                    if (ADGraphWindow.this.getHorizontalScrollBar().isVisible()) {
                        ADGraphWindow.this.getHorizontalScrollBar().revalidate();
                    }
                    if (ADGraphWindow.this.getVerticalScrollBar().isVisible()) {
                        ADGraphWindow.this.getVerticalScrollBar().revalidate();
                    }
                }
            }
        });
        this.m_hitTesting = new TSEHitTesting((TSEGraphWindow)this);
        this.setToolTipShown(true);
    }

    public void setCursorOnCanvas(Cursor cursor) {
        if (!ETSmartWaitCursor.inWaitState()) {
            super.setCursorOnCanvas(cursor);
        }
    }

    public void setupETDefaultDrawingPreferences() {
        ETSystem.out.println("ADGraphWindow setupETDefaultDrawingPreferences");
        this.getPreferences().setValue((Object)"reconnectEdgeSensitivity", 10.0);
        this.setMaxZoomLevel(50.0);
        this.setMinZoomLevel(1.0E-4);
        this.setupCommonLayoutProperties();
    }

    protected void setupCommonLayoutProperties() {
        this.setOrthogonalKeepNodeSizes(true);
    }

    public void setOrthogonalKeepNodeSizes(boolean bl) {
        TSEGraph tSEGraph = this.getGraph();
        if (tSEGraph != null) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmit(TSERoutingCommand tSERoutingCommand) {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.transmit((TSCommand)tSERoutingCommand);
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
    }

    public IDrawingAreaControl getDrawingArea() {
        return this.m_drawingAreaCtrl;
    }

    public TSEGraphManager newGraphManager() {
        return new ETGraphManager();
    }

    public void expandSelected() {
    }

    public void expandAll() {
    }

    public void collapseSelected() {
    }

    public void collapseAll() {
    }

    public void hideSelected() {
    }

    public void unhideAll() {
    }

    public void foldSelected() {
    }

    public void unfoldAll() {
    }

    public void unfoldSelected() {
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getStatus() {
        return this.status;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setGraphFileName(String string) {
        this.graphFileName = string;
    }

    public String getGraphFileName() {
        return this.graphFileName;
    }

    protected boolean ownsSameGraphFile(String string) {
        if (!this.hasFileName) {
            return false;
        }
        if (this.graphFileName == null) {
            return string == null;
        }
        return this.graphFileName.equalsIgnoreCase(string);
    }

    public void move(int n) {
        if (this.moveAdapter != null) {
            this.moveAdapter.move(n);
        }
    }

    public void finalizeMove() {
        if (this.moveAdapter != null) {
            this.moveAdapter.finalizeState();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        ETSystem.out.println("ADGraphWindow - " + string);
    }

    public void switchTool(TSEWindowTool tSEWindowTool) {
        super.switchTool(tSEWindowTool);
    }

    public int listen(TSCommand tSCommand) {
        if (tSCommand instanceof TSGroupCommand) {
            TSGroupCommand tSGroupCommand = (TSGroupCommand)tSCommand;
            List list = tSGroupCommand.getCommandList();
            for (TSCommand tSCommand2 : list) {
                this.handleCommandEvent(tSCommand2);
            }
        } else {
            this.handleCommandEvent(tSCommand);
        }
        int n = 0;
        try {
            n = super.listen(tSCommand);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    protected void handleCommandEvent(TSCommand tSCommand) {
        if (tSCommand instanceof TSDeleteNodeCommand) {
            TSDeleteNodeCommand tSDeleteNodeCommand = (TSDeleteNodeCommand)tSCommand;
            ETArrayList<IETGraphObject> eTArrayList = new ETArrayList<IETGraphObject>();
            eTArrayList.add(TypeConversions.getETGraphObject((TSNode)tSDeleteNodeCommand.getNode()));
            this.getDrawingArea().onGraphEvent(22, null, null, eTArrayList);
        }
    }

    public void deleteSelected() {
        TSEGraph tSEGraph = this.getGraph();
        if (tSEGraph != null && tSEGraph.hasSelected()) {
            super.deleteSelected();
        }
    }

    public Color getBackground() {
        TSEGraph tSEGraph = this.getGraph();
        if (tSEGraph != null && tSEGraph.getUI() instanceof TSEGraphUI) {
            TSEGraphUI tSEGraphUI = (TSEGraphUI)tSEGraph.getUI();
            return tSEGraphUI.getBackgroundColor().getColor();
        }
        return super.getBackground();
    }

    public boolean isAutoHidingScrollBarsByDefault() {
        return true;
    }

    public synchronized void updateScrollBarValues() {
        if (this.getAllowRedraw() && this.isVisible() && this.getDrawingArea() != null && this.getDrawingArea().getGraphWindow() == this) {
            this.bUpdatingScrollBars = true;
            super.updateScrollBarValues();
            this.bUpdatingScrollBars = false;
        }
    }

    public void fitInWindow(boolean bl) {
        if (this.getGraph().isBoundsUpdatingEnabled()) {
            super.fitInWindow(bl);
        } else {
            ETSystem.out.println("Warning: your are calling fitInWindow when the graph bounds are unknown.");
        }
    }

    public void drawGraph() {
        if (this.getAllowRedraw()) {
            super.drawGraph();
        }
    }

    public void drawEntireGraph(TSEGraphics tSEGraphics, int n, boolean bl, boolean bl2, int n2, int n3) {
        if (this.getAllowRedraw()) {
            super.drawEntireGraph(tSEGraphics, n, bl, bl2, n2, n3);
        }
    }

    public void drawEntireGraph(TSEGraphics tSEGraphics, int n, boolean bl, boolean bl2) {
        if (this.getAllowRedraw()) {
            super.drawEntireGraph(tSEGraphics, n, bl, bl2);
        }
    }

    public void drawGraph(boolean bl) {
        if (this.getAllowRedraw()) {
            super.drawGraph(bl);
        }
    }

    public void drawGraph(Graphics graphics, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (this.getAllowRedraw()) {
            super.drawGraph(graphics, bl, bl2, bl3, bl4, bl5);
        }
    }

    public void drawGraph(Graphics graphics, boolean bl, boolean bl2, boolean bl3) {
        if (this.getAllowRedraw()) {
            super.drawGraph(graphics, bl, bl2, bl3);
        }
    }

    public void drawGraph(Graphics graphics, boolean bl, boolean bl2) {
        if (this.getAllowRedraw()) {
            super.drawGraph(graphics, bl, bl2);
        }
    }

    public void drawGraph(Graphics graphics, boolean bl) {
        if (this.getAllowRedraw()) {
            super.drawGraph(graphics, bl);
        }
    }

    public void drawGraph(Graphics graphics) {
        if (this.getAllowRedraw()) {
            super.drawGraph(graphics);
        }
    }

    public void drawGraph(TSConstRect tSConstRect, boolean bl, boolean bl2) {
        if (this.getAllowRedraw()) {
            super.drawGraph(tSConstRect, bl, bl2);
        }
    }

    public void drawGraph(TSConstRect tSConstRect) {
        if (this.getAllowRedraw()) {
            super.drawGraph(tSConstRect);
        }
    }

    public void updateInvalidRegion() {
        if (this.getAllowRedraw()) {
            super.updateInvalidRegion();
        }
    }

    public synchronized void updateInvalidRegion(boolean bl) {
        if (this.getAllowRedraw()) {
            super.updateInvalidRegion(bl);
        }
    }

    public boolean getAllowRedraw() {
        return this.allowRedraw && this.getGraph() != null && this.getGraph().isBoundsUpdatingEnabled();
    }

    public void setAllowRedraw(boolean bl) {
        this.allowRedraw = bl;
    }

    public double getMaxZoomLevel() {
        if (this.m_drawingAreaCtrl != null) {
            return this.m_drawingAreaCtrl.getExtremeZoomValues().getParamTwo();
        }
        return super.getMaxZoomLevel();
    }

    public double getMinZoomLevel() {
        if (this.m_drawingAreaCtrl != null) {
            return this.m_drawingAreaCtrl.getExtremeZoomValues().getParamOne();
        }
        return super.getMinZoomLevel();
    }

    public void doLayout() {
        try {
            if (!this.bUpdatingScrollBars) {
                super.doLayout();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setZoomLevel(double d, boolean bl) {
        super.setZoomLevel(d, bl);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        TSENode tSENode = this.m_hitTesting.getNodeAt(this.getNonalignedWorldPoint(mouseEvent.getPoint()), this.getGraph(), true);
        if (tSENode == null) {
            return null;
        }
        TSEObjectUI tSEObjectUI = tSENode.getUI();
        if (tSEObjectUI == null) {
            return null;
        }
        if (!(tSEObjectUI instanceof IETGraphObjectUI)) {
            return null;
        }
        IDrawEngine iDrawEngine = ((IETGraphObjectUI)tSEObjectUI).getDrawEngine();
        if (iDrawEngine == null) {
            return null;
        }
        if (iDrawEngine instanceof ETClassDrawEngine) {
            return ((ETClassDrawEngine)iDrawEngine).getToolTipText(mouseEvent);
        }
        return null;
    }

    public int getHitTolerance() {
        return super.getHitTolerance();
    }

    public void setHitTolerance(int n) {
        super.setHitTolerance(n);
    }

    public void scrollBy(int n, int n2, boolean bl) {
        super.scrollBy(n, n2, bl);
        this.drawGraph();
        this.repaint();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleGraphWindow();
        }
        return this.accessibleContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AccessibleEngineAndLabelsPanel
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent,
    AccessibleSelection,
    AccessibleSelectionParent {
        public Accessible engine;

        @Override
        public void firePropertyChange(String string, Object object, Object object2) {
            super.firePropertyChange(string, object, object2);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public AccessibleEngineAndLabelsPanel(Accessible accessible) {
            this.engine = accessible;
        }

        @Override
        public Locale getLocale() {
            return Locale.US;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return 0;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            return new AccessibleStateSet(new AccessibleState[]{AccessibleState.SHOWING, AccessibleState.VISIBLE, AccessibleState.ENABLED, AccessibleState.FOCUSABLE, AccessibleState.SELECTABLE});
        }

        @Override
        public String getAccessibleName() {
            return this.engine.getAccessibleContext().getAccessibleName();
        }

        @Override
        public String getAccessibleDescription() {
            return this.engine.getAccessibleContext().getAccessibleDescription();
        }

        @Override
        public int getAccessibleChildrenCount() {
            List<Accessible> list = this.getAccessibleChildren();
            if (list != null) {
                return list.size();
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            List<Accessible> list = this.getAccessibleChildren();
            if (list != null && n < list.size()) {
                return list.get(n);
            }
            return null;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public Color getBackground() {
            return null;
        }

        @Override
        public void setBackground(Color color) {
        }

        @Override
        public Color getForeground() {
            return null;
        }

        @Override
        public void setForeground(Color color) {
        }

        @Override
        public Cursor getCursor() {
            return null;
        }

        @Override
        public void setCursor(Cursor cursor) {
        }

        @Override
        public Font getFont() {
            return null;
        }

        @Override
        public void setFont(Font font) {
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            return null;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public void setVisible(boolean bl) {
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        public boolean contains(Point point) {
            Rectangle rectangle = this.getBounds();
            return rectangle.contains(point);
        }

        @Override
        public Point getLocationOnScreen() {
            Point point = null;
            List<Accessible> list = this.getAccessibleChildren();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Point point2;
                    Accessible accessible = list.get(i);
                    if (accessible == null || (point2 = accessible.getAccessibleContext().getAccessibleComponent().getLocationOnScreen()) == null) continue;
                    if (point == null) {
                        point = point2;
                        continue;
                    }
                    if (point2.x < point.x) {
                        point.setLocation(point2.x, point.y);
                    }
                    if (point2.y >= point.y) continue;
                    point.setLocation(point.x, point2.y);
                }
            }
            return point;
        }

        @Override
        public Point getLocation() {
            Point point = null;
            List<Accessible> list = this.getAccessibleChildren();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Point point2;
                    Accessible accessible = list.get(i);
                    if (accessible == null || (point2 = accessible.getAccessibleContext().getAccessibleComponent().getLocation()) == null) continue;
                    if (point == null) {
                        point = point2;
                        continue;
                    }
                    if (point2.x < point.x) {
                        point.setLocation(point2.x, point.y);
                    }
                    if (point2.y >= point.y) continue;
                    point.setLocation(point.x, point2.y);
                }
            }
            return point;
        }

        @Override
        public void setLocation(Point point) {
        }

        @Override
        public Rectangle getBounds() {
            Rectangle rectangle = null;
            List<Accessible> list = this.getAccessibleChildren();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Rectangle rectangle2;
                    Accessible accessible = list.get(i);
                    if (accessible == null || (rectangle2 = accessible.getAccessibleContext().getAccessibleComponent().getBounds()) == null) continue;
                    rectangle = rectangle == null ? rectangle2 : rectangle.union(rectangle2);
                }
            }
            return rectangle;
        }

        @Override
        public void setBounds(Rectangle rectangle) {
        }

        @Override
        public Dimension getSize() {
            Rectangle rectangle = this.getBounds();
            return new Dimension(rectangle.width, rectangle.height);
        }

        @Override
        public void setSize(Dimension dimension) {
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            return true;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
        }

        @Override
        public int getAccessibleSelectionCount() {
            List<Accessible> list = this.getSelectedAccessibleChildren();
            if (list != null) {
                return list.size();
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            List<Accessible> list = this.getSelectedAccessibleChildren();
            if (list != null && n < list.size()) {
                return list.get(n);
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            Accessible accessible = this.getAccessibleChild(n);
            if (accessible != null) {
                return this.isSelected(accessible);
            }
            return false;
        }

        @Override
        public void addAccessibleSelection(int n) {
            Accessible accessible = this.getAccessibleChild(n);
            if (accessible != null) {
                this.selectChild(accessible, true, false);
            }
        }

        @Override
        public void removeAccessibleSelection(int n) {
            List<Accessible> list = this.getSelectedAccessibleChildren();
            List<Accessible> list2 = this.getAccessibleChildren();
            if (list2 != null && n < list2.size()) {
                this.selectChild(list2.get(n), false, true);
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
            List<Accessible> list = this.getAccessibleChildren();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    this.selectChild(list.get(i), true, false);
                }
            }
        }

        @Override
        public void clearAccessibleSelection() {
            List<Accessible> list = this.getSelectedAccessibleChildren();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    this.selectChild(list.get(i), false, true);
                }
            }
        }

        @Override
        public void selectChild(Accessible accessible, boolean bl, boolean bl2) {
            if (accessible instanceof IDrawEngine) {
                if (bl2) {
                    ADGraphWindow.this.deselectAll(false);
                }
                if (!bl) {
                    ((IDrawEngine)((Object)accessible)).selectAllCompartments(false);
                }
                ((IDrawEngine)((Object)accessible)).getParent().getTSObject().setSelected(bl);
                ADGraphWindow.this.getDrawingArea().onGraphEvent(17, null, null, null);
                ETGraph eTGraph = ADGraphWindow.this.getGraph() instanceof ETGraph ? (ETGraph)ADGraphWindow.this.getGraph() : null;
                ADGraphWindow.this.getDrawingArea().fireSelectEvent(eTGraph != null ? eTGraph.getSelectedObjects(false, false) : null);
                ADGraphWindow.this.getDrawingArea().refresh(true);
            }
        }

        public boolean isSelectable(Accessible accessible) {
            return true;
        }

        public boolean isSelected(Accessible accessible) {
            if (accessible instanceof IDrawEngine) {
                ETList<TSGraphObject> eTList;
                ETGraph eTGraph;
                ETGraph eTGraph2 = eTGraph = ADGraphWindow.this.getGraph() instanceof ETGraph ? (ETGraph)ADGraphWindow.this.getGraph() : null;
                if (eTGraph != null && (eTList = eTGraph.getSelectedObjects(false, false)) != null && eTList.contains(((IDrawEngine)((Object)accessible)).getParent().getTSObject())) {
                    return true;
                }
            }
            return false;
        }

        public List<Accessible> getAccessibleChildren() {
            ArrayList<Accessible> arrayList = new ArrayList<Accessible>();
            if (this.engine != null) {
                this.engine.getAccessibleContext().setAccessibleParent(this);
                arrayList.add(this.engine);
                ILabelManager iLabelManager = ((IDrawEngine)((Object)this.engine)).getLabelManager();
                if (iLabelManager != null) {
                    int n = 0;
                    while (true) {
                        IETLabel iETLabel = null;
                        iETLabel = iLabelManager.getLabelByIndex(n);
                        if (iETLabel == null) break;
                        IDrawEngine iDrawEngine = iETLabel.getEngine();
                        if (iDrawEngine instanceof Accessible) {
                            ((Accessible)((Object)iDrawEngine)).getAccessibleContext().setAccessibleParent(this);
                            arrayList.add((Accessible)((Object)iDrawEngine));
                        }
                        ++n;
                    }
                }
            }
            return arrayList;
        }

        public List<Accessible> getSelectedAccessibleChildren() {
            ArrayList<Accessible> arrayList = new ArrayList<Accessible>();
            List<Accessible> list = this.getAccessibleChildren();
            for (int i = 0; i < list.size(); ++i) {
                Accessible accessible = list.get(i);
                if (!this.isSelected(accessible)) continue;
                arrayList.add(accessible);
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AccessibleGraphWindow
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection {
        WeakHashMap<IDrawEngine, AccessibleEngineAndLabelsPanel> panels;

        public AccessibleGraphWindow() {
            super((JComponent)((Object)ADGraphWindow.this));
            this.panels = new WeakHashMap();
            this.registerAsGraphListener();
        }

        @Override
        public String getAccessibleName() {
            return ADGraphWindow.this.getDrawingArea().getName();
        }

        @Override
        public int getAccessibleChildrenCount() {
            List<Accessible> list = this.getAccessibleChildren();
            if (list != null) {
                return list.size();
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            List<Accessible> list = this.getAccessibleChildren();
            if (list != null && n < list.size()) {
                return list.get(n);
            }
            return null;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            return null;
        }

        @Override
        public int getAccessibleSelectionCount() {
            List<Accessible> list = this.getSelectedAccessibleChildren();
            if (list != null) {
                return list.size();
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            List<Accessible> list = this.getSelectedAccessibleChildren();
            if (list != null && n < list.size()) {
                return list.get(n);
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            Accessible accessible = this.getAccessibleChild(n);
            if (accessible != null) {
                return this.isSelected(accessible);
            }
            return false;
        }

        @Override
        public void addAccessibleSelection(int n) {
            Accessible accessible = this.getAccessibleChild(n);
            if (accessible != null) {
                this.selectChild(accessible, true, false);
            }
        }

        @Override
        public void removeAccessibleSelection(int n) {
            List<Accessible> list = this.getSelectedAccessibleChildren();
            List<Accessible> list2 = this.getAccessibleChildren();
            if (list2 != null && n < list2.size()) {
                this.selectChild(list2.get(n), false, true);
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
            List<Accessible> list = this.getAccessibleChildren();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    this.selectChild(list.get(i), true, false);
                }
            }
        }

        @Override
        public void clearAccessibleSelection() {
            List<Accessible> list = this.getSelectedAccessibleChildren();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    this.selectChild(list.get(i), false, true);
                }
            }
        }

        public void selectChild(Accessible accessible, boolean bl, boolean bl2) {
            AccessibleSelection accessibleSelection = accessible.getAccessibleContext().getAccessibleSelection();
            if (accessibleSelection != null) {
                if (bl) {
                    accessibleSelection.selectAllAccessibleSelection();
                } else {
                    accessibleSelection.clearAccessibleSelection();
                }
            }
        }

        public boolean isSelectable(Accessible accessible) {
            return true;
        }

        public boolean isSelected(Accessible accessible) {
            if (accessible instanceof AccessibleEngineAndLabelsPanel) {
                AccessibleEngineAndLabelsPanel accessibleEngineAndLabelsPanel = (AccessibleEngineAndLabelsPanel)accessible;
                return accessibleEngineAndLabelsPanel.isSelected(accessibleEngineAndLabelsPanel.engine);
            }
            return false;
        }

        public List<Accessible> getAccessibleChildren() {
            ArrayList<Accessible> arrayList = new ArrayList<Accessible>();
            if (ADGraphWindow.this.m_drawingAreaCtrl != null) {
                ETArrayList eTArrayList = new ETArrayList();
                eTArrayList.addAll(ADGraphWindow.this.getGraph().edges());
                eTArrayList.addAll(ADGraphWindow.this.getGraph().nodes());
                for (TSGraphObject tSGraphObject : eTArrayList) {
                    IDrawEngine iDrawEngine = TypeConversions.getDrawEngine((TSObject)tSGraphObject);
                    if (!(iDrawEngine instanceof Accessible) || iDrawEngine == null || !(iDrawEngine instanceof Accessible)) continue;
                    AccessibleEngineAndLabelsPanel accessibleEngineAndLabelsPanel = this.panels.get(iDrawEngine);
                    if (accessibleEngineAndLabelsPanel == null) {
                        accessibleEngineAndLabelsPanel = new AccessibleEngineAndLabelsPanel((Accessible)((Object)iDrawEngine));
                        accessibleEngineAndLabelsPanel.getAccessibleContext().setAccessibleParent(ADGraphWindow.this);
                        this.panels.put(iDrawEngine, accessibleEngineAndLabelsPanel);
                    }
                    arrayList.add(accessibleEngineAndLabelsPanel);
                }
            }
            return arrayList;
        }

        public List<Accessible> getSelectedAccessibleChildren() {
            ArrayList<Accessible> arrayList = new ArrayList<Accessible>();
            List<Accessible> list = this.getAccessibleChildren();
            for (int i = 0; i < list.size(); ++i) {
                Accessible accessible = list.get(i);
                if (!this.isSelected(accessible)) continue;
                arrayList.add(accessible);
            }
            return arrayList;
        }

        public Accessible getAccessibleChild(Object object) {
            IDrawEngine iDrawEngine;
            if (object instanceof TSObject && (iDrawEngine = TypeConversions.getDrawEngine((TSObject)object)) != null && iDrawEngine instanceof Accessible) {
                AccessibleEngineAndLabelsPanel accessibleEngineAndLabelsPanel = this.panels.get(iDrawEngine);
                if (accessibleEngineAndLabelsPanel == null) {
                    accessibleEngineAndLabelsPanel = new AccessibleEngineAndLabelsPanel((Accessible)((Object)iDrawEngine));
                    accessibleEngineAndLabelsPanel.getAccessibleContext().setAccessibleParent(ADGraphWindow.this);
                    this.panels.put(iDrawEngine, accessibleEngineAndLabelsPanel);
                }
                return accessibleEngineAndLabelsPanel;
            }
            return null;
        }

        public void registerAsGraphListener() {
            ACS_GraphListener aCS_GraphListener = new ACS_GraphListener();
            ADGraphWindow.this.getGraphManager().getEventManager().addGraphChangeListener((Object)ADGraphWindow.this.getGraphManager(), (EventListener)((Object)aCS_GraphListener));
            ((TSEEventManager)ADGraphWindow.this.getGraphManager().getEventManager()).addSelectionChangeListener((Object)ADGraphWindow.this.getGraphManager(), (EventListener)((Object)aCS_GraphListener));
            ((TSEEventManager)ADGraphWindow.this.getGraphManager().getEventManager()).addViewportChangeListener((Object)ADGraphWindow.this, (EventListener)((Object)aCS_GraphListener));
        }

        @Override
        public void firePropertyChange(String string, Object object, Object object2) {
            super.firePropertyChange(string, object, object2);
        }

        public class ACS_GraphListener
        implements TSGraphChangeListener,
        TSESelectionChangeListener,
        TSEViewportChangeListener {
            public void graphChanged(TSGraphChangeEvent tSGraphChangeEvent) {
                if (tSGraphChangeEvent.getType() == 2L || tSGraphChangeEvent.getType() == 4L) {
                    Accessible accessible = AccessibleGraphWindow.this.getAccessibleChild(tSGraphChangeEvent.getSource());
                    AccessibleGraphWindow.this.firePropertyChange("AccessibleChild", null, accessible);
                } else if (tSGraphChangeEvent.getType() == 16L || tSGraphChangeEvent.getType() == 128L || tSGraphChangeEvent.getType() == 32L || tSGraphChangeEvent.getType() == 256L) {
                    Accessible accessible = AccessibleGraphWindow.this.getAccessibleChild(tSGraphChangeEvent.getSource());
                    AccessibleGraphWindow.this.firePropertyChange("AccessibleChild", accessible, null);
                } else if (tSGraphChangeEvent.getType() == 1024L || tSGraphChangeEvent.getType() == 2048L) {
                    // empty if block
                }
            }

            public void selectionChanged(TSESelectionChangeEvent tSESelectionChangeEvent) {
                Object object;
                Object object2 = tSESelectionChangeEvent.getSource();
                Object object3 = null;
                Object object4 = null;
                if (tSESelectionChangeEvent.getData() instanceof TSESelectionChangeEventData && (object = (TSESelectionChangeEventData)tSESelectionChangeEvent.getData()) != null) {
                    if (object.isSelected()) {
                        object4 = object2;
                    } else if (object.wasSelected()) {
                        object3 = object2;
                    }
                }
                AccessibleGraphWindow.this.firePropertyChange("AccessibleSelection", object3, object4);
                if (object2 != null && (object = object2 instanceof TSLabel ? AccessibleGraphWindow.this.getAccessibleChild(((TSGraphObject)tSESelectionChangeEvent.getSource()).getOwner()) : AccessibleGraphWindow.this.getAccessibleChild(tSESelectionChangeEvent.getSource())) != null) {
                    object.getAccessibleContext().firePropertyChange("AccessibleSelection", object3, object4);
                }
            }

            public void viewportChanged(TSEViewportChangeEvent tSEViewportChangeEvent) {
            }
        }
    }

    protected class ADDrawingPreferences
    extends TSEPreferences {
        ADDrawingPreferences(TSEGraphWindow tSEGraphWindow) {
            super(tSEGraphWindow);
        }

        protected void modifyDefaults() {
            super.modifyDefaults();
        }

        public void setDefaults() {
            super.setDefaults();
        }
    }
}

