/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.drawingarea;

import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.editor.TSEGrid;
import com.tomsawyer.editor.TSEWindowTool;
import com.tomsawyer.editor.event.TSESelectionChangeEvent;
import com.tomsawyer.editor.event.TSESelectionChangeListener;
import com.tomsawyer.editor.event.TSEViewportChangeEvent;
import com.tomsawyer.editor.event.TSEViewportChangeListener;
import com.tomsawyer.editor.tool.TSEInteractiveZoomTool;
import com.tomsawyer.editor.tool.TSELinkNavigationTool;
import com.tomsawyer.editor.tool.TSEPanTool;
import com.tomsawyer.editor.tool.TSESelectTool;
import com.tomsawyer.editor.tool.TSEZoomTool;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeListener;
import com.tomsawyer.util.TSSystem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.support.Debug;
import org.netbeans.modules.uml.core.support.umlutils.ETArrayList;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IETGraphObject;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADComboBox;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADDrawingAreaPrinter;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADDrawingAreaResourceBundle;
import org.netbeans.modules.uml.ui.swing.drawingarea.ADGraphWindow;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;

public class ADDrawingAreaActions
implements ActionListener,
TSGraphChangeListener,
TSESelectionChangeListener,
TSEViewportChangeListener {
    private ADDrawingAreaControl m_drawingArea;
    private static final String BUNDLE_NAME = "org.netbeans.modules.uml.ui.swing.drawingarea.Bundle";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("org.netbeans.modules.uml.ui.swing.drawingarea.Bundle");
    private boolean processedPreMoveAction = false;
    protected ADDrawingAreaPrinter m_printer = null;
    protected boolean m_enableSelectionEvents = true;

    public ADDrawingAreaActions(ADDrawingAreaControl aDDrawingAreaControl) {
        this.m_drawingArea = aDDrawingAreaControl;
        Debug.out.println(" ADDrawingAreaActions : constructor");
    }

    public void onNextState() {
        TSEWindowTool tSEWindowTool = this.getCurrentState();
        if (tSEWindowTool instanceof TSESelectTool && !this.m_drawingArea.isAutoFitInWindow()) {
            this.onSwitchToPan();
        } else if (tSEWindowTool instanceof TSEPanTool && !this.m_drawingArea.isAutoFitInWindow()) {
            this.onSwitchToZoom();
        } else if (tSEWindowTool instanceof TSEZoomTool && !this.m_drawingArea.isAutoFitInWindow()) {
            this.onSwitchToInteractiveZoom();
        } else if (tSEWindowTool instanceof TSEInteractiveZoomTool && this.m_drawingArea.getGraphManager().numberOfViewableEdges() > 0 && !this.m_drawingArea.isAutoFitInWindow()) {
            this.onSwitchToLinkNavigation();
        } else {
            this.onSwitchToSelect();
        }
    }

    protected void switchState(TSEWindowTool tSEWindowTool) {
        this.getGraphWindow().switchTool(tSEWindowTool);
    }

    protected TSEWindowTool getDefaultState() {
        return this.getGraphWindow() != null ? this.getGraphWindow().getDefaultState() : null;
    }

    protected TSEWindowTool getCurrentState() {
        return this.getGraphWindow() != null ? this.getGraphWindow().getCurrentState() : null;
    }

    public void onSwitchToSelect() {
        this.getControl().enterMode(0);
    }

    public void onSwitchToZoom() {
        this.getControl().enterMode(3);
    }

    public void onSwitchToInteractiveZoom() {
        this.getControl().enterMode(4);
    }

    public void onSwitchToPan() {
        this.getControl().enterMode(1);
    }

    public void onSwitchToLinkNavigation() {
        this.getControl().enterMode(5);
    }

    public void onAbortAction() {
        if (this.m_drawingArea.hasGraphWindow()) {
            this.getGraphWindow().cancelAction();
            ADDrawingAreaControl aDDrawingAreaControl = this.m_drawingArea;
            aDDrawingAreaControl.autoFitInWindow = false;
        }
    }

    public void onRefresh() {
        this.getControl().refresh(false);
    }

    public void onDuplicateGraph() {
        this.m_drawingArea.duplicate();
    }

    public void onClearAll() {
        this.m_drawingArea.onClearAll();
        this.onSwitchToSelect();
    }

    public void onDeleteSelected() {
        this.m_drawingArea.onDeleteSelected();
    }

    public void onHideSelected() {
    }

    public void onUnhideAll() {
    }

    public void onFoldSelected() {
    }

    public void onUnfoldAll() {
    }

    public void onUnfoldSelected() {
    }

    public void onCollapseSelected() {
    }

    public void onExpandSelected() {
    }

    public void onScrollGraph(int n) {
        ETList<IPresentationElement> eTList = this.m_drawingArea.getSelected();
        ADGraphWindow aDGraphWindow = this.getGraphWindow();
        if (eTList == null || eTList.size() == 0) {
            switch (n) {
                case 37: {
                    aDGraphWindow.scrollBy(-20, 0, true);
                    break;
                }
                case 39: {
                    aDGraphWindow.scrollBy(20, 0, true);
                    break;
                }
                case 38: {
                    aDGraphWindow.scrollBy(0, -20, true);
                    break;
                }
                case 40: {
                    aDGraphWindow.scrollBy(0, 20, true);
                }
            }
        }
    }

    public void onSelectAll() {
        this.getGraphWindow().selectAll(true);
    }

    public void onSelectNodes() {
        ADGraphWindow aDGraphWindow = this.getGraphWindow();
        aDGraphWindow.deselectAll(false);
        aDGraphWindow.selectAllNodes(true);
    }

    public void onSelectEdges() {
        ADGraphWindow aDGraphWindow = this.getGraphWindow();
        aDGraphWindow.deselectAll(false);
        aDGraphWindow.selectAllEdges(true);
    }

    public void onSelectLabels() {
        ADGraphWindow aDGraphWindow = this.getGraphWindow();
        aDGraphWindow.deselectAll(false);
        aDGraphWindow.selectAllEdgeLabels(true);
        aDGraphWindow.selectAllNodeLabels(true);
    }

    public void onZoomChange() {
        String string = this.m_drawingArea.getZoomComboBox().getSelectedItem().toString();
        String string2 = RESOURCE_BUNDLE.getString("IDS_ZOOMTOFIT");
        if (string.equals("") || string.equals(string2)) {
            this.onFitInWindow();
        }
        if (string.endsWith("%")) {
            string = string.substring(0, string.length() - 1);
        }
        try {
            double d = Math.abs(Double.valueOf(string));
            double d2 = this.getGraphWindow().getZoomLevel() * 100.0;
            if (d2 != d) {
                this.onZoom(new Double(d).toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ADDrawingAreaControl aDDrawingAreaControl = this.m_drawingArea;
        aDDrawingAreaControl.autoFitInWindow = false;
    }

    public void onZoom(String string) {
        if (this.getGraphWindow() != null) {
            double d = 100.0;
            try {
                String string2 = string.replaceAll("ZOOM", "");
                d = Math.abs(Double.parseDouble(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.getGraphWindow().setZoomLevel(d / 100.0, true);
        }
    }

    public void onGridType(String string) {
        this.onGridType(string, true);
    }

    public void onGridType(String string, boolean bl) {
        int n = string.lastIndexOf(46);
        if (n > 0) {
            String string2 = string.substring(n + 1);
            if (string2.equals("none")) {
                this.getGraphWindow().setGrid(null);
            } else if (string2.equals("point")) {
                this.getGraphWindow().setGrid((TSEGrid)this.m_drawingArea.getPointGrid());
            } else if (string2.equals("line")) {
                this.getGraphWindow().setGrid((TSEGrid)this.m_drawingArea.getLineGrid());
            }
            if (bl) {
                this.onRefresh();
            }
        }
    }

    public void onGridSize(String string) {
        this.onGridSize(string, true);
    }

    public void onGridSize(String string, boolean bl) {
    }

    public void onCustomGridSize() {
    }

    public void onExpandCollapseAll(boolean bl) {
    }

    public ADDrawingAreaResourceBundle getResources() {
        return this.m_drawingArea.getResources();
    }

    public void onCustomZoom() {
        String string;
        ADGraphWindow aDGraphWindow = this.getGraphWindow();
        double d = 100.0 * aDGraphWindow.getZoomLevel();
        String string2 = String.valueOf(d = (double)Math.round(d * 100.0) / 100.0);
        if (string2.endsWith(".0")) {
            string2 = string2.substring(0, string2.lastIndexOf(".0"));
        }
        if ((string = (String)JOptionPane.showInputDialog(this.m_drawingArea, this.getResources().getStringResource("dialog.zoom.message"), this.getResources().getStringResource("dialog.zoom.title"), -1, null, null, string2)) != null && string.length() > 0) {
            try {
                double d2 = Double.valueOf(string);
                if (d2 < aDGraphWindow.getMinZoomLevel() * 100.0 || d2 > aDGraphWindow.getMaxZoomLevel() * 100.0) {
                    throw new Exception();
                }
                double d3 = d2 / 100.0;
                if (d3 != d) {
                    aDGraphWindow.setZoomLevel(d3, true);
                }
            }
            catch (Exception exception) {
                String string3 = TSSystem.replace((String)this.getResources().getStringResource("dialog.zoomError.message"), (String)"%X%", (String)("" + aDGraphWindow.getMinZoomLevel() * 100.0));
                string3 = TSSystem.replace((String)string3, (String)"%Y%", (String)("" + aDGraphWindow.getMaxZoomLevel() * 100.0));
                JOptionPane.showMessageDialog(this.m_drawingArea, string3, this.getResources().getStringResource("dialog.zoomError.title"), 0);
            }
        }
        aDGraphWindow.fastRepaint();
    }

    public void onZoomIn() {
        ADGraphWindow aDGraphWindow = this.getGraphWindow();
        if (aDGraphWindow.getZoomLevel() < aDGraphWindow.getMaxZoomLevel() / 1.1) {
            aDGraphWindow.zoom(0.1, true);
        } else {
            aDGraphWindow.setZoomLevel(aDGraphWindow.getMaxZoomLevel(), true);
        }
        ADDrawingAreaControl aDDrawingAreaControl = this.m_drawingArea;
        aDDrawingAreaControl.autoFitInWindow = false;
    }

    public void onZoomOut() {
        ADGraphWindow aDGraphWindow = this.getGraphWindow();
        if (aDGraphWindow.getZoomLevel() > aDGraphWindow.getMinZoomLevel() * 1.1) {
            aDGraphWindow.zoom(-0.1, true);
        } else {
            aDGraphWindow.setZoomLevel(aDGraphWindow.getMaxZoomLevel(), true);
        }
        ADDrawingAreaControl aDDrawingAreaControl = this.m_drawingArea;
        aDDrawingAreaControl.autoFitInWindow = false;
    }

    public void onUndoAction() {
    }

    public void onRedoAction() {
    }

    public void onClearHistory() {
        int n = JOptionPane.showConfirmDialog(this.m_drawingArea, this.getResources().getStringResource("dialog.clearHistory.message"), this.getResources().getStringResource("dialog.clearHistory.title"), 0, 2);
        if (n == 0) {
            this.getGraphWindow().clearUndoStack();
        }
    }

    public void onAutoFitInWindow() {
        TSEWindowTool tSEWindowTool;
        ADDrawingAreaControl aDDrawingAreaControl;
        aDDrawingAreaControl.setAutoFitInWindow(!(aDDrawingAreaControl = this.m_drawingArea).isAutoFitInWindow());
        if (aDDrawingAreaControl.isAutoFitInWindow()) {
            if (aDDrawingAreaControl.hasGraphWindow()) {
                aDDrawingAreaControl.getGraphWindow().fitInWindow(true);
            }
            aDDrawingAreaControl.unregisterKeyCommands(aDDrawingAreaControl);
        } else {
            aDDrawingAreaControl.registerKeyCommands(aDDrawingAreaControl);
        }
        if (aDDrawingAreaControl.getOverviewWindow() != null) {
            aDDrawingAreaControl.getOverviewWindow().getOverviewComponent().setToolEnabled(true);
        }
        if (aDDrawingAreaControl.hasGraphWindow() && ((tSEWindowTool = this.getCurrentState()) instanceof TSEPanTool || tSEWindowTool instanceof TSEZoomTool || tSEWindowTool instanceof TSEInteractiveZoomTool || tSEWindowTool instanceof TSELinkNavigationTool)) {
            this.onSwitchToSelect();
        }
    }

    public void onFitInWindow() {
        if (this.getGraphWindow() != null) {
            this.getGraphWindow().fitInWindow(true);
        }
    }

    public void onAppExit() {
    }

    public void onCloseGraph() {
    }

    public void onRevertGraph() {
    }

    public void onPrintPreview() {
        IDrawingAreaControl iDrawingAreaControl = this.getControl();
        iDrawingAreaControl.printPreview(iDrawingAreaControl.getName(), false);
    }

    public ADDrawingAreaPrinter getDrawingAreaPrinter() {
        if (this.m_printer == null) {
            this.m_printer = new ADDrawingAreaPrinter(this.getGraphWindow(), this.getResources());
        }
        return this.m_printer;
    }

    protected ADGraphWindow getGraphWindow() {
        return this.m_drawingArea.getGraphWindow();
    }

    public void onPrintSetup() {
        Debug.out.println(" entered ADDrawingAreaActions : onPrintSetup() ");
        IDrawingAreaControl iDrawingAreaControl = this.getControl();
        if (iDrawingAreaControl instanceof ADDrawingAreaControl) {
            Debug.out.println(" in if instanceof ...ADDrawingAreaActions : onPrintSetup() ");
            ((ADDrawingAreaControl)iDrawingAreaControl).getDrawingAreaPrinter().printSetup();
        } else {
            Debug.out.println(" in else of ...ADDrawingAreaActions : onPrintSetup() ");
            this.getDrawingAreaPrinter().printSetup();
        }
    }

    public void onPrintGraph() {
        IDrawingAreaControl iDrawingAreaControl = this.getControl();
        iDrawingAreaControl.printGraph(false);
    }

    public void onExportAsImage() {
        this.m_drawingArea.showImageDialog();
    }

    public void onChangeSpacing() {
        this.showNotImplementedMessage();
    }

    public void onDiagramSync() {
        this.m_drawingArea.validateDiagram(false, null);
    }

    public void onShowFriendly() {
        ProductHelper.toggleShowAliasedNames();
    }

    public void onRelationDiscovery() {
        this.m_drawingArea.executeRelationshipDiscovery();
    }

    public void onMoveForword() {
        this.m_drawingArea.executeStackingCommand(0, true);
    }

    public void onMoveToFront() {
        this.m_drawingArea.executeStackingCommand(1, true);
    }

    public void onMoveBackward() {
        this.m_drawingArea.executeStackingCommand(2, true);
    }

    public void onMovetoBack() {
        this.m_drawingArea.executeStackingCommand(3, true);
    }

    public void onPreMoveObjects() {
        if (this.m_drawingArea != null && !this.processedPreMoveAction) {
            ETList<Object> eTList = new ETArrayList();
            eTList = this.m_drawingArea.getSelectedNodes();
            if (eTList != null) {
                this.m_drawingArea.onGraphEvent(2, null, null, eTList);
            }
            this.processedPreMoveAction = true;
        }
    }

    public void onPostMoveObjects() {
        if (this.m_drawingArea != null) {
            ETArrayList<IETGraphObject> eTArrayList = new ETArrayList();
            eTArrayList = this.m_drawingArea.getSelectedNodes();
            this.m_drawingArea.onGraphEvent(3, null, null, eTArrayList);
            this.processedPreMoveAction = false;
        }
    }

    public void onApplySequenceLayout(String string) {
        this.m_drawingArea.immediatelySetLayoutStyle(6, false);
    }

    private void showNotImplementedMessage() {
        JOptionPane.showMessageDialog(this.m_drawingArea, this.getResources().getStringResource("dialog.notImplemented.message"), this.getResources().getStringResource("dialog.notImplemented.title"), 1);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Debug.out.println(" ADDrawingAreaActions : actionPerformed");
        String string = actionEvent.getActionCommand();
        ADGraphWindow aDGraphWindow = this.getGraphWindow();
        if (this.m_drawingArea.hasGraphWindow()) {
            aDGraphWindow.getCanvas().requestFocus();
        }
        if (!"MOVE_DONE".equals(string)) {
            this.onAbortAction();
        }
        if (this.m_drawingArea.hasGraphWindow()) {
            if ("MOVE_LEFT".equals(string)) {
                this.onPreMoveObjects();
                aDGraphWindow.move(3);
                aDGraphWindow.finalizeMove();
            } else if ("MOVE_RIGHT".equals(string)) {
                this.onPreMoveObjects();
                aDGraphWindow.move(4);
                aDGraphWindow.finalizeMove();
            } else if ("MOVE_UP".equals(string)) {
                this.onPreMoveObjects();
                aDGraphWindow.move(1);
                aDGraphWindow.finalizeMove();
            } else if ("MOVE_DOWN".equals(string)) {
                this.onPreMoveObjects();
                aDGraphWindow.move(2);
                aDGraphWindow.finalizeMove();
            } else {
                aDGraphWindow.finalizeMove();
            }
        }
        if ("PRINT_PREVIEW".equals(string)) {
            this.onPrintPreview();
        } else if ("PRINT_GRAPH".equals(string)) {
            this.onPrintGraph();
        } else if ("SAVE_AS_IMAGE".equals(string)) {
            this.onExportAsImage();
        } else if ("SELECT_STATE".equals(string)) {
            this.onSwitchToSelect();
        } else if ("PAN_STATE".equals(string)) {
            this.onSwitchToPan();
        } else if ("CHANGE_SPACING".equals(string)) {
            this.onChangeSpacing();
        } else if ("ZOOM_STATE".equals(string)) {
            this.onSwitchToZoom();
        } else if ("INTERACTIVE_ZOOM_STATE".equals(string)) {
            this.onSwitchToInteractiveZoom();
        } else if ("EDGE_NAVIGATION_STATE".equals(string)) {
            this.onSwitchToLinkNavigation();
        } else if ("OVERVIEW_WINDOW".equals(string)) {
            this.m_drawingArea.onShowOverviewWindow();
        } else if ("DIAGRAM_SYNC".equals(string)) {
            this.onDiagramSync();
        } else if ("SHOW_FRIENDLY".equals(string)) {
            this.onShowFriendly();
        } else if ("RELATION_DISCOVERY".equals(string)) {
            this.onRelationDiscovery();
        } else if ("AUTO_FIT".equals(string)) {
            this.onAutoFitInWindow();
        } else if ("ZOOM_CHANGE".equals(string)) {
            this.onZoomChange();
        } else if ("ZOOM_IN".equals(string)) {
            this.onZoomIn();
        } else if ("ZOOM_OUT".equals(string)) {
            this.onZoomOut();
        } else if ("MOVE_FORWORD".equals(string)) {
            this.onMoveForword();
        } else if ("MOVE_TO_FRONT".equals(string)) {
            this.onMoveToFront();
        } else if ("MOVE_BACKWARD".equals(string)) {
            this.onMoveBackward();
        } else if ("MOVE_TO_BACK".equals(string)) {
            this.onMovetoBack();
        } else if (string.startsWith("APPLY_LAYOUT")) {
            this.m_drawingArea.onApplyLayout(string);
        } else if (string.startsWith("SEQUENCE_LAYOUT")) {
            this.onApplySequenceLayout(string);
        } else if (string.startsWith("RELAYOUT")) {
            this.m_drawingArea.onApplyLayout(string);
        } else if (string.endsWith("INCREMENTAL_LAYOUT")) {
            this.onApplyIncrementalLayout();
        } else if ("CLOSE_GRAPH".equals(string)) {
            this.onCloseGraph();
        } else if ("APP_EXIT".equals(string)) {
            this.onAppExit();
        } else if ("CLEAR_ALL".equals(string)) {
            this.onClearAll();
        } else if ("CLEAR_HISTORY".equals(string)) {
            this.onClearHistory();
        } else if (!"DELETE_SELECTED".equals(string)) {
            if ("EXPAND_SELECTED".equals(string)) {
                this.onExpandSelected();
            } else if ("COLLAPSE_SELECTED".equals(string)) {
                this.onCollapseSelected();
            } else if ("INCREMENTAL_LAYOUT_AFTER_ACTION".equals(string)) {
                this.onIncrementalLayoutAfterAction();
            } else if ("DUPLICATE_GRAPH".equals(string)) {
                this.onDuplicateGraph();
            } else if ("REVERT_GRAPH".equals(string)) {
                this.onRevertGraph();
            } else if ("SCROLL_LEFT".equals(string)) {
                this.onScrollGraph(37);
            } else if ("SCROLL_RIGHT".equals(string)) {
                this.onScrollGraph(39);
            } else if ("SCROLL_UP".equals(string)) {
                this.onScrollGraph(38);
            } else if ("SCROLL_DOWN".equals(string)) {
                this.onScrollGraph(40);
            } else if (!("NEW_GRAPH".equals(string) || "PALETTE_WINDOW".equals(string) || "PASTE_GRAPH".equals(string) || "PRINT_SETUP".equals(string))) {
                if ("REDO".equals(string)) {
                    this.onRedoAction();
                } else if ("REFRESH_GRAPH".equals(string)) {
                    this.onRefresh();
                } else if (!("SAVE_GRAPH".equals(string) || "SAVE_GRAPH_AS".equals(string) || "SAVE_GRAPH_AS_IMAGE".equals(string))) {
                    if ("SELECT_ALL".equals(string)) {
                        this.onSelectAll();
                    } else if ("SELECT_EDGES".equals(string)) {
                        this.onSelectEdges();
                    } else if ("SELECT_LABELS".equals(string)) {
                        this.onSelectLabels();
                    } else if ("SELECT_NODES".equals(string)) {
                        this.onSelectNodes();
                    } else if ("UNDO".equals(string)) {
                        this.onUndoAction();
                    } else if ("ZOOM_CUSTOM".equals(string)) {
                        this.onCustomZoom();
                    } else if ("ZOOM_FIT".equals(string)) {
                        this.onFitInWindow();
                    } else if ("NEXT_STATE".equals(string)) {
                        this.onNextState();
                    } else if (string.startsWith("ZOOM")) {
                        this.onZoom(string);
                    } else if (string.startsWith("GRID_TYPE")) {
                        this.onGridType(string);
                    } else if ("GRID_SIZE_CUSTOM".equals(string)) {
                        this.onCustomGridSize();
                    } else if (string.startsWith("GRID_SIZE")) {
                        this.onGridSize(string);
                    } else if (string.startsWith("EXPAND_ALL")) {
                        this.onExpandCollapseAll(true);
                    } else if (string.startsWith("COLLAPSE_ALL")) {
                        this.onExpandCollapseAll(false);
                    } else if (!("LAYOUT_PROPERTIES".equals(string) || "DRAWING_PREFERENCES".equals(string) || "MOVE_DONE".equals(string) || "MOVE_LEFT".equals(string) || "MOVE_RIGHT".equals(string) || "MOVE_UP".equals(string) || "MOVE_DOWN".equals(string))) {
                        if ("NODE_RESIZE_TALLER".equals(string) || "NODE_RESIZE_SHORTER".equals(string) || "NODE_RESIZE_WIDER".equals(string) || "NODE_RESIZE_THINNER".equals(string)) {
                            this.onIncrementalResizeNodes(string);
                        } else if ("ACTION_ABORT".equals(string)) {
                            this.onCancel();
                        } else {
                            this.getControl().enterModeFromButton(string);
                        }
                    }
                }
            }
        }
        this.onPostActionaPerformed();
    }

    public void onDrawInvisibleOnDragging() {
        ADGraphWindow aDGraphWindow;
        aDGraphWindow.setDrawInvisibleOnDragging(!(aDGraphWindow = this.getGraphWindow()).isDrawInvisibleOnDragging());
    }

    public void onApplyIncrementalLayout() {
        Debug.out.println(" ADDrawingAreaActions : onApplyIncrementalLayout");
        String string = "APPLY_LAYOUT." + this.m_drawingArea.getLayoutInputTailor().getLayoutStyle((TSDGraph)this.m_drawingArea.getGraph()) + "." + "INCREMENTAL_LAYOUT";
        Debug.out.println(" Jyothi -- ADDrawingAreaActions : onApplyIncrementalLayout() -- command = " + string);
        this.m_drawingArea.onApplyLayout(string);
    }

    public void onIncrementalLayoutAfterAction() {
    }

    public void graphChanged(TSGraphChangeEvent tSGraphChangeEvent) {
        long l = tSGraphChangeEvent.getType();
        if ((l == 1L || l == 8L || l == 512L || l == 64L || l == 2L || l == 16L || l == 1024L || l == 128L || l == 4L || l == 32L || l == 2048L || l == 256L || l == 4096L) && this.m_drawingArea != null) {
            this.m_drawingArea.setChanged(true);
        }
        if ((l == 1L || l == -1L) && this.m_drawingArea.isAutoFitInWindow()) {
            this.getGraphWindow().fitInWindow(true);
        }
    }

    public void selectionChanged(TSESelectionChangeEvent tSESelectionChangeEvent) {
        if (tSESelectionChangeEvent.getType() == 1L && this.getEnableSelectionEvents()) {
            this.onSelectionChange(tSESelectionChangeEvent);
        }
    }

    public void viewportChanged(TSEViewportChangeEvent tSEViewportChangeEvent) {
        if (tSEViewportChangeEvent.getType() == 1L || tSEViewportChangeEvent.getType() == 2L) {
            this.onViewChange(tSEViewportChangeEvent);
        }
    }

    public boolean setEnableSelectionEvents(boolean bl) {
        boolean bl2 = this.m_enableSelectionEvents;
        this.m_enableSelectionEvents = bl;
        return bl2;
    }

    public boolean getEnableSelectionEvents() {
        return this.m_enableSelectionEvents;
    }

    public void onSelectionChange(TSESelectionChangeEvent tSESelectionChangeEvent) {
    }

    public void onViewChange(TSEViewportChangeEvent tSEViewportChangeEvent) {
        ADComboBox aDComboBox;
        String string;
        double d = 1.0;
        ADGraphWindow aDGraphWindow = this.getGraphWindow();
        if (aDGraphWindow != null) {
            d = aDGraphWindow.getZoomLevel() * 100.0;
        }
        if ((string = String.valueOf(d = (double)Math.round(d * 100.0) / 100.0)).endsWith(".0")) {
            string = string.substring(0, string.lastIndexOf(".0"));
        }
        if ((aDComboBox = this.m_drawingArea.getZoomComboBox()).getSelectedItem().equals(string + "%")) {
            return;
        }
        aDComboBox.setFireEvents(false);
        aDComboBox.setSelectedItem(string + "%");
        aDComboBox.setFireEvents(true);
    }

    protected void onPostActionaPerformed() {
    }

    protected IDrawingAreaControl getControl() {
        return this.m_drawingArea;
    }

    private void onIncrementalResizeNodes(String string) {
        int n = 92;
        if (string.equals("NODE_RESIZE_SHORTER")) {
            n = 93;
        } else if (string.equals("NODE_RESIZE_WIDER")) {
            n = 94;
        } else if (string.equals("NODE_RESIZE_THINNER")) {
            n = 95;
        }
        this.m_drawingArea.onHandleResize(n);
    }

    private void onCancel() {
        this.m_drawingArea.onHandleCancel();
    }

    protected void clearDrawingAreaControlRefs() {
        this.m_drawingArea = null;
    }
}

