/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.commondialogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateFamiliesDataAccess {
    private Document data;
    public static final String ELEMENT_FAMILY = "family";
    public static final String ELEMENT_DOMAIN_OBJECT = "domainObject";
    public static final String ELEMENT_MODEL_ELEMENT = "modelElement";
    public static final String ELEMENT_STEREOTYPE = "stereotype";
    public static final String ELEMENT_DESCRIPTION = "description";
    public static final String ELEMENT_TEMPLATE_FILE = "templateFile";
    public static final String ELEMENT_FILENAME_FORMAT = "filenameFormat";
    public static final String ELEMENT_FILE_EXTENSION = "fileExtension";
    public static final String ELEMENT_FOLDER_PATH = "folderPath";
    public static final String ATTRIBUTE_NAME = "name";

    public TemplateFamiliesDataAccess() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.data = documentBuilder.parse(new File(this.retrieveTemplateFamiliesFile()));
            this.getData().getDocumentElement().normalize();
            System.out.println("Root element of the doc is " + this.getData().getDocumentElement().getNodeName());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println(" " + sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            (exception == null ? sAXException : exception).printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
    }

    public NodeList getFamilyNodes() {
        return this.getData().getElementsByTagName(ELEMENT_FAMILY);
    }

    public List<String> retrieveFamilies() {
        NodeList nodeList = this.getFamilyNodes();
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            arrayList.add(((Element)node).getAttribute(ATTRIBUTE_NAME));
        }
        return arrayList;
    }

    public NodeList getFamilyTemplateNodes(String string) {
        NodeList nodeList = this.getData().getElementsByTagName(ELEMENT_FAMILY);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !string.equals((element = (Element)node).getAttribute(ATTRIBUTE_NAME))) continue;
            return element.getElementsByTagName(ELEMENT_DOMAIN_OBJECT);
        }
        return null;
    }

    public List<String> retrieveFamilyTemplates(String string) {
        NodeList nodeList = this.getFamilyTemplateNodes(string);
        if (nodeList == null || nodeList.getLength() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            arrayList.add(element.getAttribute(ATTRIBUTE_NAME));
        }
        return arrayList;
    }

    public Document getData() {
        return this.data;
    }

    public int getFamilyTotal() {
        return this.getFamilyNodes().getLength();
    }

    public String getFamilyName(int n) {
        return this.retrieveFamilies().get(n);
    }

    public int getTemplateTotal(String string) {
        return this.getFamilyTemplateNodes(string).getLength();
    }

    public String getTemplateName(String string, int n) {
        return this.retrieveFamilyTemplates(string).get(n);
    }

    private String retrieveTemplateFamiliesFile() {
        return ProductHelper.getConfigManager().getDefaultConfigLocation() + "TemplateFamilies.etc";
    }

    public String getModelElementText(String string, String string2) {
        return this.getDomainChildElementText(string, string2, ELEMENT_MODEL_ELEMENT);
    }

    public String getStereotypeText(String string, String string2) {
        return this.getDomainChildElementText(string, string2, ELEMENT_STEREOTYPE);
    }

    public String getFilenameText(String string, String string2) {
        return this.getDomainChildElementText(string, string2, ELEMENT_TEMPLATE_FILE);
    }

    public String getDescriptionText(String string, String string2) {
        return this.getDomainChildElementText(string, string2, ELEMENT_DESCRIPTION);
    }

    public NodeList getDomainNodeChildren(String string, String string2) {
        NodeList nodeList = this.getFamilyTemplateNodes(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !string2.equals((element = (Element)node).getAttribute(ATTRIBUTE_NAME))) continue;
            return element.getChildNodes();
        }
        return null;
    }

    private String getDomainChildElementText(String string, String string2, String string3) {
        NodeList nodeList = this.getDomainNodeChildren(string, string2);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !string3.equals((element = (Element)node).getTagName())) continue;
            return element.getTextContent();
        }
        return "";
    }

    public String[][] getTemplatesData(String string, String string2) {
        String[][] stringArray = null;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        NodeList nodeList = this.getDomainNodeChildren(string, string2);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !(element = (Element)node).getTagName().equals("template")) continue;
            NodeList nodeList2 = element.getChildNodes();
            String[] stringArray2 = new String[4];
            int n = 0;
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element2;
                Node node2 = nodeList2.item(j);
                if (node2.getNodeType() != 1 || (n = (element2 = (Element)node2).getTagName().equals(ELEMENT_FILENAME_FORMAT) ? 0 : (element2.getTagName().equals(ELEMENT_FILE_EXTENSION) ? 1 : (element2.getTagName().equals(ELEMENT_FOLDER_PATH) ? 2 : (element2.getTagName().equals(ELEMENT_TEMPLATE_FILE) ? 3 : -1)))) <= -1) continue;
                stringArray2[n] = element2.getTextContent();
            }
            arrayList.add(stringArray2);
        }
        stringArray = new String[arrayList.size()][4];
        if (arrayList.size() > 0) {
            arrayList.toArray((T[])stringArray);
        }
        return stringArray;
    }
}

