/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.swing.commondialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.modules.uml.core.support.umlmessagingcore.IMessageData;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.QuestionResponse;
import org.netbeans.modules.uml.ui.support.UserResultListener;
import org.netbeans.modules.uml.ui.support.commondialogs.IErrorDialog;
import org.netbeans.modules.uml.ui.support.messaging.IMessenger;
import org.netbeans.modules.uml.ui.swing.commondialogs.DefaultCommonDialogResource;
import org.netbeans.modules.uml.ui.swing.commondialogs.JCenterDialog;
import org.netbeans.modules.uml.ui.swing.commondialogs.JFixedSizeTextArea;

public class SwingErrorDialog
implements IErrorDialog {
    private boolean m_bRunSilent = false;
    private int m_DefaultButton = -1;
    private Frame m_ParentFrame = null;
    private JDialog m_ParentDialog = null;

    public SwingErrorDialog() {
        this.initMessaging();
        this.m_ParentFrame = ProductHelper.getProxyUserInterface().getWindowHandle();
    }

    public SwingErrorDialog(Frame frame) {
        this.initMessaging();
        this.m_ParentFrame = frame;
    }

    public SwingErrorDialog(JDialog jDialog) {
        this.initMessaging();
        if (jDialog != null) {
            this.m_ParentDialog = jDialog;
        } else {
            this.m_ParentFrame = ProductHelper.getProxyUserInterface().getWindowHandle();
        }
    }

    private void initMessaging() {
        IMessenger iMessenger = ProductHelper.getMessenger();
        if (iMessenger != null) {
            this.m_bRunSilent = iMessenger.getDisableMessaging();
        }
    }

    public void display(String string, int n, String string2) {
        Icon icon;
        JCenterDialog jCenterDialog;
        if (string != null && string.length() > 0 && !this.m_bRunSilent && (jCenterDialog = this.createDialog(string, string2, icon = this.getIconForType(n))) != null) {
            jCenterDialog.pack();
            Insets insets = jCenterDialog.getInsets();
            insets.top = 5;
            insets.left = 5;
            insets.bottom = 5;
            insets.right = 5;
            if (this.m_ParentFrame != null) {
                jCenterDialog.center(this.m_ParentFrame);
            } else if (this.m_ParentDialog != null) {
                jCenterDialog.center(this.m_ParentDialog);
            }
            jCenterDialog.setModal(true);
            jCenterDialog.setVisible(true);
        }
    }

    public void display(String string, String string2) {
        Icon icon;
        JCenterDialog jCenterDialog;
        String string3 = string2;
        if (string3 == null || string3.length() == 0) {
            string2 = DefaultCommonDialogResource.getString("IDS_ERROR_TITLE");
        }
        if (!this.m_bRunSilent && (jCenterDialog = this.createDialog(string, string2, icon = this.getIconForType(-1))) != null) {
            jCenterDialog.pack();
            Insets insets = jCenterDialog.getInsets();
            insets.top = 5;
            insets.left = 5;
            insets.bottom = 5;
            insets.right = 5;
            if (this.m_ParentFrame != null) {
                jCenterDialog.center(this.m_ParentFrame);
            } else if (this.m_ParentDialog != null) {
                jCenterDialog.center(this.m_ParentDialog);
            }
            jCenterDialog.setModal(true);
            jCenterDialog.setVisible(true);
        }
    }

    public void display(IMessageData iMessageData, String string, String string2) {
        if (iMessageData != null && !this.m_bRunSilent) {
            String string3 = "";
            ETList<IMessageData> eTList = iMessageData.getSubMessages();
            long l = 0L;
            if (eTList != null) {
                l = eTList.size();
            }
            if (l == 0L) {
                String string4 = DefaultCommonDialogResource.getString("IDS_ERROR_DIALOG_TITLE");
                string3 = iMessageData.getFormattedMessageString(false);
                this.display(string3, string4);
            }
        }
    }

    public boolean isRunSilent() {
        boolean bl = false;
        if (this.m_bRunSilent) {
            bl = true;
        }
        return bl;
    }

    public void setIsRunSilent(boolean bl) {
        this.m_bRunSilent = bl;
    }

    private JCenterDialog createDialog(String string, String string2, Icon icon) {
        JCenterDialog jCenterDialog = null;
        if (this.m_ParentFrame != null) {
            jCenterDialog = new JCenterDialog(this.m_ParentFrame, true);
        } else if (this.m_ParentDialog != null) {
            jCenterDialog = new JCenterDialog((Dialog)this.m_ParentDialog, true);
        }
        if (jCenterDialog != null) {
            if (string2 == null || string2.length() == 0) {
                string2 = DefaultCommonDialogResource.getString("IDS_ERROR");
            }
            jCenterDialog.setTitle(string2);
            try {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                JFixedSizeTextArea jFixedSizeTextArea = new JFixedSizeTextArea(string);
                jFixedSizeTextArea.setOpaque(false);
                jFixedSizeTextArea.setEditable(false);
                jFixedSizeTextArea.setBackground(SystemColor.control);
                jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                jPanel.add((Component)jFixedSizeTextArea, "Center");
                if (icon != null) {
                    jPanel.add((Component)new JLabel(icon), "West");
                    jFixedSizeTextArea.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                }
                jCenterDialog.getContentPane().add(jPanel);
                JPanel jPanel2 = new JPanel();
                jCenterDialog.getContentPane().add((Component)jPanel2, "South");
                QuestionResponse questionResponse = new QuestionResponse();
                UserResultListener userResultListener = new UserResultListener(questionResponse, jCenterDialog);
                JButton jButton = new JButton(DefaultCommonDialogResource.getString("IDS_OK"));
                jButton.setActionCommand("OK");
                jButton.addActionListener(userResultListener);
                jButton.setSize(100, 20);
                jPanel2.add(jButton);
                jCenterDialog.getRootPane().setDefaultButton(jButton);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return jCenterDialog;
    }

    protected Icon getIconForType(int n) {
        Icon icon = null;
        if (n >= 0 || n <= 7) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    icon = UIManager.getIcon("OptionPane.errorIcon");
                    break;
                }
                case 0: {
                    icon = UIManager.getIcon("OptionPane.informationIcon");
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    icon = UIManager.getIcon("OptionPane.warningIcon");
                    break;
                }
                case 4: {
                    icon = UIManager.getIcon("OptionPane.questionIcon");
                }
            }
        }
        return icon;
    }
}

