/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support.projecttreesupport;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IConfigManager;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamespace;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociation;
import org.netbeans.modules.uml.core.support.Debug;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyDefinition;
import org.netbeans.modules.uml.core.support.umlutils.IPropertyDefinitionFactory;
import org.netbeans.modules.uml.core.support.umlutils.PropertyDefinitionFactory;
import org.netbeans.modules.uml.core.workspacemanagement.IWSProject;
import org.netbeans.modules.uml.core.workspacemanagement.IWorkspace;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeItem;
import org.netbeans.modules.uml.ui.controls.projecttree.ProjectTreeNodeFactory;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.diagramsupport.ProxyDiagramManager;
import org.netbeans.modules.uml.ui.support.projecttreesupport.IProjectTreeBuilder;
import org.netbeans.modules.uml.ui.support.projecttreesupport.IProjectTreeBuilderFilter;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeDiagram;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeElement;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeFolder;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeItem;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeRelElement;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeWSProject;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ITreeWorkspace;
import org.netbeans.modules.uml.ui.support.projecttreesupport.ProjectTreeComparable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectTreeBuilderImpl
implements IProjectTreeBuilder {
    private static final Logger logger = Logger.getLogger("uml.ui.support.projecttreesupport.ProjectTreeBuilderImpl");
    private HashMap<String, Integer> m_SortMap = new HashMap();
    private IPropertyDefinitionFactory m_DefFactory = null;
    private ProjectTreeNodeFactory m_NodeFactory = null;
    private IProjectTreeBuilderFilter m_TreeFilter = null;
    private static String DEPENDENCIES_GROUP = "Abstraction,Usage,Permission,Delegate,RoleBinding,Derivation,Dependency";

    public ProjectTreeBuilderImpl(ProjectTreeNodeFactory projectTreeNodeFactory) {
        this.buildSortMap();
        this.setNodeFactory(projectTreeNodeFactory);
    }

    @Override
    public ITreeItem[] retrieveChildItems(Object object) {
        ITreeItem[] iTreeItemArray = null;
        if (object instanceof IElement) {
            iTreeItemArray = this.retrieveChildItemsForElement(object, (IElement)object);
        } else if (object instanceof ITreeFolder) {
            ITreeFolder iTreeFolder = (ITreeFolder)object;
            iTreeItemArray = this.retrieveChildItemsForFolder(iTreeFolder);
        } else if (!(object instanceof ITreeRelElement)) {
            if (object instanceof ITreeElement) {
                ITreeElement iTreeElement = (ITreeElement)object;
                iTreeItemArray = this.retrieveChildItemsForElement(object, iTreeElement.getElement());
            } else if (object instanceof IWorkspace) {
                iTreeItemArray = this.retrieveChildItemsForWorkspace((IWorkspace)object);
            } else if (object instanceof ITreeWorkspace) {
                ITreeWorkspace iTreeWorkspace = (ITreeWorkspace)object;
                iTreeItemArray = this.retrieveChildItemsForWorkspace(iTreeWorkspace.getWorkspace());
            } else if (object instanceof ITreeWSProject) {
                ITreeWSProject iTreeWSProject = (ITreeWSProject)object;
                iTreeItemArray = this.retrieveChildItemsForElement(object, iTreeWSProject.getRelatedProject());
            }
        }
        return iTreeItemArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITreeItem[] retrieveChildItemsForElement(Object object, IElement iElement) {
        ArrayList<ITreeItem> arrayList = new ArrayList<ITreeItem>();
        ITreeItem[] iTreeItemArray = null;
        try {
            this.retrieveDiagramsForElement(object, iElement, arrayList);
            this.buildChildItemsForElementBasedOnDefinitions(object, iElement, arrayList);
            this.removeCommonItems(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            iTreeItemArray = new ITreeItem[arrayList.size()];
            arrayList.toArray(iTreeItemArray);
        }
        return iTreeItemArray;
    }

    @Override
    public ITreeItem[] retrieveChildItemsForFolder(ITreeFolder iTreeFolder) {
        ITreeItem[] iTreeItemArray = null;
        if (iTreeFolder != null && iTreeFolder.getElement() != null) {
            if (iTreeFolder.getGetMethod() != null && iTreeFolder.getGetMethod().length() > 0) {
                Object object = this.executeGetMethod(iTreeFolder.getElement(), iTreeFolder.getID(), iTreeFolder.getGetMethod());
                iTreeItemArray = this.buildFolderChildrenFromObject(object, iTreeFolder);
            } else {
                IPropertyDefinition iPropertyDefinition;
                IElement iElement = iTreeFolder.getElement();
                IPropertyDefinition iPropertyDefinition2 = this.getDefinition(iElement);
                Debug.assertNotNull(iPropertyDefinition2, "Unable to locate the property definition for " + iTreeFolder.getName());
                if (iPropertyDefinition2 != null && (iPropertyDefinition = iPropertyDefinition2.getSubDefinition(iTreeFolder.getName())) != null) {
                    ArrayList<ITreeItem> arrayList = new ArrayList<ITreeItem>();
                    this.buildChildItemsForElementBasedOnDefinitions(null, iPropertyDefinition, iElement, arrayList);
                    iTreeItemArray = new ITreeItem[arrayList.size()];
                    for (int i = 0; i < arrayList.size(); ++i) {
                        ITreeItem iTreeItem = arrayList.get(i);
                        if (iTreeItem == null) continue;
                        iTreeItem.setParentItem(iTreeFolder);
                        iTreeItemArray[i] = iTreeItem;
                    }
                }
            }
        }
        return iTreeItemArray;
    }

    @Override
    public ITreeItem[] getItems(Object object) {
        return null;
    }

    @Override
    public String[] getFolders(Object object) {
        return null;
    }

    @Override
    public ITreeItem[] retrieveChildItemsForWorkspace(IWorkspace iWorkspace) {
        ITreeItem[] iTreeItemArray = null;
        try {
            if (iWorkspace != null) {
                ETList<IWSProject> eTList = iWorkspace.getWSProjects();
                int n = eTList.size();
                iTreeItemArray = new ITreeItem[n];
                for (int i = 0; i < n; ++i) {
                    iTreeItemArray[i] = this.createChildTreeProject(null, (IWSProject)eTList.get(i));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return iTreeItemArray;
    }

    @Override
    public ITreeItem createChild(ITreeItem iTreeItem, Object object) {
        ITreeItem iTreeItem2 = null;
        if (object != null) {
            if (object instanceof IElement) {
                iTreeItem2 = this.createChildTreeElement(iTreeItem, (IElement)object);
            } else if (object instanceof IProxyDiagram) {
                iTreeItem2 = this.createChildTreeDiagram(iTreeItem, (IProxyDiagram)object);
            } else if (object instanceof IWorkspace) {
                iTreeItem2 = this.createChildTreeWorkspace(iTreeItem, (IWorkspace)object);
            } else if (object instanceof IWSProject) {
                iTreeItem2 = this.createChildTreeProject(iTreeItem, (IWSProject)object);
            }
        }
        return iTreeItem2;
    }

    @Override
    public ITreeItem[] sort(Object object, ITreeItem[] iTreeItemArray) {
        ITreeItem[] iTreeItemArray2 = null;
        if (iTreeItemArray != null) {
            iTreeItemArray2 = new ITreeItem[iTreeItemArray.length];
            for (int i = 0; i < iTreeItemArray.length; ++i) {
                iTreeItemArray2[i] = iTreeItemArray[i];
            }
            ProjectTreeComparable projectTreeComparable = new ProjectTreeComparable();
            Arrays.sort(iTreeItemArray2, projectTreeComparable);
        }
        return iTreeItemArray2;
    }

    @Override
    public ITreeItem[] retrieveChildItemsSorted(Object object) {
        ITreeItem[] iTreeItemArray = this.retrieveChildItems(object);
        return this.sort(object, iTreeItemArray);
    }

    @Override
    public long getSortPriority(String string) {
        long l = 0L;
        if (this.m_SortMap.containsKey(string)) {
            Integer n = this.m_SortMap.get(string);
            l = n.longValue();
        }
        return l;
    }

    @Override
    public void getInfoForRefresh(IElement iElement, ETList<String> eTList, ETList<ITreeItem> eTList2) {
        if (eTList != null && eTList2 != null && iElement != null) {
            this.getPathsWhereElementTypeLives(iElement, eTList);
            if (eTList.size() > 0) {
                ArrayList<ITreeItem> arrayList = new ArrayList<ITreeItem>();
                this.buildChildItemsForElementBasedOnDefinitions(null, iElement, arrayList);
                eTList2.addAll(arrayList);
            }
        }
    }

    protected void getPathsWhereElementTypeLives(IElement iElement, ETList<String> eTList) {
        String string = null;
        if (eTList != null && iElement != null) {
            try {
                String string2 = iElement.getElementType();
                if (string2.length() > 0) {
                    IPropertyDefinitionFactory iPropertyDefinitionFactory = this.getFactory();
                    Document document = iPropertyDefinitionFactory.getXMLDocument();
                    string = DEPENDENCIES_GROUP.indexOf(string2) >= 0 ? "//*[@type='" + DEPENDENCIES_GROUP + "']" : "//*[@type='" + string2 + "']";
                    List list = document.selectNodes(string);
                    for (Node node : list) {
                        if (!(node instanceof Element)) continue;
                        eTList.add(this.getNodePath(node));
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    protected String getNodePath(Node node) {
        String string = "";
        if (node instanceof Element) {
            Element element = (Element)node;
            String string2 = element.attributeValue("name");
            if (node.getParent() != null) {
                string = this.getNodePath((Node)node.getParent());
                if (string.length() > 0) {
                    string = string + "|";
                }
                string = string + string2;
            }
        }
        return string;
    }

    protected void buildSortMap() {
        int n = 1;
        this.m_SortMap.put("Diagram", new Integer(n++));
        this.m_SortMap.put("ActivityDiagram", new Integer(n++));
        this.m_SortMap.put("ClassDiagram", new Integer(n++));
        this.m_SortMap.put("CollaborationDiagram", new Integer(n++));
        this.m_SortMap.put("ComponentDiagram", new Integer(n++));
        this.m_SortMap.put("DeploymentDiagram", new Integer(n++));
        this.m_SortMap.put("ImplementationDiagram", new Integer(n++));
        this.m_SortMap.put("RobustnessDiagram", new Integer(n++));
        this.m_SortMap.put("SequenceDiagram", new Integer(n++));
        this.m_SortMap.put("StateDiagram", new Integer(n++));
        this.m_SortMap.put("SummaryDiagram", new Integer(n++));
        this.m_SortMap.put("UseCaseDiagram", new Integer(n++));
        this.m_SortMap.put("Attributes", new Integer(n));
        this.m_SortMap.put("Attribute", new Integer(n++));
        this.m_SortMap.put("Operations", new Integer(n));
        this.m_SortMap.put("Operation", new Integer(n++));
        this.m_SortMap.put("EnumerationLiterals", new Integer(n++));
        this.m_SortMap.put("ActivityPartitions", new Integer(n++));
        this.m_SortMap.put("Activity", new Integer(n++));
        this.m_SortMap.put("Interaction", new Integer(n++));
        this.m_SortMap.put("StateMachine", new Integer(n++));
        this.m_SortMap.put("Package", new Integer(n++));
        this.m_SortMap.put("Class", new Integer(n++));
        this.m_SortMap.put("Interface", new Integer(n++));
        this.m_SortMap.put("AliasedType", new Integer(n++));
        this.m_SortMap.put("DataType", new Integer(n++));
        this.m_SortMap.put("Actor", new Integer(n++));
        this.m_SortMap.put("UseCase", new Integer(n++));
        this.m_SortMap.put("CombinedFragment", new Integer(n++));
        this.m_SortMap.put("Lifeline", new Integer(n++));
        this.m_SortMap.put("Message", new Integer(n++));
        this.m_SortMap.put("AbortedFinalState", new Integer(n++));
        this.m_SortMap.put("Abstraction", new Integer(n++));
        this.m_SortMap.put("ActionSequence", new Integer(n++));
        this.m_SortMap.put("ActivityFinalNode", new Integer(n++));
        this.m_SortMap.put("ActivityInvocation", new Integer(n++));
        this.m_SortMap.put("ActivityPartition", new Integer(n++));
        this.m_SortMap.put("Aggregation", new Integer(n++));
        this.m_SortMap.put("Argument", new Integer(n++));
        this.m_SortMap.put("Artifact", new Integer(n++));
        this.m_SortMap.put("AssemblyConnector", new Integer(n++));
        this.m_SortMap.put("AssignmentAction", new Integer(n++));
        this.m_SortMap.put("Association", new Integer(n++));
        this.m_SortMap.put("AssociationClass", new Integer(n++));
        this.m_SortMap.put("AssociationEnd", new Integer(n++));
        this.m_SortMap.put("AtomicFragment", new Integer(n++));
        this.m_SortMap.put("CallAction", new Integer(n++));
        this.m_SortMap.put("CallEvent", new Integer(n++));
        this.m_SortMap.put("ChangeEvent", new Integer(n++));
        this.m_SortMap.put("ChangeSignal", new Integer(n++));
        this.m_SortMap.put("Collaboration", new Integer(n++));
        this.m_SortMap.put("CollaborationOccurrence", new Integer(n++));
        this.m_SortMap.put("Comment", new Integer(n++));
        this.m_SortMap.put("ComplexActivityGroup", new Integer(n++));
        this.m_SortMap.put("Component", new Integer(n++));
        this.m_SortMap.put("CompositeState", new Integer(n++));
        this.m_SortMap.put("Connector", new Integer(n++));
        this.m_SortMap.put("ConnectorEnd", new Integer(n++));
        this.m_SortMap.put("Constraint", new Integer(n++));
        this.m_SortMap.put("Container", new Integer(n++));
        this.m_SortMap.put("ControlFlow", new Integer(n++));
        this.m_SortMap.put("CreateAction", new Integer(n++));
        this.m_SortMap.put("DecisionNode", new Integer(n++));
        this.m_SortMap.put("DecisionMergeNode", new Integer(n++));
        this.m_SortMap.put("DataStoreNode", new Integer(n++));
        this.m_SortMap.put("Delegation", new Integer(n++));
        this.m_SortMap.put("DelegationConnector", new Integer(n++));
        this.m_SortMap.put("Dependency", new Integer(n++));
        this.m_SortMap.put("Deployment", new Integer(n++));
        this.m_SortMap.put("DeploymentSpecification", new Integer(n++));
        this.m_SortMap.put("Derivation", new Integer(n++));
        this.m_SortMap.put("DerivationClassifier", new Integer(n++));
        this.m_SortMap.put("DestroyAction", new Integer(n++));
        this.m_SortMap.put("Enumeration", new Integer(n++));
        this.m_SortMap.put("EnumerationLiteral", new Integer(n++));
        this.m_SortMap.put("Exception", new Integer(n++));
        this.m_SortMap.put("Expression", new Integer(n++));
        this.m_SortMap.put("Extend", new Integer(n++));
        this.m_SortMap.put("ExtensionPoint", new Integer(n++));
        this.m_SortMap.put("FinalState", new Integer(n++));
        this.m_SortMap.put("Flow", new Integer(n++));
        this.m_SortMap.put("FlowFinalNode", new Integer(n++));
        this.m_SortMap.put("ForkNode", new Integer(n++));
        this.m_SortMap.put("Gate", new Integer(n++));
        this.m_SortMap.put("Generalization", new Integer(n++));
        this.m_SortMap.put("Implementation", new Integer(n++));
        this.m_SortMap.put("Include", new Integer(n++));
        this.m_SortMap.put("Increment", new Integer(n++));
        this.m_SortMap.put("InitialNode", new Integer(n++));
        this.m_SortMap.put("InitialState", new Integer(n++));
        this.m_SortMap.put("InteractionConstraint", new Integer(n++));
        this.m_SortMap.put("InteractionOccurrence", new Integer(n++));
        this.m_SortMap.put("InteractionOperand", new Integer(n++));
        this.m_SortMap.put("InterGateConnector", new Integer(n++));
        this.m_SortMap.put("InterLifelineConnector", new Integer(n++));
        this.m_SortMap.put("InterruptibleActivityRegion", new Integer(n++));
        this.m_SortMap.put("InvocationNode", new Integer(n++));
        this.m_SortMap.put("ImportedElements", new Integer(n++));
        this.m_SortMap.put("ImportedPackages", new Integer(n++));
        this.m_SortMap.put("JoinNode", new Integer(n++));
        this.m_SortMap.put("JoinState", new Integer(n++));
        this.m_SortMap.put("MergeNode", new Integer(n++));
        this.m_SortMap.put("Model", new Integer(n++));
        this.m_SortMap.put("MultiFlow", new Integer(n++));
        this.m_SortMap.put("Multiplicity", new Integer(n++));
        this.m_SortMap.put("MultiplicityRange", new Integer(n++));
        this.m_SortMap.put("NavigableEnd", new Integer(n++));
        this.m_SortMap.put("Node", new Integer(n++));
        this.m_SortMap.put("ObjectFlow", new Integer(n++));
        this.m_SortMap.put("ObjectNode", new Integer(n++));
        this.m_SortMap.put("Parameter", new Integer(n++));
        this.m_SortMap.put("ParameterUsageNode", new Integer(n++));
        this.m_SortMap.put("Part", new Integer(n++));
        this.m_SortMap.put("PartDecomposition", new Integer(n++));
        this.m_SortMap.put("PartFacade", new Integer(n++));
        this.m_SortMap.put("Permission", new Integer(n++));
        this.m_SortMap.put("Port", new Integer(n++));
        this.m_SortMap.put("Ports", new Integer(n++));
        this.m_SortMap.put("PrimitiveType", new Integer(n++));
        this.m_SortMap.put("Procedure", new Integer(n++));
        this.m_SortMap.put("Profile", new Integer(n++));
        this.m_SortMap.put("ProtocolConformance", new Integer(n++));
        this.m_SortMap.put("ProtocolTransition", new Integer(n++));
        this.m_SortMap.put("PseudoState", new Integer(n++));
        this.m_SortMap.put("Realization", new Integer(n++));
        this.m_SortMap.put("Reception", new Integer(n++));
        this.m_SortMap.put("Region", new Integer(n++));
        this.m_SortMap.put("Regions", new Integer(n++));
        this.m_SortMap.put("ReturnAction", new Integer(n++));
        this.m_SortMap.put("RoleBinding", new Integer(n++));
        this.m_SortMap.put("SendAction", new Integer(n++));
        this.m_SortMap.put("Signal", new Integer(n++));
        this.m_SortMap.put("SignalNode", new Integer(n++));
        this.m_SortMap.put("SignalEvent", new Integer(n++));
        this.m_SortMap.put("SimpleState", new Integer(n++));
        this.m_SortMap.put("SourceFileArtifact", new Integer(n++));
        this.m_SortMap.put("State", new Integer(n++));
        this.m_SortMap.put("StateGroup", new Integer(n++));
        this.m_SortMap.put("Stereotype", new Integer(n++));
        this.m_SortMap.put("SubmachineState", new Integer(n++));
        this.m_SortMap.put("Subsystem", new Integer(n++));
        this.m_SortMap.put("TaggedValue", new Integer(n++));
        this.m_SortMap.put("TemplateArgument", new Integer(n++));
        this.m_SortMap.put("TemplateBinding", new Integer(n++));
        this.m_SortMap.put("TemplateParameter", new Integer(n++));
        this.m_SortMap.put("TerminateAction", new Integer(n++));
        this.m_SortMap.put("TimeEvent", new Integer(n++));
        this.m_SortMap.put("TimeSignal", new Integer(n++));
        this.m_SortMap.put("Transition", new Integer(n++));
        this.m_SortMap.put("UMLConnectionPoint", new Integer(n++));
        this.m_SortMap.put("UninterpretedAction", new Integer(n++));
        this.m_SortMap.put("Usage", new Integer(n++));
        this.m_SortMap.put("Delegate", new Integer(n++));
        this.m_SortMap.put("UseCaseDetail", new Integer(n++));
        this.m_SortMap.put("UseCaseDetails", new Integer(n++));
        this.m_SortMap.put("JoinForkNode", new Integer(n++));
        this.m_SortMap.put("Messages", new Integer(n++));
        this.m_SortMap.put("Relationships", new Integer(n++));
    }

    protected void removeCommonItems(ArrayList<ITreeItem> arrayList) {
        if (arrayList.size() > 0) {
            ITreeItem iTreeItem = arrayList.get(0);
            ITreeItem iTreeItem2 = iTreeItem.getParentItem();
            while (iTreeItem2 != null) {
                IProjectTreeItem iProjectTreeItem = iTreeItem2.getData();
                if (iTreeItem2 instanceof ITreeElement) {
                    IAssociation iAssociation;
                    IElement iElement = iProjectTreeItem.getModelElement();
                    boolean bl = true;
                    if (iElement instanceof IAssociation && (iAssociation = (IAssociation)iElement).getIsReflexive()) {
                        bl = false;
                        iTreeItem2 = null;
                    }
                    if (bl && arrayList.contains(iTreeItem2)) {
                        arrayList.remove(iTreeItem2);
                    }
                }
                if (iTreeItem2 == null) continue;
                iTreeItem2 = iTreeItem2.getParentItem();
            }
        }
    }

    protected void buildChildItemsForElementBasedOnDefinitions(Object object, IElement iElement, ArrayList<ITreeItem> arrayList) {
        IPropertyDefinition iPropertyDefinition = this.getDefinition(iElement);
        if (iPropertyDefinition != null) {
            this.buildChildItemsForElementBasedOnDefinitions(object, iPropertyDefinition, iElement, arrayList);
        }
    }

    private void buildChildItemsForElementBasedOnDefinitions(Object object, IPropertyDefinition iPropertyDefinition, IElement iElement, ArrayList<ITreeItem> arrayList) {
        Vector vector = iPropertyDefinition.getSubDefinitions();
        if (vector != null) {
            if (iElement instanceof INamespace) {
                this.addNamespaceElements(object, iPropertyDefinition, (INamespace)iElement, arrayList);
            }
            this.buildSubElementsForSubDefinition(object, iElement, vector, arrayList);
        }
    }

    private void buildSubElementsForSubDefinition(Object object, IElement iElement, Vector vector, ArrayList<ITreeItem> arrayList) {
        for (IPropertyDefinition iPropertyDefinition : vector) {
            if (iPropertyDefinition.getName().equals("Exclude")) continue;
            if (!this.isHidden(iPropertyDefinition.getName())) {
                this.buildItem(object, iPropertyDefinition, iElement, arrayList);
                continue;
            }
            this.buildChildItemsForElementBasedOnDefinitions(object, iPropertyDefinition, iElement, arrayList);
        }
    }

    private void buildItem(Object object, IPropertyDefinition iPropertyDefinition, IElement iElement, List<ITreeItem> list) {
        if (iPropertyDefinition != null && iElement != null && list != null) {
            String string = iPropertyDefinition.getID();
            String string2 = iPropertyDefinition.getPath();
            if (iPropertyDefinition.getGetMethod() != null && iPropertyDefinition.getGetMethod().length() > 0) {
                Object object2 = this.executeGetMethod(iPropertyDefinition, iElement);
                if (object2 != null) {
                    if (object2 instanceof Collection) {
                        this.buildCollection(object, iPropertyDefinition, iElement, list, object2);
                    } else {
                        Method method = null;
                        try {
                            method = object2.getClass().getMethod("getCount", new Class[0]);
                        }
                        catch (SecurityException securityException) {
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        if (method != null) {
                            this.buildBindingCollection(method, object, object2, iPropertyDefinition, iElement, list);
                        } else {
                            this.buildObjectItem(object, iPropertyDefinition, object2, list);
                        }
                    }
                }
            } else {
                this.buildFolder(object, iPropertyDefinition, iElement, list);
            }
        }
    }

    protected void buildBindingCollection(Method method, Object object, Object object2, IPropertyDefinition iPropertyDefinition, IElement iElement, List<ITreeItem> list) {
        if (method != null) {
            try {
                int n;
                Object object3 = method.invoke(object2, new Object[0]);
                if (object3 != null && object3 instanceof Integer && (n = ((Integer)object3).intValue()) > 0 && this.getNodeFactory() != null) {
                    ITreeFolder iTreeFolder = this.getNodeFactory().createFolderNode();
                    iTreeFolder.setID(iPropertyDefinition.getID());
                    iTreeFolder.setName(iPropertyDefinition.getName());
                    iTreeFolder.setElement(iElement);
                    iTreeFolder.setDisplayName(iPropertyDefinition.getDisplayName());
                    iTreeFolder.setGetMethod(iPropertyDefinition.getGetMethod());
                    iTreeFolder.setSortPriority(this.getSortPriority(iPropertyDefinition.getName()));
                    iTreeFolder.setPathAsString(iPropertyDefinition.getPath());
                    this.setTreeItemParent(iTreeFolder, object);
                    String string = iPropertyDefinition.getFromAttrMap("minimum");
                    if (string != null && n >= Integer.parseInt(string)) {
                        list.add(iTreeFolder);
                    } else {
                        ITreeItem[] iTreeItemArray = this.retrieveChildItemsForFolder(iTreeFolder);
                        for (int i = 0; i < iTreeItemArray.length; ++i) {
                            list.add(iTreeItemArray[i]);
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    protected ITreeItem[] buildFolderChildrenFromObject(Object object, ITreeFolder iTreeFolder) {
        Object object2;
        ITreeItem[] iTreeItemArray = null;
        IElement iElement = iTreeFolder.getElement();
        IPropertyDefinition iPropertyDefinition = this.getDefinition(iElement);
        IPropertyDefinition iPropertyDefinition2 = null;
        if (iPropertyDefinition != null) {
            object2 = iTreeFolder.getName();
            iPropertyDefinition2 = iPropertyDefinition.getSubDefinition((String)object2);
        }
        try {
            object2 = null;
            if (object == null) {
                return iTreeItemArray;
            }
            if (object instanceof List) {
                Object var8_13 = null;
                List list = (List)object;
                int n = list.size();
                iTreeItemArray = new ITreeItem[n];
                for (int i = 0; i < n; ++i) {
                    var8_13 = list.get(i);
                    if (var8_13 == null || !(var8_13 instanceof IElement)) continue;
                    object2 = var8_13;
                    iTreeItemArray[i] = this.createChildTreeElement(iTreeFolder, (IElement)object2, iPropertyDefinition2);
                }
            } else {
                Object object3;
                Class<?> clazz = object.getClass();
                Method method = clazz.getMethod("getCount", new Class[0]);
                if (method != null && (object3 = method.invoke(object, new Object[0])) != null && object3 instanceof Integer) {
                    Class[] classArray = new Class[]{Integer.TYPE};
                    Method method2 = object.getClass().getMethod("item", classArray);
                    if (method2 != null) {
                        int n = (Integer)object3;
                        iTreeItemArray = new ITreeItem[n];
                        for (int i = 0; i < n; ++i) {
                            Object[] objectArray = new Object[]{new Integer(i)};
                            object2 = (IElement)method2.invoke(object, objectArray);
                            if (object2 == null) continue;
                            iTreeItemArray[i] = this.createChildTreeElement(iTreeFolder, (IElement)object2, iPropertyDefinition2);
                        }
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        return iTreeItemArray;
    }

    protected void buildFolder(Object object, IPropertyDefinition iPropertyDefinition, IElement iElement, List<ITreeItem> list) {
        String string = iPropertyDefinition.getFromAttrMap("show");
        if (string != null && string.toLowerCase().equals("true") && this.getNodeFactory() != null) {
            ITreeFolder iTreeFolder = this.getNodeFactory().createFolderNode();
            iTreeFolder.setID(iPropertyDefinition.getID());
            iTreeFolder.setName(iPropertyDefinition.getName());
            iTreeFolder.setElement(iElement);
            iTreeFolder.setDisplayName(iPropertyDefinition.getDisplayName(), false);
            iTreeFolder.setSortPriority(this.getSortPriority(iPropertyDefinition.getName()));
            iTreeFolder.setPathAsString(iPropertyDefinition.getPath());
            this.setTreeItemParent(iTreeFolder, object);
            ITreeItem[] iTreeItemArray = this.retrieveChildItemsForFolder(iTreeFolder);
            if (iTreeItemArray != null && iTreeItemArray.length > 0) {
                list.add(iTreeFolder);
            }
        }
    }

    protected void buildObjectItem(Object object, IPropertyDefinition iPropertyDefinition, Object object2, List<ITreeItem> list) {
        if (this.getNodeFactory() != null) {
            ITreeRelElement iTreeRelElement = this.getNodeFactory().createRelationshipNode();
            if (object2 instanceof IElement) {
                IElement iElement = (IElement)object2;
                String string = "";
                if (object2 instanceof INamedElement) {
                    INamedElement iNamedElement = (INamedElement)object2;
                    string = iNamedElement.getNameWithAlias();
                }
                if (string.length() <= 0) {
                    string = iElement.getElementType();
                }
                iTreeRelElement.setName(string);
                iTreeRelElement.setElement(iElement);
                iTreeRelElement.setPathAsString(iPropertyDefinition.getPath());
                iTreeRelElement.setSortPriority(this.getSortPriority(iElement.getElementType()));
                this.setTreeItemParent(iTreeRelElement, object);
                list.add(iTreeRelElement);
            }
        }
    }

    protected void buildCollection(Object object, IPropertyDefinition iPropertyDefinition, IElement iElement, List<ITreeItem> list, Object object2) {
        Collection collection = (Collection)object2;
        if (collection.size() > 0 && this.getNodeFactory() != null) {
            ITreeFolder iTreeFolder = this.getNodeFactory().createFolderNode();
            iTreeFolder.setID(iPropertyDefinition.getID());
            iTreeFolder.setName(iPropertyDefinition.getName());
            iTreeFolder.setElement(iElement);
            iTreeFolder.setDisplayName(iPropertyDefinition.getDisplayName());
            iTreeFolder.setGetMethod(iPropertyDefinition.getGetMethod());
            iTreeFolder.setSortPriority(this.getSortPriority(iPropertyDefinition.getName()));
            iTreeFolder.setPathAsString(iPropertyDefinition.getPath());
            this.setTreeItemParent(iTreeFolder, object);
            String string = iPropertyDefinition.getFromAttrMap("minimum");
            int n = -1;
            if (string != null) {
                n = Integer.parseInt(string);
            }
            if (collection.size() >= n) {
                list.add(iTreeFolder);
            } else {
                ITreeItem[] iTreeItemArray = this.retrieveChildItemsForFolder(iTreeFolder);
                for (int i = 0; i < iTreeItemArray.length; ++i) {
                    list.add(iTreeItemArray[i]);
                }
            }
        }
    }

    private void setTreeItemParent(ITreeItem iTreeItem, Object object) {
        if (iTreeItem != null && object != null && object instanceof ITreeItem) {
            ITreeItem iTreeItem2 = (ITreeItem)object;
            iTreeItem.setParentItem(iTreeItem2);
        }
    }

    protected Object executeGetMethod(IElement iElement, String string, String string2) {
        Object object = null;
        IElement iElement2 = iElement;
        Class<?> clazz = iElement2.getClass();
        try {
            Method method = clazz.getMethod(string2, new Class[0]);
            object = method.invoke((Object)iElement2, new Object[0]);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return object;
    }

    protected Object executeGetMethod(IPropertyDefinition iPropertyDefinition, IElement iElement) {
        return this.executeGetMethod(iElement, iPropertyDefinition.getID(), iPropertyDefinition.getGetMethod());
    }

    protected boolean isHidden(String string) {
        boolean bl = false;
        if (this.m_TreeFilter != null && string != null && string.length() > 0) {
            bl = this.m_TreeFilter.isHidden(string);
        }
        return bl;
    }

    protected void addNamespaceElements(Object object, IPropertyDefinition iPropertyDefinition, INamespace iNamespace, List<ITreeItem> list) {
        ETList<INamedElement> eTList;
        IPropertyDefinition iPropertyDefinition2 = iPropertyDefinition.getSubDefinition("Exclude");
        if (iPropertyDefinition2 != null && (eTList = iNamespace.getOwnedElements()) != null) {
            long l = eTList.size();
            int n = 0;
            while ((long)n < l) {
                IElement iElement = (IElement)eTList.get(n);
                if (iElement != null && !this.isExcluded(iElement, iPropertyDefinition2)) {
                    ITreeItem iTreeItem = this.createChildTreeElement(object, iElement, iPropertyDefinition);
                    list.add(iTreeItem);
                }
                ++n;
            }
        }
    }

    private ITreeItem createChildTreeElement(Object object, IElement iElement) {
        return this.createChildTreeElement(object, iElement, null);
    }

    private ITreeItem createChildTreeElement(Object object, IElement iElement, IPropertyDefinition iPropertyDefinition) {
        ITreeElement iTreeElement = null;
        if (iElement != null) {
            String string = "";
            if (iPropertyDefinition != null) {
                string = iPropertyDefinition.getName();
            }
            if (string.equals("Participants")) {
                if (this.getNodeFactory() != null) {
                    ITreeRelElement iTreeRelElement = this.getNodeFactory().createRelationshipNode();
                    this.fillTreeElement(object, iElement, iPropertyDefinition, iTreeRelElement);
                    iTreeElement = iTreeRelElement;
                }
            } else if (this.getNodeFactory() != null) {
                ITreeElement iTreeElement2 = this.getNodeFactory().createElementNode();
                this.fillTreeElement(object, iElement, iPropertyDefinition, iTreeElement2);
                iTreeElement = iTreeElement2;
            }
        }
        return iTreeElement;
    }

    private void fillTreeElement(Object object, IElement iElement, IPropertyDefinition iPropertyDefinition, ITreeElement iTreeElement) {
        Object object2;
        Object object3;
        String string = iElement.getElementType();
        String string2 = "";
        String string3 = "";
        if (iPropertyDefinition != null && iPropertyDefinition.getValidValues() != null && ((String)(object3 = iPropertyDefinition.getValidValues())).equals("FormatString") && (object2 = ProductHelper.getDataFormatter()) != null) {
            string2 = object2.formatElement(iElement);
        }
        if ((string2 == null || string2.length() <= 0) && iElement instanceof INamedElement) {
            string2 = ((INamedElement)iElement).getNameWithAlias();
        }
        if (string2 == null || string2.length() <= 0) {
            string2 = string;
            iTreeElement.setTranslateName(true);
        }
        iTreeElement.setName(string2);
        iTreeElement.setElement(iElement);
        iTreeElement.setSortPriority(this.getSortPriority(string));
        if (object instanceof ITreeItem) {
            object3 = (ITreeItem)object;
            object2 = object3.getPathAsString();
            if (object2 != null && ((String)object2).length() > 0) {
                object2 = (String)object2 + "|";
            }
            object2 = (String)object2 + string;
            iTreeElement.setPathAsString((String)object2);
        } else {
            iTreeElement.setPathAsString(string);
        }
        this.setTreeItemParent(iTreeElement, object);
    }

    @Override
    public boolean isExcluded(IElement iElement) {
        IPropertyDefinition iPropertyDefinition;
        boolean bl = false;
        IElement iElement2 = iElement.getOwner();
        if (iElement2 != null && (iPropertyDefinition = this.getDefinition(iElement2)) != null) {
            IPropertyDefinition iPropertyDefinition2 = iPropertyDefinition.getSubDefinition("Exclude");
            bl = this.isExcluded(iElement, iPropertyDefinition2);
        }
        return bl;
    }

    private boolean isExcluded(IElement iElement, IPropertyDefinition iPropertyDefinition) {
        boolean bl = false;
        try {
            String string;
            if (iPropertyDefinition.getSubDefinitions().size() > 0 && iPropertyDefinition.getSubDefinition(string = iElement.getElementType()) != null) {
                bl = true;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return bl;
    }

    public void retrieveDiagramsForElement(Object object, IElement iElement, ArrayList<ITreeItem> arrayList) {
        if (iElement instanceof INamespace) {
            ETList<IProxyDiagram> eTList;
            INamespace iNamespace = (INamespace)iElement;
            ProxyDiagramManager proxyDiagramManager = ProxyDiagramManager.instance();
            if (proxyDiagramManager != null && (eTList = proxyDiagramManager.getDiagramsInNamespace(iNamespace)) != null && eTList != null) {
                String string = null;
                for (int i = 0; i < eTList.size(); ++i) {
                    if (this.getNodeFactory() == null) continue;
                    string = ((IProxyDiagram)eTList.get(i)).getNameWithAlias();
                    logger.fine("*** retrieveDiagramsForElement: diagramNameWithAlias = " + string);
                    ITreeDiagram iTreeDiagram = this.getNodeFactory().createDiagramNode((IProxyDiagram)eTList.get(i));
                    iTreeDiagram.setDisplayedName(string);
                    iTreeDiagram.setName(string);
                    iTreeDiagram.setSortPriority(this.getSortPriority(((IProxyDiagram)eTList.get(i)).getDiagramKindName()));
                    this.setTreeItemParent(iTreeDiagram, object);
                    arrayList.add(iTreeDiagram);
                }
            }
        }
    }

    protected IPropertyDefinitionFactory getFactory() {
        if (this.m_DefFactory == null) {
            String string = this.getDefinitionFile();
            this.m_DefFactory = new PropertyDefinitionFactory();
            this.m_DefFactory.setDefinitionFile(string);
            this.m_DefFactory.buildDefinitionsUsingFile();
        }
        return this.m_DefFactory;
    }

    protected String getDefinitionFile() {
        String string = "";
        IConfigManager iConfigManager = ProductHelper.getConfigManager();
        if (iConfigManager != null) {
            StringBuffer stringBuffer = new StringBuffer(iConfigManager.getDefaultConfigLocation());
            stringBuffer.append("ProjectTreeDefinitions.etc");
            string = stringBuffer.toString();
        }
        return string;
    }

    protected IPropertyDefinition getDefinition(IElement iElement) {
        IPropertyDefinition iPropertyDefinition = null;
        if (iElement != null) {
            iPropertyDefinition = this.getDefinition(iElement.getElementType());
        }
        return iPropertyDefinition;
    }

    protected IPropertyDefinition getDefinition(String string) {
        String string2;
        IPropertyDefinition iPropertyDefinition;
        StringTokenizer stringTokenizer;
        IPropertyDefinition iPropertyDefinition2 = null;
        IPropertyDefinitionFactory iPropertyDefinitionFactory = this.getFactory();
        if (iPropertyDefinitionFactory != null && (stringTokenizer = new StringTokenizer(string, "|")).hasMoreTokens() && (iPropertyDefinition = iPropertyDefinitionFactory.getPropertyDefinitionForElement(string2 = stringTokenizer.nextToken(), null)) != null) {
            IPropertyDefinition iPropertyDefinition3 = iPropertyDefinition;
            while (stringTokenizer.hasMoreTokens()) {
                IPropertyDefinition iPropertyDefinition4;
                iPropertyDefinition3 = iPropertyDefinition4 = iPropertyDefinition3.getSubDefinition(stringTokenizer.nextToken());
            }
            if (iPropertyDefinition3 != null) {
                iPropertyDefinition2 = iPropertyDefinition3;
            }
        }
        return iPropertyDefinition2;
    }

    private ITreeItem createChildTreeProject(ITreeItem iTreeItem, IWSProject iWSProject) {
        String string;
        ITreeItem iTreeItem2 = null;
        if (iWSProject != null && (string = iWSProject.getName()).length() > 0 && this.getNodeFactory() != null) {
            ITreeItem iTreeItem3 = this.getNodeFactory().createProjectNode();
            iTreeItem3.setName(string);
            iTreeItem3.getData().setDescription("Workspace Project");
            if (iTreeItem != null) {
                this.setTreeItemParent(iTreeItem3, iTreeItem);
            }
            iTreeItem2 = iTreeItem3;
        }
        return iTreeItem2;
    }

    private ITreeItem createChildTreeWorkspace(ITreeItem iTreeItem, IWorkspace iWorkspace) {
        String string;
        ITreeWorkspace iTreeWorkspace = null;
        if (iWorkspace != null && (string = iWorkspace.getName()) != null && string.length() > 0 && this.getNodeFactory() != null) {
            ITreeWorkspace iTreeWorkspace2 = this.getNodeFactory().createWorkspaceNode();
            iTreeWorkspace2.setName(string);
            iTreeWorkspace2.setWorkspace(iWorkspace);
            if (iTreeItem != null) {
                this.setTreeItemParent(iTreeWorkspace2, iTreeItem);
            }
            iTreeWorkspace = iTreeWorkspace2;
        }
        return iTreeWorkspace;
    }

    private ITreeItem createChildTreeDiagram(ITreeItem iTreeItem, IProxyDiagram iProxyDiagram) {
        ITreeItem iTreeItem2 = null;
        return iTreeItem2;
    }

    protected ProjectTreeNodeFactory getNodeFactory() {
        return this.m_NodeFactory;
    }

    @Override
    public void setNodeFactory(ProjectTreeNodeFactory projectTreeNodeFactory) {
        this.m_NodeFactory = projectTreeNodeFactory;
    }

    @Override
    public IProjectTreeBuilderFilter getProjectTreeBuilderFilter() {
        return this.m_TreeFilter;
    }

    @Override
    public void setProjectTreeBuilderFilter(IProjectTreeBuilderFilter iProjectTreeBuilderFilter) {
        this.m_TreeFilter = iProjectTreeBuilderFilter;
    }
}

