/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support.presentationnavigation;

import java.awt.datatransfer.Transferable;
import org.netbeans.modules.uml.core.coreapplication.ICoreProduct;
import org.netbeans.modules.uml.core.coreapplication.ICoreProductInitEventsSink;
import org.netbeans.modules.uml.core.coreapplication.INavigator;
import org.netbeans.modules.uml.core.coreapplication.INavigatorFactory;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IDocumentationModifiedEventsSink;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElementLifeTimeEventsSink;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPresentationElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IVersionableElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.diagrams.IProxyDiagram;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAttribute;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IOperation;
import org.netbeans.modules.uml.core.metamodel.structure.IArtifact;
import org.netbeans.modules.uml.core.metamodel.structure.IArtifactEventsSink;
import org.netbeans.modules.uml.core.metamodel.structure.ISourceFileArtifact;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.core.support.umlutils.InvalidArguments;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeControl;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeDragVerify;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeEditVerify;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeEventsSink;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeExpandingContext;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeHandled;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeItem;
import org.netbeans.modules.uml.ui.products.ad.projecttreedefaultengine.FilteredItemManager;
import org.netbeans.modules.uml.ui.support.DispatchHelper;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProduct;
import org.netbeans.modules.uml.ui.support.presentationnavigation.ISourceNavigator;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.ICompartment;
import org.netbeans.modules.uml.ui.support.viewfactorysupport.IToolTipData;
import org.netbeans.modules.uml.ui.swing.drawingarea.ICompartmentEventsSink;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaControl;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaDropContext;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaEventsSink;
import org.netbeans.modules.uml.ui.swing.drawingarea.IDrawingAreaSelectionEventsSink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationController
implements IDrawingAreaSelectionEventsSink,
ICompartmentEventsSink,
ICoreProductInitEventsSink,
IDrawingAreaEventsSink,
IDocumentationModifiedEventsSink,
IArtifactEventsSink,
IElementLifeTimeEventsSink,
IProjectTreeEventsSink {
    private boolean m_SinksConnected = false;
    private INavigator m_Navigator = null;

    public NavigationController() {
        INavigatorFactory iNavigatorFactory;
        this.connectSinks();
        IProduct iProduct = ProductHelper.getProduct();
        if (iProduct != null && (iNavigatorFactory = iProduct.getNavigatorFactory()) != null) {
            this.m_Navigator = iNavigatorFactory.createNavigator("");
        }
    }

    private void connectSinks() {
        if (!this.m_SinksConnected) {
            DispatchHelper dispatchHelper = new DispatchHelper();
            dispatchHelper.registerForDocumentationModifiedEvents(this);
            dispatchHelper.registerDrawingAreaEvents(this);
            dispatchHelper.registerDrawingAreaSelectionEvents(this);
            dispatchHelper.registerDrawingAreaCompartmentEvents(this);
            dispatchHelper.registerForInitEvents(this);
            dispatchHelper.registerForArtifactEvents(this);
            dispatchHelper.registerForLifeTimeEvents(this);
            dispatchHelper.registerProjectTreeEvents(this);
            this.m_SinksConnected = true;
        }
    }

    private void disconnectSinks() {
        if (this.m_SinksConnected) {
            DispatchHelper dispatchHelper = new DispatchHelper();
            try {
                dispatchHelper.revokeDocumentationModifiedSink(this);
                dispatchHelper.revokeDrawingAreaSink(this);
                dispatchHelper.revokeDrawingAreaSelectionSink(this);
                dispatchHelper.revokeDrawingAreaCompartmentSink(this);
                dispatchHelper.revokeInitSink(this);
                dispatchHelper.revokeArtifactSink(this);
                dispatchHelper.revokeLifeTimeSink(this);
                dispatchHelper.revokeProjectTreeSink(this);
            }
            catch (InvalidArguments invalidArguments) {
                invalidArguments.printStackTrace();
            }
            this.m_SinksConnected = false;
        }
    }

    @Override
    public void onSelect(IDiagram iDiagram, ETList<IPresentationElement> eTList, ICompartment iCompartment, IResultCell iResultCell) {
        IPresentationElement iPresentationElement;
        IElement iElement;
        int n;
        if (eTList != null && (n = eTList.size()) == 1 && (iElement = (iPresentationElement = (IPresentationElement)eTList.get(0)).getFirstSubject()) != null) {
            this.onNavigateToElement(iElement);
        }
    }

    private void onNavigateToElement(IElement iElement) {
        if (iElement != null && this.m_Navigator != null) {
            this.m_Navigator.navigateToElement(iElement);
        }
    }

    @Override
    public void onUnselect(IDiagram iDiagram, IPresentationElement[] iPresentationElementArray, IResultCell iResultCell) {
    }

    @Override
    public void onCompartmentSelected(ICompartment iCompartment, boolean bl, IResultCell iResultCell) {
        IElement iElement;
        if (bl && iCompartment != null && (iElement = iCompartment.getModelElement()) != null) {
            this.onNavigateToElement(iElement);
        }
    }

    @Override
    public void onCompartmentCollapsed(ICompartment iCompartment, boolean bl, IResultCell iResultCell) {
    }

    @Override
    public void onCoreProductPreInit(ICoreProduct iCoreProduct, IResultCell iResultCell) {
    }

    @Override
    public void onCoreProductInitialized(ICoreProduct iCoreProduct, IResultCell iResultCell) {
    }

    @Override
    public void onCoreProductPreQuit(ICoreProduct iCoreProduct, IResultCell iResultCell) {
        this.disconnectSinks();
    }

    @Override
    public void onCoreProductPreSaved(ICoreProduct iCoreProduct, IResultCell iResultCell) {
    }

    @Override
    public void onCoreProductSaved(ICoreProduct iCoreProduct, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaPreCreated(IDrawingAreaControl iDrawingAreaControl, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaPostCreated(IDrawingAreaControl iDrawingAreaControl, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaOpened(IDiagram iDiagram, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaClosed(IDiagram iDiagram, boolean bl, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaPreSave(IProxyDiagram iProxyDiagram, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaPostSave(IProxyDiagram iProxyDiagram, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaKeyDown(IDiagram iDiagram, int n, boolean bl, boolean bl2, boolean bl3, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaPrePropertyChange(IProxyDiagram iProxyDiagram, int n, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaPostPropertyChange(IProxyDiagram iProxyDiagram, int n, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaTooltipPreDisplay(IDiagram iDiagram, IPresentationElement iPresentationElement, IToolTipData iToolTipData, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaActivated(IDiagram iDiagram, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaPreDrop(IDiagram iDiagram, IDrawingAreaDropContext iDrawingAreaDropContext, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaPostDrop(IDiagram iDiagram, IDrawingAreaDropContext iDrawingAreaDropContext, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaPreFileRemoved(String string, IResultCell iResultCell) {
    }

    @Override
    public void onDrawingAreaFileRemoved(String string, IResultCell iResultCell) {
    }

    @Override
    public void onDocumentationPreModified(IElement iElement, String string, IResultCell iResultCell) {
    }

    @Override
    public void onDocumentationModified(IElement iElement, IResultCell iResultCell) {
    }

    @Override
    public void onPreFileNameModified(IArtifact iArtifact, String string, IResultCell iResultCell) {
    }

    @Override
    public void onFileNameModified(IArtifact iArtifact, String string, IResultCell iResultCell) {
        if (string != null && string.length() > 0 && this.m_Navigator != null) {
            this.m_Navigator.navigateToElement(iArtifact);
        }
    }

    @Override
    public void onPreDirty(IArtifact iArtifact, IResultCell iResultCell) {
    }

    @Override
    public void onDirty(IArtifact iArtifact, IResultCell iResultCell) {
    }

    @Override
    public void onPreSave(IArtifact iArtifact, String string, IResultCell iResultCell) {
    }

    @Override
    public void onSave(IArtifact iArtifact, String string, IResultCell iResultCell) {
    }

    @Override
    public void onElementPreCreate(String string, IResultCell iResultCell) {
    }

    @Override
    public void onElementCreated(IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onElementPreDelete(IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onElementDeleted(IVersionableElement iVersionableElement, IResultCell iResultCell) {
        if (iVersionableElement != null) {
            ISourceFileArtifact iSourceFileArtifact = null;
            if (iVersionableElement instanceof ISourceFileArtifact) {
                iSourceFileArtifact = (ISourceFileArtifact)iVersionableElement;
            }
            if (iSourceFileArtifact == null && iVersionableElement instanceof IClassifier) {
                iSourceFileArtifact = this.getSourceFileArtifact((IClassifier)iVersionableElement);
            }
            if (iSourceFileArtifact != null && this.m_Navigator != null && this.m_Navigator instanceof ISourceNavigator) {
                ((ISourceNavigator)this.m_Navigator).closeArtifact(iSourceFileArtifact);
            }
        }
    }

    private ISourceFileArtifact getSourceFileArtifact(IClassifier iClassifier) {
        IElement iElement;
        int n;
        ETList<IElement> eTList;
        ISourceFileArtifact iSourceFileArtifact = null;
        if (iClassifier != null && (eTList = iClassifier.getSourceFiles()) != null && (n = eTList.size()) > 0 && (iElement = (IElement)eTList.get(0)) instanceof ISourceFileArtifact) {
            iSourceFileArtifact = (ISourceFileArtifact)iElement;
        }
        return iSourceFileArtifact;
    }

    @Override
    public void onElementPreDuplicated(IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onElementDuplicated(IVersionableElement iVersionableElement, IResultCell iResultCell) {
    }

    @Override
    public void onItemExpanding(IProjectTreeControl iProjectTreeControl, IProjectTreeExpandingContext iProjectTreeExpandingContext, IResultCell iResultCell) {
    }

    @Override
    public void onItemExpandingWithFilter(IProjectTreeControl iProjectTreeControl, IProjectTreeExpandingContext iProjectTreeExpandingContext, FilteredItemManager filteredItemManager, IResultCell iResultCell) {
        this.onItemExpanding(iProjectTreeControl, iProjectTreeExpandingContext, iResultCell);
    }

    @Override
    public void onBeforeEdit(IProjectTreeControl iProjectTreeControl, IProjectTreeItem iProjectTreeItem, IProjectTreeEditVerify iProjectTreeEditVerify, IResultCell iResultCell) {
    }

    @Override
    public void onAfterEdit(IProjectTreeControl iProjectTreeControl, IProjectTreeItem iProjectTreeItem, IProjectTreeEditVerify iProjectTreeEditVerify, IResultCell iResultCell) {
    }

    @Override
    public void onDoubleClick(IProjectTreeControl iProjectTreeControl, IProjectTreeItem iProjectTreeItem, boolean bl, boolean bl2, boolean bl3, boolean bl4, IResultCell iResultCell) {
        IElement iElement;
        if (iProjectTreeItem != null && ((iElement = iProjectTreeItem.getModelElement()) instanceof ISourceFileArtifact || iElement instanceof IOperation || iElement instanceof IAttribute)) {
            this.onNavigateToElement(iElement);
        }
    }

    @Override
    public void onSelChanged(IProjectTreeControl iProjectTreeControl, IProjectTreeItem[] iProjectTreeItemArray, IResultCell iResultCell) {
    }

    @Override
    public void onRightButtonDown(IProjectTreeControl iProjectTreeControl, IProjectTreeItem iProjectTreeItem, IProjectTreeHandled iProjectTreeHandled, int n, int n2, IResultCell iResultCell) {
    }

    @Override
    public void onBeginDrag(IProjectTreeControl iProjectTreeControl, IProjectTreeItem[] iProjectTreeItemArray, IProjectTreeDragVerify iProjectTreeDragVerify, IResultCell iResultCell) {
    }

    @Override
    public void onMoveDrag(IProjectTreeControl iProjectTreeControl, Transferable transferable, IProjectTreeDragVerify iProjectTreeDragVerify, IResultCell iResultCell) {
    }

    @Override
    public void onEndDrag(IProjectTreeControl iProjectTreeControl, Transferable transferable, int n, IProjectTreeDragVerify iProjectTreeDragVerify, IResultCell iResultCell) {
    }
}

