/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.modules.uml.core.support.umlsupport.StringUtilities;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.netbeans.modules.uml.ui.support.QuestionResponse;
import org.netbeans.modules.uml.ui.support.UserResultListener;
import org.netbeans.modules.uml.ui.support.applicationmanager.IProxyUserInterface;
import org.netbeans.modules.uml.ui.support.commondialogs.CommonDialogResources;
import org.netbeans.modules.uml.ui.support.commondialogs.IQuestionDialog;
import org.netbeans.modules.uml.ui.support.messaging.IMessenger;
import org.netbeans.modules.uml.ui.swing.commondialogs.DefaultCommonDialogResource;
import org.netbeans.modules.uml.ui.swing.commondialogs.JCenterDialog;
import org.netbeans.modules.uml.ui.swing.commondialogs.JFixedSizeTextArea;

public class SwingQuestionDialogImpl
implements IQuestionDialog {
    private JCheckBox m_Checkbox = null;
    private boolean m_RunSilent = false;
    private int m_DefaultButton = -1;
    private boolean m_CheckboxIsChecked = false;
    private Frame m_ParentFrame = null;
    private JDialog m_ParentDialog = null;
    private QuestionResponse m_RetVal = null;

    public SwingQuestionDialogImpl() {
        this.initMessaging();
        IProxyUserInterface iProxyUserInterface = ProductHelper.getProxyUserInterface();
        if (iProxyUserInterface != null) {
            this.m_ParentFrame = iProxyUserInterface.getWindowHandle();
        }
    }

    public SwingQuestionDialogImpl(Frame frame) {
        this.initMessaging();
        this.m_ParentFrame = frame;
    }

    public SwingQuestionDialogImpl(JDialog jDialog) {
        this.initMessaging();
        if (jDialog != null) {
            this.m_ParentDialog = jDialog;
        } else {
            IProxyUserInterface iProxyUserInterface = ProductHelper.getProxyUserInterface();
            if (iProxyUserInterface != null) {
                this.m_ParentFrame = iProxyUserInterface.getWindowHandle();
            }
        }
    }

    private void initMessaging() {
        IMessenger iMessenger = ProductHelper.getMessenger();
        if (iMessenger != null) {
            this.m_RunSilent = iMessenger.getDisableMessaging();
        }
    }

    public QuestionResponse displaySimpleQuestionDialogWithCheckbox(int n, int n2, String string, String string2, int n3, boolean bl) {
        return this.displaySimpleQuestionDialogWithCheckbox(n, n2, string, string2, "", n3, bl);
    }

    private JCenterDialog createDialog(String string, String string2, Icon icon, String string3, int n, QuestionResponse questionResponse) {
        JCenterDialog jCenterDialog = null;
        if (this.m_ParentFrame != null) {
            jCenterDialog = new JCenterDialog(this.m_ParentFrame, true);
        } else if (this.m_ParentDialog != null) {
            jCenterDialog = new JCenterDialog((Dialog)this.m_ParentDialog, true);
        }
        if (jCenterDialog != null) {
            if (string2 == null || string2.length() == 0) {
                string2 = DefaultCommonDialogResource.getString("IDS_QUESTION");
            }
            jCenterDialog.setTitle(string2);
            jCenterDialog.setModal(true);
            try {
                if (string3 != null && string3.length() > 0) {
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new BorderLayout());
                    string.replaceAll("\\n", System.getProperty("line.separator"));
                    JFixedSizeTextArea jFixedSizeTextArea = new JFixedSizeTextArea(string);
                    jFixedSizeTextArea.setOpaque(false);
                    jFixedSizeTextArea.setEditable(false);
                    jFixedSizeTextArea.setBackground(SystemColor.control);
                    jPanel.add((Component)jFixedSizeTextArea, "Center");
                    jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    if (icon != null) {
                        jPanel.add((Component)new JLabel(icon), "West");
                        jFixedSizeTextArea.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                    }
                    String string4 = string3;
                    String string5 = "";
                    int n2 = string3.indexOf(38);
                    if (n2 > -1) {
                        string5 = string3.substring(n2 + 1, n2 + 2);
                        string4 = StringUtilities.replaceAllSubstrings(string3, "&", "");
                    }
                    this.m_Checkbox = new JCheckBox(string4);
                    this.m_Checkbox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
                    if (string5.length() > 0) {
                        this.m_Checkbox.setMnemonic(string5.charAt(0));
                    }
                    this.m_Checkbox.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            SwingQuestionDialogImpl.this.onCheck(actionEvent);
                        }
                    });
                    jPanel.add((Component)this.m_Checkbox, "South");
                    jCenterDialog.getContentPane().add(jPanel);
                } else {
                    JPanel jPanel = new JPanel();
                    jPanel.setLayout(new BorderLayout());
                    JFixedSizeTextArea jFixedSizeTextArea = new JFixedSizeTextArea(string);
                    jFixedSizeTextArea.setOpaque(false);
                    jFixedSizeTextArea.setEditable(false);
                    jFixedSizeTextArea.setBackground(SystemColor.control);
                    jPanel.add((Component)jFixedSizeTextArea, "Center");
                    if (icon != null) {
                        jPanel.add((Component)new JLabel(icon), "West");
                        jFixedSizeTextArea.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
                    }
                    jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
                    jCenterDialog.getContentPane().add((Component)jPanel, "Center");
                }
                this.addButtons(n, questionResponse, jCenterDialog);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return jCenterDialog;
    }

    protected void addButtons(int n, QuestionResponse questionResponse, JDialog jDialog) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 10));
        jDialog.getContentPane().add((Component)jPanel, "South");
        UserResultListener userResultListener = new UserResultListener(questionResponse, jDialog);
        switch (n) {
            case 1: {
                JButton jButton = this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.OK_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.OK_BTN_NAME"), userResultListener);
                jPanel.add(jButton);
                jDialog.getRootPane().setDefaultButton(jButton);
                break;
            }
            case 0: {
                JButton jButton = this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.ABORT_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.ABORT_BTN_NAME"), userResultListener);
                jPanel.add(jButton);
                jPanel.add(this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.RETRY_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.RETRY_BTN_NAME"), userResultListener));
                jPanel.add(this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.IGNORE_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.IGNORE_BTN_NAME"), userResultListener));
                jDialog.getRootPane().setDefaultButton(jButton);
                break;
            }
            case 2: {
                JButton jButton = this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.OK_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.OK_BTN_NAME"), userResultListener);
                jPanel.add(jButton);
                jPanel.add(this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.CANCEL_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.CANCEL_BTN_NAME"), userResultListener));
                jDialog.getRootPane().setDefaultButton(jButton);
                break;
            }
            case 3: {
                JButton jButton = this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.RETRY_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.RETRY_BTN_NAME"), userResultListener);
                jPanel.add(jButton);
                jPanel.add(this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.CANCEL_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.CANCEL_BTN_NAME"), userResultListener));
                jDialog.getRootPane().setDefaultButton(jButton);
                break;
            }
            case 4: {
                JButton jButton = this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.YES_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.YES_BTN_NAME"), userResultListener);
                jPanel.add(jButton);
                jPanel.add(this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.NO_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.NO_BTN_NAME"), userResultListener));
                jDialog.getRootPane().setDefaultButton(jButton);
                break;
            }
            case 5: {
                JButton jButton = this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.YES_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.YES_BTN_NAME"), userResultListener);
                jPanel.add(jButton);
                jPanel.add(this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.NO_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.NO_BTN_NAME"), userResultListener));
                jPanel.add(this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.CANCEL_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.CANCEL_BTN_NAME"), userResultListener));
                jDialog.getRootPane().setDefaultButton(jButton);
                break;
            }
            case 6: {
                JButton jButton = this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.YES_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.YES_BTN_NAME"), userResultListener);
                jPanel.add(jButton);
                jPanel.add(this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.NO_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.NO_BTN_NAME"), userResultListener));
                jPanel.add(this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.ALWAYS_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.ALWAYS_BTN_NAME"), userResultListener));
                jDialog.getRootPane().setDefaultButton(jButton);
                break;
            }
            case 7: {
                JButton jButton = this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.YES_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.YES_BTN_NAME"), userResultListener);
                jPanel.add(jButton);
                jPanel.add(this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.NO_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.NO_BTN_NAME"), userResultListener));
                jPanel.add(this.createActionButton(CommonDialogResources.getString("SwingQuestionDialogImpl.NEVER_BTN_TITLE"), CommonDialogResources.getString("SwingQuestionDialogImpl.NEVER_BTN_NAME"), userResultListener));
                jDialog.getRootPane().setDefaultButton(jButton);
                break;
            }
        }
    }

    protected JButton createActionButton(String string, String string2, ActionListener actionListener) {
        String string3 = string;
        String string4 = "";
        int n = string.indexOf(38);
        if (n > -1) {
            string4 = string.substring(n + 1, n + 2);
            string3 = StringUtilities.replaceAllSubstrings(string, "&", "");
        }
        JButton jButton = new JButton(string3);
        jButton.setActionCommand(string2);
        jButton.addActionListener(actionListener);
        if (string4.length() > 0) {
            jButton.setMnemonic(string4.charAt(0));
        }
        return jButton;
    }

    public QuestionResponse displaySimpleQuestionDialogWithCheckbox(int n, int n2, String string, String string2, String string3, int n3, boolean bl) {
        this.m_RetVal = new QuestionResponse(bl, n3);
        if (string != null && string.length() > 0) {
            if (this.isRunSilent()) {
                this.m_RetVal.setResult(n3);
            } else {
                Icon icon = this.getIconForType(n2);
                JCenterDialog jCenterDialog = this.createDialog(string, string3, icon, string2, n, this.m_RetVal);
                if (this.m_Checkbox != null) {
                    this.m_Checkbox.setSelected(bl);
                }
                this.determineDefaultResult(n, this.m_Checkbox);
                if (jCenterDialog != null) {
                    jCenterDialog.pack();
                    Insets insets = jCenterDialog.getInsets();
                    insets.top = 5;
                    insets.left = 5;
                    insets.bottom = 5;
                    insets.right = 5;
                    jCenterDialog.doLayout();
                    if (this.m_Checkbox != null) {
                        this.setCheckboxIsChecked(this.m_Checkbox.isSelected());
                        this.m_RetVal.setChecked(this.m_Checkbox.isSelected());
                    }
                    if (this.m_ParentFrame != null) {
                        jCenterDialog.center(this.m_ParentFrame);
                    } else if (this.m_ParentDialog != null) {
                        jCenterDialog.center(this.m_ParentDialog);
                    }
                    jCenterDialog.setVisible(true);
                }
            }
        }
        return this.m_RetVal;
    }

    public boolean isRunSilent() {
        return this.m_RunSilent || ProductHelper.getMessenger().getDisableMessaging();
    }

    public void setIsRunSilent(boolean bl) {
        this.m_RunSilent = bl;
    }

    public void setDefaultButton(int n) {
        this.m_DefaultButton = n;
    }

    protected Icon getIconForType(int n) {
        Icon icon = null;
        if (n >= 0 || n <= 7) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    icon = UIManager.getIcon(CommonDialogResources.getString("SwingQuestionDialogImpl.ERROR_ICON"));
                    break;
                }
                case 0: {
                    icon = UIManager.getIcon(CommonDialogResources.getString("SwingQuestionDialogImpl.INFORMATION_ICON"));
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    icon = UIManager.getIcon(CommonDialogResources.getString("SwingQuestionDialogImpl.WARNING_ICON"));
                    break;
                }
                case 4: {
                    icon = UIManager.getIcon(CommonDialogResources.getString("SwingQuestionDialogImpl.QUESTION_ICON"));
                }
            }
        }
        return icon;
    }

    public QuestionResponse displaySimpleQuestionDialog(int n, int n2, String string, int n3, Window window, String string2) {
        this.m_RetVal = new QuestionResponse();
        if (string != null && string.length() > 0) {
            if (this.isRunSilent()) {
                this.m_RetVal.setResult(n3);
            } else {
                Icon icon = this.getIconForType(n2);
                JCenterDialog jCenterDialog = this.createDialog(string, string2, icon, "", n, this.m_RetVal);
                this.determineDefaultResult(n, this.m_Checkbox);
                if (jCenterDialog != null) {
                    jCenterDialog.pack();
                    Insets insets = jCenterDialog.getInsets();
                    insets.top = 5;
                    insets.left = 5;
                    insets.bottom = 5;
                    insets.right = 5;
                    jCenterDialog.doLayout();
                    if (this.m_ParentFrame != null) {
                        jCenterDialog.center(this.m_ParentFrame);
                    } else if (this.m_ParentDialog != null) {
                        jCenterDialog.center(this.m_ParentDialog);
                    }
                    jCenterDialog.setVisible(true);
                }
            }
        }
        return this.m_RetVal;
    }

    public boolean getCheckboxIsChecked() {
        return this.m_CheckboxIsChecked;
    }

    public void setCheckboxIsChecked(boolean bl) {
        this.m_CheckboxIsChecked = bl;
    }

    protected void centerDialog(JDialog jDialog) {
        if (jDialog != null) {
            Container container = jDialog.getParent();
            Rectangle rectangle = container.getBounds();
            double d = rectangle.getCenterX();
            double d2 = rectangle.getCenterY();
            Rectangle rectangle2 = jDialog.getBounds();
            double d3 = d - rectangle2.getWidth() / 2.0;
            double d4 = d2 - rectangle2.getHeight() / 2.0;
            jDialog.setLocation((int)d3, (int)d4);
        }
    }

    private void onCheck(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JCheckBox) {
            JCheckBox jCheckBox = (JCheckBox)object;
            boolean bl = jCheckBox.isSelected();
            if (bl) {
                this.setCheckboxIsChecked(true);
                this.m_RetVal.setChecked(true);
            } else {
                this.setCheckboxIsChecked(false);
                this.m_RetVal.setChecked(false);
            }
        }
    }

    private void determineDefaultResult(int n, JCheckBox jCheckBox) {
        switch (n) {
            case 1: {
                this.m_RetVal.setResult(3);
                break;
            }
            case 0: {
                this.m_RetVal.setResult(2);
                break;
            }
            case 2: {
                this.m_RetVal.setResult(4);
                break;
            }
            case 3: {
                this.m_RetVal.setResult(4);
                break;
            }
            case 4: {
                if (jCheckBox != null) {
                    this.m_RetVal.setResult(4);
                    break;
                }
                this.m_RetVal.setResult(6);
                break;
            }
            case 5: {
                this.m_RetVal.setResult(4);
                break;
            }
            case 6: {
                this.m_RetVal.setResult(4);
                break;
            }
            case 7: {
                this.m_RetVal.setResult(4);
            }
        }
    }
}

