/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.ui.support;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.uml.common.RelationshipCookie;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.ui.controls.projecttree.IProjectTreeItem;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ProjectTreeHelper {
    private static TopComponent projectTabComp = WindowManager.getDefault().findTopComponent("projectTabLogical_tc");
    private static final RequestProcessor RP = new RequestProcessor();

    public static boolean findElementInProjectTree(IElement iElement) {
        Project project = ProjectTreeHelper.findReferencingProject(iElement);
        if (project == null) {
            return false;
        }
        if (projectTabComp != null) {
            ExplorerManager explorerManager = ((ExplorerManager.Provider)projectTabComp).getExplorerManager();
            Node node = explorerManager.getRootContext();
            Children children = node.getChildren();
            Node[] nodeArray = children.getNodes(true);
            for (int i = 0; i < nodeArray.length; ++i) {
                Project project2 = (Project)nodeArray[i].getLookup().lookup(Project.class);
                if (project2 != project) continue;
                Node node2 = ProjectTreeHelper.findNode(nodeArray[i], iElement);
                ProjectTreeHelper.selectProjectNodeAsync(node2);
                return true;
            }
        }
        return false;
    }

    public static Project findElementOwner(IElement iElement) {
        Project project = null;
        if (iElement != null) {
            IElement iElement2 = iElement.getOwner();
            if (iElement2 != null) {
                IProject iProject = iElement2.getProject();
                project = ProjectTreeHelper.findNetBeansProjectForModel(iProject);
            } else {
                project = ProjectTreeHelper.findNetBeansProjectForModel(iElement.getProject());
            }
        }
        return project;
    }

    public static Project findReferencingProject(IElement iElement) {
        Project project = null;
        if (iElement != null) {
            IProject iProject = iElement.getProject();
            project = ProjectTreeHelper.findNetBeansProjectForModel(iProject);
        }
        return project;
    }

    public static Project findNetBeansProjectForModel(IProject iProject) {
        String string;
        Project project = null;
        if (iProject != null && (string = iProject.getFileName()) != null && string.length() > 0) {
            FileObject fileObject = FileUtil.toFileObject((File)new File(string));
            project = FileOwnerQuery.getOwner((FileObject)fileObject);
        }
        return project;
    }

    public static Node findNode(Node node, IElement iElement) {
        if (node.isLeaf()) {
            return null;
        }
        Children children = node.getChildren();
        Node[] nodeArray = children.getNodes(true);
        for (int i = 0; i < nodeArray.length; ++i) {
            IElement iElement2;
            IProjectTreeItem iProjectTreeItem = (IProjectTreeItem)nodeArray[i].getCookie(IProjectTreeItem.class);
            if (iProjectTreeItem != null) {
                iElement2 = iProjectTreeItem.getModelElement();
                if (iElement2 == null && iElement instanceof IDiagram && iProjectTreeItem.getDiagram() != null && iProjectTreeItem.getDescription().equals(((IDiagram)iElement).getFilename())) {
                    return nodeArray[i];
                }
                if (iElement2 != null && iElement.getXMIID().equals(iElement2.getXMIID())) {
                    if (nodeArray[i].getCookie(RelationshipCookie.class) != null) continue;
                    return nodeArray[i];
                }
            }
            if (nodeArray[i].isLeaf() || (iElement2 = ProjectTreeHelper.findNode(nodeArray[i], iElement)) == null) continue;
            return iElement2;
        }
        return null;
    }

    public static void selectProjectNodeAsync(final Node node) {
        if (projectTabComp == null) {
            return;
        }
        final ExplorerManager explorerManager = ((ExplorerManager.Provider)projectTabComp).getExplorerManager();
        projectTabComp.setCursor(Utilities.createProgressCursor((Component)projectTabComp));
        projectTabComp.open();
        projectTabComp.requestActive();
        RP.post(new Runnable(){

            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (node != null) {
                            try {
                                explorerManager.setSelectedNodes(new Node[]{node});
                                StatusDisplayer.getDefault().setStatusText("");
                            }
                            catch (PropertyVetoException propertyVetoException) {}
                        } else {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ProjectTreeHelper.class, (String)"MSG_NodeNotFound"));
                        }
                        projectTabComp.setCursor(null);
                    }
                });
            }
        });
    }
}

